#include "stdafx.h"
#include "iiddrv30_pro_interface.h"
#include "atlstr.h"
#include "atltime.h"

//Load and Register driver functions
//  --> if Registration fails, function returns "false" otherwise "true"
BOOL Init_Driver()
{	
	HINSTANCE DLL_Handle;
	
	//---------- LINK DLL --------------------------
	DLL_Handle = NULL;
	DLL_Handle=LoadLibrary("iiddrv30_pro.dll");
	if (DLL_Handle == NULL) return FALSE;

	//Get Pointer and Type-Cast to specific Type
	PROC_reader_openinterface=(MP_reader_open_interface) GetProcAddress(DLL_Handle,_T("c_openinterface"));
	if (PROC_reader_openinterface==NULL) return FALSE;
	PROC_reader_closeinterface=(MP_reader_close_interface) GetProcAddress(DLL_Handle,_T("c_closeinterface"));
	if (PROC_reader_closeinterface==NULL) return FALSE;
	PROC_reader_get_port_state=(MP_reader_get_port_state) GetProcAddress(DLL_Handle,_T("c_get_port_state"));
	if (PROC_reader_get_port_state==NULL) return FALSE;
	PROC_reader_set_port_type=(MP_reader_set_port_type) GetProcAddress(DLL_Handle,_T("c_set_port_type"));
	if (PROC_reader_set_port_type==NULL) return FALSE;
	PROC_reader_set_interface_type=(MP_reader_set_interface_type) GetProcAddress(DLL_Handle,_T("c_set_interface_type"));
	if (PROC_reader_set_interface_type==NULL) return FALSE;
	PROC_reader_get_handle=(MP_reader_get_handle) GetProcAddress(DLL_Handle,_T("c_get_handle"));
	if (PROC_reader_get_handle==NULL) return FALSE;
	PROC_driver_set_timeout=(MP_driver_set_timeout) GetProcAddress(DLL_Handle,_T("c_set_timeout"));
	if (PROC_driver_set_timeout==NULL) return FALSE;
	PROC_driver_get_timeout=(MP_driver_get_timeout) GetProcAddress(DLL_Handle,_T("c_get_timeout"));
	if (PROC_driver_get_timeout==NULL) return FALSE;
	PROC_driver_set_system_mask=(MP_driver_set_system_mask) GetProcAddress(DLL_Handle,_T("c_set_system_mask"));
	if (PROC_driver_set_system_mask==NULL) return FALSE;
	PROC_driver_get_system_mask=(MP_driver_get_system_mask) GetProcAddress(DLL_Handle,_T("c_get_system_mask"));
	if (PROC_driver_get_system_mask==NULL) return FALSE;
	PROC_driver_get_driver_version=(MP_driver_get_driver_version) GetProcAddress(DLL_Handle,_T("c_get_driver_version"));
	if (PROC_driver_get_driver_version==NULL) return FALSE;

	//general instructions for SAP-interface
	PROC_initialize=(MP_initialize) GetProcAddress(DLL_Handle,_T("c_initialize"));
	if (PROC_initialize==NULL) return FALSE;
	PROC_terminate=(MP_terminate) GetProcAddress(DLL_Handle,_T("c_terminate"));
	if (PROC_terminate==NULL) return FALSE;
	
	PROC_read_reader_id=(MP_read_reader_id) GetProcAddress(DLL_Handle,_T("c_read_reader_id"));
	if (PROC_read_reader_id==NULL) return FALSE;
	PROC_identify=(MP_identify) GetProcAddress(DLL_Handle,_T("c_identify"));
	if (PROC_identify==NULL) return FALSE;
	PROC_readBytes=(MP_readBytes) GetProcAddress(DLL_Handle,_T("c_readbytes"));
	if (PROC_readBytes==NULL) return FALSE;
	PROC_writeBytes=(MP_writeBytes) GetProcAddress(DLL_Handle,_T("c_writebytes"));
	if (PROC_writeBytes==NULL) return FALSE;
	PROC_emul_On=(MP_emul_On) GetProcAddress(DLL_Handle,_T("c_emul_on"));
	if (PROC_emul_On==NULL) return FALSE;
	PROC_emul_Off=(MP_emul_Off) GetProcAddress(DLL_Handle,_T("c_emul_off"));
	if (PROC_emul_Off==NULL) return FALSE;
	PROC_tagAppeared=(MP_tagAppeared) GetProcAddress(DLL_Handle,_T("c_tag_appeared"));
	if (PROC_tagAppeared==NULL) return FALSE;
	PROC_tagDisappeared=(MP_tagDisappeared) GetProcAddress(DLL_Handle,_T("c_tag_disappeared"));
	if (PROC_tagDisappeared==NULL) return FALSE;
	PROC_get_temperature = (MP_c_get_temperature) GetProcAddress(DLL_Handle,_T("c_get_temperature"));
	if (PROC_get_temperature == NULL) return FALSE;

	//ISO15693 specific functions
	PROC_iso15693_set_myd_custom_mode=(MP_iso15693_set_myd_custom_mode) GetProcAddress(DLL_Handle,_T("iso15693_set_myd_custom_mode"));
	if (PROC_iso15693_set_myd_custom_mode==NULL) return FALSE;

	//WaPro 100 pin specific
	//PROC_gps_c_read_data=(MP_gps_c_read_data) GetProcAddress(DLL_Handle,_T("gps_c_read_data"));
	//if (PROC_gps_c_read_data==NULL) return FALSE;


	return TRUE;
}


//Open Port for Communication
//  -->"true" if successful, otherwise "false"
BOOL InitializePort(BYTE PortType, LPTSTR PortName)
{
	//load driver dll first at program start
	if(startup) 
	{
		if (!Init_Driver()) 
		{
			MessageBox(NULL,TEXT("ERROR loading iiddrv30_pro.dll!"),TEXT("DRIVER"),MB_OK);
			return FALSE;
		}
		startup = FALSE;
	}

	//get handle of initialized port
	HANDLE	PortHandle = PROC_reader_get_handle();

	//close port if open
	if(PortHandle != INVALID_HANDLE_VALUE)
	{
		ClosePort();
	}

	//set port type
	//and serial port name
	if (PROC_reader_set_port_type(PortType,PortName) != PortType) 
	{
		MessageBox(NULL,TEXT("ERROR setting port parameters!"),TEXT("OPEN INTERFACE"),MB_OK);
		return FALSE;
	}

	//now open the specified interface using 'initialize'
	if (bool(PROC_initialize()))
	{
		MessageBox(NULL,TEXT("ERROR during 'Open Interface' !"),TEXT("OPEN INTERFACE"),MB_OK);
		return FALSE;
	}

	if (PROC_driver_set_system_mask(GROUP_ISO15693 | GROUP_IID_L | GROUP_IID_G) != 0) 
	{
		MessageBox(NULL,TEXT("ERROR setting system mask!"),TEXT("OPEN INTERFACE"),MB_OK);
		return FALSE;
	}

	if (PROC_driver_set_timeout(3500) != 0) 
	{
		MessageBox(NULL,TEXT("ERROR setting timeout!"),TEXT("OPEN INTERFACE"),MB_OK);
		return FALSE;
	}

	PROC_iso15693_set_myd_custom_mode(1);

	//port successfully initialized...
	MessageBox(NULL,TEXT("Port initialized!"),TEXT("OPEN INTERFACE"),MB_OK);
	return TRUE;
}

//close initialized port
BOOL ClosePort()
{
	//load driver dll first at program start
	if(startup) 
	{
		if (!Init_Driver()) 
		{
			MessageBox(NULL,TEXT("ERROR loading iiddrv30_pro.dll!"),TEXT("DRIVER"),MB_OK);
			return FALSE;
		}
		startup = FALSE;
	}

	//get handle of initialized port
	HANDLE	PortHandle = PROC_reader_get_handle();

	//if port initialized then...
	if(PortHandle != INVALID_HANDLE_VALUE) 
	{
		if(!bool(PROC_terminate()))
		{
			MessageBox(NULL,TEXT("Port closed."),TEXT("CLOSE INTERFACE"),MB_OK);
			return TRUE;
		}
		MessageBox(NULL,TEXT("ERROR closing Port!"),TEXT("CLOSE INTERFACE"),MB_OK);
		return FALSE;
	}
	MessageBox(NULL,TEXT("Port already closed!"),TEXT("CLOSE INTERFACE"),MB_OK);
	return TRUE;	//if no port initialized, return true
}

//reads the reader ID from connected reader
BOOL ReadID()
{
	INT32	ReaderID = 0;
	BYTE	ReadArray[9];

	//initialize Array
	for(int i=0; i<9; i++) ReadArray[i] = 0;

	//load driver dll first at program start
	if(startup) 
	{
		if (!Init_Driver()) 
		{
			MessageBox(NULL,TEXT("ERROR loading iiddrv30_pro.dll!"),TEXT("DRIVER"),MB_OK);
			return FALSE;
		}
		startup = FALSE;
	}

	//get handle of initialized port
	HANDLE	PortHandle = PROC_reader_get_handle();

	//if port initialized then...
	if(PortHandle != INVALID_HANDLE_VALUE)
	{
		//read reader ID
		if (!bool(PROC_read_reader_id(&ReaderID,ReadArray))) 
		{
			CString	csReaderID = "";
			csReaderID.Format("%d",ReaderID);

			MessageBox(NULL,TEXT("READER ID = "+csReaderID+"."),TEXT("READ READER ID"),MB_OK);
			return TRUE;
		}
		else
		{
			MessageBox(NULL,TEXT("ERROR reading Reader ID!"),TEXT("READ READER ID"),MB_OK);
			return FALSE;
		}
	}
	MessageBox(NULL,TEXT("ERROR reading Reader ID! Port not initialized!"),TEXT("READ READER ID"),MB_OK);
	return FALSE;
}


//read UID from TAG
BOOL ReadUID()
{
	BYTE	ReadArray[9];
	//initialize Array
	for(int i=0; i<9; i++) ReadArray[i] = 0;

	//load driver dll first at program start
	if(startup) 
	{
		if (!Init_Driver()) 
		{
			MessageBox(NULL,TEXT("ERROR loading iiddrv30_pro.dll!"),TEXT("DRIVER"),MB_OK);
			return FALSE;
		}
		startup = FALSE;
	}

	//get handle of initialized port
	HANDLE	PortHandle = PROC_reader_get_handle();

	//if port initialized then...
	if(PortHandle != INVALID_HANDLE_VALUE)
	{
		//read UID from TAG
		if (!bool(PROC_identify(ReadArray))) 
		{
			CString	csROCode ="";
			csROCode.Format("0x%X 0x%X 0x%X 0x%X 0x%X 0x%X 0x%X 0x%X",ReadArray[1],ReadArray[2],
				ReadArray[3],ReadArray[4],ReadArray[5],ReadArray[6],ReadArray[7],ReadArray[8]);
			for (int i=0;i<8;i++) UIDARRAY[i]=ReadArray[i+1];

			MessageBox(NULL,TEXT("UID = "+csROCode+"."),TEXT("READ RO-CODE"),MB_OK);
			return TRUE;
		}
		else
		{
			MessageBox(NULL,TEXT("ERROR reading UID!"),TEXT("READ UID"),MB_OK);
			return FALSE;
		}
	}
	MessageBox(NULL,TEXT("ERROR reading UID! Port not initialized!"),TEXT("READ RO-CODE"),MB_OK);
	return FALSE;
}


BOOL ReadBytes()
{
	BYTE Block[128];

	INT32	from = 0;	//for example block address
	INT32	length = 64;	//for example block address
	CTime theTime;

	BYTE *pBlock;
	CString OutputText,HlpText;

	CString Strg, Strg2;
	int	year,month,day,hour,minute,second;
	
	theTime = CTime::GetCurrentTime();

	//--------------------------------------------
	//---Read Bytes (from..(from+length)) from----
	//---transponder------------------------------
	//--------------------------------------------
	pBlock=&Block[0];


	//load driver dll first at program start
	if(startup) 
	{
		if (!Init_Driver()) 
		{
			MessageBox(NULL,TEXT("ERROR loading iiddrv30_pro.dll!"),TEXT("DRIVER"),MB_OK);
			return FALSE;
		}
		startup = FALSE;
	}

	//get handle of initialized port
	HANDLE	PortHandle = PROC_reader_get_handle();

	//if port initialized then...
	if(PortHandle != INVALID_HANDLE_VALUE)
	{
		
		//readbytes
		BYTE MSS_Result=PROC_readBytes(UIDARRAY,from,length,pBlock);
		if (!bool(MSS_Result)) 
		{
			//Block[0] contains length (6)
			//Block[1..length] contains data
			year=Block[1]+2000;
			month=Block[2];
			day=Block[3];
			hour=Block[4];
			minute=Block[5];
			second=Block[6];
			//OutputText.Format(_T("Time Stamp: %d/%d/%d %d:%d:%d read from TAG!"),year,month,day,hour,minute,second);
		
			OutputText=_T("");
			for (int i=0;i<Block[0];i++) 
			{
				HlpText.Format("%X ",Block[i+1]);
				OutputText+=HlpText;
			}
			
			MessageBox(NULL,OutputText,TEXT("SUCCESS"),MB_OK);
			return TRUE;
		}
		else
		{
			OutputText.Format("ERROR 0x%X reading data !",MSS_Result);
			MessageBox(NULL,TEXT("ERROR reading data !"),TEXT("C_READBYTES"),MB_OK);
			return FALSE;
		}
	}
	MessageBox(NULL,TEXT("ERROR reading data !Port not initialized!"),TEXT("C_READBYTES"),MB_OK);
	return FALSE;
}

BOOL WriteBytes()
{
	INT32	from = 0;	//for example from
	INT32	length = 64;	//for example length

	BYTE Block[128];
	BYTE *pBlock;
	CTime theTime;
	CString OutputText;
	BYTE	year,month,day,hour,minute,second;

	pBlock=&Block[0];
	theTime = CTime::GetCurrentTime();
	
	year=theTime.GetYear()-2000;
	month=theTime.GetMonth();
	day=theTime.GetDay();
	hour=theTime.GetHour();
	minute=theTime.GetMinute();
	second=theTime.GetSecond();
	Block[0]=year;
	Block[1]=month;
	Block[2]=day;
	Block[3]=hour;
	Block[4]=minute;
	Block[5]=second;

	for (int i=0;i<length;i++) Block[i]=i+1;

	//load driver dll first at program start
	if(startup) 
	{
		if (!Init_Driver()) 
		{
			MessageBox(NULL,TEXT("ERROR loading iiddrv30_pro.dll!"),TEXT("DRIVER"),MB_OK);
			return FALSE;
		}
		startup = FALSE;
	}

	//get handle of initialized port
	HANDLE	PortHandle = PROC_reader_get_handle();

	//if port initialized then...
	if(PortHandle != INVALID_HANDLE_VALUE)
	{
	
		//writedata
		BYTE MSS_Result=PROC_writeBytes(UIDARRAY,from,length,pBlock,false);
		if (!bool(MSS_Result)) 
		{
			//OutputText.Format(_T("Time Stamp: %d/%d/%d %d:%d:%d written to TAG!"),(year+2000),month,day,hour,minute,second);
			OutputText=_T("Data written...");
			MessageBox(NULL,OutputText,TEXT("SUCCESS"),MB_OK);
			return TRUE;
		}
		else
		{
			OutputText.Format(_T("ERROR 0x%x writing data !",MSS_Result));
			MessageBox(NULL,OutputText,TEXT("C_WRITEBYTES"),MB_OK);
			return FALSE;
		}
	}
	MessageBox(NULL,TEXT("ERROR writing data ! Port not initialized!"),TEXT("C_WRITEBYTES"),MB_OK);
	return FALSE;
}

BOOL GetTemperature()
{
	double	Temperature = 0.0;
	BYTE	ReadArray[4];
	//initialize Array
	for(int i=0; i<4; i++) ReadArray[i] = 0;	//Array length will be received in byte 0

	//load driver dll first at program start
	if(startup) 
	{
		if (!Init_Driver()) 
		{
			MessageBox(NULL,TEXT("ERROR loading iiddrv30_pro.dll!"),TEXT("DRIVER"),MB_OK);
			return FALSE;
		}
		startup = FALSE;
	}

	//get handle of initialized port
	HANDLE	PortHandle = PROC_reader_get_handle();

	//if port initialized then...
	if(PortHandle != INVALID_HANDLE_VALUE)
	{
		
		//write Block
		if (!bool(PROC_get_temperature(&Temperature,ReadArray))) 
		{
			CString csTemperature="";
			csTemperature.Format("%f",Temperature);

			MessageBox(NULL,TEXT("GET TEMPERATURE = "+csTemperature+"."),TEXT("GET TEMPERATURE"),MB_OK);
			return TRUE;
		}
		else
		{
			MessageBox(NULL,TEXT("ERROR reading temperature!"),TEXT("GET TEMPERATURE"),MB_OK);
			return FALSE;
		}
	}
	MessageBox(NULL,TEXT("ERROR reading temperature! Port not initialized!"),TEXT("GET TEMPERATURE"),MB_OK);
	return FALSE;
}
