// SampleApp_VC++_MFC.cpp : Definiert das Klassenverhalten fr die Anwendung.
//

#include "stdafx.h"
#include "SampleApp_VC++_MFC.h"
#include "MainFrm.h"
#include "Reader_Interface.h"

#include "ChildFrm.h"
#include "SampleApp_VC++_MFCDoc.h"
#include "SampleApp_VC++_MFCView.h"
#include ".\sampleapp_vc++_mfc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

	//CString OutputText, HelpText;
	BOOL	SEARCH;
	BYTE	Identifier[0x8];	//maximum length of identifier (8byte)

	//set port type: 0=standard serial, 1=CompactFlash by elserial, 2=Bluetooth SPP, 4=USB
	BYTE			PortType=4;
	//and serial port name: or any port name for CF/USB
	LPTSTR			lpszPortName=TEXT("COM1:");
	//set Interface_Type  125/1356/0x10 (125kHz, 13.56MHz, 125kHz/13.56MHz Mem)
	INT32			Interface_Type=1356;
	//set TimeOut for iIDDriver functions identify, readbytes and writebytes (10...4999msec)
	INT32			TimeOut=50;
	//set supported systems for this demo (0xFF -> enable all transponder systems)
	INT32			SystemMask = 0xFF;

	INT32			main_ver, sub_ver;

	HANDLE m_HCom;

// CSampleApp_VC_MFCApp

BEGIN_MESSAGE_MAP(CSampleApp_VC_MFCApp, CWinApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	// Dateibasierte Standarddokumentbefehle
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standarddruckbefehl "Seite einrichten"
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
	ON_COMMAND(ID_PORT_INITIALIZEPORT, OnPortInitializeport)
	ON_COMMAND(ID_PORT_CLOSEPORT, OnPortCloseport)
	ON_COMMAND(ID_TAGMEMORY_READRO, OnTagmemoryReadro)
	ON_COMMAND(ID_TAGMEMORY_WRITERO, OnTagmemoryWritero)
	ON_COMMAND(ID_TAGMEMORY_READBLOCK64, OnTagmemoryReadblock64)
	ON_COMMAND(ID_TAGMEMORY_WRITEBLOCK64, OnTagmemoryWriteblock64)
	ON_COMMAND(ID_TAGI_READIN4, OnTagiReadin4)
	ON_COMMAND(ID_TAGI_iIDLREADIN2, OnTagiiidlreadin2)
	ON_COMMAND(ID_TAGI_SETOUT2, OnTagiSetout2)
	ON_COMMAND(ID_READER_SETAUTO, OnReaderSetauto)
	ON_COMMAND(ID_READER_READINTERFACE, OnReaderReadinterface)
END_MESSAGE_MAP()


// CSampleApp_VC_MFCApp-Erstellung

CSampleApp_VC_MFCApp::CSampleApp_VC_MFCApp()
{
	// TODO: Hier Code zur Konstruktion einfgen
	// Alle wichtigen Initialisierungen in InitInstance positionieren
}


// Das einzige CSampleApp_VC_MFCApp-Objekt

CSampleApp_VC_MFCApp theApp;

// CSampleApp_VC_MFCApp Initialisierung

BOOL CSampleApp_VC_MFCApp::InitInstance()
{
	// InitCommonControls() ist fr Windows XP erforderlich, wenn ein Anwendungsmanifest
	// die Verwendung von ComCtl32.dll Version 6 oder hher zum Aktivieren
	// von visuellen Stilen angibt. Ansonsten treten beim Erstellen von Fenstern Fehler auf.
	InitCommonControls();

	CWinApp::InitInstance();

	// OLE-Bibliotheken initialisieren
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}
	AfxEnableControlContainer();
	// Standardinitialisierung
	// Wenn Sie diese Features nicht verwenden und die Gre
	// der ausfhrbaren Datei verringern mchten, entfernen Sie
	// die nicht erforderlichen Initialisierungsroutinen.
	// ndern Sie den Registrierungsschlssel unter dem Ihre Einstellungen gespeichert sind.
	// TODO: ndern Sie diese Zeichenfolge entsprechend,
	// z.B. zum Namen Ihrer Firma oder Organisation.
	SetRegistryKey(_T("Vom lokalen Anwendungs-Assistenten generierte Anwendungen"));
	LoadStdProfileSettings(4);  // Standard INI-Dateioptionen laden (einschlielich MRU)
	// Dokumentvorlagen der Anwendung registrieren. Dokumentvorlagen
	//  dienen als Verbindung zwischen Dokumenten, Rahmenfenstern und Ansichten.
	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(IDR_SampleApp_VC_MFTYPE,
		RUNTIME_CLASS(CSampleApp_VC_MFCDoc),
		RUNTIME_CLASS(CChildFrame), // Benutzerspezifischer MDI-Child-Rahmen
		RUNTIME_CLASS(CSampleApp_VC_MFCView));
	if (!pDocTemplate)
		return FALSE;
	//AddDocTemplate(pDocTemplate);
	// Haupt-MDI-Rahmenfenster erstellen
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame || !pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;
	// Rufen Sie DragAcceptFiles nur auf, wenn eine Suffix vorhanden ist.
	//  In einer MDI-Anwendung ist dies unmittelbar nach dem Festlegen von m_pMainWnd erforderlich
	// Befehlszeile parsen, um zu prfen auf Standardumgebungsbefehle DDE, Datei offen
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);
	// Verteilung der in der Befehlszeile angegebenen Befehle. Es wird FALSE zurckgegeben, wenn
	// die Anwendung mit /RegServer, /Register, /Unregserver oder /Unregister gestartet wurde.
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;
	// Das Hauptfenster ist initialisiert und kann jetzt angezeigt und aktualisiert werden.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	if (!Init_Driver(TEXT("iiddrv30_pro.dll"))) 
	{
		MessageBox(NULL,TEXT("Error loading iiddrv30_pro.dll!"),TEXT("DRIVER"),MB_OK);
		return FALSE;
	}

	return TRUE;
}



// CAboutDlg-Dialogfeld fr Anwendungsbefehl 'Info'

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialogfelddaten
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung

// Implementierung
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()

// Anwendungsbefehl zum Ausfhren des Dialogfelds
void CSampleApp_VC_MFCApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}


//------------------------------------------------------
//------------------------------------------------------
//------------------------------------------------------

bool InitializePort()
{
	// ------------------------------------------------------------
	// MICROSENSYS: -----------------------------------------------
	// ------------------------------------------------------------
	// -dynamic load of the driver functions and first setting of -
	// -port and driver parameters---------------------------------
	// ------------------------------------------------------------

	//check driver version
	PROC_driver_get_driver_version(&main_ver, &sub_ver);
	if ((main_ver<0x10) || (sub_ver<0xB))
	{
		MessageBox(NULL,TEXT("Wrong DLL version !"),TEXT("DRIVER"),MB_OK);
		return FALSE;
	}
	
	//set port type
	//and serial port name
	if (PROC_reader_set_port_type(PortType,lpszPortName)!=PortType) 
	{
		MessageBox(NULL,TEXT("ERROR setting parameters !"),TEXT("OPEN INTERFACE"),MB_OK);
		return FALSE;
	}
	//and interface type
	if (PROC_reader_set_interface_type(Interface_Type)!=0)
	{
		MessageBox(NULL,TEXT("ERROR setting parameters !"),TEXT("OPEN INTERFACE"),MB_OK);
		return FALSE;
	}
	//and TimeOut
	if (PROC_driver_set_timeout(TimeOut)!=0)
	{
		MessageBox(NULL,TEXT("ERROR setting parameters !"),TEXT("OPEN INTERFACE"),MB_OK);
		return FALSE;
	}

    //set system mask for iID driver mode
	SystemMask = 0xFF;
	if (PROC_driver_set_system_mask(SystemMask)!=0) 
	{
		MessageBox(NULL,TEXT("ERROR setting parameters !"),TEXT("OPEN INTERFACE"),MB_OK);
		return FALSE;
	}

	//now open the specified interface using 'initialize'
	if (PROC_initialize()!=0)
	{
		MessageBox(NULL,TEXT("ERROR during 'Open Interface' !"),TEXT("OPEN INTERFACE"),MB_OK);
		return FALSE;
	}

	m_HCom=PROC_reader_get_handle();
	MessageBox(NULL,TEXT("Interface initialized !"),TEXT("OPEN INTERFACE"),MB_OK);
	return TRUE;
}

bool ClosePort()
{
	//Terminate reader communication
	PROC_terminate();
	MessageBox(NULL,TEXT("Interface communication terminated !"),TEXT("CLOSE INTERFACE"),MB_OK);
	return TRUE;
}

bool ReadInterfaceID()
{
	CString Out,Out2;
	int id;
	
	//Read transponder's Read Only-Code
	int MSS_Result=PROC_read_reader_id(&id,&ReadArray[0]);
	if (MSS_Result!=0)
	{
		Out.Format("Error: 0x%X reading Interface-ID",MSS_Result);
		MessageBox(NULL,Out,TEXT("READ INTERFACE-ID"),MB_OK);
		return FALSE;
	}
	Out=TEXT("INTERFACE-ID: ");
	for (int i=0;i<ReadArray[0];i++)
	{
		Out2.Format("%X ",ReadArray[i+1]);
		Out=Out+Out2;
	}
	MessageBox(NULL,Out,TEXT("READ INTERFACE-ID"),MB_OK);
	return TRUE;
}

bool ReadRO()
{
	CString Out,Out2;
	
	//Read transponder's Read Only-Code
	int MSS_Result=PROC_iidl_c_read_ro_code(m_HCom,&ReadArray[0]);
	if (MSS_Result!=0)
	{
		Out.Format("Error: 0x%X reading RO-Code",MSS_Result);
		MessageBox(NULL,Out,TEXT("READ RO-CODE"),MB_OK);
		return FALSE;
	}
	Out=TEXT("RO-Code: ");
	for (int i=0;i<ReadArray[0];i++)
	{
		Out2.Format("%X ",ReadArray[i+1]);
		Out=Out+Out2;
	}
	MessageBox(NULL,Out,TEXT("READ RO-CODE"),MB_OK);
	return TRUE;
}

bool WriteRO()
{
	CString Out,Out2;
	
	//Write user definable 4byte of transponder's Read Only-Code
	WriteArray[0]=1;
	WriteArray[1]=2;
	WriteArray[2]=3;
	WriteArray[3]=4;

	int MSS_Result=PROC_iidl_c_write_ro_code(m_HCom,&WriteArray[0],0);
	if (MSS_Result!=0)
	{
		Out.Format("Error: 0x%X writing RO-Code",MSS_Result);
		MessageBox(NULL,Out,TEXT("WRITE RO-CODE"),MB_OK);
		return FALSE;
	}
	Out=TEXT("User part RO-Code: ");
	for (int i=0;i<4;i++)
	{
		Out2.Format("%X ",WriteArray[i]);
		Out=Out+Out2;
	}
	MessageBox(NULL,Out,TEXT("WRITE RO-CODE"),MB_OK);
	return TRUE;
}

bool ReadBlock64()
{
	CString Out,Out2;
	int address;
	
	//Read one of transponder's memory blocks
	address=0;
	int MSS_Result=PROC_iidl_c_read_block_ee_64(m_HCom,address,&ReadArray[0]);
	if (MSS_Result!=0)
	{
		Out.Format("Error: 0x%X reading block",MSS_Result);
		MessageBox(NULL,Out,TEXT("READ BLOCK 64"),MB_OK);
		return FALSE;
	}
	Out.Format("Block 0x%X: ",address);
	for (int i=0;i<ReadArray[0];i++)
	{
		Out2.Format("%X ",ReadArray[i+1]);
		Out=Out+Out2;
	}
	MessageBox(NULL,Out,TEXT("READ BLOCK 64"),MB_OK);
	return TRUE;
}

bool WriteBlock64()
{
	CString Out,Out2;
	int address,i;
	
	//Write one of transponder's memory blocks
	address=0;
	for (i=0;i<64;i++) WriteArray[i]=i;

	int MSS_Result=PROC_iidl_c_write_block_ee_64(m_HCom,address,&WriteArray[0]);
	if (MSS_Result!=0)
	{
		Out.Format("Error: 0x%X writing block",MSS_Result);
		MessageBox(NULL,Out,TEXT("WRITE BLOCK 64"),MB_OK);
		return FALSE;
	}
	Out.Format("Block 0x%X: ",address);
	for (i=0;i<WriteArray[0];i++)
	{
		Out2.Format("%X ",WriteArray[i]);
		Out=Out+Out2;
	}
	MessageBox(NULL,Out,TEXT("WRITE BLOCK 64"),MB_OK);
	return TRUE;
}

bool ReadIn4()
{
	CString Out,Out2;
	BYTE	Setting;
	BYTE    mask = 0x4;
	
	//Read transponder's IN4
	int MSS_Result=PROC_telid2io_c_read_in(m_HCom,&Setting);
	if (MSS_Result!=0)
	{
		Out.Format("Error: 0x%X reading Input",MSS_Result);
		MessageBox(NULL,Out,TEXT("READ IN4"),MB_OK);
		return FALSE;
	}
	Out=TEXT("Read IN4: ");
	for (int i=0;i<=3;i++)
	{
		if ((Setting & mask)==0) Out=Out+"X "; else Out=Out+"- ";
		mask=mask<<1;
	}

	MessageBox(NULL,Out,TEXT("READ IN4"),MB_OK);
	return TRUE;
}

bool ReadIn2()
{
	CString Out,Out2;
	BYTE	Setting;
	BYTE	mask=1;
	
	//Read transponder's IN4
	int MSS_Result=PROC_iidl_c_read_in2(m_HCom,&Setting);
	if (MSS_Result!=0)
	{
		Out.Format("Error: 0x%X reading Input",MSS_Result);
		MessageBox(NULL,Out,TEXT("READ IN2"),MB_OK);
		return FALSE;
	}

	Out=TEXT("Read IN2: ");
	for (int i=0;i<=1;i++)
	{
		if ((Setting & mask)==0) Out=Out+"X "; else Out=Out+"- ";
		mask=mask<<1;
	}

	MessageBox(NULL,Out,TEXT("READ IN2"),MB_OK);
	return TRUE;
}

bool SetOut2()
{
	CString Out,Out2;
	BYTE	Setting;
	BYTE	mask=0x40;
	
	//Set transponder's OUT
	Setting=0;
	Setting=Setting | 0x80; //switch ON OUT2
	Setting=Setting | 0x40; //switch ON OUT1
	int MSS_Result=PROC_telid2io_c_set_out(m_HCom,Setting);
	if (MSS_Result!=0)
	{
		Out.Format("Error: 0x%X setting Output",MSS_Result);
		MessageBox(NULL,Out,TEXT("SET OUT2"),MB_OK);
		return FALSE;
	}

	Out=TEXT("Set OUT2: ");
	for (int i=0;i<=1;i++)
	{
		if ((Setting & mask)!=0) Out=Out+"X "; else Out=Out+"- ";
		mask=mask<<1;
	}

	MessageBox(NULL,Out,TEXT("SET OUT2"),MB_OK);
	return TRUE;
}

bool SetAutoOff()
{
	CString Out,Out2;
	BYTE	Setting;
	
	//Set reader antenna AUTO-OFF time
	//Setting=0;  //switch OFF antenna immediately
	//Setting=1..0xFE  //switch OFF after nx10msec
	//Setting=0xFF;  //newer switch OFF antenna (not recommended)
	Setting=100;
	int MSS_Result=PROC_c_reader_set_auto_off_iid3000(m_HCom,Setting);
	if (MSS_Result!=0)
	{
		Out.Format("Error: 0x%X setting AUTO-OFF",MSS_Result);
		MessageBox(NULL,Out,TEXT("SET AUTO-OFF"),MB_OK);
		return FALSE;
	}

	Out.Format("Set AUTO-OFF: %dmsec",Setting*10);

	MessageBox(NULL,Out,TEXT("SET AUTO-OFF"),MB_OK);
	return TRUE;
}

//------------------------------------------------------
//------------------------------------------------------
//------------------------------------------------------

void CSampleApp_VC_MFCApp::OnPortInitializeport()
{
	InitializePort();
}

void CSampleApp_VC_MFCApp::OnPortCloseport()
{
	ClosePort();
}

void CSampleApp_VC_MFCApp::OnTagmemoryReadro()
{
	ReadRO();
}

void CSampleApp_VC_MFCApp::OnTagmemoryWritero()
{
	WriteRO();
}

void CSampleApp_VC_MFCApp::OnTagmemoryReadblock64()
{
	ReadBlock64();
}

void CSampleApp_VC_MFCApp::OnTagmemoryWriteblock64()
{
	WriteBlock64();
}

void CSampleApp_VC_MFCApp::OnTagiReadin4()
{
	ReadIn4();
}

void CSampleApp_VC_MFCApp::OnTagiiidlreadin2()
{
	ReadIn2();
}

void CSampleApp_VC_MFCApp::OnTagiSetout2()
{
	SetOut2();
}

void CSampleApp_VC_MFCApp::OnReaderSetauto()
{
	SetAutoOff();
}

void CSampleApp_VC_MFCApp::OnReaderReadinterface()
{
	ReadInterfaceID();
}
