/*----------------------------DISPLAY.CPP-----------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Sample for IK410 to display all registers of all axes

  V 1.00
  October 1997
 --------------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>
#include <fstream.h>
#include "IK410.h"
#include "IK410_1.h"


/****************************************************************************/
/**		Globals                                                           **/
/****************************************************************************/
const unsigned short Adr_IK410[] =
{
0,
(DIP_SWITCH_CARD1	& 0x003f) <<4,
(DIP_SWITCH_CARD2 & 0x003f) <<4,
(DIP_SWITCH_CARD3	& 0x003f) <<4,
(DIP_SWITCH_CARD4 & 0x003f) <<4,
(DIP_SWITCH_CARD5 & 0x003f) <<4,
(DIP_SWITCH_CARD6 & 0x003f) <<4,
(DIP_SWITCH_CARD7 & 0x003f) <<4,
(DIP_SWITCH_CARD8 & 0x003f) <<4,
(DIP_SWITCH_CARD9 & 0x003f) <<4,
(DIP_SWITCH_CARD10 & 0x003f) <<4,
(DIP_SWITCH_CARD11 & 0x003f) <<4,
(DIP_SWITCH_CARD12 & 0x003f) <<4,
(DIP_SWITCH_CARD13 & 0x003f) <<4,
(DIP_SWITCH_CARD14 & 0x003f) <<4,
(DIP_SWITCH_CARD15 & 0x003f) <<4,
(DIP_SWITCH_CARD16 & 0x003f) <<4
};

unsigned short Card_Adr;					


/*--------------------------------------------------------------------
		main
 --------------------------------------------------------------------- */

int main()
{
pCard board;
double dCountValue10=0, dCountValue20=0, dCountValue11=0, dCountValue21=0;        

board = new struct cardc;
for(int i=1;i<=16;i++)
	{
	if(Adr_IK410[i] != 0x000)
		{
		board->card[i] = new struct ik121;
		board->card[i]->axis[1] = new struct g26;
		board->card[i]->axis[2] = new struct g26;
		Card_Adr = Adr_IK410[i];
		InitIK410(board->card[i]);
		if (!LookforIK410(board->card[i]))
			{
			cout << "\n IK410 number" << i  << " is missing";
			exit(-1);
			}
		}
	 }

_setcursortype(_NOCURSOR);
clrscr();
gotoxy(10,4);
printf("X1/Register0            X2/Register0");       
gotoxy(10,9);            
printf("X1/Register1            X2/Register1"); 
									 
while(!kbhit())
	{
	 // Software latch in register 0, axis 1 and 2 
	WriteG26(board->card[1]->axis[1]->baseadr,1,CONTROLREG1,0x01);
	WriteG26(board->card[1]->axis[1]->baseadr,2,CONTROLREG1,0x01);

	// Poll whether latched in register 0 of axis 1 and 2
	PollLatch(board->card[1]->axis[1]->baseadr,1,0x00);
	PollLatch(board->card[1]->axis[1]->baseadr,2,0x00);

	// Read register0 of axis 1 and 2
	dCountValue10 = ReadCountValue_48(board->card[1]->axis[1]->baseadr,1,0);
	dCountValue20 = ReadCountValue_48(board->card[1]->axis[1]->baseadr,2,0);
	//Check whether latched in register 1 of axis 1 and 2 from external input X41
	if(Latched(board->card[1]->axis[1]->baseadr,1,0x01))
		dCountValue11 = ReadCountValue_48(board->card[1]->axis[1]->baseadr,1,1);
	if(Latched(board->card[1]->axis[1]->baseadr,2,0x01))
		dCountValue21 = ReadCountValue_48(board->card[1]->axis[1]->baseadr,2,1);


	// Display measured values
	gotoxy(5,5);
	printf("%16.4f\t%16.4f", dCountValue10*0.02/1024.,
									 dCountValue20*0.02/1024.);
	gotoxy(5,10);
	printf("%16.4f\t%16.4f", dCountValue11*0.02/1024.,
									 dCountValue21*0.02/1024.);
	}               
getch();
// Cursor on
_setcursortype (_NORMALCURSOR);

										  
for(int j=1;j<=16;j++)
	{
	if(Adr_IK410[j] != 0x000)
		{
		delete board->card[j]->axis[1];
		delete board->card[j]->axis[2];
		delete board->card[j];
		}
	 }
delete board;			 		  
return (0);
}
	