/*----------------------VMEROTEC.H-------------------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Header File for ROTEC VMEbus-Interface

  V 1.00
  November 1998
 --------------------------------------------------------------------------*/




/*	  Definitions for VCPU486 */

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* I/O - Addresses of VCPU486 */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define ADR_STAT	   0x7000		/* Address status register     */
#define CARD_ENABLE  0x4000		/* VMEbus card enable         */
#define SWAP_ENABLE	0x7100		/* Byte swapping register     */

#define ADR_REG		0x7000	/* Address register */
										/* (Write access on 7000-70FF) */

#define STATUS_REG 	0x7000	/* Status register */
										/* (Read access on 7000-70FF) */

#define VIC_068 	0x7300	/* Chip select VIC068 (7300-73FF) */


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*	Addresses of VIC068 registers */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define IACK1	0x7203		/* VMEbus Interrupt Acknowledge 1 */
#define IACK2	0x7205		/* VMEbus Interrupt Acknowledge 2 */
#define IACK3	0x7207		/* VMEbus Interrupt Acknowledge 3 */
#define IACK4	0x7209		/* VMEbus Interrupt Acknowledge 4 */
#define IACK5	0x720B		/* VMEbus Interrupt Acknowledge 5 */
#define IACK6	0x720D		/* VMEbus Interrupt Acknowledge 6 */
#define IACK7	0x720F		/* VMEbus Interrupt Acknowledge 7 */
#define VICR1	0x7307		/* VMEbus Interrupt Control Register 1 */
#define VICR2	0x730b		/* VMEbus Interrupt Control Register 2 */
#define VICR3	0x730f		/* VMEbus Interrupt Control Register 3 */
#define VICR4	0x7313		/* VMEbus Interrupt Control Register 4 */
#define VICR5	0x7317		/* VMEbus Interrupt Control Register 5 */
#define VICR6	0x731b		/* VMEbus Interrupt Control Register 6 */
#define VICR7	0x731f		/* VMEbus Interrupt Control Register 7 */
#define ICR7	0x737f		/* Interprocessor Communication Register 7 */
#define TTR 	0x73a3		/* Transfer Timeout Register */
#define ICR	   0x73af		/* Interface Configuration Register */
#define ARCR	0x73b3		/* Arbiter Requester Configuration Register */
#define SS0CR0 0x73c3		/* Slave Select 0 - Control Register 0 */
#define SS0CR1 0x73c7		/* Slave Select 0 - Control Register 1 */
#define RCR	   0x73d3		/* Release Control Register */
#define AMSR   0x73b7		/* Address Modifier Register */
#define SRR    0x73e3		/* System Reset Register */

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*	Various Definitions */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define VIC_ADRREG 	0x0000	/* Address register for VIC068 access */


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*	Definitions for VIC068 registers */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define SPER_VICR1	0xf9	/* Interrupt Handler 1 locked */
#define SPER_VICR2	0xfa	/* Interrupt Handler 2 locked */
#define SPER_VICR3	0xfb	/* Interrupt Handler 3 locked */
#define SPER_VICR4	0xfc	/* Interrupt Handler 4 locked */
#define SPER_VICR5	0xfd	/* Interrupt Handler 5 locked */
#define SPER_VICR6	0xfe	/* Interrupt Handler 6 locked */
#define SPER_VICR7	0xff	/* Interrupt Handler 7 locked */

#define FREI_VICR1	0x79	/* Interrupt Handler 1 released */
#define FREI_VICR2	0x7a	/* Interrupt Handler 2 released */
#define FREI_VICR3	0x7b	/* Interrupt Handler 3 released */
#define FREI_VICR4	0x7c	/* Interrupt Handler 4 released */
#define FREI_VICR5	0x7d	/* Interrupt Handler 5 released */
#define FREI_VICR6	0x7e	/* Interrupt Handler 6 released */
#define FREI_VICR7	0x7f	/* Interrupt Handler 7 released */


#define VAL_TTR  	0x68	/* VMEbus Timeout 64us */
								/*	Local Bus Timeout 32us */

#define VAL_ARCR	0x60	/* RRS - Arbiter, Bus Req. Level 3, no Fairn. */

#define VAL_RCR  	0x00	/* Release Modus ROR */

#define VAL_AMR  	0x7c	/* Address Modifier use AM3-5 */

#define VAL_SRR  	0xF0	/* System Reset VMEbus */

/*============= Don't change these values ================================*/
#define VAL_ICR		0x5c
#define VAL_ICR7  	0x80	/* Reset SYSFAIL */
#define VAL_SS0CR0 	0x04
#define VAL_SS0CR1  	0x0f
/*=========================================================================*/

void VmeInit(void);
void int_eoi(int);



