/*------------------------------POTIS.CPP------------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Sample for adjusting the EEPROM Poteniometers 

  V 1.00
  November 1998
 ---------------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>
#include <fstream.h>
#include "ik342.h"
#include "ik342_1.h"
extern "C" {
#include "vmerotec.h"
};


/****************************************************************************/
/**		Globals                                                           **/
/****************************************************************************/
extern unsigned char iic_error;



unsigned short Adr_Ik342[] =
{
0,
(DIP_SWITCH_CARD1  >>1) * 0x0200,
(DIP_SWITCH_CARD2  >>1) * 0x0200,
(DIP_SWITCH_CARD3  >>1) * 0x0200,
(DIP_SWITCH_CARD4  >>1) * 0x0200,
(DIP_SWITCH_CARD5  >>1) * 0x0200,
(DIP_SWITCH_CARD6  >>1) * 0x0200,
(DIP_SWITCH_CARD7  >>1) * 0x0200,
(DIP_SWITCH_CARD8  >>1) * 0x0200,
(DIP_SWITCH_CARD9  >>1) * 0x0200,
(DIP_SWITCH_CARD10 >>1) * 0x0200,
(DIP_SWITCH_CARD11 >>1) * 0x0200,
(DIP_SWITCH_CARD12 >>1) * 0x0200,
(DIP_SWITCH_CARD13 >>1) * 0x0200,
(DIP_SWITCH_CARD14 >>1) * 0x0200,
(DIP_SWITCH_CARD15 >>1) * 0x0200,
(DIP_SWITCH_CARD16 >>1) * 0x0200
};

const unsigned short VmeA16Adr_Ik342[] =
{
0,
((((DIP_SWITCH_CARD1  >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD2  >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD3  >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD4  >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD5  >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD6  >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD7  >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD8  >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD9  >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD10 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD11 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD12 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD13 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD14 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD15 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD16 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00
};

unsigned short Card_Adr;             

pCard board;
int iNum = 0;



/*--------------------------------------------------------------------
								main
 --------------------------------------------------------------------- */

int main()
{
VmeInit();
board = new struct cardc;


printf ("\n\n");
for(int i=1;i<=16;i++)
{
	if(Adr_Ik342[i] != 0x0000)
		{
		printf ("Initializing card %2d\r", i);
		if (iNum==0) iNum=i;
		board->card[i] = new struct ik342;
		board->card[i]->axis[1] = new struct g26;
		board->card[i]->axis[2] = new struct g26;
		board->card[i]->axis[3] = new struct g26;
		board->card[i]->axis[4] = new struct g26;
		Card_Adr = Adr_Ik342[i] | 0x8000;
		outport(ADR_REG,VmeA16Adr_Ik342[i]);	//switch to VME A16 memory space
		InitIk342(board->card[i]);
		if (!LookforIk342(board->card[i]))
		{
			cout << "\n Ik342 number " << i  << " is missing";
			exit(-1);
		}
	}
}
printf ("\n");

// outport(ADR_REG,VmeA16Adr_Ik342[1]);	//switch to VME A16 memory space

CrtInit();
ShowPotis(board->card[iNum]);
TurnPotis(board->card[iNum]);			
 
textbackground(BLACK);
textcolor(WHITE);
window(1,1,80,25);
clrscr();
// Cursor on
_setcursortype (_NORMALCURSOR);

for(int j=1;j<=16;j++)
	{
	if(Adr_Ik342[j] != 0x0000)
		{
		delete board->card[j]->axis[1];
		delete board->card[j]->axis[2];
		delete board->card[j]->axis[3];
		delete board->card[j]->axis[4];
		delete board->card[j];
		}
	 }
delete board;	
return (0);
}
  

