/*----------------------------POTI_1.CPP---------------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Functions for adjusting EEPROM Potentiometers  

  V 1.00
  April 1996
 ---------------------------------------------------------------------------*/
#include <conio.h>
#include "ik341_1.h"


const unsigned char CLEFT = 75;
const unsigned char CRIGHT = 77;
const unsigned char CUP = 72;
const unsigned char CDOWN = 80;
const unsigned char ESC = 27;

const unsigned char att_wsonsw =		0x0f;
const unsigned char att_wsongr =		0x7f;
const unsigned char att_gbongr =		0x7e;
const unsigned char att_blongr =		0x71;      
const unsigned char att_wsonbl =		0x1f;



void CrtInit()
{
	textbackground(LIGHTGRAY);
	textcolor(BLACK);
	clrscr();
	highvideo();
	window(1,1,80,25);     
	textattr(att_blongr);
	gotoxy(2,1);	cputs("EEPROM-Potentiometer Adjustment");
	textattr(att_wsongr);
	gotoxy(2,4);	cputs("   Phase axis1");
	gotoxy(2,7);	cputs(" Amplitude axis1");
	gotoxy(2,11);	cputs("Offset DG00 axis1");
	gotoxy(2,15);	cputs("Offset DG90 axis1");
	gotoxy(22,4);	cputs("   Phase axis2");
	gotoxy(22,7);	cputs(" Amplitude axis2");
	gotoxy(22,11);	cputs("Offset DG00 axis2");
	gotoxy(22,15);	cputs("Offset DG90 axis2");
	gotoxy(42,4);	cputs("   Phase axis3");
	gotoxy(42,7);	cputs(" Amplitude axis3");
	gotoxy(42,11);	cputs("Offset DG00 axis3");
	gotoxy(42,15);	cputs("Offset DG90 axis3");
	gotoxy(62,4);	cputs("   Phase axis4");
	gotoxy(62,7);	cputs(" Amplitude axis4");
	gotoxy(62,11);	cputs("Offset DG00 axis4");
	gotoxy(62,15);	cputs("Offset DG90 axis4");
	gotoxy(2,21);	cputs(" +: Increment");
	gotoxy(2,22);	cputs(" -: Decrement");
	gotoxy(2,23);	cputs(" >: Maximum");
	gotoxy(2,24);	cputs(" <: Minimum");
	gotoxy(2,25);	cputs(" n: Neutral    N: Neutral all");
	gotoxy(50,24);	cputs(" s: Store values");
	textattr(att_gbongr);
	gotoxy(50,25);	cputs(" q: Quit");
}

void ShowPotis(pIk341 card)
{	
	for(int i=1; i<=16; i++)
	ShowPoti(card, i, att_wsonsw);
}

void ShowPoti(pIk341 card, unsigned char poti_nr, unsigned char color_attr)
{
	switch(poti_nr)
		{
		case 1:
		textattr(color_attr);
		window(8,5,18,5);
		cprintf(" %3d ",ReadPhasepoti(card,1));
		break;
		case 2:
		textattr(color_attr);
		window(8,8,18,8);
		cprintf(" %3d ",ReadSympoti(card,1));
		break;
		case 3:
		textattr(color_attr);
		window(8,12,18,12);
		cprintf(" %3d ",card->axis[1]->offset00);
		break;
		case 4:
		textattr(color_attr);
		window(8,16,18,16);
		cprintf(" %3d ",card->axis[1]->offset90);
		break;
		case 5:
		textattr(color_attr);
		window(28,5,38,5);
		cprintf(" %3d ",ReadPhasepoti(card,2));
		break;
		case 6:
		textattr(color_attr);
		window(28,8,38,8);
		cprintf(" %3d ",ReadSympoti(card,2));
		break;
		case 7:
		textattr(color_attr);
		window(28,12,38,12);
		cprintf(" %3d ",card->axis[2]->offset00);
		break;
		case 8:
		textattr(color_attr);
		window(28,16,38,16);
		cprintf(" %3d ",card->axis[2]->offset90);
		break;
		case 9:
		textattr(color_attr);
		window(48,5,58,5);
		cprintf(" %3d ",ReadPhasepoti(card,3));
		break;
		case 10:
		textattr(color_attr);
		window(48,8,58,8);
		cprintf(" %3d ",ReadSympoti(card,3));
		break;
		case 11:
		textattr(color_attr);
		window(48,12,58,12);
		cprintf(" %3d ",card->axis[3]->offset00);
		break;
		case 12:
		textattr(color_attr);
		window(48,16,58,16);
		cprintf(" %3d ",card->axis[3]->offset90);
		break;
		case 13:
		textattr(color_attr);
		window(68,5,78,5);
		cprintf(" %3d ",ReadPhasepoti(card,4));
		break;
		case 14:
		textattr(color_attr);
		window(68,8,78,8);
		cprintf(" %3d ",ReadSympoti(card,4));
		break;
		case 15:
		textattr(color_attr);
		window(68,12,78,12);
		cprintf(" %3d ",card->axis[4]->offset00);
		break;
		case 16:
		textattr(color_attr);
		window(68,16,78,16);
		cprintf(" %3d ",card->axis[4]->offset90);
		break;
		default:
		break;
		}
}

void TurnPotis(pIk341 card)
{
	short c, poti_nr =1;
	
	ShowPoti(card, poti_nr, att_wsonbl);
	while(kbhit()) getch();
	do
	{
	c = getch();
	switch(c)
		{
		case 0:					//Key CLEFT,CRIGHT,CUP,CDOWN,ESC
			c = getch();
			switch(c)
				{
				case CLEFT:
					if(poti_nr <= 4)
						poti_nr += 12;
					else
						poti_nr -= 4;
				ShowPotis(card);
				ShowPoti(card, poti_nr,att_wsonbl);
				break;   
				case CRIGHT:
					if(poti_nr <= 12)
						poti_nr += 4;
					else
						poti_nr -= 12;
				ShowPotis(card);
				ShowPoti(card, poti_nr,att_wsonbl);
				break;
				case CUP:
				poti_nr -= 1;
				if (poti_nr <= 0) poti_nr = 16;
				ShowPotis(card);
				ShowPoti(card, poti_nr,att_wsonbl);
				break;       
				case CDOWN:
				poti_nr += 1;
				if (poti_nr >= 17) poti_nr = 1;  					 
				ShowPotis(card);
				ShowPoti(card, poti_nr,att_wsonbl);
				break;       
				default:
				break;
				}		
			break;
		case '+':
				switch(poti_nr)
					{
					case 1:
						TurnPhasepoti(card,1,1,1);
						ShowPoti(card, 1, att_wsonbl);
						break;
					case 2:
						TurnSympoti(card,1,1,1);
						ShowPoti(card, 2, att_wsonbl);
						break;
					case 3:
						TurnOffsetdg00(card,1,1,1);
						ShowPoti(card, 3, att_wsonbl);
						break;
					case 4:
						TurnOffsetdg90(card,1,1,1);
						ShowPoti(card, 4, att_wsonbl);
						break;
					case 5:
						TurnPhasepoti(card,2,1,1);
						ShowPoti(card, 5, att_wsonbl);
						break;
					case 6:
						TurnSympoti(card,2,1,1);
						ShowPoti(card, 6, att_wsonbl);
						break;
					case 7:
						TurnOffsetdg00(card,2,1,1);
						ShowPoti(card, 7, att_wsonbl);
						break;
					case 8:
						TurnOffsetdg90(card,2,1,1);
						ShowPoti(card, 8, att_wsonbl);
						break;
					case 9:
						TurnPhasepoti(card,3,1,1);
						ShowPoti(card, 9, att_wsonbl);
						break;
					case 10:
						TurnSympoti(card,3,1,1);
						ShowPoti(card, 10, att_wsonbl);
						break;
					case 11:
						TurnOffsetdg00(card,3,1,1);
						ShowPoti(card, 11, att_wsonbl);
						break;
					case 12:
						TurnOffsetdg90(card,3,1,1);
						ShowPoti(card, 12, att_wsonbl);
						break;
					case 13:
						TurnPhasepoti(card,4,1,1);
						ShowPoti(card, 13, att_wsonbl);
						break;
					case 14:
						TurnSympoti(card,4,1,1);
						ShowPoti(card, 14, att_wsonbl);
						break;
					case 15:
						TurnOffsetdg00(card,4,1,1);
						ShowPoti(card, 15, att_wsonbl);
						break;
					case 16:
						TurnOffsetdg90(card,4,1,1);
						ShowPoti(card, 16, att_wsonbl);
						break;
					default:           
					break;
					}
			break;
		case '-':
				switch(poti_nr)
					{
					case 1:
						TurnPhasepoti(card,1,1,0);
						ShowPoti(card, 1, att_wsonbl);
						break;
					case 2:
						TurnSympoti(card,1,1,0);
						ShowPoti(card, 2, att_wsonbl);
						break;
					case 3:
						TurnOffsetdg00(card,1,1,0);
						ShowPoti(card, 3, att_wsonbl);
						break;
					case 4:
						TurnOffsetdg90(card,1,1,0);
						ShowPoti(card, 4, att_wsonbl);
						break;
					case 5:
						TurnPhasepoti(card,2,1,0);
						ShowPoti(card, 5, att_wsonbl);
						break;
					case 6:
						TurnSympoti(card,2,1,0);
						ShowPoti(card, 6, att_wsonbl);
						break;
					case 7:
						TurnOffsetdg00(card,2,1,0);
						ShowPoti(card, 7, att_wsonbl);
						break;
					case 8:
						TurnOffsetdg90(card,2,1,0);
						ShowPoti(card, 8, att_wsonbl);
						break;
					case 9:
						TurnPhasepoti(card,3,1,0);
						ShowPoti(card, 9, att_wsonbl);
						break;
					case 10:
						TurnSympoti(card,3,1,0);
						ShowPoti(card, 10, att_wsonbl);
						break;
					case 11:
						TurnOffsetdg00(card,3,1,0);
						ShowPoti(card, 11, att_wsonbl);
						break;
					case 12:
						TurnOffsetdg90(card,3,1,0);
						ShowPoti(card, 12, att_wsonbl);
						break;
					case 13:
						TurnPhasepoti(card,4,1,0);
						ShowPoti(card, 13, att_wsonbl);
						break;
					case 14:
						TurnSympoti(card,4,1,0);
						ShowPoti(card, 14, att_wsonbl);
						break;
					case 15:
						TurnOffsetdg00(card,4,1,0);
						ShowPoti(card, 15, att_wsonbl);
						break;
					case 16:
						TurnOffsetdg90(card,4,1,0);
						ShowPoti(card, 16, att_wsonbl);
						break;
					default:                
					break;
					}
			break;
		case '>':              
				switch(poti_nr)
					{
					case 1:
						WritePhasepoti(card,1,63);
						ShowPoti(card, 1, att_wsonbl);
						break;
					case 2:
						WriteSympoti(card,1,63);
						ShowPoti(card, 2, att_wsonbl);
						break;
					case 3:
						WriteOffset00(card,1,63);
						ShowPoti(card, 3, att_wsonbl);
						break;
					case 4:
						WriteOffset90(card,1,63);
						ShowPoti(card, 4, att_wsonbl);
						break;
					case 5:
						WritePhasepoti(card,2,63);
						ShowPoti(card, 5, att_wsonbl);
						break;
					case 6:
						WriteSympoti(card,2,63);
						ShowPoti(card, 6, att_wsonbl);
						break;
					case 7:
						WriteOffset00(card,2,63);
						ShowPoti(card, 7, att_wsonbl);
						break;
					case 8:
						WriteOffset90(card,2,63);
						ShowPoti(card, 8, att_wsonbl);
						break;
					case 9:
						WritePhasepoti(card,3,63);
						ShowPoti(card, 9, att_wsonbl);
						break;
					case 10:
						WriteSympoti(card,3,63);
						ShowPoti(card, 10, att_wsonbl);
						break;
					case 11:
						WriteOffset00(card,3,63);
						ShowPoti(card, 11, att_wsonbl);
						break;
					case 12:
						WriteOffset90(card,3,63);
						ShowPoti(card, 12, att_wsonbl);
						break;
					case 13:
						WritePhasepoti(card,4,63);
						ShowPoti(card, 13, att_wsonbl);
						break;
					case 14:
						WriteSympoti(card,4,63);
						ShowPoti(card, 14, att_wsonbl);
						break;
					case 15:
						WriteOffset00(card,4,63);
						ShowPoti(card, 15, att_wsonbl);
						break;
					case 16:
						WriteOffset90(card,4,63);
						ShowPoti(card, 16, att_wsonbl);
						break;
					default:                
					break;
					}
			break;
		case '<':
				switch(poti_nr)
					{
					case 1:
						WritePhasepoti(card,1,0);
						ShowPoti(card, 1, att_wsonbl);
						break;
					case 2:
						WriteSympoti(card,1,0);
						ShowPoti(card, 2, att_wsonbl);
						break;
					case 3:
						WriteOffset00(card,1,-63);
						ShowPoti(card, 3, att_wsonbl);
						break;
					case 4:
						WriteOffset90(card,1,-63);
						ShowPoti(card, 4, att_wsonbl);
						break;
					case 5:
						WritePhasepoti(card,2,0);
						ShowPoti(card, 5, att_wsonbl);
						break;
					case 6:
						WriteSympoti(card,2,0);
						ShowPoti(card, 6, att_wsonbl);
						break;
					case 7:
						WriteOffset00(card,2,-63);
						ShowPoti(card, 7, att_wsonbl);
						break;
					case 8:
						WriteOffset90(card,2,-63);
						ShowPoti(card, 8, att_wsonbl);
						break;
					case 9:
						WritePhasepoti(card,3,0);
						ShowPoti(card, 9, att_wsonbl);
						break;
					case 10:
						WriteSympoti(card,3,0);
						ShowPoti(card, 10, att_wsonbl);
						break;
					case 11:
						WriteOffset00(card,3,-63);
						ShowPoti(card, 11, att_wsonbl);
						break;
					case 12:
						WriteOffset90(card,3,-63);
						ShowPoti(card, 12, att_wsonbl);
						break;
					case 13:
						WritePhasepoti(card,4,0);
						ShowPoti(card, 13, att_wsonbl);
						break;
					case 14:
						WriteSympoti(card,4,0);
						ShowPoti(card, 14, att_wsonbl);
						break;
					case 15:
						WriteOffset00(card,4,-63);
						ShowPoti(card, 15, att_wsonbl);
						break;
					case 16:
						WriteOffset90(card,4,-63);
						ShowPoti(card, 16, att_wsonbl);
						break;
					default:               
					break;
					}
			break;
		case 'n':
				switch(poti_nr)
					{
					case 1:
						WritePhasepoti(card,1,32);
						ShowPoti(card, 1, att_wsonbl);
						break;
					case 2:
						WriteSympoti(card,1,32);
						ShowPoti(card, 2, att_wsonbl);
						break;
					case 3:
						WriteOffset00(card,1,0);
						ShowPoti(card, 3, att_wsonbl);
						break;
					case 4:
						WriteOffset90(card,1,0);
						ShowPoti(card, 4, att_wsonbl);
						break;
					case 5:
						WritePhasepoti(card,2,32);
						ShowPoti(card, 5, att_wsonbl);
						break;
					case 6:
						WriteSympoti(card,2,32);
						ShowPoti(card, 6, att_wsonbl);
						break;
					case 7:
						WriteOffset00(card,2,0);
						ShowPoti(card, 7, att_wsonbl);
						break;
					case 8:
						WriteOffset90(card,2,0);
						ShowPoti(card, 8, att_wsonbl);
						break;
					case 9:
						WritePhasepoti(card,3,32);
						ShowPoti(card, 9, att_wsonbl);
						break;
					case 10:
						WriteSympoti(card,3,32);
						ShowPoti(card, 10, att_wsonbl);
						break;
					case 11:
						WriteOffset00(card,3,0);
						ShowPoti(card, 11, att_wsonbl);
						break;
					case 12:
						WriteOffset90(card,3,0);
						ShowPoti(card, 12, att_wsonbl);
						break;
					case 13:
						WritePhasepoti(card,4,32);
						ShowPoti(card, 13, att_wsonbl);
						break;
					case 14:
						WriteSympoti(card,4,32);
						ShowPoti(card, 14, att_wsonbl);
						break;
					case 15:
						WriteOffset00(card,4,0);
						ShowPoti(card, 15, att_wsonbl);
						break;
					case 16:
						WriteOffset90(card,4,0);
						ShowPoti(card, 16, att_wsonbl);
						break;
					default:               
					break;
					}
			break;
		case 'N':
         PotiDefault(card);
         LoadOffset(card);
			ShowPotis(card);
			ShowPoti(card, poti_nr,att_wsonbl);
         break;
		case 's':
			StoreOffset(card);
			StorePotis(card);
			break;
		case 'q':
			break;
		default:
			break;
		}	
	}
	while((kbhit) && c != 'q');
}


