/*---------------------------IK341_1.H---------------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Header File for the Basic Functions of the Ik341_1

  V 1.00
  April 1996
  --------------------------------------------------------------------------*/


// Constants for structurs
const unsigned char	on = 1;
const unsigned char	off = 0;

//Configuration- and Id-Register
const unsigned short IDREG			 	= 0x00;					 
const unsigned short ENLATCHX1	 	= 0x00;					 
const unsigned short ENLATCHX2	 	= 0x02;					 
const unsigned short ENLATCHX3	 	= 0x04;					 
const unsigned short ENLATCHX4	 	= 0x06;					 
const unsigned short LATCHPOL		 	= 0x08;					 
const unsigned short INTREG		 	= 0x0a;					 

// Write register G26	
const unsigned short INITIALREG 	= 0x24;		// write and read					 
const unsigned short CONTROLREG1	= 0x20;					 
const unsigned short REFMARKREG 	= 0x1c;					 
const unsigned short ENDATUMREG 	= 0x18;					 
const unsigned short OFFSET00	 	= 0x10;					 
const unsigned short OFFSET90	 	= 0x0c;
const unsigned short TIMERREG	 	= 0x08;
const unsigned short CONTROLREG2	= 0x04;
const unsigned short CONTROLREG3	= 0x00;
					 
// Read register G26
const unsigned short DATUMREG0LSB = 0x3c;					 
const unsigned short DATUMREG0	 = 0x38;					 
const unsigned short DATUMREG0MSB = 0x34;					 
const unsigned short DATUMREG1LSB = 0x30;					 
const unsigned short DATUMREG1	 = 0x2c;					 
const unsigned short DATUMREG1MSB = 0x28;					 
const unsigned short STATUSREG12	 = 0x20;					 
const unsigned short AMPLITUDEREG = 0x1c;					 
const unsigned short AMPLITUDE00	 = 0x10;					 
const unsigned short AMPLITUDE90	 = 0x0c;
const unsigned short STATUSREG3	 = 0x04;
const unsigned short STATUSREG4	 = 0x00;

// Structurs
struct softcommand{
						unsigned char start;
						unsigned char stop;
						unsigned char clear;
						unsigned char latch0;
						unsigned char latch1;
						unsigned char softl;
						unsigned char clrfreq;
						unsigned char clrstat;
						};

struct refcommand	{
						unsigned char ristart;
						unsigned char ristop;
						unsigned char riclear;
						unsigned char riclear2;
						unsigned char rilatch;
						unsigned char rilatch2;
						};

struct initlatch	{
						unsigned char en_l0_reg0;
						unsigned char en_softl_reg0;
						unsigned char en_timerl_reg0;
						unsigned char en_l1_reg1;
						unsigned char en_softl_reg1;
						unsigned char en_timerl_reg1;
						};

struct initsync	{
						unsigned char en_l0_casc0;
						unsigned char en_softl_casc0;
						unsigned char en_timerl_casc0;
						unsigned char en_l1_casc1;
						unsigned char en_softl_casc1;
						unsigned char en_timerl_casc1;
						};                           

struct initmain	{
						unsigned char mode1024;
						unsigned char en_timer;
						unsigned char en_48bit;
						unsigned char onefold;
						unsigned char twofold;
						unsigned char fourfold;
						unsigned char arcmode;
						unsigned char arc180000;
						unsigned char sel_ri_1st;
						unsigned char sel_ri_2nd;
						};

struct countstate	{
						unsigned char latch0;
						unsigned char latch1;
						unsigned char stop;
						unsigned char sda;
						unsigned char error_freq;
						unsigned char ref_activ;
						};

struct signalstate{
						unsigned long ad00;
						unsigned long ad90;
						unsigned char amp_act;
						unsigned char amp_min;
						};

struct g26			{
						unsigned char				id;
						unsigned short				baseadr;
						unsigned char				ucaxis;
						double						register0;
						double						register1;
						struct softcommand		softcomm;
						struct refcommand			refcomm;
						struct initmain			inimain;
						struct initlatch			inilatch;
						struct initsync			inisync;
						struct countstate			cstatus;
						struct signalstate		sstatus;
						unsigned short				timer;
						short							offset00;
						short							offset90;
						};
						
struct ik341		{
						struct g26*	  		axis[4];		
						};		

struct cardc{
						struct ik341*		card[16];		
						};		

typedef struct g26* 				pG26;			// pointer to G26
typedef struct ik341* 			pIk341;		// pointer to Ik341
typedef struct cardc* 			pCard;		// pointer to first card


/***************************************************************************/
/*			Definitions of funktions from file Ik341_1                        */
/***************************************************************************/
void InitIk341(pIk341);
void InitAxis(pG26);
void InitHandler(pG26);
void CommHandler(pG26);
unsigned short G26Main(pG26);  
unsigned short G26Latch(pG26);
unsigned short G26Sync(pG26); 
unsigned short G26Soft(pG26);
unsigned short G26Ref(pG26);
void ReadCountStatus(pG26);
void ReadSignalStatus(pG26);
unsigned char LookforIk341(pIk341);
unsigned char ReadId(unsigned short,unsigned short);
unsigned char ReadConfReg(unsigned short,unsigned short);
void WriteConfReg(unsigned short,unsigned short,unsigned char);
void ReadReg0(pG26 axis);
void ReadReg1(pG26 axis);
void WriteOff00(unsigned short,unsigned char,short);         
void WriteOff90(unsigned short,unsigned char,short);
void WriteG26(unsigned short,unsigned char,unsigned short,unsigned short);
unsigned int ReadG26(unsigned short,unsigned char,unsigned short);
unsigned char Latched(unsigned int,unsigned char,unsigned char);
void PollLatch(unsigned int,unsigned char,unsigned char);
double ReadCountValue_48(unsigned short,unsigned char,unsigned char);
long ReadCountValue_32(unsigned short,unsigned char,unsigned char);
																											  

/***************************************************************************/
/*			Definitions of funktion from file IIC                             */
/***************************************************************************/
unsigned char PotiRead(pIk341,unsigned char,unsigned char,unsigned char,unsigned char);
void PotiInc(pIk341,unsigned char,unsigned char,unsigned char);
void PotiDec(pIk341,unsigned char,unsigned char,unsigned char);
unsigned char ReadPhasepoti(pIk341,unsigned char);
unsigned char ReadSympoti(pIk341,unsigned char);
void WritePhasepoti(pIk341,unsigned char,unsigned char);
void WriteSympoti(pIk341,unsigned char,unsigned char);
void WriteOffset00(pIk341,short,short);
void WriteOffset90(pIk341,short,short);
void TurnPhasepoti(pIk341,unsigned char,unsigned char,unsigned char);
void TurnSympoti(pIk341,unsigned char,unsigned char,unsigned char);
void TurnOffsetdg00(pIk341,unsigned char,unsigned char,unsigned char);
void TurnOffsetdg90(pIk341,unsigned char,unsigned char,unsigned char);
void StorePotis(pIk341);
void PotiDefault(pIk341);
void Read8Byte(pIk341,unsigned char*,unsigned char*,unsigned char*,unsigned char*,
							 unsigned char*,unsigned char*,unsigned char*,unsigned char*);
void Write8Byte(pIk341,unsigned char,unsigned char,unsigned char,unsigned char,
							  unsigned char,unsigned char,unsigned char,unsigned char);
void LoadOffset(pIk341); 
void StoreOffset(pIk341); 
 

/***************************************************************************/
/*			Definitions of funktions from file Poti.cpp                       */
/***************************************************************************/
void CrtInit();
void ShowPotis(pIk341);
void ShowPoti(pIk341,unsigned char,unsigned char);
void TurnPotis(pIk341);

