/*----------------------------DISPLAY.CPP-----------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Sample for IK121 to display all registers of all axes

  V 1.00
  April 1996
 --------------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>
#include <fstream.h>
#include "ik341.h"
#include "ik341_1.h"
extern "C" {
#include "vmerotec.h"
};



const unsigned short Adr_Ik341[] =
{
0,
(DIP_SWITCH_CARD1 >>1) * 0x0200,
(DIP_SWITCH_CARD2 >>1) * 0x0200,
(DIP_SWITCH_CARD3 >>1) * 0x0200,
(DIP_SWITCH_CARD4 >>1) * 0x0200,
(DIP_SWITCH_CARD5 >>1) * 0x0200,
(DIP_SWITCH_CARD6 >>1) * 0x0200,
(DIP_SWITCH_CARD7 >>1) * 0x0200,
(DIP_SWITCH_CARD8 >>1) * 0x0200,
(DIP_SWITCH_CARD9 >>1) * 0x0200,
(DIP_SWITCH_CARD10 >>1) * 0x0200,
(DIP_SWITCH_CARD11 >>1) * 0x0200,
(DIP_SWITCH_CARD12 >>1) * 0x0200,
(DIP_SWITCH_CARD13 >>1) * 0x0200,
(DIP_SWITCH_CARD14 >>1) * 0x0200,
(DIP_SWITCH_CARD15 >>1) * 0x0200,
(DIP_SWITCH_CARD16 >>1) * 0x0200
};

const unsigned short VmeA16Adr_Ik341[] =
{
0,
((((DIP_SWITCH_CARD1 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD2 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD3 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD4 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD5 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD6 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD7 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD8 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD9 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD10 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD11 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD12 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD13 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD14 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD15 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD16 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00
};

unsigned short Card_Adr;					


/*--------------------------------------------------------------------
								main
 --------------------------------------------------------------------- */
int main()
{
pCard board;
double dCountValue10=0, dCountValue20=0, dCountValue30=0, dCountValue40=0;
double dCountValue11=0, dCountValue21=0, dCountValue31=0, dCountValue41=0;        

VmeInit();
board = new struct cardc;
for(int i=1;i<=16;i++)
	{
	if(Adr_Ik341[i] != 0x0000)
		{
		board->card[i] = new struct ik341;
		board->card[i]->axis[1] = new struct g26;
		board->card[i]->axis[2] = new struct g26;
		board->card[i]->axis[3] = new struct g26;
		board->card[i]->axis[4] = new struct g26;
		Card_Adr = Adr_Ik341[i] | 0x8000;
		outport(ADR_REG,VmeA16Adr_Ik341[i]);	//switch to VME A16 memory space
		InitIk341(board->card[i]);
		if (!LookforIk341(board->card[i]))
			{
			cout << "\n IK341 number" << i  << " is missing";
			exit(-1);
			}
		}
	 }
	 
outport(ADR_REG,VmeA16Adr_Ik341[1]);	//switch to VME A16 memory space

_setcursortype(_NOCURSOR);
clrscr();
gotoxy(10,4);
printf("X1/Register0            X2/Register0");       
gotoxy(10,9);
printf("X3/Register0            X4/Register0"); 
gotoxy(10,14);            
printf("X1/Register1            X2/Register1"); 
gotoxy(10,19);
printf("X3/Register1            X4/Register1"); 
									 
while(!kbhit())
	{
	 // Software latch in register 0, axis 1,2,3,4 
	WriteG26(board->card[1]->axis[4]->baseadr,1,CONTROLREG1,0x01);
	WriteG26(board->card[1]->axis[4]->baseadr,2,CONTROLREG1,0x01);
	WriteG26(board->card[1]->axis[4]->baseadr,3,CONTROLREG1,0x01);
	WriteG26(board->card[1]->axis[4]->baseadr,4,CONTROLREG1,0x01);
	// Poll whether latched in register 0 of axis 1,2,3,4 
	PollLatch(board->card[1]->axis[1]->baseadr,1,0x00);
	PollLatch(board->card[1]->axis[1]->baseadr,2,0x00);
	PollLatch(board->card[1]->axis[1]->baseadr,3,0x00);
	PollLatch(board->card[1]->axis[1]->baseadr,4,0x00);
	// Read register0 of axis 1,2,3,4 
	dCountValue10 = ReadCountValue_48(board->card[1]->axis[1]->baseadr,1,0);
	dCountValue20 = ReadCountValue_48(board->card[1]->axis[1]->baseadr,2,0);
	dCountValue30 = ReadCountValue_48(board->card[1]->axis[1]->baseadr,3,0);
	dCountValue40 = ReadCountValue_48(board->card[1]->axis[1]->baseadr,4,0);
	// Check whether latched in register 1 of axis 1,2,3,4 from external input X41
	if(Latched(board->card[1]->axis[1]->baseadr,1,0x01))
		dCountValue11 = ReadCountValue_48(board->card[1]->axis[1]->baseadr,1,1);
	if(Latched(board->card[1]->axis[1]->baseadr,2,0x01))
		dCountValue21 = ReadCountValue_48(board->card[1]->axis[1]->baseadr,2,1);
	if(Latched(board->card[1]->axis[1]->baseadr,3,0x01))                     
		dCountValue31 = ReadCountValue_48(board->card[1]->axis[1]->baseadr,3,1);
	if(Latched(board->card[1]->axis[1]->baseadr,4,0x01))
		dCountValue41 = ReadCountValue_48(board->card[1]->axis[1]->baseadr,4,1);

	// Display measured values 
	gotoxy(5,5);
	printf("%16.4f\t%16.4f", dCountValue10*0.02/1024,
									dCountValue20*0.02/1024);
	gotoxy(5,10);
	printf("%16.4f\t%16.4f", dCountValue30*0.02/1024,
									 dCountValue40*0.02/1024);
	gotoxy(5,15);
	printf("%16.4f\t%16.4f", dCountValue11*0.02/1024,
									dCountValue21*0.02/1024);
	gotoxy(5,20);
	printf("%16.4f\t%16.4f", dCountValue31*0.02/1024,
									 dCountValue41*0.02/1024);
	}               
// Cursor on
_setcursortype (_NORMALCURSOR);

for(int j=1;j<=16;j++)      
	{
	if(Adr_Ik341[j] != 0x0000)
		{
		delete board->card[j]->axis[1];
		delete board->card[j]->axis[2];
		delete board->card[j]->axis[3];
		delete board->card[j]->axis[4];
		delete board->card[j];
		}
	 }
delete board;			 		  
return (0);
}
  