/*---------------------------IK341_0.H--------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Header File for the Basic Functions of the IK341

  V 1.00
  January 1996
  ------------------------------------------------------------------*/


#define CLS printf("\x1B[2J")


/*--------------------------------------------------------------------
  Defines for register addresses.
  ------------------------------------------------------------------*/
#define INITIALIZING_REGISTER   0x24
#define CONTROL_REGISTER_1      0x20
#define CONTROL_REGISTER_2      0x04

/*--------------------------------------------------------------------
  Macro to calculate the IK address.
  ------------------------------------------------------------------*/

#define CALCULATE_IK_BASE_ADDRESS(switch) \
 ((unsigned short)(switch >> 1)*0x0200) | 0x8000

/*--------------------------------------------------------------------
  Macro to switch VME to A16 memory space.
  ROTEC specific code.
  ------------------------------------------------------------------*/

#define SWITCH_VME_TO_A16_ADDRESS_SPACE(switch)    \
 outport (ADR_REG,\
 ((((unsigned short)(switch >> 1)*0x0200)\
 & 0x8000) >> 8) | 0xFC00)

/*Definitions of functions*/

void WriteRegister (unsigned short, unsigned char,
		 unsigned short, unsigned short);

unsigned short ReadRegister (unsigned short, unsigned char,
			unsigned short);

void SoftLatch_0 (unsigned short, unsigned char);

void SoftLatch_1 (unsigned short, unsigned char);

unsigned char CountValueLatched (unsigned short, unsigned char,
			unsigned char);

void PollForLatched (unsigned short,unsigned char,
			unsigned char);

long ReadCountValue_32 (unsigned short, unsigned char,
			 unsigned char);

double ReadCountValue_48 (unsigned short, unsigned char,
			 unsigned char);



