/*----------------------------SAMPLE.C-------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Sample for IK 320

  V 1.00
  September 1995
 -------------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include "vmerotec.h"//Header file for ROTEC VME interface
#include "ik320.h"
#include "sample.h"

/*--------------------------------------------------------------------
  Global variables
  ------------------------------------------------------------------*/

unsigned char extucErrorCode = 0, extucMessage = 0;

/*--------------------------------------------------------------------
  Variables for Compensation run
  ------------------------------------------------------------------*/

unsigned short usIntervalOfCompPoints, usNumberOfCompPoints;

/*--------------------------------------------------------------------
  Main
  ------------------------------------------------------------------*/

void main()
{
  clrscr();

  //Initialize VME interface (ROTEC specific functions)
  VmeInit();
  //Initialize IK 320
  InitIK320(DIP_SWITCH_SI, DIP_SWITCH_SII);

  //Display the main menu
  MainMenu();
  exit(0);
}//End of main


/*--------------------------------------------------------------------
  MainMenu
  ------------------------------------------------------------------*/
void MainMenu()
{
  char cCharacter;

  _setcursortype(_NOCURSOR);


  do
   {
   if (extucErrorCode)
    {
    DisplayError();
    }
   if (extucMessage)
    {
    DisplayMessage();
    }
   clrscr();
   fflush(stdin);
   printf("1: Traverse over Reference Mark axis 1\n");
   printf("2: Traverse over Reference Mark axis 2\n");
   printf("3: Display Position Values\n");
   printf("4: Compensation Run axis 1\n");
   printf("5: Compensation Run axis 2\n");
   printf("6: Compensation On/Off\n");
   printf("0: End");

   do
    {
    if (extucErrorCode)
     {
     DisplayError();
     }
    if (extucMessage)
     {
     DisplayMessage();
     }
    }
   while (!(kbhit()));

   cCharacter=getch();

   switch(cCharacter)
    {
    case '1':
     TraverseOverReferenceMark(DIP_SWITCH_SI, DIP_SWITCH_SII, 1);
     break;
    case '2':
     TraverseOverReferenceMark(DIP_SWITCH_SI, DIP_SWITCH_SII, 2);
     break;
    case '3':
     DisplayPositionValue(DIP_SWITCH_SI, DIP_SWITCH_SII);
     break;
    case '4':
     clrscr();
     fflush(stdin);
     printf("\nNumber of Compensation Points  ");
     scanf("%d",&usNumberOfCompPoints);
     fflush(stdin);
     printf("\nInterval of Compensation Points  ");
     scanf("%d",&usIntervalOfCompPoints);
     CompensationRun (DIP_SWITCH_SI, DIP_SWITCH_SII,1,0,
                      usNumberOfCompPoints,
                      usIntervalOfCompPoints,1);
     break;
    case '5':
     clrscr();
     fflush(stdin);
     printf("\nNumber of Compensation Points	 ");
     scanf("%d",&usNumberOfCompPoints);
     fflush(stdin);
     printf("\nInterval of Compensation Points	");
     scanf("%d",&usIntervalOfCompPoints);
     CompensationRun(DIP_SWITCH_SI, DIP_SWITCH_SII,2,0,usNumberOfCompPoints,
                     usIntervalOfCompPoints,0);
     break;
    case '6':
     CompensationOnOff(DIP_SWITCH_SI, DIP_SWITCH_SII);
     break;
    }
   }
	while(cCharacter!='0');
  //Set normal cursor again
  _setcursortype (_NORMALCURSOR);

  //InitIK320() sets a new interrupt vector. Therefore the old
  //interrupt vector has to be reinstalled.
  RestoreOldInterruptVector();
}//End of MainMenu



