/*----------------------IK320.H---------------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Header File for the Driver Unit IK320.C

  V 1.00
  September 1995
  ------------------------------------------------------------------*/

#define SUBDIVISION        4096
#define IK_BASE_ADDRESS    0xC00000L
#define INTERPOLATION_BITS 12

/*The ROTEC VMEbus interface converts VME interrupts to DOS
  interrupt IRQ15. The following defines are addresses of
  the DOS interrupt controllers.*/
#define INTC1A0   0x20
#define INTC1A1   0x21
#define INTC2A0   0xa0
#define INTC2A1   0xa1
#define INT_NR             0x77        //Dos Interrupt IRQ15
#define INT_MASK          ~0x80        //Interrupt mask IRQ15
#define EOI                0x20        //End of Interrupt command

/*--------------------------------------------------------------------
  Macro to switch VME to A24 memory space;
  ROTEC specific code
  ------------------------------------------------------------------*/
#define SWITCH_VME_TO_A24_ADDRESS_SPACE(switch) outport(ADR_REG,\
(short)((IK_BASE_ADDRESS + switch * 0x4000l) >> 8) & 0xFF80)

/*--------------------------------------------------------------------
  Macro to switch VME to A16 memory space;
  ROTEC specific code
  ------------------------------------------------------------------*/

#define SWITCH_VME_TO_A16_ADDRESS_SPACE(switch) outport(ADR_REG,\
((((short) ((switch & 0xE0) >> 5) * 0x2000) & 0x8000) >> 8 ) |0xFC00)

/*--------------------------------------------------------------------
  Macro to calculate the IK address.
  The code <& 0xFFFF) | 0x8000> is a ROTEC specific
  address modification
  ------------------------------------------------------------------*/

#define CALCULATE_IK_ADDRESS(switch) \
 (short)(((IK_BASE_ADDRESS + switch * 0x4000l)	& 0xFFFF) | 0x8000)

/*--------------------------------------------------------------------
  Macro to calculate the IK group address.
  The code <| 0x8000> is a ROTEC specific
  address modification
  ------------------------------------------------------------------*/

#define 	CALCULATE_BAS_ADR_GROUP(switch) \
 ((short)((switch & 0xE0) >> 5) * 0x2000) | 0x8000

/*--------------------------------------------------------------------
  Addresses of Parameters
  ------------------------------------------------------------------*/
#define  PAR_01_1    0x0102  //Counting direction axis 1
#define  PAR_01_2    0x0103  //Counting direction axis 2
#define  PAR_01_3    0x0104  //Counting direction for axis comb.

#define  PAR_02_1    0x0106  //Definition axis 1
#define  PAR_02_2    0x0107  //Definition axis 2
#define  PAR_02_3    0x0108  //Definition for axis combination

#define  PAR_03      0x010A  //Bits of subdivision

#define  PAR_04_1    0x010C  //Ref. mark spacing axis 1
#define  PAR_04_2    0x010E  //Ref. mark spacing axis 2

#define  PAR_05_1    0x0110  //Signal periods per rev. axis 1
#define  PAR_05_2    0x0114  //Signal periods per rev. axis 2
#define  PAR_05_3    0x0118  //Signal periods per rev. for axis comb.

#define  PAR_06_1    0x011C  //Compensation on/off axis 1
#define  PAR_06_2    0x011D  //Compensation on/off axis 2

#define  PAR_07_1    0x011E  //Compensation start axis 1
#define  PAR_07_2    0x0122  //Compensation start axis 2

#define  PAR_08_1    0x0126  //Number of comp. points axis 1
#define  PAR_08_2    0x0128  //Number of comp. points axis 2

#define  PAR_09_1    0x012A  //Interval comp. points axis 1
#define  PAR_09_2    0x012C  //Interval comp. points axis 2

#define  PAR_10      0x012E  //Latch enable

#define  PAR_19_1    0x0130  //Ref offset axis 1
#define  PAR_19_2    0x0134  //Ref offset axis 2

#define  PAR_21      0x0138  //Axis combination

#define  PAR_30_1    0x013A  //Compensation run axis 1(axis 2)
#define  PAR_30_2    0x013B  //Compensation run axis 2

#define  PAR_70_1    0x013C  //Preset external setting axis 1
#define  PAR_70_2    0x0142  //Preset external setting axis 2
#define  PAR_70_3    0x0148  //Preset external setting for axis comb.

#define  PAR_71_1    0x014E  //Preset Master setting axis 1
#define  PAR_71_2    0x0154  //Preset Master setting axis 2
#define  PAR_71_3    0x015A  //Preset Master setting for axis comb.

#define  PAR_72_1    0x0160  //Axis offset axis 1
#define  PAR_72_2    0x0166  //Axis offset axis 2
#define  PAR_72_3    0x016C  //Axis offset for axis combination

#define  PAR_80_1    0x0172  //External function 1
#define  PAR_80_2    0x0173  //External function 2

#define  PAR_81      0x0100  // Master interrupt function


/*--------------------------------------------------------------------
  Status and Data of IK
  ------------------------------------------------------------------*/
#define  POS_X1_1       0x0000 //Position value axis 1
#define  POS_X1_2       0x0002
#define  POS_X1_3       0x0004
#define  STAT_X1        0x0006 //Status axis 1
#define  TM_X1          0x0007 //Transfer marker axis 1

#define  POS_X2_1       0x0008 //Position value axis 2
#define  POS_X2_2       0x000A
#define  POS_X2_3       0x000C
#define  STAT_X2        0x000E //Status axis 2
#define  TM_X2          0x000F //Transfer marker axis 2

#define  POS_COMB_1     0x0010 //Pos. value comb. axis
#define  POS_COMB_2     0x0012
#define  POS_COMB_3     0x0014
#define  STAT_COMB      0x0016 //Status combined axis
#define  TM_COMB        0x0017 //Transfer marker comb. axis

#define  INTSTAT        0x0018 //IK interrupt status

#define  CRC_NOML       0x001A //Nominal CRC sum EPROM
#define  CRC_ACTL       0x001C //Actual CRC sum EPROM

#define  EPR1_NOML      0x001E //Nominal CRC sum EPROM 1
#define  EPR1_ACTL      0x0022 //Actual CRC sum EPROM 1
#define  EPR2_NOML      0x0026 //Nominal CRC sum EPROM 2
#define  EPR2_ACTL      0x002A //Actual CRC SUM EPROM 2

#define  HRDVERS        0x002E //Hardware version
#define  SFTVERS        0x0030 //Software version

#define  SYSST1         0x003C //System status 1
#define  SYSST2         0x003D //System status 2

#define  PRES1          0x003E //Preset axis 1
#define  PRES2          0x0044 //Preset axis 2
#define  PRES_COMB      0x004A //Preset axis combination


/*--------------------------------------------------------------------
  Prototypes for Functions
  ------------------------------------------------------------------*/
void far interrupt NewInterruptRoutine(void);
void RestoreOldInterruptVector(void);
void Read_IK_InterruptStatus(unsigned char);
void Evaluate_IK_InterruptStatus(unsigned char);

void MasterInterrupt(unsigned char, unsigned char, unsigned short);

void InitIK320 (unsigned char, unsigned char);
void InitParams (unsigned char);
void SetParam (unsigned char, unsigned short, long,short);

void TraverseOverReferenceMark(unsigned char, unsigned char,
                               unsigned char);

void DisplayPositionValue(unsigned char, unsigned char);
void SynchroPosTrigger(unsigned char, unsigned char);

void CompensationRun(unsigned char, unsigned char,
                     unsigned char, unsigned char,
                     unsigned short, unsigned short, short);
void CompensationOnOff(unsigned char, unsigned char);

void DisplayMessage(void);
void DisplayError(void);
