////////////////////////////////////////////////////////////////////////////
///
///	Definition of IK 220 - DLL-Functions 
///
////////////////////////////////////////////////////////////////////////////


#ifndef _DLLFUNC_H_
#define _DLLFUNC_H_

#include <windows.h>

#ifdef __cplusplus
extern "C"
{
#endif


	WINUSERAPI BOOL WINAPI IK220Find_64	    	(UINT64* pBuffer16);
	WINUSERAPI BOOL WINAPI IK220Find256_64   	(UINT64* pBuffer256);

	WINUSERAPI BOOL WINAPI IK220Find			(ULONG* pBuffer16);
	WINUSERAPI BOOL WINAPI IK220Find256			(ULONG* pBuffer256);
	WINUSERAPI BOOL WINAPI IK220Init			(USHORT Axis);
	WINUSERAPI BOOL WINAPI IK220Version			(USHORT Axis, char* pVersCard, char* pVersDrv, char* pVersDll);

	WINUSERAPI BOOL WINAPI IK220Reset			(USHORT Axis);
	WINUSERAPI BOOL WINAPI IK220Start			(USHORT Axis);
	WINUSERAPI BOOL WINAPI IK220Stop			(USHORT Axis);
	WINUSERAPI BOOL WINAPI IK220ClearErr		(USHORT Axis);
	WINUSERAPI BOOL WINAPI IK220Latch			(USHORT Axis, USHORT Latch);

	WINUSERAPI BOOL WINAPI IK220LatchInt		(USHORT Card);
	WINUSERAPI BOOL WINAPI IK220LatchExt		(USHORT Card);
	
	WINUSERAPI BOOL WINAPI IK220ResetRef		(USHORT Axis);
	WINUSERAPI BOOL WINAPI IK220StartRef		(USHORT Axis);
	WINUSERAPI BOOL WINAPI IK220StopRef			(USHORT Axis);
	WINUSERAPI BOOL WINAPI IK220LatchRef		(USHORT Axis);
	
	WINUSERAPI BOOL WINAPI IK220Latched			(USHORT Axis, USHORT Latch, BOOL* pStatus);
	WINUSERAPI BOOL WINAPI IK220WaitLatch		(USHORT Axis, USHORT Latch);

	WINUSERAPI BOOL WINAPI IK220Set				(USHORT Axis, double   SetVal );
	WINUSERAPI BOOL WINAPI IK220SetPreset		(USHORT Axis, double   PresVal);
	WINUSERAPI BOOL WINAPI IK220GetPreset		(USHORT Axis, double* pPresVal);

	WINUSERAPI BOOL WINAPI IK220Read32			(USHORT Axis, USHORT Latch, LONG*   pData);
	WINUSERAPI BOOL WINAPI IK220Read48			(USHORT Axis, USHORT Latch, double* pData);
	WINUSERAPI BOOL WINAPI IK220Get32			(USHORT Axis, USHORT Latch, LONG*   pData);
	WINUSERAPI BOOL WINAPI IK220Get48			(USHORT Axis, USHORT Latch, double* pData);
	WINUSERAPI BOOL WINAPI IK220CntStatus		(USHORT Axis, USHORT Latch,	USHORT* pRefSta, SHORT* pKorr00, SHORT* pKorr90, SHORT* pNKorr00, SHORT* pNKorr90, USHORT* pSamCnt);
	
	WINUSERAPI BOOL WINAPI IK220DoRef			(USHORT Axis);
	WINUSERAPI BOOL WINAPI IK220RefActive		(USHORT Axis, BOOL* pStatus);
	WINUSERAPI BOOL WINAPI IK220WaitRef			(USHORT Axis);
	WINUSERAPI BOOL WINAPI IK220CancelRef		(USHORT Axis);

	WINUSERAPI BOOL WINAPI IK220PositionRef		(USHORT Axis, double* pData,  LONG* pPeriod,  USHORT* pIntpol);
	WINUSERAPI BOOL WINAPI IK220PositionRef2	(USHORT Axis, double* pData1, LONG* pPeriod1, USHORT* pIntpol1, double* pData2, LONG* pPeriod2, USHORT* pIntpol2);
	
	WINUSERAPI BOOL WINAPI IK220Status			(USHORT Axis, ULONG* pStatus);
	WINUSERAPI BOOL WINAPI IK220DllStatus		(ULONG* pStatus, ULONG* pInfo);
	WINUSERAPI BOOL WINAPI IK220RefStatus		(USHORT Axis, LONG* pRef1, LONG* pRef2, LONG* pDiff, LONG* pCode, USHORT* pFlag);
	WINUSERAPI BOOL WINAPI IK220SignalStatus	(USHORT Axis, USHORT* pFreq, USHORT* pAmin, USHORT* pAact, USHORT* pAmax);
	
	WINUSERAPI BOOL WINAPI IK220GetCorrA		(USHORT Axis, SHORT* pOfs0, SHORT* pOfs90, SHORT* pPha0, SHORT* pPha90, SHORT* pSym0, SHORT* pSym90, USHORT* pFlag1, USHORT* pFlag2);
	WINUSERAPI BOOL WINAPI IK220GetCorrB		(USHORT Axis, SHORT* pOfs0, SHORT* pOfs90, SHORT* pPha0, SHORT* pPha90, SHORT* pSym0, SHORT* pSym90, USHORT* pFlag1, USHORT* pFlag2);
	WINUSERAPI BOOL WINAPI IK220LoadCorrA		(USHORT Axis, SHORT   Ofs0, SHORT   Ofs90, SHORT   Pha0, SHORT   Pha90, SHORT   Sym0, SHORT   Sym90);
	WINUSERAPI BOOL WINAPI IK220OctStatus		(USHORT Axis, USHORT* pOct0, USHORT* pOct1, USHORT* pOct2, USHORT* pOct3, USHORT* pOct4, USHORT* pOct5, USHORT* pOct6, USHORT* pOct7, USHORT* pSamCnt);
	
	WINUSERAPI BOOL WINAPI IK220ChkSumPar		(USHORT Axis, USHORT* pChkSum);
	WINUSERAPI BOOL WINAPI IK220ChkSumPrg		(USHORT Axis, USHORT* pChkSum1, USHORT* pChkSum2);

	WINUSERAPI BOOL WINAPI IK220WritePar		(USHORT Axis, USHORT ParNum, ULONG   ParVal);
	WINUSERAPI BOOL WINAPI IK220ReadPar			(USHORT Axis, USHORT ParNum, ULONG* pParVal);

	WINUSERAPI BOOL WINAPI IK220ResetEn			(USHORT Axis, USHORT* pStatus);
	WINUSERAPI BOOL WINAPI IK220ConfigEn		(USHORT Axis, USHORT* pStatus, USHORT* pType, ULONG* pPeriod, ULONG* pStep, USHORT* pTurns, USHORT* pRefDist, USHORT* pCntDir);
	WINUSERAPI BOOL WINAPI IK220ReadEn			(USHORT Axis, USHORT* pStatus, double* pData, USHORT* pAlarm);
	WINUSERAPI BOOL WINAPI IK220ReadEnInc		(USHORT Axis, USHORT Latch, USHORT* pStatus, double* pDataEn, USHORT* pAlarm, double* pDataInc);

	WINUSERAPI BOOL WINAPI IK220ModeEnCont		(USHORT Axis, USHORT Latch, USHORT Mode, USHORT* pStatus);
	WINUSERAPI BOOL WINAPI IK220ReadEnIncCont	(USHORT Axis, USHORT* pStatus, double* pDataEn, USHORT* pAlarm, double* pDataInc, USHORT* pSigSta);

	WINUSERAPI BOOL WINAPI IK220AlarmEn			(USHORT Axis, USHORT* pStatus, USHORT* pAlarm);
	WINUSERAPI BOOL WINAPI IK220WarnEn			(USHORT Axis, USHORT* pStatus, USHORT* pWarn);
	WINUSERAPI BOOL WINAPI IK220ReadMemEn		(USHORT Axis, USHORT Range, USHORT MemAdr, USHORT* pMemData, USHORT* pStatus);
	WINUSERAPI BOOL WINAPI IK220WriteMemEn		(USHORT Axis, USHORT Range, USHORT MemAdr, USHORT   MemData, USHORT* pStatus);

	WINUSERAPI BOOL WINAPI IK220ReadSSI			(USHORT Axis, USHORT* pStatus, double* pData);
	WINUSERAPI BOOL WINAPI IK220ReadSsiInc		(USHORT Axis, USHORT Latch, USHORT* pStatus, double* pDataSsi, double* pDataInc);

	WINUSERAPI BOOL WINAPI IK220SetTimer		(USHORT Axis, ULONG SetVal, ULONG* pTimVal);
	WINUSERAPI BOOL WINAPI IK220ModeTimer		(USHORT Axis, USHORT Mode);

	WINUSERAPI BOOL WINAPI IK220ModeRam			(USHORT Axis, USHORT Mode);
	WINUSERAPI BOOL WINAPI IK220ResetRam		(USHORT Axis);
	WINUSERAPI BOOL WINAPI IK220GetRam			(USHORT Axis, double* pData, USHORT* pRead, USHORT* pWrite, USHORT* pStatus);
	WINUSERAPI BOOL WINAPI IK220GetSig			(USHORT Axis, USHORT* pPeriod, SHORT* pAmp0, SHORT* pAmp90, USHORT* pRead, USHORT* pWrite, USHORT* pStatus);
	WINUSERAPI BOOL WINAPI IK220BurstRam		(USHORT Axis, USHORT maxCount, double* pData, USHORT* pCount, USHORT* pStatus);
	WINUSERAPI BOOL WINAPI IK220BurstSig		(USHORT Axis, USHORT maxCount, USHORT* pPeriod, SHORT* pAmp0, SHORT* pAmp90, USHORT* pCount, USHORT* pStatus);

	WINUSERAPI BOOL WINAPI IK220Led				(USHORT Axis, USHORT Mode);
	WINUSERAPI BOOL WINAPI IK220SysLed			(USHORT Card, USHORT Mode);
	WINUSERAPI BOOL WINAPI IK220GetPort			(USHORT Axis, USHORT* pPortInfo, USHORT* pRising, USHORT* pFalling);

	WINUSERAPI BOOL WINAPI IK220InputW			(USHORT Axis, USHORT Adr, USHORT* pData);
	WINUSERAPI BOOL WINAPI IK220InputL			(USHORT Axis, USHORT Adr, ULONG*  pData);
	WINUSERAPI BOOL WINAPI IK220Output			(USHORT Axis, USHORT Adr, USHORT   Data);
	
	WINUSERAPI BOOL WINAPI IK220RamRead			(USHORT Axis, USHORT Adr, USHORT* pData);
	WINUSERAPI BOOL WINAPI IK220RamWrite		(USHORT Axis, USHORT Adr, USHORT   Data);

	WINUSERAPI BOOL WINAPI IK220DownLoad_64  	(USHORT Axis, IOCTL_DOWNLOAD_DATA* pPgmData, ULONG PgmSize);

	WINUSERAPI BOOL WINAPI IK220DownLoad		(USHORT Axis, USHORT* pPgmData, ULONG PgmSize);

	WINUSERAPI BOOL WINAPI IK220SetEnClock		(USHORT Axis, BOOL  State, USHORT* pStatus);
	WINUSERAPI BOOL WINAPI IK220SetEnData		(USHORT Axis, BOOL  State, USHORT* pStatus);
	WINUSERAPI BOOL WINAPI IK220ReadEnData		(USHORT Axis, BOOL* State);

	WINUSERAPI BOOL WINAPI IK220SetTimeOut		(ULONG TimeOut);

	WINUSERAPI BOOL WINAPI IK220RefEval			(USHORT Axis, USHORT Mode);

	WINUSERAPI BOOL WINAPI IK220SetBw			(USHORT Axis, USHORT Mode);
	WINUSERAPI BOOL WINAPI IK220SetTrm			(USHORT Axis, USHORT Mode);

	WINUSERAPI BOOL WINAPI IK220SetOpMode		(USHORT Axis, USHORT   Mode);
	WINUSERAPI BOOL WINAPI IK220GetOpMode		(USHORT Axis, USHORT* pMode);
      
	WINUSERAPI BOOL WINAPI IK220SetLatInt		(USHORT Card, USHORT Mode);
	WINUSERAPI BOOL WINAPI IK220SetLatExt		(USHORT Card, USHORT Mode);
      

#ifdef __cplusplus
}
#endif


#endif
