program ik121;
(**************************************************************)
(*   Dr. Johannes Heidenhain GmbH                             *)
(*                                                            *)
(*                                                            *)
(*   IK 121  Version 1.00                                     *)
(*                                                            *)
(*   January 1998                                             *)
(*                                                            *)
(**************************************************************)
uses
  Windows,
  ik121_baseunit,
  Forms,
  ik121_unit1 in 'ik121_unit1.pas'                              {Heidenhain},
  ik121_unit2 in 'ik121_unit2.pas'                              {Parameters},
  ik121_unit3 in 'ik121_unit3.pas'                              {Controller},
  display_unit1 in 'display_unit1.pas'                          {Counter_X},
  adjust_unit in 'adjust_unit.pas'                              {Drawer},
  ik121_printer in 'ik121_printer.pas'                          {Output},
  ik121_infounit in 'ik121_infounit.pas';                       {Info}
(**************************************************************)
var
  x        : byte;
  a,b      : word;
  s        : string;

{$R *.RES}
(**************************************************************)
begin

  (* Pointers *)
  new_pointers;

  read_csetup(count);
  read_psetup(cprint);

  adrzeiger:=@boardadressen;
  Status:=IKFind(adrzeiger);

  autoadjust:=false;

  count^.axisnumber:=0;
  if boardadressen[0]<>0 then
    begin
      count^.axisnumber:=1;
      if boardadressen[1]<>0 then
        begin
          count^.axisnumber:=3;
          if boardadressen[2]<>0 then
            begin
              count^.axisnumber:=5;
              if boardadressen[3]<>0 then
                begin
                  count^.axisnumber:=7;
                end;
            end;
        end;
    end;

  if count^.axisnumber>0 then
    begin

      (* Initialize IK 121 *)
      for x:=0 to count^.axisnumber do
        begin
          Status:=IKInit(x,0);
          Status:=IKReset(x);
        end;

      (* Setup IK 121 *)
      for x:=0 to count^.axisnumber do
        begin
          if count^.count[x]^.refmark=one then
            begin
              Status:=IKResetRef(x);
            end;
          if count^.count[x]^.refmark=coded then
            begin
              count^.count[x]^.offset:=0;
              Status:=IKStrtCodRef(x,1,count^.count[x]^.distance);
            end;
         end;

      (* Open windows *)
      Application.Initialize;

      Application.CreateForm(THeidenhain, Heidenhain);
      Heidenhain.Top:=3;
      Heidenhain.Left:=3;
      Heidenhain.visible:=true;

      Application.CreateForm(TParameters, Parameters);
      Parameters.Top:=25;
      Parameters.Left:=25;
      Parameters.FormStyle:=fsStayonTop;

      Application.CreateForm(TController, Controller);
      Controller.Top:=25;
      Controller.Left:=30;
      Controller.FormStyle:=fsStayonTop;

      Application.CreateForm(Tdrawer, drawer);
      drawer.top:=25;
      drawer.left:=35;
      drawer.FormStyle:=fsStayonTop;

      Application.CreateForm(TOutput, Output);
      output.top:=25;
      output.left:=40;
      Output.FormStyle:=fsStayonTop;

      Application.CreateForm(TInfo, Info);
      output.top:=125;
      output.left:=40;
      Output.FormStyle:=fsStayonTop;

      (* Display windows *)
      a:=50;
      b:=16;
      for x:=0 to count^.axisnumber do
        begin
          Application.CreateForm(TCounter_X, Counter[x]);
          Counter[x].Top:=a;
          Counter[x].Left:=b;
          a:=a+105;
        end;
      
      for x:=0 to count^.axisnumber do
        begin
          str(x,s);
          Counter[x].Visible:=true;
          Counter[x].Caption:='Axis '+s;
          Counter[x].xlabel.Caption:='X'+s+':';
          Counter[x].autoscroll:=false;
          Counter[x].borderstyle:=bsSingle;
          Counter[x].formstyle:=fsStayonTop;
        end;

     Init_correct;

     Application.Run;
    end
  else
    begin
      (* No hardware found *)
    end;
  dispose_pointers;
end.

