unit adjust_unit;

interface

uses
  ik121_baseunit,
  ik121_correct,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons;

type
  Tdrawer = class(TForm)
    Timer1: TTimer;
    stop_adjust: TBitBtn;
    offx_button: TButton;
    samp_button: TButton;
    clr_button: TButton;
    axis: TPanel;
    Label2: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    offy_button: TButton;
    phas_button: TButton;
    sym_button: TButton;
    save_button: TButton;
    auto_button: TButton;
    Label1: TLabel;
    Label11: TLabel;
    v0: TPanel;
    v1: TPanel;
    v3: TPanel;
    v2: TPanel;
    p1: TPanel;
    p2: TPanel;
    p3: TPanel;
    p0: TPanel;
    Timer2: TTimer;
    def_button: TButton;
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure stop_adjustClick(Sender: TObject);
    procedure offx_buttonClick(Sender: TObject);
    procedure samp_buttonClick(Sender: TObject);
    procedure clr_buttonClick(Sender: TObject);
    procedure axisClick(Sender: TObject);
    procedure offy_buttonClick(Sender: TObject);
    procedure phas_buttonClick(Sender: TObject);
    procedure sym_buttonClick(Sender: TObject);
    procedure save_buttonClick(Sender: TObject);
    procedure auto_buttonClick(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure def_buttonClick(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  drawer: Tdrawer;

procedure rebuild_draw(count:count_pointr);

implementation

uses ik121_unit3;

{$R *.DFM}

(******************************************************************)
(******************************************************************)
procedure rebuild_draw(count:count_pointr);
var
  ofs0,ofs9 : short;
  data,
  x         : byte;
  s         : string;
begin
  drawer.Canvas.Rectangle(1,1,256,256);

  drawer.Canvas.Pen.Color:=clblue;
  drawer.Canvas.moveto(1,1);
  drawer.Canvas.lineto(1,256);
  drawer.Canvas.lineto(256,256);
  drawer.Canvas.lineto(256,1);
  drawer.Canvas.lineto(1,1);

  drawer.Canvas.Pen.Color:=clyellow;
  drawer.Canvas.moveto(128,1);
  drawer.Canvas.lineto(128,256);
  drawer.Canvas.moveto(1,128);
  drawer.Canvas.lineto(256,128);

  x:=count^.axis;
  str(x,s);
  drawer.axis.caption:=s;

  Status:=ikreadoffset(x,@ofs0,@ofs9);
  str(ofs0,s);
  drawer.v0.Caption:=s;
  str(ofs9,s);
  drawer.v1.Caption:=s;

  Status:=ikreadphase(x,@data);
  str(data,s);
  drawer.v2.Caption:=s;

  Status:=ikreadamp(x,@data);
  str(data,s);
  drawer.v3.Caption:=s;

end;
(******************************************************************)
(* Calculate Compensation Parameters                              *)
(******************************************************************)
procedure calculate(var sin_val,cos_val : adsample);
var
  o,r,
  i,j,z  : byte;
  pr,
  rx,ry  : real;
  ma     : matrix;
  ellfit : boolean;
  dg00_val        : array[0..maxaxis] of signalvalues;
  dg90_val        : array[0..maxaxis] of signalvalues;

begin
      i:=count^.axis;

      for o:=0 to 7 do
        begin
          for r:=0 to val_in_okt do
            begin
              z:=(o*8)+r;
              dg00_val[i,z]:=ik_ad[i].oktant[o].wert[r].dg00;
              dg90_val[i,z]:=ik_ad[i].oktant[o].wert[r].dg90;
            end;
        end;

      ellfit:=ellfit0(dg00_val[i],dg90_val[i],N_Values,ma);

      if ellfit then ellfit:=ellfit1(ma);
      if ellfit then ellfit:=ellfit2(ma);
      if ellfit then ellfit:=ellfit3(ma,Ellipse_Param[i]);

      if ellfit then
        begin
          ellipse_error:=false;

         (* Build image *)
          for j:=0 to N_Values do
            begin
              pr:=2*Pi*j/(N_Values+1);

              rx := (sin(pr + Ellipse_param[i].pv)) + Ellipse_param[i].ofx;
              ry := (Ellipse_param[i].g * cos(pr))  + Ellipse_param[i].ofy;

              rx := 0.8*(rx * 128)+128;
              ry := 0.8*(ry * 128)+128;

              Sin_Val[j] := round(rx);
              Cos_Val[j] := round(ry);
            end;
         end
       else
         begin
           ellipse_error:=true;

           (* Build pseudo values if calculation was not successful *)
           for j:=0 to N_Values do
            begin
              Sin_Val[j] := j;
              Cos_Val[j] := j;
            end;
         end;
end;
(******************************************************************)
(* Draw                                                           *)
(******************************************************************)
procedure draw_ad;
var
 i,r           : byte;
 a,b           : double;
 x,y,j         : word;
begin
  i:=count^.axis;
  drawer.Canvas.Pen.Color:=clgreen;

  for j:=0 to 7 do
    begin
      for r:=0 to val_in_okt do
        begin
          a:=ik_ad[i].oktant[j].wert[r].dg00;
          b:=ik_ad[i].oktant[j].wert[r].dg90;

          a := 0.8*(a * 128)+128;
          b := 0.8*(b * 128)+128;
          x:=round(a);
          y:=round(b);

          if x<=0 then x:=0;
          if x>256 then x:=256;
          if y<=0 then y:=0;
          if y>256 then y:=256;
          drawer.Canvas.moveto(x,y);
          drawer.Canvas.lineto(x+1,y+1);
        end;
    end;
end;
(******************************************************************)
(* Draw                                                           *)
(******************************************************************)
procedure draw_fit(var sin_val,cos_val : adsample);
var
 x,y,j         : word;
begin
  drawer.Canvas.Pen.Color:=clred;

  x := sin_val[0];
  y := cos_val[0];
  if x<=0 then x:=0;
  if x>256 then x:=256;
  if y<=0 then y:=0;
  if y>256 then y:=256;
  drawer.Canvas.moveto(x,y);
  for j:=1 to N_Values do
    begin
      x:=sin_val[j];
      y:=cos_val[j];
      if x<=0 then x:=0;
      if x>256 then x:=256;
      if y<=0 then y:=0;
      if y>256 then y:=256;
      drawer.Canvas.lineto(x,y);
    end;
end;
(******************************************************************)
procedure offxadjust(count:count_pointr);
var
  i         : byte;
  ofx       : real;
  ofs0,ofs9 : short;
begin
  i:=count^.axis;
  ofx := Ellipse_param[i].ofx;
  Status:=ikreadoffset(i,@ofs0,@ofs9);
  if ofx>0 then
    begin
      if ofs0<63 then ofs0:=ofs0-1;
    end
  else
    begin
      if ofs0>-63 then ofs0:=ofs0+1;
    end;
  Status:=ikwriteoffset(i,ofs0,ofs9);
end;
(******************************************************************)
procedure offyadjust(count:count_pointr);
var
  i         : byte;
  ofy       : real;
  ofs0,ofs9 : short;
begin
  i:=count^.axis;
  ofy := Ellipse_param[i].ofy;
  Status:=ikreadoffset(i,@ofs0,@ofs9);
  if ofy>0 then
    begin
      if ofs9<63 then ofs9:=ofs9-1;
    end
  else
    begin
      if ofs9>-62 then ofs9:=ofs9+1;
    end;
  Status:=ikwriteoffset(i,ofs0,ofs9);
end;
(******************************************************************)
procedure phaseadjust(count:count_pointr);
var
  i         : byte;
  phas      : real;
  data      : byte;
begin
  i:=count^.axis;
  phas:= Ellipse_param[i].pv;
  Status:=ikreadphase(i,@data);
  if phas>0 then
    begin
      if data<63 then data:=data+1;
    end
  else
    begin
      if data>0 then data:=data-1;
    end;
  Status:=ikwritephase(i,data);
end;
(******************************************************************)
procedure symadjust(count:count_pointr);
var
  i         : byte;
  sym       : real;
  data      : byte;
begin
  i:=count^.axis;
  sym := Ellipse_param[i].g;
  Status:=ikreadamp(i,@data);
  if sym>1 then
    begin
      if data<63 then data:=data+1;
    end
  else
    begin
      if data>0 then data:=data-1;
    end;
  Status:=ikwriteamp(i,data);
end;
(******************************************************************)
(******************************************************************)
procedure neustart;
var
  i : byte;
begin
   (* Start a new sample *)
  i:=count^.axis;
  if not(ik_ad[i].samp_req) and not(ik_ad[i].samp_rdy) then
    begin
      ik_ad[i].samp_req:=true;
    end;
end;
(******************************************************************)
(* Show compensation values                                       *)
(******************************************************************)
procedure Tdrawer.Timer1Timer(Sender: TObject);
var
 r        : real;
 s        : string;
 i        : word;
begin
  i:=count^.axis;
  if (ik_ad[i].samp_req and ik_ad[i].samp_rdy) then
    begin

      rebuild_draw(count);

      draw_ad;
      calculate(sin_val,cos_val);
      draw_fit(sin_val,cos_val);

      r:=ellipse_param[i].ofx;
      str(r:3:4,s);
      drawer.P0.caption:=s;

      r:=ellipse_param[i].ofy;
      str(r:3:4,s);
      drawer.P1.caption:=s;

      r:=ellipse_param[i].pv;
      str(r:3:4,s);
      drawer.P2.caption:=s;

      r:=ellipse_param[i].g;
      str(r:3:4,s);
      drawer.P3.caption:=s;

      ik_ad[i].samp_req:=false;

    end;
end;
(******************************************************************)
(* Correct potentiometer values                                   *)
(******************************************************************)
procedure Tdrawer.Timer2Timer(Sender: TObject);
begin
  if autoadjust then
    begin
      if not(ellipse_error) then
        begin
          offxadjust(count);
          offyadjust(count);
          phaseadjust(count);
          symadjust(count);
        end;
    end;

  if autosample then
    begin
      neustart;
    end;
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.FormActivate(Sender: TObject);
begin
  rebuild_draw(count);
  autoadjust:=false;
  autosample:=false;
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.axisClick(Sender: TObject);
begin
  autoadjust:=false;
  count^.axis:=count^.axis+1;
  if count^.axis>count^.axisnumber then
    begin
      count^.axis:=0;
    end;
  rebuild_draw(count);
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.stop_adjustClick(Sender: TObject);
begin
  drawer.hide;
  autoadjust:=false;
  autosample:=false;
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.samp_buttonClick(Sender: TObject);
begin
  autoadjust:=false;
  autosample:=not(autosample);
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.clr_buttonClick(Sender: TObject);
begin
  autoadjust:=false;
  autosample:=false;
  rebuild_draw(count);
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.offx_buttonClick(Sender: TObject);
begin
  autoadjust:=false;
  autosample:=true;
  offxadjust(count);
  rebuild_draw(count);
  neustart;
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.offy_buttonClick(Sender: TObject);
begin
  autoadjust:=false;
  autosample:=true;
  offyadjust(count);
  rebuild_draw(count);
  neustart;
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.phas_buttonClick(Sender: TObject);
begin
  autoadjust:=false;
  autosample:=true;
  phaseadjust(count);
  rebuild_draw(count);
  neustart;
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.sym_buttonClick(Sender: TObject);
begin
  autoadjust:=false;
  autosample:=true;
  symadjust(count);
  rebuild_draw(count);
  neustart;
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.save_buttonClick(Sender: TObject);
begin
  autoadjust:=false;
  autosample:=false;
  Status:=IKstore(count^.axis);
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.auto_buttonClick(Sender: TObject);
begin
  autoadjust:=not(autoadjust);
  autosample:=autoadjust;
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.def_buttonClick(Sender: TObject);
var
  x : byte;
begin
  x:=count^.axis;
  autoadjust:=false;
  autosample:=false;
  Status:=ikdefault(x);
  rebuild_draw(count);
end;
(******************************************************************)
(******************************************************************)
end.
