/*++

	Copyright (c) 1998,  Dr. Johannes Heidenhain GmbH

	Module Name:	DllMain.c
	
	Version 1.1:	22.06.1998

	Abstract:		Windows DLL for IK 121

	Notes:			This DLL provides IK 121 card functions for IK 121.
					IK121 hardware is accsessed through IK121Drv.Sys.


	History:		V1.1
						- Device driver started by the system not by the DLL.

--*/


#include <windows.h>
#include "dllglob.h"


#ifndef _Windows95
#include <winioctl.h>
#include <winsvc.h>
#endif

//
//  FUNCTION: DLLMain(HINSTANCE, DWORD, LPVOID)
//
//  PURPOSE:  Called when DLL is loaded by a process, and when new
//			  threads are created by a process that has already loaded the
//			  DLL.  Also called when threads of a process that has loaded the
//			  DLL exit cleanly and when the process itself unloads the DLL.
//
//  PARAMETERS:
//    hDLLInst    - Instance handle of the DLL
//    fdwReason   - Process attach/detach or thread attach/detach
//    lpvReserved - Reserved and not used
//
//  RETURN VALUE:  (Used only when fdwReason == DLL_PROCESS_ATTACH)
//    TRUE  -  Used to signify that the DLL should remain loaded.
//    FALSE -  Used to signify that the DLL should be immediately unloaded.
//
//  COMMENTS:
//
//    When fdwReason == DLL_PROCESS_ATTACH, the return value is used to
//    determine if the DLL should remain loaded, or should be immediately
//    unloaded depending upon whether the DLL could be initialized properly.
//    For all other values of fdwReason, the return value is ignored.
//



#undef StartService			// Service not started


BOOL WINAPI DllMain(HINSTANCE hDLLInst, DWORD fdwReason, LPVOID lpvReserved)
{

int Axis;

#ifdef _Windows95
	int IKCard;
	LPCTSTR SubKey = "System\\CurrentControlSet\\Services\\IK121Drv\\Parameters";
	LPTSTR ValueName[8] = {"IK_Base_1","IK_Base_2","IK_Base_3","IK_Base_4","IK_Base_5","IK_Base_6","IK_Base_7"};
	HKEY hkResult;
	ULONG RegStatus;
	ULONG Type;
	ULONG Leng;
#else
  #ifdef _StartService
	SC_HANDLE		hSCManager, hService;
	unsigned char	szService[] = "IK121Drv";
	BOOL			success;	
	SERVICE_STATUS	serviceStatus;
  #endif
#endif


    switch (fdwReason)
    {
        case DLL_PROCESS_ATTACH:


		for (Axis=0; Axis<16; Axis++)
		{
			CodRefSta   [Axis]=0;		// Clear status for coded REF
			Ram_OfsReg0 [Axis]=0;		// Clear shadow register for offset  0 degree
			Ram_OfsReg90[Axis]=0;		// Clear shadow register for offset 90 degree
			Ram_LatchReg[Axis]=0;		// Clear shadow register for latch register
		}


		#ifdef _Windows95


			RegStatus = RegOpenKeyEx ( HKEY_LOCAL_MACHINE,		// Handle of open key 
									   SubKey,					// Address of name of subkey to open 
									   0,						// Reserved 
									   KEY_READ,				// Security access mask 
									   &hkResult );				// Address of handle of open key 


			if (RegStatus == ERROR_SUCCESS)
			{
				for (IKCard=0; IKCard<8; IKCard++)
				{
					Leng = sizeof(PortBase[0]);
					RegStatus = RegQueryValueEx( hkResult,					// Handle of key to inquiry 
												 ValueName[IKCard],			// Address of name of value to inquiry 
												 NULL,						// Reserved 
												 &Type,						// Address of buffer for value type 
												 (UCHAR*)&(PortBase[IKCard]),	// Address of data buffer 
												 &Leng );	 				// Address of data buffer size 

					if ( (RegStatus != ERROR_SUCCESS) || (Type !=REG_DWORD) || (Leng != sizeof(PortBase[0])) )
						if (IKCard==0) PortBase[IKCard]=0x330;
						else PortBase[IKCard]=0;
				}
				RegCloseKey (hkResult);
			}
			else 
			{
				PortBase[0]=0x330;
				for (IKCard=2; IKCard<8; IKCard++) PortBase[IKCard]=0;
			}
		

		#else		// ifdef _Windows95


		  #ifdef _StartService

			// Start device driver IK121Drv.SYS
			///////////////////////////////////

			hSCManager = OpenSCManager ( NULL,						// Local Computer
										 NULL,						// ServiceActive Database
										 SC_MANAGER_CONNECT );

			if (hSCManager == NULL) return FALSE;

			hService = OpenService ( hSCManager,
									 (LPCTSTR) szService,
									 SERVICE_START | SERVICE_STOP );

			if (hService == NULL)
			{
				CloseServiceHandle (hSCManager);
				return FALSE;
			}


			success = StartService ( hService,
									 0,
									 NULL );

			if ( (!success) && (GetLastError() == ERROR_SERVICE_ALREADY_RUNNING) )
			{
				success = ControlService ( hService,
										   SERVICE_CONTROL_STOP,
										   &serviceStatus );

				if (success) success = StartService ( hService,
													  0,
													  NULL );
				else
				{
					CloseServiceHandle (hService);
					CloseServiceHandle (hSCManager);
					return FALSE;
				}
			}

			CloseServiceHandle (hService);
			CloseServiceHandle (hSCManager);

		  #endif


			// Open device driver IK121Drv.SYS
			//////////////////////////////////

			m_hIK121Drv = CreateFile ( "\\\\.\\IK121Drv",
									   GENERIC_READ | GENERIC_WRITE,
									   0,
									   NULL,
									   OPEN_EXISTING,
									   FILE_ATTRIBUTE_NORMAL,
									   NULL );

			if ( m_hIK121Drv == INVALID_HANDLE_VALUE ) return FALSE;
	#endif		// ifdef _Windows95

            break;


        case DLL_PROCESS_DETACH:

	#ifdef _Windows95


	#else		// ifdef _Windows95


			CloseHandle (m_hIK121Drv);		// Stop device driver IK121Drv.SYS


		  #ifdef _StartService

			hSCManager = OpenSCManager ( NULL,						// Local Computer
										 NULL,						// ServiceActive Database
										 SC_MANAGER_CONNECT );		// Connect Service Manager

			hService = OpenService ( hSCManager,					// Open service for stop
									 (LPCTSTR) szService,
									 SERVICE_STOP );

			ControlService ( hService,								// Stop service
							 SERVICE_CONTROL_STOP,
							 &serviceStatus );

			CloseServiceHandle (hService);
			CloseServiceHandle (hSCManager);

		  #endif


	#endif		// ifdef _Windows95
            break;


        case DLL_THREAD_ATTACH:
            // A thread is being created in a process that has already loaded
            // this DLL.  Perform any per-thread initialization here.  The
            // return value is ignored.
            break;

        case DLL_THREAD_DETACH:
            // A thread is exiting cleanly in a process that has already
            // loaded this DLL.  Perform any per-thread clean up here.  The
            // return value is ignored.
            break;
    }
    return TRUE;
}
