//
//  MODULE:   dllglob.h
//
//	Version 1.0:	21.09.1999
//
//  PURPOSE:
//    Contains declarations for all globally scoped names in the DLL.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef INC_DLLGLOB_H
#define INC_DLLGLOB_H

#include <windows.h>


//-------------------------------------------------------------------------
// Constant definitions
#define DLLEXPORT __declspec(dllexport)


#define DataReg0	 (USHORT)0x00		// Address of data register 0
#define DataReg1	 (USHORT)0x06		// Address of data register 1
#define InitReg1	 (USHORT)0x0C		// Address of initializing register 0
#define ContrReg	 (USHORT)0x0E		// Address of initializing register 1
#define RefCmdReg	 (USHORT)0x10		// Address of initializing register 2
#define LatchReg	 (USHORT)0x12		// Address of latch  register
#define IntrReg		 (USHORT)0x14		// Address of Interrupt enable register
#define OfsReg0		 (USHORT)0x16		// Address of offset register  0
#define OfsReg90	 (USHORT)0x18		// Address of offset register 90
#define TimReg		 (USHORT)0x1A		// Address of timer register
#define StatReg3	 (USHORT)0x1C		// Address of status register 3
#define ContrReg3	 (USHORT)0x1E		// Address of initializing register 3


#define cmdLatch0	 (USHORT)0x0001		// Command: latch counter to data register 0 
#define cmdLatchSync (USHORT)0x0004		// Command: latch all counters 
#define cmdStart	 (USHORT)0x0008		// Command: start counter
#define cmdStop		 (USHORT)0x0010		// Command: stop  counter
#define cmdReset	 (USHORT)0x0020		// Command: reset counter
#define cmdClear	 (USHORT)0x00C0		// Command: clear frequency and amplitude error

#define cmdStartREF	 (USHORT)0x0001		// Command: start counter with next reference mark
#define cmdStopREF	 (USHORT)0x0002		// Command: stop  counter with next reference mark
#define cmdResetREF	 (USHORT)0x0004		// Command: reset counter with next reference mark
#define cmdLatchREF	 (USHORT)0x0008		// Command: latch counter with next reference mark 

#define cmdREF2L0	 (USHORT)0x0000		// Command: latch with reference mark is stored
										//          in data register 0

#define cmdREF2L1	 (USHORT)0xC000		// Command: latch with reference mark is stored
										//          in data register 1

#define cmdADFreeze	 (USHORT)0x0018		// Command: freeze   A/D converter values
#define cmdADFree	 (USHORT)0x0008		// Command: unfreeze A/D converter values


//-------------------------------------------------------------------------
// Exported function declarations

DLLEXPORT BOOL WINAPI IKDefine		  (ULONG* pBuffer8);
DLLEXPORT BOOL WINAPI IKFind	      (ULONG* pBuffer8);
DLLEXPORT BOOL WINAPI IKInit	      (USHORT Axis, USHORT Mode);
DLLEXPORT BOOL WINAPI IKVersion		  (USHORT Axis, char* pVersCard, char* pVersDrv, char* pVersDll);

DLLEXPORT BOOL WINAPI IKReset	      (USHORT Axis);
DLLEXPORT BOOL WINAPI IKStart	      (USHORT Axis);
DLLEXPORT BOOL WINAPI IKStop	      (USHORT Axis);
DLLEXPORT BOOL WINAPI IKLatch         (USHORT Axis, USHORT Latch);

DLLEXPORT BOOL WINAPI IKResetREF      (USHORT Axis);
DLLEXPORT BOOL WINAPI IKStartREF      (USHORT Axis);
DLLEXPORT BOOL WINAPI IKStopREF       (USHORT Axis);
DLLEXPORT BOOL WINAPI IKLatchREF      (USHORT Axis, USHORT Latch);

DLLEXPORT BOOL WINAPI IKLatched       (USHORT Axis, USHORT Latch, BOOL* pStatus);
DLLEXPORT BOOL WINAPI IKWaitLatch     (USHORT Axis, USHORT Latch);

DLLEXPORT BOOL WINAPI IKStrtCodRef    (USHORT Axis, USHORT Latch, ULONG RefDist);
DLLEXPORT BOOL WINAPI IKCodRef	      (USHORT Axis, BOOL* pStatus, double* pData);
DLLEXPORT BOOL WINAPI IKWaitCodRef    (USHORT Axis, double* pData);
DLLEXPORT BOOL WINAPI IKStopCodRef    (USHORT Axis);

DLLEXPORT BOOL WINAPI IKClear	      (USHORT Axis);
DLLEXPORT BOOL WINAPI IKStatus        (USHORT Axis, ULONG* pStatus);

DLLEXPORT BOOL WINAPI IKRead32        (USHORT Axis, USHORT Latch, LONG*   pData);
DLLEXPORT BOOL WINAPI IKRead48        (USHORT Axis, USHORT Latch, double* pData);

DLLEXPORT BOOL WINAPI IKReadPhase     (USHORT Axis, BYTE* pData);
DLLEXPORT BOOL WINAPI IKWritePhase    (USHORT Axis, BYTE   Data);
DLLEXPORT BOOL WINAPI IKLoadPhase	  (USHORT Axis, BYTE* pData);

DLLEXPORT BOOL WINAPI IKReadAmp       (USHORT Axis, BYTE* pData);
DLLEXPORT BOOL WINAPI IKWriteAmp      (USHORT Axis, BYTE   Data);
DLLEXPORT BOOL WINAPI IKLoadAmp		  (USHORT Axis, BYTE* pData);

DLLEXPORT BOOL WINAPI IKReadOffset    (USHORT Axis, SHORT* Ofs0, SHORT* Ofs90);
DLLEXPORT BOOL WINAPI IKWriteOffset   (USHORT Axis, SHORT  Ofs0, SHORT  Ofs90);
DLLEXPORT BOOL WINAPI IKLoadOffset	  (USHORT Axis, SHORT* Ofs0, SHORT* Ofs90);

DLLEXPORT BOOL WINAPI IKStore	 	  (USHORT Axis);
DLLEXPORT BOOL WINAPI IKDefault		  (USHORT Axis);

DLLEXPORT BOOL WINAPI IKRomRead       (USHORT Card, BYTE  Adr, BYTE* Data);
DLLEXPORT BOOL WINAPI IKRomWrite	  (USHORT Card, BYTE  Adr, BYTE  Data);

DLLEXPORT BOOL WINAPI IKInputW		  (USHORT Axis, USHORT Adr, USHORT* pBuffer);
DLLEXPORT BOOL WINAPI IKInputL	      (USHORT Axis, USHORT Adr, ULONG*  pBuffer);
DLLEXPORT BOOL WINAPI IKOutput	      (USHORT Axis, USHORT Adr, USHORT  Data);

DLLEXPORT BOOL WINAPI IKSetI2C		  (USHORT Card, BOOL SCL, BOOL SDA);


DLLEXPORT BOOL WINAPI IKSetTimer	  (USHORT Axis, USHORT SetVal);
DLLEXPORT BOOL WINAPI IKEnableLatch   (USHORT Axis, USHORT Latch, USHORT Source);
DLLEXPORT BOOL WINAPI IKEnableSync    (USHORT Card, USHORT Source);
DLLEXPORT BOOL WINAPI IKLatchAll      (USHORT Axis);
																		

//-------------------------------------------------------------------------
// Global variables

extern USHORT CodRefSta   [16];		// Status for coded ref.
extern USHORT Ram_OfsReg0 [16];		// Shadow register for offset  0 degree (register 16H/17H)
extern USHORT Ram_OfsReg90[16];		// Shadow register for offset 90 degree (register 18H/19H)
extern USHORT Ram_LatchReg[16];		// Shadow register for latch register   (register 12H/13H)

#ifdef _Windows95
	extern ULONG  PortBase[8];
#else
	extern HANDLE m_hIK121Drv;
#endif



//-------------------------------------------------------------------------
// Product identifier string defines

#define SZAPPNAME     "IK121Dll"
#define SZDESCRIPTION "Win32 DLL for IK 121"
#define SZVERSION     "Version 4.0"


//-------------------------------------------------------------------------
// Version string definitions

#define SZRCOMPANYNAME "Dr. Johannes Heidenhain GmbH"
#define SZRDESCRIPTION "FileDescription"
#define SZRVERSION     "FileVersion"
#define SZRAPPNAME     "InternalName"
#define SZRCOPYRIGHT   "LegalCopyright"
#define SZRTRADEMARK   "LegalTrademarks"
#define SZRPRODNAME    "ProductName"
#define SZRPRODVER     "ProuctVersion"


#endif // INC_DLLGLOB_H
