/*++

	Copyright (c) 1997,  Dr. Johannes Heidenhain GmbH

	Module Name:	IK121Con.cpp
	
	Version 1.0:	22.01.1998

	Abstract:		Windows Console Application for IK 121.

	Notes:			This application shows IK 121 card functions.
					IK 121 is accessed through IK121Dll.DLL.


	History:		- Display of device driver and DLL version added		ES		11.06.99
--*/


#include <windows.h>
#include <stdio.h>								  
#include <conio.h>
#include "..\Include\DllFunc.h"


#define Latch		0		// Latch for display
#define RefLatch	1		// Latch for REF
#define CodedREF	0		// Evaluate coded ref. marks
#define TP			0.020	// Signal period 20 m

void main (void)
{
	
	ULONG		IKCard[8];		// Port address of IK card(s)
	USHORT		Ax;				// Axis number
	double		Count48;		// Count value 48Bit
	ULONG		Status;			// Status
	BOOL		RefSta;			// Status for coded ref.
	BOOL		RefStatus[8];	// Status for ref.
	double		OffsetCRef[8];	// Offset for coded ref. marks
	BYTE		Data;			// Phase and amplitude compensation values
	SHORT		Ofs0, Ofs90;	// Offset compensation values

	char		VersCard[20], VersDrv[20], VersDll[20];


	printf ("\n\n                  *****   IK 121   *****\n");




	
	if (!IKFind (IKCard)) printf ("Error: IKFind\n");				// Read port address of IK card(s)

	for (Ax=0; Ax<8; Ax++)
		if (IKCard[Ax])
		{
			printf ("IK 121 at address: 0x%lX\n", IKCard[Ax]);		// Output port address of IK card(s)

			if (!IKVersion (Ax, &VersCard[0], &VersDrv[0], &VersDll[0])) printf ("Error: IKVersion\n");				// Read port address of IK card(s)
			else 
				printf ("Card: %s   %s   %s\n", VersCard, VersDrv, VersDll);   
		}

	printf ("\n");



    for (Ax=0; Ax<8; Ax++)
		if (IKCard[Ax>>1])
		{
			if (!IKInit(Ax, 1)) printf ("\nError: IKInit %d\n", Ax);		// Init IK card(s)

			printf ("Axis %d:\t", Ax);
			if (!IKStatus (Ax, &Status)) printf ("\nError: IKStatus %d\n", Ax);
			else printf ("Status = %08lX\n", Status);

			if (!IKReadPhase (Ax, &Data)) printf ("\nError: IKReadPhase %d\n", Ax) ;
			else printf ("\tPhase = %3d     ", Data);

			if (!IKReadAmp (Ax, &Data)) printf ("\nError: IKReadAmp %d\n", Ax) ;
			else printf ("Amplitude = %3d     ", Data);

			if (!IKReadOffset (Ax, &Ofs0, &Ofs90)) printf ("\nError: IKReadOffset %d\n", Ax) ;
			else printf ("Offset 0 = %3d     Offset 90 = %3d\n", Ofs0, Ofs90);
		}
	printf ("\n");

#if CodedREF==1
	for (Ax=0; Ax<8; Ax++)
	{
		RefStatus[Ax]=FALSE;
		OffsetCRef[Ax]=0;
		if (IKCard[Ax>>1])
			if (!IKStrtCodRef (Ax, RefLatch, 1000)) printf ("\nError: IKStrtCodRef %d\n", Ax);
	}

	RefSta=FALSE;
#else
	RefSta=TRUE;
#endif


   	while( !_kbhit() )
	{
		if (!RefSta)
		{
			RefSta=TRUE;
			for (Ax=0; Ax<8; Ax++)
				if (IKCard[Ax>>1]!=0)
				{
					if (!RefStatus[Ax])
						if (!IKCodRef (Ax, &RefStatus[Ax], &OffsetCRef[Ax]))
							printf ("\nError IKCodRef\n");
					RefSta=RefSta & RefStatus[Ax];
				}
		}
		
			
		for (Ax=0; Ax<8; Ax++)
			if (IKCard[Ax>>1]!=0) 
			{
				if (!IKLatch (Ax,Latch)) printf ("\nError IKLatch\n");										// Store counter value
				if (!IKWaitLatch (Ax,Latch)) printf ("\nError IKWaitLatch\n");								// Wait until stored

				if (IKRead48 (Ax, Latch, &Count48)) printf ("%14.4f",((Count48+OffsetCRef[Ax])/1024*TP));	// Output counter value
				else printf("   Error  ");
			}
		printf("\r");

		if (RefSta) Sleep (100);		// Wait for a while
	}

	printf ("\n");
}
