program wrrom;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Write to User ROM                                     }
{                                                       }
{ V 1.00                                                }
{ July 1994                                             }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

uses crt,ik121_1;

var
    error : boolean;
    xx    : byte;
    board : ik121_pointr;
    axis1,axis2 : g26_pointr;
{----------------------------------------------------------}
procedure wr_rom(board:ik121_pointr);
var
   f   : file of byte;
   b   : byte;
   adr : word;
begin
      error:=false;
      gotoxy(2,2);
      write('Writing to EEPROM File IK121.TXT!');
      Assign(f,'ik121.txt');
      (* $I- *)
      reset(f);
      (* $I+ *)
      if ioresult=0 then
        begin
          adr:=0;
          gotoxy(1,5);
          while (not(eof(f))) and (adr<512) do
            begin
              read(f,b);
              rom_write(board,adr,b,error);
              write(char(b));
              adr:=adr+1;
            end;
          close(f);
          while (adr<512) do
            begin
              rom_write(board,adr,32,error);
              adr:=adr+1;
            end;
        end
      else
        begin
          writeln('No File');
          readln;
        end;
end;
{----------------------------------------------------------}
begin
  textbackground(7);
  clrscr;
  textcolor(15);
  New(board);
  New(axis1);
  New(axis2);
  board^.axis[1]:=axis1;
  board^.axis[2]:=axis2;
  init_ik121(board);
  if look_for_ik121(board) then
    begin
      wr_rom(board);
    end
  else
    begin
      clrscr;
      write('No hardware!');
      readln;
    end;
  Dispose(board);
  Dispose(axis1);
  Dispose(axis2);
  textbackground(0);
  clrscr;
end.