UNIT scope_0;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Driver Unit for SCOPE.EXE                             }
{                                                       }
{ V 1.01                                                }
{ April 1995                                            }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

interface

uses crt,graph,cnt_0,ik121_0,ik121_1,ik121_2;

procedure oszi(board:ik121_pointr);

Implementation
(*________________________________________*)
procedure scopeheader;
begin
  setbkcolor(7);
  setcolor(1);
  rectangle(2,2,636,386);

  setcolor(15);
  rectangle(4,4,632,382);

  setfillstyle(1,7);
  bar(10,10,600,40);
  bar(10,330,600,370);
  bar(10,400,600,450);

  setcolor(1);
  rectangle(10,10,600,40);
  rectangle(10,330,600,370);
  rectangle(10,400,600,450);

  setcolor(8);
  settextstyle(0,0,1);
  outtextxy(20,15,'Scope');
  outtextxy(100,15,'Red  : DG00');
  outtextxy(250,15,'Blue : DG90');
  setcolor(15);
  outtextxy(21,16,'Scope');
  outtextxy(101,16,'Red  : DG00');
  outtextxy(251,16,'Blue : DG90');
  setfillstyle(1,15);
  bar(10,50,600,310);

  setcolor(1);
  rectangle(9,49,601,311);

  ctext3d(20,340,'q : Quit',8,15);
  ctext3d(100,340,'1 : Axis 1',8,11);
  ctext3d(100,350,'2 : Axis 2',8,15);
  ctext3d(250,340,'3 : XY-Graph Axis 1',8,15);
  ctext3d(250,350,'4 : XY-Graph Axis 2',8,15);

  ctext3d(100,410,'a : Offset DG00',8,11);
  ctext3d(100,420,'b : Offset DG90',8,15);
  ctext3d(100,430,'c : Ampl. DG00',8,15);
  ctext3d(100,440,'d : Phase DG90',8,15);

  ctext3d(250,440,'s : Store pots',8,15);

  ctext3d(400,410,'+ : Increment pot',8,15);
  ctext3d(400,420,'- : Decrement pot',8,15);
  ctext3d(400,430,'> : Fast increment',8,15);
  ctext3d(400,440,'< : Fast decrement',8,15);

end;
(*________________________________________*)
procedure clear;
begin
  setfillstyle(1,15);
  bar(10,50,600,310);   (* Erase-bar *)
end;
(*________________________________________*)
(*                                        *)
(*  X-T Graph                             *)
(*________________________________________*)
procedure show_sample1(pointr: single_pointr);
var
  x0,y0,x1,y1 : word;
  dg00,dg90,dg00alt,dg90alt : word;
begin
  x0:=10;
  while pointr^.next<>nil do
    begin
      dg00alt:=pointr^.dg00;
      dg90alt:=pointr^.dg90;
      pointr:=pointr^.next;
      dg00:=pointr^.dg00;
      dg90:=pointr^.dg90;

      setfillstyle(1,15);
      bar(x0+1,70,x0+4,133);
      bar(x0+1,200,x0+4,263);

      setcolor(2);
      moveto(x0,32+70);
      lineto(x0+4,32+70);

      setcolor(4);
      y0:=(dg00alt shr 4)+70;
      if y0>310 then y0:=310;
      if y0<50 then y0:=50;
      moveto(x0,y0);

      y0:=(dg00 shr 4)+70;
      if y0>310 then y0:=310;
      if y0<50 then y0:=50;
      lineto(x0+4,y0);

      setcolor(2);
      moveto(x0,32+200);
      lineto(x0+4,32+200);

      setcolor(1);
      y0:=(dg90alt shr 4)+200;
      if y0>310 then y0:=310;
      if y0<50 then y0:=50;
      moveto(x0,y0);

      y0:=(dg90 shr 4)+200;
      if y0>310 then y0:=310;
      if y0<50 then y0:=50;
      lineto(x0+4,y0);
      x0:=x0+4;
    end;
end;
(*________________________________________*)
(*                                        *)
(*  X-Y Graph                             *)
(*________________________________________*)
procedure show_sample2(pointr: single_pointr);
var
  buffer                    : single_pointr;
  x0,y0,x1,y1               : word;
  dg00,dg90,dg00alt,dg90alt : word;
begin
  buffer:=pointr;
  while pointr^.next<>nil do
    begin
      dg00alt:=pointr^.dg00;
      dg90alt:=pointr^.dg90;
      pointr:=pointr^.next;
      dg00:=pointr^.dg00;
      dg90:=pointr^.dg90;

      setcolor(2);
      moveto(10,180);
      lineto(600,180);
      moveto(300,50);
      lineto(300,310);

      setcolor(4);
      x0:=(dg00alt shr 2)+172;
      if x0>310 then y0:=310;
      if x0<50 then y0:=50;
      y0:=(dg90alt shr 2)+52;
      if y0>310 then y0:=310;
      if y0<50 then y0:=50;

      moveto(x0,y0);

      x0:=(dg00 shr 2)+172;
      if x0>310 then y0:=310;
      if x0<50 then y0:=50;
      y0:=(dg90 shr 2)+52;
      if y0>310 then y0:=310;
      if y0<50 then y0:=50;
      lineto(x0,y0);
    end;

  pointr:=buffer;
  while pointr^.next<>nil do
    begin
      dg00alt:=pointr^.dg00;
      dg90alt:=pointr^.dg90;
      pointr:=pointr^.next;
      dg00:=pointr^.dg00;
      dg90:=pointr^.dg90;

      setcolor(2);
      moveto(10,180);
      lineto(600,180);
      moveto(300,50);
      lineto(300,310);

      setcolor(15);
      x0:=(dg00alt shr 2)+172;
      if x0>310 then y0:=310;
      if x0<50 then y0:=50;
      y0:=(dg90alt shr 2)+52;
      if y0>310 then y0:=310;
      if y0<50 then y0:=50;

      moveto(x0,y0);

      x0:=(dg00 shr 2)+172;
      if x0>310 then y0:=310;
      if x0<50 then y0:=50;
      y0:=(dg90 shr 2)+52;
      if y0>310 then y0:=310;
      if y0<50 then y0:=50;
      lineto(x0,y0);
    end;
end;
(*________________________________________*)
procedure xyminmax;
var i : byte;
begin
  setcolor(4);
  moveto(40,160);
  lineto(60,160);
  lineto(55,155);
  moveto(55,165);
  lineto(60,160);
  outtextxy(70,160,'+ DG00');
  moveto(40,160);
  lineto(40,140);
  lineto(35,145);
  moveto(40,140);
  lineto(45,145);
  outtextxy(30,130,'- DG90');
  setcolor(2);
  Circle(300,180,128);
  Circle(300,180,20);
  setcolor(13);
  for i:=1 to 15 do
    begin
      Circle(300,180,(i*8));
    end;
  setcolor(1);
  moveto(450,50);
  lineto(450,310);
  setlinestyle(3,0,1);
  moveto(300,52);
  lineto(455,52);
  moveto(460,52);
  outtext('+8 uA');
  moveto(300,84);
  lineto(455,84);
  moveto(460,84);
  outtext('+6 uA');
  moveto(300,116);
  lineto(455,116);
  moveto(460,112);
  outtext('+4 uA');
  moveto(300,160);
  lineto(455,160);
  moveto(460,156);
  outtext('+1.25 uA');
  setlinestyle(0,0,1);
  moveto(445,180);
  lineto(455,180);
  moveto(460,176);
  outtext('0 uA');
  moveto(445,200);
  lineto(455,200);
  moveto(460,196);
  outtext('-1.25 uA');
  moveto(445,244);
  lineto(455,244);
  moveto(460,240);
  outtext('-4 uA');
  moveto(445,276);
  lineto(455,276);
  moveto(460,276);
  outtext('-6 uA');
  moveto(445,308);
  lineto(455,308);
  moveto(460,300);
  outtext('-8 uA');
end;
(*________________________________________*)
procedure xtminmax(board:ik121_pointr);
var
  i                 : word;
  s                 : string;
  timbase,timerwert : word;
begin
  timerwert:=board^.axis[1]^.timer;
  setcolor(2);
  moveto(10,170);
  lineto(540,170);
  for i:=1 to 9 do
    begin
      moveto((i*50)+10,165);
      lineto((i*50)+10,175);
      moveto((i*50)+10,180);
      timbase:=round(i*12.5*timerwert/100);
      str(timbase:3,s);
      outtext(s);
    end;
  setlinestyle(3,0,1);
  moveto(10,102);
  lineto(540,102);
  moveto(10,232);
  lineto(540,232);
  moveto(10,134);
  lineto(540,134);
  moveto(10,69);
  lineto(540,69);
  moveto(10,264);
  lineto(540,264);
  moveto(10,199);
  lineto(540,199);
  moveto(530,50);
  lineto(530,310);
  setlinestyle(0,0,1);
  outtextxy(545,65,'+8uA');
  outtextxy(545,129,'-8uA');
  outtextxy(545,160,'us');
  outtextxy(545,195,'+8uA');
  outtextxy(545,260,'-8uA');
end;
(*________________________________________*)
procedure oszi(board:ik121_pointr);
var
  ende,cont,prev,trig : boolean;
  eing      : char;
  axis,poti : byte;
  w         : string;
  pointr    : single_pointr;
  mode      : byte;
  refresh   : word;
  error     : boolean;
begin
  refresh:=0;
  mode:=0;
  SetFillpattern(schw,3);
  bar(1,1,getmaxx,getmaxy);
  init_analyze(board);
  scopeheader;
  xtminmax(board);
  ende:=false;
  eing:='0';
  axis:=1;
  poti:=1;
  while not ende do
    begin
      if keypressed then eing:=readkey;
      case eing of
      'q' : begin
              ende:=true;
            end;
      '1': begin
             clear;
             axis:=1;
             ctext3d(100,340,'1 : Axis 1',8,11);
             ctext3d(100,350,'2 : Axis 2',8,15);
             ctext3d(250,340,'3 : XY-Graph Axis 1',8,15);
             ctext3d(250,350,'4 : XY-Graph Axis 2',8,15);
             mode:=0;
             xtminmax(board);
           end;
      '2': begin
             clear;
             axis:=2;
             ctext3d(100,340,'1 : Axis 1',8,15);
             ctext3d(100,350,'2 : Axis 2',8,11);
             ctext3d(250,340,'3 : XY-Graph Axis 1',8,15);
             ctext3d(250,350,'4 : XY-Graph Axis 2',8,15);
             mode:=0;
             xtminmax(board);
           end;
      '3': begin
             clear;
             axis:=1;
             ctext3d(100,340,'1 : Axis 1',8,15);
             ctext3d(100,350,'2 : Axis 2',8,15);
             ctext3d(250,340,'3 : XY-Graph Axis 1',8,11);
             ctext3d(250,350,'4 : XY-Graph Axis 2',8,15);
             mode:=1;
             xyminmax;
           end;
      '4': begin
             clear;
             axis:=2;
             ctext3d(100,340,'1 : Axis 1',8,15);
             ctext3d(100,350,'2 : Axis 2',8,15);
             ctext3d(250,340,'3 : XY-Graph Axis 1',8,15);
             ctext3d(250,350,'4 : XY-Graph Axis 2',8,11);
             mode:=1;
             xyminmax;
           end;
      'a': begin
             ctext3d(100,410,'a : Offset DG00',8,11);
             ctext3d(100,420,'b : Offset DG90',8,15);
             ctext3d(100,430,'c : Ampl. DG00',8,15);
             ctext3d(100,440,'d : Phase DG90',8,15);
             poti:=1;
           end;
      'b': begin
             ctext3d(100,410,'a : Offset DG00',8,15);
             ctext3d(100,420,'b : Offset DG90',8,11);
             ctext3d(100,430,'c : Ampl. DG00',8,15);
             ctext3d(100,440,'d : Phase DG90',8,15);
             poti:=2;
           end;
      'c': begin
             ctext3d(100,410,'a : Offset DG00',8,15);
             ctext3d(100,420,'b : Offset DG90',8,15);
             ctext3d(100,430,'c : Ampl. DG00',8,11);
             ctext3d(100,440,'d : Phase DG90',8,15);
             poti:=3;
           end;
      'd': begin
             ctext3d(100,410,'a : Offset DG00',8,15);
             ctext3d(100,420,'b : Offset DG90',8,15);
             ctext3d(100,430,'c : Ampl. DG00',8,15);
             ctext3d(100,440,'d : Phase DG90',8,11);
             poti:=4;
           end;
      's': begin
             ctext3d(250,440,'s : Store pots',8,11);
             error:=false;
             store_offset(board,error);
             store_potis(board,error);
             ctext3d(250,440,'s : Store pots',8,15);
           end;
      '>': begin
             ctext3d(400,430,'> : Fast increment ',8,11);
             sound(100);
             error:=false;
             case poti of
               1: turn_offsetdg00(board,axis,8,true);
               2: turn_offsetdg90(board,axis,8,true);
               3: turn_sympoti(board,axis,8,true,error);
               4: turn_phasepoti(board,axis,8,true,error);
             end;
             nosound;
             ctext3d(400,430,'> : Fast increment ',8,15);
           end;
      '<': begin
             ctext3d(400,440,'< : Fast decrement ',8,11);
             sound(100);
             error:=false;
             case poti of
               1: turn_offsetdg00(board,axis,8,false);
               2: turn_offsetdg90(board,axis,8,false);
               3: turn_sympoti(board,axis,8,false,error);
               4: turn_phasepoti(board,axis,8,false,error);
             end;
             nosound;
             ctext3d(400,440,'< : Fast decrement ',8,15);
           end;
      '+': begin
             ctext3d(400,410,'+ : Increment pot ',8,11);
             sound(100);
             error:=false;
             case poti of
               1: turn_offsetdg00(board,axis,1,true);
               2: turn_offsetdg90(board,axis,1,true);
               3: turn_sympoti(board,axis,1,true,error);
               4: turn_phasepoti(board,axis,1,true,error);
             end;
             nosound;
             ctext3d(400,410,'+ : Increment pot ',8,15);
           end;
      '-': begin
             ctext3d(400,420,'- : Decrement pot ',8,11);
             sound(100);
             error:=false;
             case poti of
               1: turn_offsetdg00(board,axis,1,false);
               2: turn_offsetdg90(board,axis,1,false);
               3: turn_sympoti(board,axis,1,false,error);
               4: turn_phasepoti(board,axis,1,false,error);
             end;
             nosound;
             ctext3d(400,420,'- : Decrement pot ',8,15);
           end;
      end;
      eing:=' ';
      if axis=1 then
        begin
         build_sample(pointr);
         get_sample(board^.axis[1],pointr);
         if mode=0 then show_sample1(pointr) else show_sample2(pointr);
         free_sample(pointr);
       end
     else
       begin
         build_sample(pointr);
         get_sample(board^.axis[2],pointr);
         if mode=0 then show_sample1(pointr) else show_sample2(pointr);
         free_sample(pointr);
       end;

     refresh:=refresh+1;
     if refresh=10 then
       begin
         if mode=1 then xyminmax;
         refresh:=0;
       end;
   end;
 end;
(*________________________________________*)
end.