program sample4;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Read Potentiometers                                   }
{                                                       }
{ V 1.01                                                }
{ April 1995                                            }
{ V 1.02                                                }
{ March 1996                                            }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

uses crt,ik121_1;

var
    error : boolean;
    xx    : byte;
    board : ik121_pointr;
    axis1,axis2 : g26_pointr;
{----------------------------------------------------------}
procedure write_error(error:boolean);
begin
      textcolor(2);
      if error then write('error!!');
end;
{----------------------------------------------------------}
procedure poti_status(board:ik121_pointr);
begin
      gotoxy(40,22);
      write('Press any key!');
      gotoxy(1,5);
      xx:=Read_phasepoti(board,1,error);
      write_error(error);
      textcolor(4);
      writeln(' Axis 1 phase : ',xx);
      xx:=Read_phasepoti(board,2,error);
      write_error(error);
      textcolor(1);
      writeln(' Axis 2 phase : ',xx);
      xx:=Read_sympoti(board,1,error);
      write_error(error);
      textcolor(4);
      writeln(' Axis 1 sym.  : ',xx);
      xx:=Read_sympoti(board,2,error);
      write_error(error);
      textcolor(1);
      writeln(' Axis 2 sym.  : ',xx);
      writeln;
      writeln(' Offset : ');
      load_offset(board,error);
      write_error(error);
      writeln(' Axis 1 DG00  : ',board^.axis[1]^.offset00);
      writeln(' Axis 1 DG90  : ',board^.axis[1]^.offset90);
      writeln(' Axis 2 DG00  : ',board^.axis[2]^.offset00);
      writeln(' Axis 2 DG90  : ',board^.axis[2]^.offset90);
      repeat until keypressed;
end;
{----------------------------------------------------------}
begin
  textbackground(7);
  clrscr;
  textcolor(15);
  New(board);
  New(axis1);
  New(axis2);
  board^.axis[1]:=axis1;
  board^.axis[2]:=axis2;
  init_ik121(board);
  if look_for_ik121(board) then
    begin
      poti_status(board);
    end
  else
    begin
      clrscr;
      write('No hardware!!');
      readln;
    end;
  Dispose(board);
  Dispose(axis1);
  Dispose(axis2);
  textbackground(0);
  clrscr;
end.