program rdrom;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Read User ROM                                         }
{                                                       }
{ V 1.00                                                }
{ July 1994                                             }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

uses crt,ik121_1;

var
    error : boolean;
    xx    : byte;
    board : ik121_pointr;
    axis1,axis2 : g26_pointr;
{----------------------------------------------------------}
procedure rd_rom(board:ik121_pointr);
var
   c     : char;
   b     : byte;
   adr   : word;
begin
      error:=false;
      gotoxy(1,20);
      write(' Press RETURN to exit program!');
      gotoxy(2,2);
      writeln('Reading from IK121 EEPROM!');
      writeln;
      adr:=0;
      while (adr<511) do
        begin
          b:=rom_read(board,adr,error);
          c:=char(b);
          write(c);
          adr:=adr+1;
        end;
      readln;
end;
{----------------------------------------------------------}
begin
  textbackground(7);
  clrscr;
  textcolor(15);
  New(board);
  New(axis1);
  New(axis2);
  board^.axis[1]:=axis1;
  board^.axis[2]:=axis2;
  init_ik121(board);
  if look_for_ik121(board) then
    begin
      rd_rom(board);
    end
  else
    begin
      clrscr;
      write('No hardware!');
      readln;
    end;
  Dispose(board);
  Dispose(axis1);
  Dispose(axis2);
  textbackground(0);
  clrscr;
end.