UNIT CNT_1;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Display Unit for Counter Program                      }
{                                                       }
{ V 1.00                                                }
{ July 1994                                             }
{ V 1.02                                                }
{ July 1996                                             }
{ V 1.04                                                }
{ Mai 1998                                              }
{-------------------------------------------------------}

{$N+,E+}
{$V+}
{$R+}

interface

uses graph,ik121_1;

const
   Gray50  : Fillpatterntype = ($AA,$AA,$AA,$AA,
                                $AA,$AA,$AA,$AA);

TYPE

   device = (druck_lpt1,druck_lpt2,druck_file,none);

   axis_pointr   = ^axis_record;
   axis_record   = record
                     position      : real;    (* mm *)
                     position_new  : array[1..14] of char;
                     position_old  : array[1..14] of char;
                     wintext       : string[1];
                     win_xpos      : word;
                     win_ypos      : word;
                     digits        : byte;
                     dimension     : byte;
                     preset        : array[1..4] of real;
                     offset        : comp;
                     min           : real;
                     max           : real;
                     mode          : (min,max,pos);
                     lbound        : real;
                     hbound        : real;
                     periode       : word;
                     strichzahl    : word;
                     drehgeber     : boolean;
                     direction     : boolean;
                     refmark       : byte;
                     resolution    : word;
                  end;

   count_pointr = ^count_record;
   count_record = record
                    board   : ik121_pointr;
                    count   : array[1..2] of axis_pointr;
                    printer : device;
                  end;
   countstore   = record
                    count   : array[1..2] of axis_record;
                    printer : device;
                  end;

PROCEDURE count_back(pointr:axis_pointr);
PROCEDURE count_display(pointr:axis_pointr);
PROCEDURE status_back(pointr:axis_pointr);
PROCEDURE status_display(pointr1:g26_pointr;pointr0:axis_pointr);
PROCEDURE Build_Countwert(pointr0:g26_pointr;pointr1:axis_pointr);
PROCEDURE setup_count(count:count_pointr);
PROCEDURE Write_Count(count:count_pointr);
PROCEDURE Read_Count(count:count_pointr);
(******************************************************************)
implementation
(******************************************************************)
PROCEDURE count_back(pointr:axis_pointr);
  VAR
    x,y : word;
  BEGIN

     (* Numbers *)
  x:=pointr^.win_xpos;
  y:=pointr^.win_ypos;

  setfillstyle(1,1);
  bar(x+43,y+3,x+463,y+53);
  setfillstyle(1,15);
  bar(x+40,y,x+460,y+50);
  setcolor(2);
  rectangle(x+40,y,x+460,y+50);

     (* Designation of axes *)

  setfillstyle(1,1);
  bar(x+3,y+3,x+33,y+53);
  setfillstyle(1,15);
  bar(x,y,x+33,y+50);
  rectangle(x,y,x+33,y+50);
  setcolor(4);
  settextstyle(0,0,3);
  moveto(x+7,y+17);
  setcolor(7);
  outtext(pointr^.wintext);
  moveto(x+5,y+15);
  setcolor(4);
  outtext(pointr^.wintext);

  (* Decimal point *)

  setcolor(7);
  x:=(pointr^.win_xpos+15)+((14-pointr^.digits)*30)+17;
  y:=pointr^.win_ypos+22;
  outtextxy(x,y,'.');

  setcolor(4);
  x:=(pointr^.win_xpos+15)+((14-pointr^.digits)*30)+15;
  y:=pointr^.win_ypos+20;
  outtextxy(x,y,'.');

  (* After 3 digits a decimal point *)

  if pointr^.digits>3 then
    begin
      setcolor(7);
      x:=(pointr^.win_xpos+15)+((14-pointr^.digits+3)*30)+17;
      y:=pointr^.win_ypos+22;
      outtextxy(x,y,'.');
      setcolor(4);
      x:=(pointr^.win_xpos+15)+((14-pointr^.digits+3)*30)+15;
      y:=pointr^.win_ypos+20;
      outtextxy(x,y,'.');
    end;
end;
(**********************************************************)
PROCEDURE count_display(pointr:axis_pointr);
VAR
  i               : byte;
  xpos,ypos       : word;

BEGIN
     ypos:=pointr^.win_ypos+15;
     settextstyle(0,0,3);
     For i:=1 to 14 do
        begin
          if pointr^.position_new[i]<>pointr^.position_old[i] then
            begin
              xpos:=(pointr^.win_xpos+15)+(i*30);
              setcolor(15);
              outtextxy(xpos,ypos,pointr^.position_old[i]);
              outtextxy(xpos+2,ypos+2,pointr^.position_old[i]);
              setcolor(7);
              outtextxy(xpos+2,ypos+2,pointr^.position_new[i]);
              setcolor(4);
              outtextxy(xpos,ypos,pointr^.position_new[i]);
            end;
        end;

END;
(******************************************************************)
PROCEDURE Draw_Button(x,y :word;text:string);

BEGIN
  x:=x+475;
  setfillstyle(1,7);
  bar(x,y,x+55,y+12);
  setcolor(4);
  rectangle(x,y,x+55,y+15);
  setcolor(8);
  line(x+1,y+14,x+54,y+14);
  line(x+2,y+13,x+53,y+13);
  line(x+54,y+1,x+54,y+14);
  line(x+53,y+2,x+53,y+13);
  setcolor(15);
  line(x+1,y+1,x+54,y+1);
  line(x+2,y+2,x+53,y+2);
  line(x+1,y+1,x+1,y+14);
  line(x+2,y+2,x+2,y+13);
  SetTextStyle(1,0,1);
  setcolor(8);
  outtextxy(x+5,y+4,text);
END;
(******************************************************************)
PROCEDURE Push_Button(x,y :word;text:string);
BEGIN
  x:=x+475;
  setcolor(15);
  line(x+1,y+14,x+54,y+14);
  line(x+2,y+13,x+53,y+13);
  line(x+54,y+1,x+54,y+14);
  line(x+53,y+2,x+53,y+13);
  setcolor(8);
  line(x+1,y+1,x+54,y+1);
  line(x+2,y+2,x+53,y+2);
  line(x+1,y+1,x+1,y+14);
  line(x+2,y+2,x+2,y+13);
  SetTextStyle(1,0,1);
  setcolor(14);
  outtextxy(x+5,y+4,text);
END;
(******************************************************************)
PROCEDURE Pop_Button(x,y :word;text:string);
BEGIN
  x:=x+475;
  setcolor(8);
  line(x+1,y+14,x+54,y+14);
  line(x+2,y+13,x+53,y+13);
  line(x+54,y+1,x+54,y+14);
  line(x+53,y+2,x+53,y+13);
  setcolor(15);
  line(x+1,y+1,x+54,y+1);
  line(x+2,y+2,x+53,y+2);
  line(x+1,y+1,x+1,y+14);
  line(x+2,y+2,x+2,y+13);
  SetTextStyle(1,0,1);
  setcolor(8);
  outtextxy(x+5,y+4,text);
END;
(******************************************************************)
PROCEDURE status_back(pointr:axis_pointr);
VAR
  xpos,ypos : word;
BEGIN
  Draw_Button(pointr^.win_xpos,pointr^.win_ypos,'Signal');
  Draw_Button(pointr^.win_xpos,pointr^.win_ypos+15,'Ref');
  Draw_Button(pointr^.win_xpos,pointr^.win_ypos+30,'<');
  Draw_Button(pointr^.win_xpos+60,pointr^.win_ypos+30,'>');
END;
(******************************************************************)
PROCEDURE status_display(pointr1:g26_pointr;pointr0:axis_pointr);
VAR
  xpos,ypos       : word;
BEGIN
  xpos:=pointr0^.win_xpos+475;
  ypos:=pointr0^.win_ypos;

  if (pointr1^.cstatus.error_freq) or (pointr1^.sstatus.amp_act=$03) then
    begin
      Push_Button(pointr0^.win_xpos,pointr0^.win_ypos,'Signal');
    end
  else
    begin
      Pop_Button(pointr0^.win_xpos,pointr0^.win_ypos,'Signal');
    end;

  if (pointr1^.cstatus.ref_activ) then
    begin
      Push_Button(pointr0^.win_xpos,pointr0^.win_ypos+15,'Ref');
    end
  else
    begin
      Pop_Button(pointr0^.win_xpos,pointr0^.win_ypos+15,'Ref');
    end;

  if (pointr0^.position<pointr0^.lbound) then
    begin
      Push_Button(pointr0^.win_xpos,pointr0^.win_ypos+30,'<');
    end
  else
    begin
      Pop_Button(pointr0^.win_xpos,pointr0^.win_ypos+30,'<');
    end;

  if (pointr0^.position>pointr0^.hbound) then
    begin
      Push_Button(pointr0^.win_xpos+60,pointr0^.win_ypos+30,'>');
    end
  else
    begin
      Pop_Button(pointr0^.win_xpos+60,pointr0^.win_ypos+30,'>');
    end;

END;
(******************************************************************)
PROCEDURE Build_Countwert(pointr0:g26_pointr;pointr1:axis_pointr);
  VAR
    counter  : comp;
    i,a,b    : byte;
    cx       : string[14];
    wert     : real;
    sign     : boolean;

    d        : real;
    z0       : integer;

BEGIN
      (* Convert increments to mm *)

      counter:=pointr0^.register0;

      if pointr0^.inimain.mode1024 then
        begin
          counter:=counter+(pointr1^.offset*1024);
          if pointr1^.drehgeber then
            begin
              wert:=counter*(360/pointr1^.strichzahl)/1024;
            end
          else
            begin
              wert:=0.001*counter*pointr1^.periode/1024;
            end;
        end
      else
        begin
          counter:=counter+pointr1^.offset;
          if (pointr0^.inimain.onefold) then
            begin
              wert:=0.001*counter*pointr1^.periode;
            end;
          if (pointr0^.inimain.twofold) then
            begin
              wert:=0.001*counter*(pointr1^.periode/2);
            end;
         if (pointr0^.inimain.fourfold) then
            begin
              wert:=0.001*counter*(pointr1^.periode/4);
            end;
        end;



      wert:=wert*1000000;  (* mm -> nm *)
      wert:=wert/pointr1^.resolution;
      wert:=int(wert);
      wert:=wert*pointr1^.resolution;
      wert:=wert/1000000;  (* nm -> mm *)

      pointr1^.position:=wert+pointr1^.preset[pointr1^.dimension];

      if pointr1^.drehgeber then   (* Modula 360 *)
        begin
          d:=pointr1^.position/360;
          z0:=trunc(d);
          pointr1^.position:=abs(pointr1^.position-(z0*360));

          if pointr1^.direction then
            begin
              pointr1^.position:=360-pointr1^.position;
            end;
        end;

      if pointr1^.position<pointr1^.min then pointr1^.min:=pointr1^.position;
      if pointr1^.position>pointr1^.max then pointr1^.max:=pointr1^.position;

      case pointr1^.mode of
        min : pointr1^.position:=pointr1^.min;
        max : pointr1^.position:=pointr1^.max;
      end;

      (* Generate characters *)

      wert:=pointr1^.position;

      (* Clear buffer: 14 digits *)
      For i:=1 to 14 do
        begin
          cx[i]:=' ';
        end;

      (* Get algebraic sign *)

      sign:=true;
      if wert<0 then
        begin
          wert:=abs(wert);
          sign:=false;
        end;

      a:=14-pointr1^.digits;
      b:=pointr1^.digits;
      (* Convert string *)
      str(wert:a:b,cx);

      (* Shift right *)

      While cx[14]=' ' do
        begin
          For i:=14 downto 2 do
            begin
              cx[i]:=cx[i-1];
            end;
          cx[1]:=' ';
        end;

      (* Remove decimal point *)

      For i:=a downto 2 do
        begin
          cx[i]:=cx[i-1];
        end;
      cx[1]:=' ';

      if sign then cx[1]:='+' else cx[1]:='-';

      For i:=1 to 14 do
        begin
          pointr1^.position_old[i]:=pointr1^.position_new[i];
          pointr1^.position_new[i]:=cx[i];
        end;
END;
(******************************************************************)
PROCEDURE setup_count(count:count_pointr);
VAR
  i : byte;
BEGIN

    count^.count[1]^.wintext:='X';
    count^.count[1]^.win_xpos:=25;
    count^.count[1]^.win_ypos:=280;

    count^.count[2]^.wintext:='Y';
    count^.count[2]^.win_xpos:=25;
    count^.count[2]^.win_ypos:=380;

    for i:=1 to 2 do
      begin
        count^.count[i]^.position:=0;
        count^.count[i]^.position_new:='              ';
        count^.count[i]^.position_old:='--------------';
        count^.count[i]^.digits:=5;
        count^.count[i]^.dimension:=1;
        count^.count[i]^.preset[1]:=0;
        count^.count[i]^.preset[2]:=0;
        count^.count[i]^.preset[3]:=0;
        count^.count[i]^.preset[4]:=0;
        count^.count[i]^.offset:=0;
        count^.count[i]^.min:=1000000;
        count^.count[i]^.max:=-1000000;
        count^.count[i]^.mode:=pos;
        count^.count[i]^.lbound:=-5;
        count^.count[i]^.hbound:=5;
        count^.count[i]^.periode:=10;
        count^.count[i]^.strichzahl:=1000;
        count^.count[i]^.drehgeber:=false;
        count^.count[i]^.direction:=false;
        count^.count[i]^.refmark:=0;
        count^.count[i]^.resolution:=1;
      end;

    count^.printer:=none;
END;
(******************************************************************)
PROCEDURE Write_Count(count:count_pointr);
VAR
  initfile        : file of countstore;
  buffer          : countstore;
BEGIN
  Assign(initfile,'IK121.CNT');
  (*$I-*)
  Rewrite(initfile);
  (*$I+*)
  if ioresult=0 then
    begin
      buffer.count[1]:=count^.count[1]^;
      buffer.count[2]:=count^.count[2]^;
      buffer.printer:=count^.printer;
      write(initfile,buffer);
      close(initfile);
    end;
END;
(******************************************************************)
PROCEDURE Read_Count(count:count_pointr);
VAR
  initfile          : file of countstore;
  buffer            : countstore;
  nofile            : boolean;
BEGIN
  setup_count(count);
  nofile:=true;
  Assign(initfile,'IK121.CNT');
  (*$I-*)
  Reset(initfile);
  (*$I+*)
  if ioresult=0 then
    begin
      (*$I-*)
      read(initfile,buffer);
      (*$I+*)
      if ioresult=0 then
        begin
          count^.count[1]^.digits:=buffer.count[1].digits;
          count^.count[1]^.min:=buffer.count[1].min;
          count^.count[1]^.max:=buffer.count[1].max;
          count^.count[1]^.mode:=buffer.count[1].mode;
          count^.count[1]^.lbound:=buffer.count[1].lbound;
          count^.count[1]^.hbound:=buffer.count[1].hbound;
          count^.count[1]^.periode:=buffer.count[1].periode;
          count^.count[1]^.refmark:=buffer.count[1].refmark;
          count^.count[1]^.resolution:=buffer.count[1].resolution;

          count^.count[1]^.strichzahl:=buffer.count[1].strichzahl;
          count^.count[1]^.drehgeber:=buffer.count[1].drehgeber;
          count^.count[1]^.direction:=buffer.count[1].direction;
          count^.board^.axis[1]^.direction:=buffer.count[1].direction;


          (* V1.02 *)
          count^.count[1]^.preset[1]:=buffer.count[1].preset[1];
          count^.count[1]^.preset[2]:=buffer.count[1].preset[2];
          count^.count[1]^.preset[3]:=buffer.count[1].preset[3];
          count^.count[1]^.preset[4]:=buffer.count[1].preset[4];
          count^.count[1]^.lbound:=buffer.count[1].lbound;
          count^.count[1]^.hbound:=buffer.count[1].hbound;

          count^.count[2]^.digits:=buffer.count[2].digits;
          count^.count[2]^.min:=buffer.count[2].min;
          count^.count[2]^.max:=buffer.count[2].max;
          count^.count[2]^.mode:=buffer.count[2].mode;
          count^.count[2]^.lbound:=buffer.count[2].lbound;
          count^.count[2]^.hbound:=buffer.count[2].hbound;
          count^.count[2]^.periode:=buffer.count[2].periode;
          count^.count[2]^.refmark:=buffer.count[2].refmark;
          count^.count[2]^.resolution:=buffer.count[2].resolution;

          count^.count[2]^.strichzahl:=buffer.count[2].strichzahl;
          count^.count[2]^.drehgeber:=buffer.count[2].drehgeber;
          count^.count[2]^.direction:=buffer.count[2].direction;
          count^.board^.axis[2]^.direction:=buffer.count[2].direction;

          (* V1.02 *)
          count^.count[2]^.preset[1]:=buffer.count[2].preset[1];
          count^.count[2]^.preset[2]:=buffer.count[2].preset[2];
          count^.count[2]^.preset[3]:=buffer.count[2].preset[3];
          count^.count[2]^.preset[4]:=buffer.count[2].preset[4];
          count^.count[2]^.lbound:=buffer.count[2].lbound;
          count^.count[2]^.hbound:=buffer.count[2].hbound;

          count^.printer:=buffer.printer;
          nofile:=false;
        end;
      close(initfile);
    end;
  if nofile then
    begin
      write_count(count);
    end;
END;
(******************************************************************)
(******************************************************************)
end.