/*----------------------SAMPLE32.C----------------------

 DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

 A simple program for the IK 121 to display
 two axes. Measured value with 32 bits.

 V 1.01
 April 1995

 Project files:        IK121_0.C, SAMPLE32.C
 Include files:        IK121_0.H
 ------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include "ik121_0.h"

#define base_address 0x0330

int main()
{
double c_value_0, c_value_1;

cls;
   /* Initialise the board in interpolation mode,
   axis 1 */
write_g26 (base_address, 1, 0x0c, 0x0001);
   /* Initialise the board in interpolation mode,
   axis 2 */
write_g26 (base_address, 2, 0x0c, 0x0001);
   /* Reset error bit, start counter, axis 1 */
write_g26 (base_address, 1, 0x0e, 0x0048);
   /* Reset error bit, start counter, axis 2 */
write_g26 (base_address, 2, 0x0e, 0x0048);
   /* Write to control register 2, axis 1 */
write_g26 (base_address, 1, 0x1c, 0x0028);
   /* Write to control register 2, axis 2 */
write_g26 (base_address, 2, 0x1c, 0x0028);

   /*Cursor off*/
_setcursortype(_NOCURSOR);

while(!kbhit())
	{
           /* Software latch in register 0, axis 1 */
	soft_l0 (base_address, 1);
           /* Software latch in register 0, axis 2 */
	soft_l0 (base_address, 2);
           /* Poll whether latched in axis 1 */
	poll_latch (base_address, 1, 0);
	   /* Read axis 1 */
	c_value_0 = (double)read_count_value32
                                   (base_address, 1, 0);
           /* Poll whether latched in axis 2 */
	poll_latch (base_address, 2, 0);
	   /* Read axis 2 */
	c_value_1 = (double)read_count_value32
                                   (base_address, 2, 0);

        /* Display measured values */
	printf("\r\t%16.4f\t%16.4f",c_value_0*0.02/1024,
				     c_value_1*0.02/1024);
	}

   /*Cursor on*/
_setcursortype (_NORMALCURSOR);

return (0);
}


