Unit Timer;    { Unit Name }

  { Globale Compiler Schalter                     }
  {$A+  Word Speicher zuweisungen                 }

Interface
  { uses Liste Global benuzteter Units; optional  }
  {      Globale Declarationen                    }

Uses IK120;

  Procedure StartDataAquisition (No_of_points : integer);
  Procedure SetTimerInterval(Interval: Real);
  Procedure RemoveTimer;


  { uses List Lokaler benuzteter Units;  optional }
  {      Lokale Declarationen                     }
  {      Proceduren und Functionen                }


  Const
      Int1CVect      = $1C;
      LocalMpmax     = 5000;
      I8254CTRL = $0043;
      I8254Cot0 = $0040;
      I8254Cot2 = $0042;
      I8254Mod0 = $34;
      I8254Mod3 = $0B6;


  Var
      OldInt1CVect :Pointer;
      Buffer       :array [0..LocalMpmax+1,0..1] of longint;
      ScreenIndex,
      DataIndex, BufferEnd,i : integer;
      InterruptCount,
      InterruptSpacing : Longint;


Implementation
Uses Dos;                   { Fr die Benutzung von Set-Get-IntVec    }

{----------------------------------------------------------------------------}
{ Lokale Compiler Schalter fr die Interrupt Proceduren                      }
{$B- Short Circuit bei Bedienungs Test                                       }
{$R- Breiches Prfung Range Checking off                                     }
{$S- Stack Checking off                                                      }
{$V+ Strict Var-Checking on                                                  }
{$I- I/O Checking off                                                        }
{----------------------------------------------------------------------------}

{----------------------------------------------------------------------------}
{ Timer Interrupt                                                            }
{----------------------------------------------------------------------------}

  Procedure TimerInt; Interrupt;
  Begin

     If DataIndex < BufferEnd then
        If InterruptSpacing=InterruptCount then
        begin
           Write_Strobe(0);
           Read_Count(0,regx,Buffer[DataIndex,0]);
           Read_Count(1,regx,Buffer[DataIndex,1]);
           DataIndex := DataIndex +1;
           InterruptCount := 0;
{           if Dataindex=BufferEnd then write(chr(7));
}        end
        else InterruptCount:=InterruptCount +1;
  End;

{----------------------------------------------------------------------------}
{ ReMove Timer                                                               }
{----------------------------------------------------------------------------}

  Procedure RemoveTimer;
  Begin
    InterruptSpacing:=0;
    SetIntvec(Int1CVect,OldInt1CVect);

    port[I8254CTRL]:= I8254Mod0;
    port[I8254Cot0]:= $FF;
    port[I8254Cot0]:= $FF;

  End;

{----------------------------------------------------------------------------}
{ Install Timer                                                              }
{----------------------------------------------------------------------------}

  Procedure InstallTimer;
  Begin
    SetIntvec(Int1CVect,@TimerInt);
  End;

{----------------------------------------------------------------------------}
{ SetTimerInterval                                                           }
{----------------------------------------------------------------------------}
Procedure SetTimerInterval(Interval: real);
{ The time between timer interrupts is set in milliseconds                 }
{ InterruptSpacing is required because the maximum time between interrupts }
{ is limited to 56ms due to the 16 bit timer register.                     }
  var Int : Longint;
  begin
    InterruptSpacing:= 1;
    Int := trunc(Interval*1193);
    while Int > $FFFF do
    begin
       Int := Int SHR 1;
       InterruptSpacing:= InterruptSpacing SHL 1;
    end;
    InterruptSpacing := InterruptSpacing -1;

    port[I8254CTRL]:= I8254Mod0;
    port[I8254Cot0]:= Lo(Int);
    port[I8254Cot0]:= Hi(Int);
  end;


{----------------------------------------------------------------------------}
{ Start Data Aquisition                                                      }
{----------------------------------------------------------------------------}

  Procedure StartDataAquisition ( No_of_points : integer );
  Begin
     if No_of_points > LocalMpmax then BufferEnd := LocalMpmax+1
                                  else BufferEnd := No_of_points+1;
     ScreenIndex := 0;
     DataIndex := 0;
     InterruptCount:= 0;
     { Required so that strobe signal can be used to freeze both axes }
     { simultaneously.                                                }
     Latch_Enable(0,Internal);
     Init_Latch(0,Strobe_Latch,fourfold,0);

     InstallTimer;
  End;

{----------------------------------------------------------------------------}
{ Initialisierung der Unit                                                   }
{----------------------------------------------------------------------------}

Begin
  GetIntVec(Int1CVect,OldInt1CVect);  { sichern fr die Reinstallation }
  regx := 0;
  for i:= 0 to LocalMPMax do begin
                                  buffer[i,0]:= 0;
                                  buffer[i,1]:= 0;
                             end;
End.
