{$define standalone }
(*************************************************************************)
(* Dr JOHANNES HEIDENHAIN, Traunreut, West Germany                       *)
(* 09.12.91                                                              *)
(*                                                                       *)
(* Demonstration program to illustrate the programming of the interface  *)
(* card IK120 using the IK120.PAS unit supplied.                         *)
(*                                                                       *)
(* Demonstrations-Programm fr die 2-Achsen Interface-Karte IK120        *)
(* Dieses Programm zeigt die Anwendung der Treiber-Software "IK120.PAS"  *)
(* und die Programmierung der Interface-Karte "IK120".                   *)
(*                                                                       *)
(*                                                                       *)
(* Program requires EGA,VGA or HERC graphics adapter.                    *)
(*                                                                       *)
(*************************************************************************)

program DEMO;
(*$R+*)
uses dos,crt,graph,IK120 {$ifdef standalone},bgidriv{$endif} ;
const
   Gray50  : Fillpatterntype = ($AA,$AA,$AA,$AA,
                                $AA,$AA,$AA,$AA);
   latchvalue = 500;
   ESC = #27;
   FactorX = 1.0;
   FactorY = 1.0;   { 0.97656 = 1/ 1.024 for 1024 lines }
var
  countvalue,xpreset,ypreset       : longint;
  xmax,ymax,land                   : integer;
  altcx,altcy,cx,cy                : string[10];
  latch_flagx,latch_flagy,
  aerrorx,ferrorx,aerrory,ferrory  : boolean;
  sregister                        : byte;
  latchw                           : word;
  com                              : array [1..2,1..60] of string;
  Period_x, Period_y               : real;
  Subdivision                      : integer;
  mm_display                       : boolean;
  graphmode,graphdriver,i : integer;
{  eingabe : char;

  ende    : boolean;
  adresse : word;
  sbuffer : byte;
}
(**********************************************************)


procedure init_com;
(* Define the text variable is array com *)
begin
com[1, 1]:= 'Program Ende (Taste "q")';
com[1, 2]:= 'Start X-Achse';
com[1, 3]:= 'Start Y-Achse';
com[1, 4]:= 'Stop X-Achse';
com[1, 5]:= 'Stop Y-Achse';
com[1, 6]:= 'Reset u. Start X mit RI';
com[1, 7]:= 'Reset u. Start Y mit RI';
com[1, 8]:= 'Stop X-Achse mit RI';
com[1, 9]:= 'Stop Y-Achse mit RI';
com[1,10]:= 'Reset X-Achse';
com[1,11]:= 'Reset Y-Achse';
com[1,12]:= 'Reset u. Start X-Achse';
com[1,13]:= 'Reset u. Start Y-Achse';
com[1,14]:= '25fach Interpolation';
com[1,15]:= '50fach Interpolation';
com[1,16]:= 'Zhler start';
com[1,17]:= 'Reset u. Start mit RI';
com[1,18]:= 'Zhler Stop mit RI';
com[1,19]:= 'Zhler Stop';
com[1,20]:= 'Zhler Reset';
com[1,21]:= 'Freigabe interner Latch';
com[1,22]:= 'Freigabe externer Latch';
com[1,23]:= 'Abrufwert-Eingabe';
com[1,24]:= 'Zhler X gestartet';
com[1,25]:= 'Zhler X gestoppt';
com[1,26]:= 'Zhler Y gestartet';
com[1,27]:= 'Zhler Y gestoppt';
com[1,28]:= 'Interpolation : 25fach';
com[1,29]:= 'Interpolation : 50fach';
com[1,30]:= 'Abrufwert : ';
com[1,31]:= 'Verschmutzung bei X';
com[1,32]:= 'Verschmutzung bei Y';
com[1,33]:= 'Steuerung des Menue durch Cursor-Tasten.';
com[1,34]:= 'Anwahl der Menpunkte durch Tasten(links,rechts).';
com[1,35]:= 'Anwahl der Unterpunkte durch Tasten (auf,ab).';
com[1,36]:= 'Ausfhrung des gewuenschten Befehls durch "Enter".';
com[1,37]:= 'Ende des Programs durch q (Quit).';
com[1,38]:= 'IK 120  Demo Programm ';
com[1,39]:= 'Quit';
com[1,40]:= 'Start/Stopp';
com[1,41]:= 'Reset';
com[1,42]:= 'Latch';
com[1,43]:= 'Status';
com[1,44]:= 'Hilfe';
com[1,45]:= 'Englisch';
com[1,46]:= 'Anzeige: mm/impulse';
com[1,47]:= 'Teilungsperiode X';
com[1,48]:= 'Teilungsperiode Y';
com[1,49]:= 'Signal';
com[1,50]:= 'Fehler';

com[2, 1]:= 'Press "q" to Quit program';
com[2, 2]:= 'Start X axis';
com[2, 3]:= 'Start Y axis';
com[2, 4]:= 'Stop X axis';
com[2, 5]:= 'Stop Y axis';
com[2, 6]:= 'Reset & Start X with REF';
com[2, 7]:= 'Reset & Start Y with REF';
com[2, 8]:= 'Stop X axis with REF';
com[2, 9]:= 'Stop Y axis with REF';
com[2,10]:= 'Reset X axis';
com[2,11]:= 'Reset Y axis';
com[2,12]:= 'Reset & start X axis';
com[2,13]:= 'Reset & start Y axis';
com[2,14]:= '25 fold Interpolation';
com[2,15]:= '50 fold Interpolation';
com[2,16]:= 'Start counter';
com[2,17]:= 'Reset & Start with REF';
com[2,18]:= 'Stop counter with REF';
com[2,19]:= 'Stop counter';
com[2,20]:= 'Reset counter';
com[2,21]:= 'Enable internal latch';
com[2,22]:= 'Enable external latch';
com[2,23]:= 'Enter interval value';
com[2,24]:= 'Counter X started';
com[2,25]:= 'Counter X stopped';
com[2,26]:= 'Counter Y started';
com[2,27]:= 'Counter Y stopped';
com[2,28]:= 'Interpolation: 25 fold';
com[2,29]:= 'Interpolation: 50 fold';
com[2,30]:= 'Interval value:';
com[2,31]:= 'Signal error on X';
com[2,32]:= 'Signal error on Y';
com[2,33]:= 'Select menu using cursor keys <-  ->';
com[2,34]:= 'Choose the menu option using up, down arrows.';
com[2,35]:= 'Press <Enter> to execute an option ';
com[2,37]:= '';
com[2,36]:= 'Press "q" to quit program   ';
com[2,38]:= 'IK 120  Demo Program ';
com[2,39]:= 'Quit';
com[2,40]:= 'Start/Stop';
com[2,41]:= 'Reset';
com[2,42]:= 'Latch';
com[2,43]:= 'Status';
com[2,44]:= 'Help';
com[2,45]:= 'German';
com[2,46]:= 'Display: mm/counts';
com[2,47]:= 'Grating period X';
com[2,48]:= 'Grating period Y';
com[2,49]:= 'Signal';
com[2,50]:= 'Error';

end;

procedure setwindow(nummer:byte);
var
  buffer  : byte;
  wort    : string[11];
  xx ,yy  : string[16];
begin
  Case nummer of
    1 : begin
          SetViewport(30,200,280,300,true);
          ClearViewport;
          setfillpattern(Gray50,5);
          bar(0,0,250,100);
          Rectangle(0,0,250,100);
          SetTextStyle(0,0,0);
          outtextxy(20,10,com[land,1]);
          outtextxy(20,20,com[land,45]);
          outtextxy(20,30,com[land,46]);
          outtextxy(20,40,com[land,47]);
          outtextxy(20,50,com[land,48]);


{         outtextxy(20,10,' Program Ende (Taste "q")'); }
          SetViewport(0,0,xmax,ymax,true);
        end;
    2 : begin
          SetViewport(110,200,360,300,true);
          ClearViewport;
          setfillpattern(Gray50,5);
          bar(0,0,250,100);
          Rectangle(0,0,250,100);
          SetTextStyle(0,0,0);

{         outtextxy(20,10,' Start X axis');
          outtextxy(20,20,' Start Y-Achse');
          outtextxy(20,30,' Stop X-Achse');
          outtextxy(20,40,' Stop Y-Achse');
          outtextxy(20,50,' Reset u. Start X mit RI');
          outtextxy(20,60,' Reset u. Start Y mit RI');
          outtextxy(20,70,' Stop X-Achse mit RI');
          outtextxy(20,80,' Stop Y-Achse mit RI');
}
          outtextxy(20,10,com[land,2]);
          outtextxy(20,20,com[land,3]);
          outtextxy(20,30,com[land,4]);
          outtextxy(20,40,com[land,5]);
          outtextxy(20,50,com[land,6]);
          outtextxy(20,60,com[land,7]);
          outtextxy(20,70,com[land,8]);
          outtextxy(20,80,com[land,9]);
          SetViewport(0,0,xmax,ymax,true);
        end;
    3 : begin
          SetViewport(190,200,490,300,true);
          ClearViewport;
          setfillpattern(Gray50,5);
          bar(0,0,300,100);
          Rectangle(0,0,300,100);
          SetTextStyle(0,0,0);

{         outtextxy(20,10,' Reset X-Achse');
          outtextxy(20,20,' Reset Y-Achse');
          outtextxy(20,30,' Reset u. Start X-Achse');
          outtextxy(20,40,' Reset u. Start Y-Achse');
          outtextxy(20,50,' 25fach Interpolation');
          outtextxy(20,60,' 50fach Interpolation');
}
          outtextxy(20,10,com[land,10]);
          outtextxy(20,20,com[land,11]);
          outtextxy(20,30,com[land,12]);
          outtextxy(20,40,com[land,13]);
          outtextxy(20,50,com[land,14]);
          outtextxy(20,60,com[land,15]);
          SetViewport(0,0,xmax,ymax,true);
        end;
    4 : begin
          SetViewport(270,200,520,300,true);
          ClearViewport;
          setfillpattern(Gray50,5);
          bar(0,0,250,100);
          Rectangle(0,0,250,100);
          SetTextStyle(0,0,0);
{
          outtextxy(20,10,' Counter start');
          outtextxy(20,20,' Reset u. Start mit RI');
          outtextxy(20,30,' Counter Stop mit RI');
          outtextxy(20,40,' Counter Stop');
          outtextxy(20,50,' Counter Reset');
          outtextxy(20,60,' Freigabe interner Latch');
          outtextxy(20,70,' Freigabe externer Latch');
          outtextxy(20,80,' Abrufwert-Eingabe');
}
          outtextxy(20,10,com[land,16]);
          outtextxy(20,20,com[land,17]);
          outtextxy(20,30,com[land,18]);
          outtextxy(20,40,com[land,19]);
          outtextxy(20,50,com[land,20]);
          outtextxy(20,60,com[land,21]);
          outtextxy(20,70,com[land,22]);
          outtextxy(20,80,com[land,23]);


          SetViewport(0,0,xmax,ymax,true);
        end;
    5 : begin
          SetViewport(350,200,560,300,true);
          ClearViewport;
          setfillpattern(Gray50,5);
          bar(0,0,210,100);
          Rectangle(0,0,210,100);
          SetTextStyle(0,0,0);
          buffer:=read_status(0);
          if (buffer AND 4)=4 then
{            outtextxy(20,10,' Counter X gestartet')}
            outtextxy(20,10,com[land,24])
          else
{            outtextxy(20,10,' Counter X gestoppt');}
            outtextxy(20,10,com[land,25]);

          buffer:=read_status(1);
          if (buffer AND 4)=4 then
{           outtextxy(20,20,' Counter Y gestartet')}
            outtextxy(20,20,com[land,26])
          else
{          outtextxy(20,20,' Counter Y gestoppt');}
          outtextxy(20,20, com[land,27]);
          if m_interpol=I_25 then
            begin
{              outtextxy(20,30,'Interpolation : 25fach');}
              outtextxy(20,30,com[land,28]);
            end
          else
            begin
{              outtextxy(20,30,'Interpolation : 50fach');}
              outtextxy(20,30,com[land,29]);
            end;
          str(latchw,wort);
{          outtextxy(20,40,'Abrufwert : '+wort);}
          outtextxy(20,40,com[land,30]+wort);

          str(period_x * 1000:5:0,xx);
          str(period_y * 1000:5:0,yy);
          outtextxy(20,50,com[land,47]+xx);
          outtextxy(20,60,com[land,48]+yy);

          SetViewport(0,0,xmax,ymax,true);
        end;
    6 : begin
          SetViewport(30,200,560,300,true);
          ClearViewport;
          setfillpattern(Gray50,5);
          bar(0,0,530,100);
          Rectangle(0,0,530,100);
          SetTextStyle(0,0,0);

          outtextxy(20,10,com[land,33]);
          outtextxy(20,20,com[land,34]);
          outtextxy(20,30,com[land,35]);
          outtextxy(20,40,com[land,36]);
          outtextxy(20,50,com[land,37]);
          SetViewport(0,0,xmax,ymax,true);
        end;
  end;
end;
(**********************************************************)

procedure intextxy(x,y:integer;var a:word);

var
  ende     : boolean;
  eing     : char;
  i,code   : integer;
  wort     : array[1..5] of char;


begin
SetTextStyle(0,0,0);
setfillpattern(Gray50,3);
for i:=1 to 5 do wort[i]:=' ';
wort[1]:='0';
i:=1;
ende:=false;
while not ende do
  begin
    outtextxy(x,y,#95);
    eing:=readkey;
    case eing of
      #13 : begin
              ende:=true;
              while wort[5]= ' ' do
                begin
                  for i:=5 downto 2 do
                    begin
                      wort[i]:=wort[i-1];
                    end;
                  wort[1]:=' ';
                end;
              val(wort,a,code);
            end;
      else
            begin
              outtextxy(x,y,eing);
              wort[i]:=eing;
              i:=i+1;
              x:=x+10;
              if i=6 then
                begin
                  i:=5;
                  x:=x-10;
                  bar(x,y,x+10,y+10);
                  outtextxy(x,y,wort[5]);
                end;
            end;
    end;
  end;
end;


(**********************************************************)
procedure clrwindow(nummer:byte);
begin
  Case nummer of
    1: begin
         SetViewport(30,200,280,300,true);
         ClearViewport;
         SetViewport(0,0,xmax,ymax,true);
       end;
    2: begin
         SetViewport(110,200,360,300,true);
         ClearViewport;
         SetViewport(0,0,xmax,ymax,true);
       end;
    3: begin
         SetViewport(190,200,490,300,true);
         ClearViewport;
         SetViewport(0,0,xmax,ymax,true);
       end;
    4: begin
         SetViewport(270,200,520,300,true);
         ClearViewport;
         SetViewport(0,0,xmax,ymax,true);
       end;
    5: begin
         SetViewport(310,200,560,300,true);
         ClearViewport;
         SetViewport(0,0,xmax,ymax,true);
       end;
    6: begin
         SetViewport(30,200,560,300,true);
         ClearViewport;
         SetViewport(0,0,xmax,ymax,true);
       end;

  end;
end;
(**********************************************************)
PROCEDURE header;
BEGIN
  SetTextJustify(0,2);
  Setbkcolor(16);
  SetTextStyle(0,0,0);
  rectangle(0,0,600,340);
  rectangle(10,170,590,330);
  moveto(30,4);
  outtext(com[land,38]);
  moveto(470,4);
  outtext('HEIDENHAIN');
  moveto(0,15);
  lineto(600,15);
  SetTextStyle(0,0,3);
  moveto(50,50);
  outtext('X : ');
  moveto(50,100);
  outtext('Y : ');

  (* Menzeile *)
  SetTextStyle(0,0,0);
{ outtextxy(40,180,'Quit');
  outtextxy(90,180,'Start/Stopp');
  outtextxy(200,180,'Reset');
  outtextxy(280,180,'Latch');
  outtextxy(360,180,'Status');
  outtextxy(440,180,'Hilfe');
}
  outtextxy(40,180,com[land,39]);
  outtextxy(90,180,com[land,40]);
  outtextxy(200,180,com[land,41]);
  outtextxy(280,180,com[land,42]);
  outtextxy(360,180,com[land,43]);
  outtextxy(440,180,com[land,44]);

  (* Anzeigebalken *)
  setfillpattern(Gray50,0);
  bar(130,45,450,80);
  rectangle(130,45,450,80);
  bar(130,95,450,130);
  rectangle(130,95,450,130);

END;
(**********************************************************)

PROCEDURE errorcheck(axis: integer;
                     var axerror,ayerror,fxerror,fyerror:boolean);
var
  ebuffer : byte;
  pos: integer;
begin
  if axis MOD 2 = 0 then pos := 45 else pos := 95;
  ebuffer:=read_status(axis);
  if (ebuffer and 8)=8 then
    begin
              SetColor(4);
              SetTextStyle(0,0,0);
              rectangle(480,pos,560,pos+30);
              outtextxy(490,pos+5,com[land,49]);
              outtextxy(490,pos+20,com[land,50]);

              Setcolor(15);
              axerror:=true;
    end;
end;

(**********************************************************)

PROCEDURE counter_anzeige;
VAR
  xaxis,yaxis           : longint;
  xaxis_mm, yaxis_mm    : real;
  signx,signy           : boolean;
  xpos,ypos             : integer;
  i                     : byte;

BEGIN

      (* Buffer lschen *)

      For i:=1 to 10 do
        begin
          cx[i]:=' ';
          cy[i]:=' ';
        end;

      (* Latchen und Auslesen *)

      if latch_flagx then
        begin
          Latch_Count(0,sregister);
          Read_Count(0,sregister,xaxis);
          xaxis:=xaxis+xpreset;
        end
      else
        begin
          Read_Count(0,sregister,xaxis);
          xaxis:=xaxis+xpreset;
        end;
      if latch_flagy then
        begin
          Latch_Count(1,sregister);
          Read_Count(1,sregister,yaxis);
          yaxis:=yaxis+ypreset;
        end
      else
        begin
          Read_Count(1,sregister,yaxis);
          yaxis:=yaxis+ypreset;
        end;

      (* Vorzeichen bestimmen *)
      signx:=true;
      signy:=true;
      if xaxis<0 then
        begin
          xaxis:=abs(xaxis);
          signx:=false;
        end;
      if yaxis<0 then
        begin
          yaxis:=abs(yaxis);
          signy:=false;
        end;

      if mm_display then
      begin
         (* MM_calculator *)
         xaxis_mm := FactorX * xaxis * period_X  /subdivision;
         yaxis_mm := FactorY * yaxis * period_Y  /subdivision;

         (* String umwandeln *)

         str(xaxis_mm:9:4,cx);
         str(yaxis_mm:9:4,cy);
      end
      else
      begin
         (* String umwandeln *)
         str(xaxis,cx);
         str(yaxis,cy);
      end;

      (* Shiften bis rechtsbndig *)

      While cx[10]=' ' do
        begin
          For i:=10 downto 2 do
            begin
              cx[i]:=cx[i-1];
            end;
          cx[1]:=' ';
        end;
      if signx then cx[1]:='+' else cx[1]:='-';

      While cy[10]=' ' do
        begin
          For i:=10 downto 2 do
            begin
              cy[i]:=cy[i-1];
            end;
          cy[1]:=' ';
        end;
     if signy then cy[1]:='+' else cy[1]:='-';

     (* Genderte Zeichen ausgeben *)

     settextstyle(0,0,3);
     setfillpattern(Gray50,0);

     For i:=1 to 10 do
        begin
          if cx[i]<>altcx[i] then
            begin
              xpos:=150+(i*25);
              ypos:=50;
              bar(xpos,ypos,xpos+25,ypos+25);
              outtextxy(xpos,ypos,cx[i]);
              altcx[i]:=cx[i];
            end;
         if cy[i]<>altcy[i] then
            begin
              xpos:=150+(i*25);
              ypos:=100;
              bar(xpos,ypos,xpos+25,ypos+25);
              outtextxy(xpos,ypos,cy[i]);
              altcy[i]:=cy[i];
            end;
        end;
END;

(**********************************************************)
PROCEDURE menu;
VAR
  ende                   : boolean;
  stata,statb            : byte;
  eingabe                : char;
  x,y,altx,alty,ycmax    : integer;
  wnummer,altwnummer     : byte;
  temp                   : word;

BEGIN
  sregister:=0;
  xpreset:=0;
  ypreset:=0;
  aerrorx:=false;
  aerrory:=false;
  ferrorx:=false;
  ferrory:=false;
  ycmax:=210;
  wnummer:=6;
  altwnummer:=6;
  header;
  latch_flagx:=true;
  latch_flagy:=true;
  x:=440;
  altx:=x;
  setfillpattern(Gray50,2);
  bar(x,190,x+5,195);
  rectangle(x,190,x+5,195);
  setwindow(wnummer);
  y:=210;
  alty:=y;
  setfillpattern(Gray50,4);
  bar(x,y,x+5,y+5);
  rectangle(x,y,x+5,y+5);

  ende:=false;
  eingabe:=#00;
  while not ende do
    begin

      (* Taste bewerten wenn gedrckt *)

      if keypressed then
        begin
          eingabe:=readkey;
          case eingabe of
            'q',ESC: ende:=true;

            #0 : begin
                   eingabe:=readkey;
                   case eingabe of
                    'P' : begin
                            altwnummer:=wnummer;
                            wnummer:=((x-40) div 80)+1;
                            alty:=y;
                            y:=y+10;
                            if y>ycmax then y:=210;
                          end;
                    'H' : begin
                            altwnummer:=wnummer;
                            wnummer:=((x-40) div 80)+1;
                            alty:=y;
                            y:=y-10;
                            if y<210 then y:=ycmax;
                          end;
                    'M' : begin
                            altx:=x;
                            alty:=y;
                            y:=210;
                            x:=x+80;
                            if x>440 then x:=40;
                            altwnummer:=wnummer;
                            wnummer:=((x-40) div 80)+1;
                          end;
                    'K' : begin
                            altx:=x;
                            alty:=y;
                            y:=210;
                            x:=x-80;
                            if x<40 then x:=440;
                            altwnummer:=wnummer;
                            wnummer:=((x-40) div 80)+1;
                          end;
                   end;
                 end;
          end; (* case *)


          (* X-Cursor *)

          setfillpattern(Gray50,0);
          bar(altx,190,altx+5,195);
          setfillpattern(Gray50,2);
          bar(x,190,x+5,195);
          rectangle(x,190,x+5,195);

          (* Y-Cursor *)

          setfillpattern(Gray50,5);
          bar(x,alty,x+5,alty+5);
          setfillpattern(Gray50,4);
          bar(x,y,x+5,y+5);
          rectangle(x,y,x+5,y+5);

          (* Men wechseln wenn notwendig *)

          if wnummer<>altwnummer then
                 begin
                   clrwindow(altwnummer);
                   setwindow(wnummer);
                   setfillpattern(Gray50,4);
                   bar(x,y,x+5,y+5);
                   rectangle(x,y,x+5,y+5);
                   altwnummer:=wnummer;
                   case wnummer of
                     1: ycmax:=250;
                     2: ycmax:=280;
                     3: ycmax:=260;
                     4: ycmax:=280;
                     5: ycmax:=210;
                     6: ycmax:=210;
                   end;
                    wnummer:=((x-40) div 80)+1;
                 end;

           (* Auswahl wenn Enter-Taste gedrckt *)

           if eingabe=#13 then
             begin
               case wnummer of
                 1: begin
                      case y of
                        210 : begin
                                ende:=true;
                              end;
                        220 : if land = 1 then land := 2 else land:=1;
                        230 : MM_display:= not MM_display;
                        240 : begin
                                 temp:= trunc(Period_X*1000);
                                 intextxy(200,240,temp);
                                 Period_X:= temp/1000;
                              end;
                        250 : begin
                                 temp:= trunc(Period_Y*1000);
                                 intextxy(200,250,temp);
                                 Period_Y:= temp/1000;
                              end;
                      end;


                    end;
                 2: begin
                      latch_flagx:=true;
                      latch_flagy:=true;
                      sregister:=1;
                      case y of
                        210 : begin
                                Init_Counter(0,c_start,fourfold,normal,linear);
                              end;
                        220 : begin
                                Init_Counter(1,c_start,fourfold,normal,linear);
                              end;
                        230 : begin
                                Init_Counter(0,c_stop,fourfold,normal,linear);
                              end;
                        240 : begin
                                Init_Counter(1,c_stop,fourfold,normal,linear);
                              end;
                        250 : begin
                                Init_Counter(0,RI_reset_start,fourfold,normal,linear);
                              end;
                        260 : begin
                                Init_Counter(1,RI_reset_start,fourfold,normal,linear);
                              end;
                        270 : begin
                                Init_Counter(0,RI_stop,fourfold,normal,linear);
                              end;
                        280 : begin
                                Init_Counter(1,RI_stop,fourfold,normal,linear);
                              end;
                      end;
                    end;
                 3: begin
                      latch_flagx:=true;
                      latch_flagy:=true;
                      sregister:=1;
                      case y of
                        210 : begin
                                Init_Counter(0,c_reset,fourfold,normal,linear);
                              end;
                        220 : begin
                                Init_Counter(1,c_reset,fourfold,normal,linear);
                              end;
                        230 : begin
                                Init_Counter(0,reset_start,fourfold,normal,linear);
                              end;
                        240 : begin
                                Init_Counter(1,reset_start,fourfold,normal,linear);
                              end;
                        250 : begin
                                subdivision := 100;
                                m_interpol:=I_25;
                                Interpolation(0,m_interpol);
                                Interpolation(1,m_interpol);
                              end;
                        260 : begin
                                subdivision := 200;
                                m_interpol:=I_50;
                                Interpolation(0,m_interpol);
                                Interpolation(1,m_interpol);
                              end;
                      end;
                    end;
                 4: begin
                      latch_flagx:=false;
                      latch_flagy:=false;
                      case y of
                        210 : begin
                                Init_Latch(0,c_start,fourfold,latchw);
                                Init_Counter(0,c_start,fourfold,normal,linear);
                                Init_Counter(1,c_start,fourfold,normal,linear);
                              end;
                        220 : begin
                                Init_Latch(0,c_reset,fourfold,latchw);
                                Init_Latch(0,RI_start,fourfold,latchw);
                                Init_Counter(0,RI_reset_start,fourfold,normal,linear);
                                Init_Counter(1,RI_reset_start,fourfold,normal,linear);
                              end;
                        230 : begin
                                Init_Latch(0,RI_stop,fourfold,latchw);
                                Init_Counter(0,RI_stop,fourfold,normal,linear);
                                Init_Counter(1,RI_stop,fourfold,normal,linear);
                              end;
                        240 : begin
                                Init_Latch(0,c_stop,fourfold,latchw);
                                Init_Counter(0,c_stop,fourfold,normal,linear);
                                Init_Counter(1,c_stop,fourfold,normal,linear);
                              end;
                        250 : begin
                                Init_Latch(0,c_reset,fourfold,latchw);
                                Init_Counter(0,c_reset,fourfold,normal,linear);
                                Init_Counter(1,c_reset,fourfold,normal,linear);
                              end;
                        260 : begin
                                Latch_Disable(0,ExternalX1X2);
                                Latch_Enable(0,Internal);
                                sregister:=0;
                              end;
                        270 : begin
                                Latch_Disable(0,Internal);
                                Latch_Enable(0,ExternalX1X2);
                                sregister:=1;
                              end;
                        280 : begin
                                intextxy(450,280,latchw);
                                Init_Latch(0,c_stop,fourfold,latchw);
                              end;
                      end;
                    end;
               end;
             end;

           eingabe:=#00;


        end; (* if *)

      (* Bildschirmausgabe *)

      Counter_anzeige;

      (* Fehlerabfrage *)
      errorcheck(0,aerrorx,aerrory,ferrorx,ferrory);
      errorcheck(1,aerrorx,aerrory,ferrorx,ferrory);

    end; (* while *)
END;

(********************* main program ***********************)
BEGIN
    clrscr;
    Land:=1;
    Period_X := 0.020;
    Period_Y := 0.020;
    MM_display:=true;
    Subdivision := 200;
    m_interpol:=I_50;
    latchw:= 5000;  { 5689 = Jeder 10 fur 1024-Strich Geber }

    init_com;

    { Load Graphics driver if running standalone }
    {$ifdef standalone};
      if RegisterBGIdriver(@CgaDriverProc)<0 then begin end;
      if RegisterBGIdriver(@EgaVGADriverProc)<0 then begin end;
      if RegisterBGIdriver(@HercDriverProc)<0 then begin end;
      if RegisterBGIdriver(@ATTDriverProc)<0 then begin end;
      if RegisterBGIdriver(@PC3270DriverProc)<0 then begin end;
    {$endif}


    Init_Interface(0);
    Init_Interface(1);
    Interpolation(0,m_interpol);
    Interpolation(1,m_interpol);
    Init_Counter (0,reset_start,fourfold,normal,linear);
    Init_Counter (1,reset_start,fourfold,normal,linear);
    Init_Latch(0,c_stop,fourfold,latchw);
    Reset_uas(0);
    Reset_uas(1);
    Reset_Status(0);
    Reset_Status(1);
    graphdriver:=detect;
    writeln('Before initgraph');
    initgraph(graphdriver,graphmode,'');

    xmax:=GetMaxX;
    ymax:=GetMaxY;
    SetViewport(0,0,xmax,ymax,true);
    ClearViewport;
    For i:=1 to 10 do
    begin
      cx[i]:=' ';
      cy[i]:=' ';
      altcx[i]:=' ';
      altcy[i]:=' ';
    end;
    menu;
    closegraph;
END.

(**********************************************************)
