{--------------------------------------------------------------------------}
{ DR JOHANNES HEIDENHAIN GmbH                                              }
{ UNIT BIGDISP to display large numerals in text mode.                     }
{--------------------------------------------------------------------------}

unit BigDisp;

interface

type DisplayMode = (Medium,Large,Rounded);

procedure LDisplay( Value:real;DMode:DisplayMode; pos_x,pos_y,
                    NoOfChars,DigitsAfterDecPoint:byte;
                    MinutesSeconds,flash:boolean ;var lastvalstr:string);
{--------------------------------------------------------------------------}
{ This procedure displays a real value in large numeral without using      }
{ graphics using only ASCII characters.					   }
{ The parameters that are required are as follows: 			   }
{ Value      the value to be displayed					   }
{ DMode      type (size/form) of display                                   }
{ pos_x      the x coordinate of the upper left character		   }
{ pos_y       "  y      "             "      "      "			   }
{ NoOfChars  total number of characters including both dec. point and sign }
{ DigitsAfterDecPoint: number of digits after the decimal point		   }
{ MinutesSeconds:  true = output in degrees,minutes,seconds		   }
{ flash       enable/disable of flashing display                           }
{ lastvalstr  A string to store the last value that was output to the      }
{             screen. Required to speed up the display. Don't forget to    }
{             initialise.                                                  }
{--------------------------------------------------------------------------}

implementation

uses crt;
{----------------------------------------------------------}
{Compiler switches to speed up all routines                }
{$B- Short Circuit bei Bedienungs Test                     }
{$R- Range Checking off                                    }
{$S+ Stack Checking on                                     }
{$V+ Strict Variable Checking on                           }
{$I- I/O Checking off                                      }
{----------------------------------------------------------}


procedure LDisplay ( Value:real;DMode:DisplayMode; pos_x,pos_y,
                    NoOfChars,DigitsAfterDecPoint:byte;
                    MinutesSeconds,flash:boolean ;var lastvalstr:string);

var valstr,w_h:string;
    i,x1,y1,x2,y2,color:byte;

begin
   X1 := lo(WindMin);
   Y1 := hi(WindMin);
   X2 := lo(WindMax);
   Y2 := hi(WindMax);
   valstr:='';
   w_h:='';
   if MinutesSeconds then
   begin
     NoOfChars:=10;
     str(trunc(Value):4,w_h);
     valstr:=w_h+':';
     if (trunc(value)=0) and (value<0) then valstr[3]:='-';
     Value:=abs(frac(Value)*60 );
     str(trunc(Value):2,w_h);
     if w_h[1]=' ' then w_h[1]:='0';
     valstr:=valstr+w_h+':';
     Value:=abs(frac(Value)*60 );
     str(round(Value):2,w_h);
     if w_h[1]=' ' then w_h[1]:='0';
     valstr:=valstr+w_h;
   end
   else str(Value:NoOfChars:DigitsAfterDecPoint,valstr);

   if length(valstr)<>length(lastvalstr) then
     begin
     lastvalstr:=valstr;
     Lastvalstr:='$$$$$$$$$$$$$$$$$';
     end;
   color:=TextAttr and ($80+$0F);
   if flash then TextColor(color or Blink)
            else TextColor(color and not Blink);
   case DMode of
     Medium:begin
            for i:=1 to NoOfChars do
              begin
    {            if (valstr[i]='.') or (valstr[i]=':') then dec(pos_x); }
                if valstr[i]<>lastvalstr[i] then
                begin
                window(pos_x+(i-1)*4,pos_y,pos_x+i*4-2,pos_y+3);
                case valstr[i] of
                '0':write(' ');
                '1':write('      ');
                '2':write('');
                '3':write('');
                '4':write('   ');
                '5':write('');
                '6':write('');
                '7':write('    ');
                '8':write('');
                '9':write('');
                '.':write('        ');
                ':':write('       ');
                ' ':write('         ');
                '-':write('      ');
                ' ':write('         ');
                end;
              end;
{              if (valstr[i]='.') or (valstr[i]=':') then dec(pos_x);}
              end;
            end;

      Large:begin
            for i:=1 to NoOfChars do
              begin
{                if (valstr[i]='.') or (valstr[i]=':') then dec(pos_x); }
                if valstr[i] <> lastvalstr[i] then
                begin
                window(pos_x+(i-1)*7,pos_y,pos_x+i*7-3,pos_y+4);
                case valstr[i] of
                  '0':write('      ');
                  '1':write('                ');
                  '2':write('    ');
                  '3':write('     ');
                  '4':write('           ');
                  '5':write('    ');
                  '6':write('   ');
                  '7':write('            ');
                  '8':write('   ');
                  '9':write('    ');
                  '-':write('                ');
                  '.':write('                ');
                  ' ':write('                    ');
                  ':':write('              ');
                  ' ':write('                    ');
                  end;
                end;
 {               if (valstr[i]='.') or (valstr[i]=':') then dec(pos_x); }
              end;
            end;
    Rounded:begin
            for i:=1 to NoOfChars do
              begin
{                if (valstr[i]='.') or (valstr[i]=':') then dec(pos_x);   }
                if valstr[i] <> lastvalstr[i] then
                begin
                window(pos_x+(i-1)*7,pos_y,pos_x+i*7-3,pos_y+4);
                case valstr[i] of
                  '0':write('        ');
                  '1':write('            ');
                  '2':write('      ');
                  '3':write('       ');
                  '4':write('           ');
                  '5':write('      ');
                  '6':write('      ');
                  '7':write('          ');
                  '8':write('     ');
                  '9':write('     ');
                  '-':write('                 ');
                  '.':write('                ');
                  ' ':write('                    ');
                  ':':write('              ');
                  ' ':write('                    ');
                  end;
                end;
 {               if (valstr[i]='.') or (valstr[i]=':') then dec(pos_x); }
             end;
            end;
        end; { of case medium/large/rounded }
   lastvalstr:=valstr;
   window(X1+1,Y1+1,X2+1,Y2+1);
   TextColor(color);
end;

end.