UNIT IK120_0;

{-------------------------------------------------------
  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Driver Unit for IK120 (Basic Functions)

  V 1.00
  Nov 1995
 -----------------------------------------------------------}

{$N+,E+}
{$V+}
{$R+}

interface

PROCEDURE write_g6(baseadr:word;axes,address:byte;datum:byte);
PROCEDURE write_conf(baseadr:word;reg:byte;datum:byte);
PROCEDURE write_stb(baseadr:word);
FUNCTION read_g6(baseadr:word;axes,address:byte):byte;

PROCEDURE soft_l0(baseadr:word;axis:byte);
PROCEDURE soft_l1(baseadr:word;axis:byte);
FUNCTION read_count_value32(baseadr:word;axis,reg:byte):comp;
FUNCTION latched(baseadr:word;axis,reg:byte):boolean;
PROCEDURE poll_latch(baseadr:word;axis,reg:byte);

Implementation

{-------------------------------------------------------
                      write_g6
 axis 1 : Counter axis 1
 axis 2 : Counter axis 2
 -------------------------------------------------------}
PROCEDURE
 write_g6(baseadr:word;axes,address:byte;datum:byte);
  VAR
    adr : word;
  BEGIN
    address:=address and $000F;
    if axes=1 then
      begin
        adr:=address;
        mem[baseadr:adr]:=datum;
      end
    else
      begin
        adr:=$0010 or address;
        mem[baseadr:adr]:=datum;
      end;
  END;
{-------------------------------------------------------
                      write_config
 reg : 0 = control1
 reg : 1 = control2
 reg : 2 = latch-counter lword
 reg : 3 = latch-counter hword
 -------------------------------------------------------}
PROCEDURE
 write_conf(baseadr:word;reg:byte;datum:byte);
  VAR
    adr : word;
  BEGIN
    case reg of
    0 : mem[baseadr:$0020]:=datum;
    1 : mem[baseadr:$0030]:=datum;
    2 : mem[baseadr:$0040]:=datum;
    3 : mem[baseadr:$0050]:=datum;
    end;
  END;
{-------------------------------------------------------
                      write_stb
 -------------------------------------------------------}
PROCEDURE
 write_stb(baseadr:word);
  BEGIN
    mem[baseadr:$0070]:=$FF;
  END;
{-------------------------------------------------------
                        read_g6
 axis 1 : Counter axis 1
 axis 2 : Counter axis 2
 -------------------------------------------------------}
FUNCTION read_g6(baseadr:word;axes,address:byte):byte;
  VAR
    adr : word;
  BEGIN
    address:=address and $000F;
    if axes=1 then
      begin
        adr:=address;
        read_g6:=mem[baseadr:adr];
      end
    else
      begin
        adr:=$0010 + address;
        read_g6:=mem[baseadr:adr];
      end;
  END;
{-------------------------------------------------------
                         soft_l0
 -------------------------------------------------------}
PROCEDURE soft_l0(baseadr:word;axis:byte);
  BEGIN
    write_g6(baseadr,axis,8,$FF);
  END;
{-------------------------------------------------------
                         soft_l1
 -------------------------------------------------------
 This procedure reads the measured value and stores
 it in data register 1.
 -------------------------------------------------------}
PROCEDURE soft_l1(baseadr:word;axis:byte);
  BEGIN
    write_g6(baseadr,axis,9,$FF);
  END;
{-------------------------------------------------------
  		    read_count_value32
 -------------------------------------------------------}
FUNCTION
 read_count_value32(baseadr:word;axis,reg:byte):comp;
  TYPE
    vartype = (li,by);
    mapper = record
               case wert:vartype of
                 li : (field0:longint);
                 by : (field1:array[0..3] of byte);
               end;
  VAR
    buffer : mapper;
  BEGIN
    case reg of
     0 : begin
           buffer.field1[0]:=read_g6(baseadr,axis,0);
           buffer.field1[1]:=read_g6(baseadr,axis,1);
           buffer.field1[2]:=read_g6(baseadr,axis,2);
           buffer.field1[3]:=read_g6(baseadr,axis,3);
         end;
     1 : begin
           buffer.field1[0]:=read_g6(baseadr,axis,4);
           buffer.field1[1]:=read_g6(baseadr,axis,5);
           buffer.field1[2]:=read_g6(baseadr,axis,6);
           buffer.field1[3]:=read_g6(baseadr,axis,7);
         end;
     end;
     read_count_value32:=buffer.field0;
  END;
{-------------------------------------------------------
                         latched
 -------------------------------------------------------}
FUNCTION latched(baseadr:word;axis,reg:byte):boolean;
  BEGIN
      case reg of
        0: latched:=
        ( Read_g6(baseadr,axis,14) and $01 ) = $01;
        1: latched:=
        ( Read_g6(baseadr,axis,14) and $02 ) = $02;
      end;
  END;
{-------------------------------------------------------
                       poll_latch
 -------------------------------------------------------}
PROCEDURE poll_latch(baseadr:word;axis,reg:byte);
  BEGIN
      case reg of
        0: begin
             repeat
             until latched(baseadr,axis,0);
           end;
        1: begin
             repeat
             until latched(baseadr,axis,1);
           end;
      end;
  END;
{-------------------------------------------------------}
END.