UNIT cnt_2;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Counter Program                                       }
{                                                       }
{ V 1.00                                                }
{ July 1994                                             }
{-------------------------------------------------------}

{$N+,E+}
{$V+}
{$R+}

interface

uses crt,graph,cnt_0,cnt_1,ik120_1;

procedure display_panel(count:count_pointr);
procedure menu(var restart:boolean;count:count_pointr);

implementation

var
 i                                   : byte;
 tfile                               : Text;
 mwin                                : wpointr;
 win                                 : array[0..10] of wpointr;
 hmwin                               : hpointr;
 hwin                                : array[0..10] of hpointr;
 winvector                           : cpointr;
 text                                : string;
 buffer                              : word;
 hardware                            : boolean;
 hw                                  : string4;
 refmark0,refmark1                   : comp;
 printval                            : string;
 rifound1,rifound2                   : boolean;
(**********************************************************)
procedure range(var wert:word;min,max:word);
begin
  if wert>max then wert:=max;
  if wert<min then wert:=min;
end;
(**********************************************************)
(*$I ik120.win*)
(*$I ik120.hlp*)
(**********************************************************)
procedure draw_mainwin(count:count_pointr);
begin
  (* Main window *)
  setcolor(4);
  rectangle(mwin^.x+8,mwin^.y+21,mwin^.x+mwin^.dx-8,mwin^.y+41);
  moveto((mwin^.x+mwin^.dx div 3),mwin^.y+8);
  setcolor(15);
  outtext('DR. JOHANNES HEIDENHAIN GmbH');
  setcolor(2);
  rectangle(mwin^.x+6,count^.count[1]^.win_ypos-20,mwin^.x+mwin^.dx-6,mwin^.y+mwin^.dy-30);
  bar(mwin^.x+6,count^.count[1]^.win_ypos-20,mwin^.x+mwin^.dx-6,mwin^.y+mwin^.dy-30);
  setcolor(15);
  moveto(mwin^.x+8,mwin^.y+mwin^.dy-16);
  outtext('F1=Help');
  moveto(mwin^.x+130,mwin^.y+mwin^.dy-16);
  outtext('ESC=Close window');
  moveto(mwin^.x+320,mwin^.y+mwin^.dy-16);
  outtext('F10=Quit');

end;
(**********************************************************)
procedure init_counter(count:count_pointr);
  BEGIN

  init_ik120(count^.board);
  read_count(count);

  (* Any hardware? *)
  hardware:=look_for_ik120(count^.board);

  count^.count[1]^.win_xpos:=mwin^.x+25;
  count^.count[1]^.win_ypos:=mwin^.y+mwin^.dy-160;
  count^.count[2]^.win_xpos:=mwin^.x+25;
  count^.count[2]^.win_ypos:=mwin^.y+mwin^.dy-100;

  if hardware then
    begin
      count^.board^.axis[1]^.inimain.interpol:=i50fach;
      count^.board^.axis[1]^.inilatch.en_ref:=l1;
      count^.board^.axis[1]^.softcomm.stop:=true;
      count^.board^.axis[1]^.softcomm.clear:=true;
      count^.board^.axis[1]^.softcomm.latch0:=true;
      count^.board^.axis[1]^.softcomm.clrerror:=true;

      count^.board^.axis[2]^.inimain.interpol:=i50fach;
      count^.board^.axis[2]^.inilatch.en_ref:=l1;
      count^.board^.axis[2]^.softcomm.stop:=true;
      count^.board^.axis[2]^.softcomm.clear:=true;
      count^.board^.axis[2]^.softcomm.latch0:=true;
      count^.board^.axis[2]^.softcomm.clrerror:=true;

      Init_G6Handler(count^.board^.axis[1]);
      Init_G6Handler(count^.board^.axis[2]);
      Comm_G6Handler(count^.board^.axis[1]);
      Comm_G6Handler(count^.board^.axis[2]);

      if count^.count[1]^.refmark=0 then
        begin
          count^.board^.axis[1]^.softcomm.start:=true;
          count^.board^.axis[1]^.softcomm.clear:=true;
        end
      else
        begin
          count^.board^.axis[1]^.refcomm.ristart:=true;
          count^.board^.axis[1]^.refcomm.riclear:=true;
        end;

      if count^.count[2]^.refmark=0 then
        begin
          count^.board^.axis[2]^.softcomm.start:=true;
          count^.board^.axis[2]^.softcomm.clear:=true;
        end
      else
        begin
          count^.board^.axis[2]^.refcomm.ristart:=true;
          count^.board^.axis[2]^.refcomm.riclear:=true;
        end;

      Comm_G6Handler(count^.board^.axis[1]);
      Comm_G6Handler(count^.board^.axis[2]);

    end;
end;
(**********************************************************)
procedure display_panel(count:count_pointr);
begin
  read_reg0(count^.board^.axis[1]);           (* Timer latches *)
  read_reg0(count^.board^.axis[2]);
  Build_Countwert(count^.board^.axis[1],count^.count[1]);
  Build_Countwert(count^.board^.axis[2],count^.count[2]);
  count_display(count^.count[1]);
  count_display(count^.count[2]);
  read_count_status(count^.board^.axis[1]);
  read_count_status(count^.board^.axis[2]);
  status_display(count^.board^.axis[1],count^.count[1]);
  status_display(count^.board^.axis[2],count^.count[2]);
end;
(**********************************************************)
procedure menu(var restart:boolean;count:count_pointr);
begin
  New(winvector);
  New(mwin);
  for i:=0 to 10 do
    begin
      New(win[i]);
    end;
  New(hmwin);
  for i:=0 to 10 do
    begin
      New(hwin[i]);
    end;

  init_mainwin;
  init_counter(count);
  init_windows(count);
  init_help;

  winvector^.enmouse:=mousedriver;
  winvector^.window:=mwin;
  init_defaults(winvector);
  open_window(winvector^.window);
  winvector^.x:=35;
  winvector^.y:=40;
  setmousepos(winvector);
  draw_cursor(winvector);
  draw_mainwin(count);

  count_back(count^.count[1]);
  count_back(count^.count[2]);
  count_display(count^.count[1]);
  count_display(count^.count[2]);
  status_back(count^.count[1]);
  status_back(count^.count[2]);

  if not(hardware) then
    begin
      moveto(100,120);
      setcolor(4);
      settextstyle(0,0,3);
      outtext('NO HARDWARE!!');
      moveto(100,150);
      settextstyle(0,0,1);
      outtext('Press Return - Run INSTALL.EXE');
      readln;
      moveto(100,120);
      setcolor(15);
      settextstyle(0,0,3);
      outtext('NO HARDWARE!!');
      moveto(100,150);
      settextstyle(0,0,1);
      outtext('Press Return - Run INSTALL.EXE');
    end;

  if count^.printer=druck_lpt1 then
    begin
      Assign(tfile,'LPT1');
      (*$I-*)
      Rewrite(tfile);
      (*$I+*)
    end;
  if count^.printer=druck_lpt2 then
    begin
      Assign(tfile,'LPT2');
      (*$I-*)
      Rewrite(tfile);
      (*$I+*)
    end;
  if count^.printer=druck_file then
    begin
      Assign(tfile,'IK120.DAT');
      (*$I-*)
      Rewrite(tfile);
      (*$I+*)
    end;

  rifound1:=false;
  rifound2:=false;

  while not(winvector^.exit) do
    begin

      win_handler(winvector);

      case winvector^.proc_sel of
        1 :  begin   (* Save *)
               write_count(count);
               write_adr(count^.board^.axis[1]^.baseadr);
             end;
        2 :  begin   (* Preset X *)
               i:=count^.count[1]^.dimension;
               count^.count[1]^.preset[i]:=-(count^.count[1]^.position-
                                           count^.count[1]^.preset[i])+
                                           winvector^.wert;
             end;
        3 :  begin   (* Preset Y *)
               i:=count^.count[2]^.dimension;
               count^.count[2]^.preset[i]:=-(count^.count[2]^.position-
                                           count^.count[2]^.preset[i])+
                                           winvector^.wert;
             end;
        4 :  begin    (* Basic address *)
               buffer:=round(winvector^.wert);
               range(buffer,0,$FFFF);
               buffer:=buffer and $0FF0;
               count^.board^.axis[1]^.baseadr:=buffer;
               count^.board^.axis[2]^.baseadr:=buffer;
               word_hex(buffer,hw);
               win[6]^.zeile[1].lines:='Base addr.: '+hw[4]+hw[3]+hw[2]+hw[1]+'H';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        5 :  begin    (* Resolution axis 1 *)
               buffer:=round(winvector^.wert);
               range(buffer,0,10000);
               if buffer<>0 then count^.count[1]^.resolution:=buffer;
               str(buffer,text);
               win[4]^.zeile[1].lines:='Resol.: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        6 :  begin    (* Period axis 1 *)
               buffer:=round(winvector^.wert);
               range(buffer,1,1000);
               count^.count[1]^.periode:=buffer;
               str(buffer,text);
               win[4]^.zeile[2].lines:='Period: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        7 :  begin    (* Reference-pulse axis 1 *)
               buffer:=round(winvector^.wert);
               range(buffer,0,2);
               count^.count[1]^.refmark:=buffer;
               str(buffer,text);
               win[4]^.zeile[3].lines:='Ref. marks: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        8 :  begin    (* Resolution axis 2 *)
               buffer:=round(winvector^.wert);
               range(buffer,0,10000);
               if buffer<>0 then count^.count[2]^.resolution:=buffer;
               str(buffer,text);
               win[5]^.zeile[1].lines:='Resol.: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        9 :  begin    (* Period axis 2*)
               buffer:=round(winvector^.wert);
               range(buffer,1,1000);
               count^.count[2]^.periode:=buffer;
               str(buffer,text);
               win[5]^.zeile[2].lines:='Period: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        10:  begin    (* Reference-pulse axis 1 *)
               buffer:=round(winvector^.wert);
               range(buffer,0,2);
               count^.count[2]^.refmark:=buffer;
               str(buffer,text);
               win[5]^.zeile[3].lines:='Ref. marks: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        11 : begin
               if count^.printer<>none then close(tfile);
               count^.printer:=none;
               win[7]^.zeile[2].lines:='LPT1: off';
               win[7]^.zeile[3].lines:='LPT2: off';
               win[7]^.zeile[4].lines:='File: off';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        12 : begin (* LPT1 *)
               if count^.printer<>none then
                 begin
                   (*$I-*)
                   close(tfile);
                   (*$I+*)
                 end;
               Assign(tfile,'LPT1');
               (*$I-*)
               Rewrite(tfile);
               (*$I+*)
               if ioresult=0 then
                 begin
                   count^.printer:=druck_lpt1;
                   win[7]^.zeile[2].lines:='LPT1: on';
                   win[7]^.zeile[3].lines:='LPT2: off';
                   win[7]^.zeile[4].lines:='File: off';
                   draw_cursor(winvector);
                   refresh_window(winvector^.window);
                   draw_cursor(winvector);
                 end;
             end;
        13 : begin (* LPT2 *)
               if count^.printer<>none then
                 begin
                   (*$I-*)
                   close(tfile);
                   (*$I+*)
                 end;
               Assign(tfile,'LPT2');
               (*$I-*)
               Rewrite(tfile);
               (*$I+*)
               if ioresult=0 then
                 begin
                   count^.printer:=druck_lpt2;
                   win[7]^.zeile[2].lines:='LPT1: off';
                   win[7]^.zeile[3].lines:='LPT2: on';
                   win[7]^.zeile[4].lines:='File: off';
                   draw_cursor(winvector);
                   refresh_window(winvector^.window);
                   draw_cursor(winvector);
                 end;
             end;
        14 : begin (* File *)
               if count^.printer<>none then
                 begin
                   (*$I-*)
                   close(tfile);
                   (*$I+*)
                 end;
               Assign(tfile,'IK120.DAT');
               (*$I-*)
               Rewrite(tfile);
               (*$I+*)
               if ioresult=0 then
                 begin
                   count^.printer:=druck_file;
                   win[7]^.zeile[2].lines:='LPT1: off';
                   win[7]^.zeile[3].lines:='LPT2: off';
                   win[7]^.zeile[4].lines:='File: on';
                   draw_cursor(winvector);
                   refresh_window(winvector^.window);
                   draw_cursor(winvector);
                 end;
             end;
        15 : begin  (* Print *)
               moveto(100,150);
               settextstyle(0,0,1);
               setcolor(4);
               if count^.printer=druck_lpt2 then outtext('Printing to LPT2');
               if count^.printer=druck_lpt1 then outtext('Printing to LPT1');
               if count^.printer=druck_file then outtext('Printing to IK120.DAT');
               if count^.printer=none then outtext('No print device');
               sound(100);
               if count^.printer<>none then
                 begin
                   (*$I-*)
                   str(count^.count[1]^.position:10:count^.count[1]^.digits,printval);
                   writeln(tfile,' X: ',printval);
                   str(count^.count[2]^.position:10:count^.count[2]^.digits,printval);
                   writeln(tfile,' Y: ',printval);
                   (*$I+*)
                 end;
               delay(500);
               nosound;
               moveto(100,150);
               setcolor(15);
               if count^.printer=druck_lpt2 then outtext('Printing to LPT2');
               if count^.printer=druck_lpt1 then outtext('Printing to LPT1');
               if count^.printer=druck_file then outtext('Printing to IK120.DAT');
               if count^.printer=none then outtext('No print device');
             end;
        16 : begin  (* Reference axis 1 *)
               for i:=1 to 4 do
               count^.count[1]^.preset[i]:=0;
               if count^.count[1]^.refmark=1 then
                 begin
                   count^.board^.axis[1]^.refcomm.ristart:=true;
                   count^.board^.axis[1]^.refcomm.riclear:=true;
                   Comm_G6handler(count^.board^.axis[1]);
                 end;
               if count^.count[1]^.refmark=2 then
                 begin
                   count^.board^.axis[1]^.refcomm.ristart:=true;
                   count^.board^.axis[1]^.refcomm.riclear:=true;
                   count^.board^.axis[1]^.refcomm.rilatch:=true;
                   Comm_G6handler(count^.board^.axis[1]);
                 end;
             end;
        17 : begin  (* Reference axis 2 *)
               for i:=1 to 4 do
               count^.count[2]^.preset[i]:=0;
               if count^.count[2]^.refmark=1 then
                 begin
                   count^.board^.axis[2]^.refcomm.ristart:=true;
                   count^.board^.axis[2]^.refcomm.riclear:=true;
                   Comm_G6handler(count^.board^.axis[2]);
                 end;
               if count^.count[2]^.refmark=2 then
                 begin
                   count^.board^.axis[2]^.refcomm.ristart:=true;
                   count^.board^.axis[2]^.refcomm.riclear:=true;
                   count^.board^.axis[2]^.refcomm.rilatch:=true;
                   Comm_G6handler(count^.board^.axis[2]);
                 end;
             end;
        18 : begin
             end;
        19 : begin
             end;
        20:  begin    (* Reset axis 1 *)
               i:=count^.count[1]^.dimension;
               count^.count[1]^.preset[i]:=-(count^.count[1]^.position-
                                             count^.count[1]^.preset[i]);
             end;
        21:  begin    (* Reset axis 2 *)
               i:=count^.count[2]^.dimension;
               count^.count[2]^.preset[i]:=-(count^.count[2]^.position-
                                             count^.count[2]^.preset[i]);
             end;
        22 : begin     (* Number of digits axis 1 *)
               buffer:=round(winvector^.wert);
               range(buffer,1,5);
               count^.count[1]^.digits:=buffer;
               str(buffer,text);
               win[4]^.zeile[4].lines:='Digits: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
               write_count(count);
               restart:=true;
               winvector^.act_sel:=13;   (* Exit *)
             end;
        23 : begin     (* Number of digits axis 2 *)
               buffer:=round(winvector^.wert);
               range(buffer,1,5);
               count^.count[2]^.digits:=buffer;
               str(buffer,text);
               win[5]^.zeile[4].lines:='Digits: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
               write_count(count);
               restart:=true;
               winvector^.act_sel:=13;   (* Exit *)
             end;
        24 : begin  (* Min. axis 1 *)
               count^.count[1]^.lbound:=winvector^.wert;
               str(count^.count[1]^.lbound:5:5,text);
               win[8]^.zeile[1].lines:='Min X: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        25 : begin
               count^.count[1]^.hbound:=winvector^.wert;
               str(count^.count[1]^.hbound:5:5,text);
               win[8]^.zeile[2].lines:='Max X: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        26 : begin
               count^.count[2]^.lbound:=winvector^.wert;
               str(count^.count[2]^.lbound:5:5,text);
               win[8]^.zeile[3].lines:='Min Y: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        27 : begin
               count^.count[2]^.hbound:=winvector^.wert;
               str(count^.count[2]^.hbound:5:5,text);
               win[8]^.zeile[4].lines:='Max Y: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        28 : begin
               count^.count[1]^.dimension:=1;
               win[9]^.zeile[1].lines:='X datum 1: on';
               win[9]^.zeile[2].lines:='X datum 2:';
               win[9]^.zeile[3].lines:='X datum 3:';
               win[9]^.zeile[4].lines:='X datum 4:';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        29 : begin
               count^.count[1]^.dimension:=2;
               win[9]^.zeile[1].lines:='X datum 1:';
               win[9]^.zeile[2].lines:='X datum 2: on';
               win[9]^.zeile[3].lines:='X datum 3:';
               win[9]^.zeile[4].lines:='X datum 4:';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        30 : begin
               count^.count[1]^.dimension:=3;
               win[9]^.zeile[1].lines:='X datum 1:';
               win[9]^.zeile[2].lines:='X datum 2:';
               win[9]^.zeile[3].lines:='X datum 3: on';
               win[9]^.zeile[4].lines:='X datum 4:';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        31 : begin
               count^.count[1]^.dimension:=4;
               win[9]^.zeile[1].lines:='X datum 1:';
               win[9]^.zeile[2].lines:='X datum 2:';
               win[9]^.zeile[3].lines:='X datum 3:';
               win[9]^.zeile[4].lines:='X datum 4: on';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        32 : begin
               count^.count[2]^.dimension:=1;
               win[9]^.zeile[5].lines:='Y datum 1: on';
               win[9]^.zeile[6].lines:='Y datum 2:';
               win[9]^.zeile[7].lines:='Y datum 3:';
               win[9]^.zeile[8].lines:='Y datum 4:';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        33 : begin
               count^.count[2]^.dimension:=2;
               win[9]^.zeile[5].lines:='Y datum 1:';
               win[9]^.zeile[6].lines:='Y datum 2: on';
               win[9]^.zeile[7].lines:='Y datum 3:';
               win[9]^.zeile[8].lines:='Y datum 4:';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        34 : begin
               count^.count[2]^.dimension:=3;
               win[9]^.zeile[5].lines:='Y datum 1:';
               win[9]^.zeile[6].lines:='Y datum 2:';
               win[9]^.zeile[7].lines:='Y datum 3: on';
               win[9]^.zeile[8].lines:='Y datum 4:';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        35 : begin
               count^.count[2]^.dimension:=4;
               win[9]^.zeile[5].lines:='Y datum 1:';
               win[9]^.zeile[6].lines:='Y datum 2:';
               win[9]^.zeile[7].lines:='Y datum 3:';
               win[9]^.zeile[8].lines:='Y datum 4: on';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        36 : begin
               if count^.count[1]^.mode=min then
                 begin
                   win[10]^.zeile[1].lines:='X min: off';
                   win[10]^.zeile[2].lines:='X max: off';
                   count^.count[1]^.mode:=pos;
                   count^.count[1]^.min:=1000000;
                 end
               else
                 begin
                   win[10]^.zeile[1].lines:='X min: on';
                   win[10]^.zeile[2].lines:='X max: off';
                   count^.count[1]^.mode:=min;
                   count^.count[1]^.min:=1000000;
                 end;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        37 : begin
             if count^.count[1]^.mode=max then
                 begin
                   win[10]^.zeile[1].lines:='X min: off';
                   win[10]^.zeile[2].lines:='X max: off';
                   count^.count[1]^.mode:=pos;
                   count^.count[1]^.max:=-1000000;
                 end
               else
                 begin
                   win[10]^.zeile[1].lines:='X min: off';
                   win[10]^.zeile[2].lines:='X max: on';
                   count^.count[1]^.mode:=max;
                   count^.count[1]^.max:=-1000000;
                 end;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        38 : begin
               if count^.count[2]^.mode=min then
                 begin
                   win[10]^.zeile[3].lines:='Y min: off';
                   win[10]^.zeile[4].lines:='Y max: off';
                   count^.count[2]^.mode:=pos;
                   count^.count[2]^.min:=1000000;
                 end
               else
                 begin
                   win[10]^.zeile[3].lines:='Y min: on';
                   win[10]^.zeile[4].lines:='Y max: off';
                   count^.count[2]^.mode:=min;
                   count^.count[2]^.min:=1000000;
                 end;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        39 : begin
             if count^.count[2]^.mode=max then
                 begin
                   win[10]^.zeile[3].lines:='Y min: off';
                   win[10]^.zeile[4].lines:='Y max: off';
                   count^.count[2]^.mode:=pos;
                   count^.count[2]^.max:=-1000000;
                 end
               else
                 begin
                   win[10]^.zeile[3].lines:='Y min: off';
                   win[10]^.zeile[4].lines:='Y max: on';
                   count^.count[2]^.mode:=max;
                   count^.count[2]^.max:=-1000000;
                 end;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        40 : begin
             end;
       100 : begin
               restart:=true;
               winvector^.act_sel:=13;   (* Exit *)
             end;
      end;
      winvector^.proc_sel:=0;

      if (hardware) then
        begin

          soft_latch0(count^.board^.axis[1]);
          soft_latch0(count^.board^.axis[2]);

          display_panel(count);

          if count^.count[1]^.refmark=2 then        (* Distance-coded ref. marks *)
            begin
              if (count^.board^.axis[1]^.cstatus.latch1) then
                begin
                  rifound1:=true;
                  Read_Reg1(count^.board^.axis[1]);
                  refmark0:=count^.board^.axis[1]^.register1;

                  if count^.board^.axis[1]^.inimain.interpol=i50fach then
                    begin
                      refmark0:=refmark0/200;
                    end
                  else
                    begin
                      refmark0:=refmark0/100;
                    end;

                  if (refmark0>500) then  (* Positive direction *)
                     begin
                       count^.count[1]^.offset:=((refmark0-501)*1000);
                       for i:=1 to 4 do
                       count^.count[1]^.preset[i]:=0;
                     end;
                  if (refmark0<500) and (refmark0>0) then
                     begin
                       count^.count[1]^.offset:=((500-refmark0)*1000)-refmark0;
                       for i:=1 to 4 do
                       count^.count[1]^.preset[i]:=0;
                     end;
                  if (refmark0<-500) then  (* Negative direction *)
                     begin
                       count^.count[1]^.offset:=((-refmark0-501)*1000)-refmark0;
                       for i:=1 to 4 do
                       count^.count[1]^.preset[i]:=0;
                     end;
                  if (refmark0>-500) and (refmark0<0) then
                    begin
                      count^.count[1]^.offset:=((500+refmark0)*1000);
                      for i:=1 to 4 do
                      count^.count[1]^.preset[i]:=0;
                    end;
                  if (refmark0=0) then
                    begin
                      rifound1:=false;
                      count^.board^.axis[1]^.refcomm.ristart:=true;
                      count^.board^.axis[1]^.refcomm.riclear:=true;
                      Comm_G6handler(count^.board^.axis[1]);
                    end;
                end (* Latched1 *)
              else
                begin
                  if not(count^.board^.axis[1]^.cstatus.ref) and
                     not(rifound1) then
                    begin
                      count^.board^.axis[1]^.refcomm.rilatch:=true;
                      Comm_G6handler(count^.board^.axis[1]);
                    end;
                end;
            end; (* Ref2 *)

          if count^.count[2]^.refmark=2 then        (* Distance-coded ref. marks *)
            begin
              if (count^.board^.axis[2]^.cstatus.latch1) then
                begin
                  rifound2:=true;
                  Read_Reg1(count^.board^.axis[2]);
                  refmark1:=count^.board^.axis[2]^.register1;

                  if count^.board^.axis[2]^.inimain.interpol=i50fach then
                    begin
                       case count^.board^.axis[2]^.inimain.flankenaw of
                        onefold  : refmark1:=refmark1/50;
                        twofold  : refmark1:=refmark1/100;
                        fourfold : refmark1:=refmark1/200;
                      end;
                    end
                  else
                    begin
                       case count^.board^.axis[2]^.inimain.flankenaw of
                        onefold  : refmark1:=refmark1/25;
                        twofold  : refmark1:=refmark1/50;
                        fourfold : refmark1:=refmark1/100;
                      end;
                    end;

                  if (refmark1>500) then  (* Positive direction *)
                     begin
                       count^.count[2]^.offset:=((refmark1-501)*1000);
                       for i:=1 to 4 do
                       count^.count[2]^.preset[i]:=0;
                     end;
                  if (refmark1<500) and (refmark1>0) then
                     begin
                       count^.count[2]^.offset:=((500-refmark1)*1000)-refmark1;
                       for i:=1 to 4 do
                       count^.count[2]^.preset[i]:=0;
                     end;
                  if (refmark1<-500) then  (* Negative direction *)
                     begin
                       count^.count[2]^.offset:=((-refmark1-501)*1000)-refmark1;
                       for i:=1 to 4 do
                       count^.count[2]^.preset[i]:=0;
                     end;
                  if (refmark1>-500) and (refmark1<0) then
                    begin
                      count^.count[2]^.offset:=((500+refmark1)*1000);
                      for i:=1 to 4 do
                      count^.count[2]^.preset[i]:=0;
                    end;
                  if (refmark1=0) then
                    begin
                      rifound2:=false;
                      count^.board^.axis[2]^.refcomm.ristart:=true;
                      count^.board^.axis[2]^.refcomm.riclear:=true;
                      Comm_G6handler(count^.board^.axis[2]);
                    end;
                end (* Latched1 *)
              else
                begin
                  if not(count^.board^.axis[2]^.cstatus.ref) and
                     not(rifound2) then
                    begin
                      count^.board^.axis[2]^.refcomm.rilatch:=true;
                      Comm_G6handler(count^.board^.axis[2]);
                    end;
                end;
            end; (* Ref2 *)
        end; (* Hardware *)
    end; (* Loop *)

  if count^.printer<>none then
    begin
      (*$I-*)
      close(tfile);
      (*$I+*)
    end;

  for i:=0 to 10 do
    begin
      Dispose(win[i]);
    end;
  Dispose(mwin);
  for i:=0 to 10 do
    begin
      Dispose(hwin[i]);
    end;
  Dispose(hmwin);
  Dispose(winvector);
end;
(*****************************)
end.