/*
   -----------------------------------------------------------------------
   -  DR JOHANNES HEIDENHAIN GmbH, Traunreut, West Germany               -
   -                                                                     -
   -  Headerfile  ik120.h                                                -
   -  for:                                                               -
   -  2 Counter and latch counter                                        -
   -  Interface cards                                                    -
   -  Id.No.:F90 BE 271 208 01                           Date: 12.03.92  -
   -                                                                     -
   -----------------------------------------------------------------------
   -                                                                     -
   -  This is a headerfile intended for inclusion in module ik120.c      -
   -  The header ik120.h must be included in file ik120.c                -
   -                                                                     -
   -----------------------------------------------------------------------
                                                                           */   



/* --------------------------
         Defines
   --------------------------*/


#define  POINTER(seg,off)      ((void far *)((unsigned long)(seg)<<16 | off))



/* --------------------------
         Typedefs
   --------------------------*/


typedef enum   {
                C_start,C_stop,C_reset,C_latch,C_load,C_reset_start,
                C_reset_stop,RI_start,RI_stop,RI_reset,RI_latch,
                RI_reset_start,RI_reset_stop,
                RI_latch_start,RI_latch_stop,RI_latch_reset,
                RI_latch_reset_start,RI_latch_reset_stop,RI_load,
                Strobe_latch} control;
typedef enum   {onefold,twofold,fourfold} eval;
typedef enum   {normal,inverse} direction;
typedef enum   {linear,arc} method;
typedef enum   {I_50,I_25} interpol;
typedef enum   {Internal,ExternalX1,ExternalX2,ExternalX1X2,LatchOut}lcontrol;
typedef enum   {Int_1,Int_0} interr;
typedef enum   {C_0 = 0x00,C_1 = 0x10} counter;
typedef enum   {L_0 = 0x00,L_1 = 0x01} latch;


control     Control;
eval        Eval;
direction   Direction;
method      Method;
interpol    Interpol;
lcontrol    Lcontrol;
interr      Interr;
counter     Counter;
latch       Latch;



/* --------------------------
         Globals
   --------------------------*/


unsigned int boardseg;
unsigned int boardoff;
unsigned int interval;



























