/* #######################################################################
   #                                                                     #
   #                        demohex.c                                    #
   #                                                    Date: 19.03.92   #
   #                                                                     #
   #######################################################################
   #                                                                     #
   # "c"-program for interface IK120                                     #
   #                                                                     #
   #    Functionparameter and variables defined in header ik120.h        #
   #    Functions are defined in module ik120.c                          #
   #                                                                     #
   #       Link and compile:                                             #
   #                 e.g.: cl /AL /Oaxz /G2 /Fc demohex.c ik120.obj      #
   #                                                                     #
   #                                                                     #
   ####################################################################### */



/* -------------------
      INCLUDE
   ------------------- */

#include <stdio.h>
#include <ik120.h>
  

/* -------------------
      GLOBALS
   ------------------- */

unsigned int   boardseg = 0xc800;              /*    Basesadress IK120     */
unsigned int   boardoff = 0;                   /*    Offset boardadress    */
unsigned int   interval = 0;                   /*      Latchvalue          */


extern	void Init_Interface(counter);
extern	void Init_Counter(counter,control,eval,direction,method);
extern	unsigned long Soft_Count(counter,latch);


/*
   ===============================================================
           Simultaneous latching and reading of both axis
   ===============================================================       */

void main ()
{
   
	Init_Interface(C_0);
	Init_Interface(C_1);

printf ("\n\t Counter1\t Counter2\n");
   
   Init_Counter(C_0,C_start,fourfold,normal,linear);
   Init_Counter(C_1,C_start,fourfold,normal,linear);
   
while (!kbhit())

   printf ("\r\t %8lx     \t %8lx",Soft_Count(C_0,L_0),
                                   Soft_Count(C_1,L_0));
}



          






