/* #######################################################################
   #                                                                     #
   #                                                                     #
   #                           demo.c                                    #
   #                                                                     #
   #                                                    Date: 19.03.92   #
   #                                                                     #
   #######################################################################
   #                                                                     #
   # "c"-program for interface IK120                                     #
   #                                                                     #
   #    Functionparameter and variables defined in header ik120.h        #
   #    Functions are defined in module ik120.c                          #
   #                                                                     #
   #       Link and compile:                                             #
   #                   e.g.: cl /AL /Oaxz /G2 /Fc demo.c ik120.obj       #
   #                                                                     #
   ####################################################################### */





/* -------------------
      INCLUDE
   ------------------- */

#include <stdio.h>
#include <float.h>
#include <graph.h>
#include <ik120.h>                             /* Include_File for ik120.c */
  

/* -------------------
      GLOBALS
   ------------------- */

unsigned int   boardseg = 0xc800;              /*    Basesadress IK120     */
unsigned int   boardoff = 0;                   /*    Offset boardadress    */
unsigned int   interval = 1000;                /*      Latchvalue          */

extern	void Init_Interface(counter);
extern   int Signal_Error(counter);
extern	void Init_Counter(counter,control,eval,direction,method);
extern	unsigned long Soft_Count(counter,latch);



/*
   ===============================================================
           Simultaneous latching and reading of both axis
   ===============================================================       */

void main ()
{
   char buffer[30];
   short oldfgd;
   long oldbgd;
   float c_value0,c_value1;

   /* Save original foreground, background. */

   oldfgd = _gettextcolor();
   oldbgd = _getbkcolor();
 
   _clearscreen( _GCLEARSCREEN );
   _setbkcolor(1);
   _settextposition(5,15);
   _settextcolor(15);
   _outtext("    Counter 0      Counter 1   ");                      
   _settextposition(6,15);
   _outtext(" ----------------------------- ");                      

	Init_Interface(C_0);
	Init_Interface(C_1);
   Init_Counter(C_0,C_start,fourfold,normal,linear);
   Init_Counter(C_1,C_start,fourfold,normal,linear);
   
while (!kbhit())
   {
      c_value0 = (float) (signed long) Soft_Count(C_0,L_0) * 0.01 / 200;
      c_value1 = (float) (signed long) Soft_Count(C_1,L_1) * 0.01 / 200;

      _setbkcolor(1);
      _settextposition(7,15);
      sprintf(buffer, " %11.4f    ", c_value0);
      _outtext(buffer);
      _settextposition(7,30);
      sprintf(buffer, " %11.4f    ", c_value1);
      _outtext(buffer);
      if (Signal_Error(C_0) != 0)
         {
         _setbkcolor(4);
         _settextposition(9,15);
         _outtext( "Signalerror_axis1" );
         }
      if (Signal_Error(C_1) != 0)
         {
         _setbkcolor(4);
         _settextposition(10,15);
         _outtext( "Signalerror_axis2" );
         }
   }

   /* Restore original foreground and background. */

   _settextcolor( oldfgd );
   _setbkcolor( oldbgd );
   _settextposition(0,0);
   _clearscreen( _GCLEARSCREEN );

}
