// SampleAppl_VC++_iiddrv30_pro.cpp : Definiert den Einstiegspunkt fr die Anwendung.
//

#include "stdafx.h"
#include "SampleAppl_VC++_iiddrv20.h"
#include "iiddrv20_interface.h"

#define MAX_LOADSTRING 100


// Globale Variablen:
HINSTANCE hInst;								// Aktuelle Instanz
TCHAR szTitle[MAX_LOADSTRING];					// Titelleistentext
TCHAR szWindowClass[MAX_LOADSTRING];			// Klassenname des Hauptfensters

// Vorwrtsdeklarationen der in diesem Codemodul enthaltenen Funktionen:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);


int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
 	// TODO: Hier Code einfgen.
	MSG msg;
	HACCEL hAccelTable;

	// Globale Zeichenfolgen initialisieren
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_SAMPLEAPPL_VC_iiddrv30_pro, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Anwendungsinitialisierung ausfhren:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_SAMPLEAPPL_VC_iiddrv30_pro);

	// Hauptmeldungsschleife:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}



//
//  FUNKTION: MyRegisterClass()
//
//  ZWECK: Registriert die Fensterklasse.
//
//  KOMMENTAR:
//
//    Sie mssen die Funktion zu verwenden, wenn Sie mchten, dass der Code
//    mit Win32-Systemen kompatibel ist, bevor die Funktion 'RegisterClassEx'
//    zu Windows 95 hinzugefgt wurde. Der Aufrud der Funktion ist wichtig,
//    damit die kleinen Symbole, die mit der Anwendung verknpft sind,
//    richtig formatiert werden.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_SAMPLEAPPL_VC_iiddrv30_pro);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCTSTR)IDC_SAMPLEAPPL_VC_iiddrv30_pro;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx(&wcex);
}

//
//   FUNKTION: InitInstance(HANDLE, int)
//
//   ZWECK: Speichert das Instanzenhandle und erstellt das Hauptfenster.
//
//   KOMMENTAR:
//
//        In dieser Funktion wird das Instanzenhandle in einer globalen Variablen gespeichert, und das
//        Hauptprogrammfenster wird erstellt und angezeigt.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // Instanzenhandle in der globalen Variablen speichern

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

//
//  FUNKTION: WndProc(HWND, unsigniert, WORD, LONG)
//
//  ZWECK:  Verarbeitet Meldungen vom Hauptfenster.
//
//  WM_COMMAND	- Verarbeiten des Anwendungsmens
//  WM_PAINT	- Zeichnen des Hauptfensters
//  WM_DESTROY	- Beenden-Meldung anzeigen und zurckgeben
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message) 
	{
	case WM_COMMAND:
		wmId    = LOWORD(wParam); 
		wmEvent = HIWORD(wParam); 
		// Menauswahl bearbeiten:
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		
		//PortType: 0==serial port; 1==CF-port; 2==BT serial port; 4==USB port
		//include Message Handler for MSS added Menu-Items
		case ID_INIT_COM1:
			//set Portselection to port COM1 --> serial
			//and open port
			InitializePort(0,"COM1:");
			break;
		case ID_INIT_COM2:
			//set Portselection to port COM2 --> serial
			//and open port
			InitializePort(0,"COM2:");
			break;
		case ID_INIT_COM3:
			//set Portselection to port COM3 --> serial
			//and open port
			InitializePort(0,"COM3:");
			break;
		case ID_INIT_COM4:
			//set Portselection to port COM4 --> serial
			//and open port
			InitializePort(0,"COM4:");
			break;
		case ID_INIT_COM5:
			//set Portselection to port COM5 --> serial
			//and open port
			InitializePort(0,"COM5:");
			break;
		case ID_INIT_COM6:
			//set Portselection to port COM6 --> serial
			//and open port
			InitializePort(0,"COM6:");
			break;
		case ID_INIT_COM7:
			//set Portselection to port COM7 --> serial
			//and open port
			InitializePort(0,"COM7:");
			break;
		case ID_INIT_USB:
			//set Portselection to port USB --> USB
			//and open port
			InitializePort(4,"USB:");
			break;
		case ID_CLOSEPORT:
			//close initialized port
			ClosePort();
			break;
		case ID_READER_READID:
			//read reader ID
			ReadID();
			break;
		case ID_READUID:
			//read UID from TAG
			ReadUID();
			break;
		case ID_GETTAGPARAMS:
			//get transponder parameters of last identify()
			GetTransponderParameters();
			break;
		case ID_READBYTES:
			//read bytes from TAG
			ReadBytes();
			break;
		case ID_WRITEBYTES:
			//write bytes to TAG
			WriteBytes();
			break;
		case ID_TELID_GETTEMP:
			//read actual temperature from TAG
			GetTemperature();
			break;

		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		// TODO: Fgen Sie hier den Zeichnungscode hinzu...
		EndPaint(hWnd, &ps);
		break;
	case WM_DESTROY:
		//Close port on program termination
		ClosePort();
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Meldungshandler fr Infofeld.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_INITDIALOG:
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}



