unit RegistryRead;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  StdCtrls, Menus, ComCtrls, ExtCtrls, ImgList, Buttons, Dialogs;

procedure GetRegistryPorts(DetectedPorts: PByteArray; Size: Integer);


implementation

uses
  Registry;


//Funktion prft die ComPorts der Registry
//erfordert ein bergabeArray von mind. 255 Elementen Lnge
procedure GetRegistryPorts(DetectedPorts: PByteArray; Size: Integer);
var Registry : TRegistry;
    i        : Integer;
    PortCount: Integer;
    TempPort : Array[0..254]of Byte;
    Res      : String;
    InitTo   : Integer;
    OSVerInfo: TOSVersionInfo;
    Result   : Boolean;
begin
  Registry:=TRegistry.Create;
  PortCount:=0;
  InitTo:=29;
  Result:=true;

  for i:=0 to 254 do TempPort[i]:=0;
  //Init
  for i:=0 to Size-1 do DetectedPorts[i]:=0;

  try
    Registry.RootKey:=HKEY_LOCAL_MACHINE;
    //WinNT,Win2000,WinXP...
    Result:=Registry.OpenKey('SOFTWARE\Microsoft\Windows NT\CurrentVersion\Ports',False);  //False, weil der Schlssel nicht automatisch erstellt werden soll
  except
    //Standardbelegung der Ports, wenn kein Schlssel gefunden
    if Size<=30 then InitTo:=Size-1;
    Result:=false;
    //Registry.Free;
    //exit;
  end;
  //Anmerkung: wird kein Schlssel gefunden--> leerer String
  //           enthlt Schlssel keinen Wert--> Exception
  if Result then
   for i:=1 to 255 do //max. 255 ComPorts
    begin
      try
        Res :=Registry.ReadString(Format('COM%d:',[i]));
        if Res='' then continue //kein Schlssel gefunden, nchster Port
        else
         begin
           //Schlssel ist vorhanden
           TempPort[PortCount]:=i;
           inc(PortCount);
         end;
      except
        //Schlssel ist vorhanden aber leer
        TempPort[PortCount]:=i;
        inc(PortCount);
      end;
    end
  else
  //prfe jetzt nochmal den alten Schlssel fr Win98 etc.
  if PortCount=0 then
   begin
     try
       Registry.RootKey:=HKEY_LOCAL_MACHINE;
       Result:=Registry.OpenKey('Hardware\DeviceMap\SerialComm',False); //False, weil der Schlssel nicht automatisch erstellt werden soll
     except
       //Standardbelegung der Ports, wenn kein Schlssel gefunden
       if Size<=30 then InitTo:=Size-1;
       Result:=false;
     end;
     if Result then
       for i:=1 to 255 do //max. 255 ComPorts
        begin
          try
            Res :=Registry.ReadString(Format('COM%d',[i]));
            if Res='' then continue //kein Schlssel gefunden, nchster Port
            else
             begin
               //Schlssel ist vorhanden
               TempPort[PortCount]:=i;
               inc(PortCount);
             end;
          except
            //Schlssel ist vorhanden aber leer
            TempPort[PortCount]:=i;
            inc(PortCount);
          end;
        end;
     end;
  //Prfe, ob Ports gefunden wurden, wenn nicht dann Standardauswahl
  if not Result then for i:=0 to InitTo do DetectedPorts[i]:=i+1
  else
   begin
     //Prfen, ob Array gro genug
     if Size<PortCount then PortCount:=Size;
     //Portanalyse abgeschlossen, jetzt noch Werte bergeben
     for i:=0 to PortCount-1 do DetectedPorts[i]:=TempPort[i];
   end;
  Registry.Free;
end;

end.
