unit iID3000PRO_Interface;
{----------------------------------------------------------------}
{--Interface-Routinen fr ser. und USB-DLL-FTD2XX.DLL------------}
{----------------------------------------------------------------}
{--8.12.03 - Aufnahme der TELID2-Routinen------------------------}
{--10.6.05 - Modification of DLL Imports to iIDdriver 3000-------}
{----------------------------------------------------------------}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, main;

var Driver_Version_Main, Driver_Version_Sub : Integer;

function Load_Interface_Dll(Port_Type:byte):boolean;   {registriert jeweilige Interface-DLL}
function Register_Interface_Procedures(Port_Type:byte):boolean;  {registriert Prozeduren der Interface-DLL}
procedure GetBuildInfo(filename:string);
function DummyProc(m_HCom:THandle):integer;
function search_interface(m_HCom:THandle;USB_Timer:TTimer;cancelread:PBool):THandle;

type TOpenInterface =function (Port : PChar):THandle; stdcall;
type TCloseInterface = function(m_HCom:Thandle):integer; stdcall;
type TGetPortState = function(m_HCom:THandle):THandle; stdcall;

type TGetDriverVersion = function(ver_main,ver_sub:PInteger):integer; stdcall;

type TReadReaderID = function(m_HCom:Thandle;pid:PInteger;zeiger_data:pbytearray):integer; stdcall;
type TReadE2PROM = function (m_HCom:THandle;address:Byte;param:PByte):integer; stdcall;
type TWriteE2PROM = function (m_HCom:THandle;address:Byte;param:Byte):integer; stdcall;
type TSetRFID = function(m_HCom:THandle; Zeiger:PbyteArray):integer; stdcall;
type TSendTest = function (m_HCom:THandle;param:Byte):integer; stdcall;
type TSetAutoOff = function (m_HCom:THandle;param:Byte):integer; stdcall;
type TLedOn = function (m_HCom:THandle):integer; stdcall;
type TLedOff = function (m_HCom:THandle):integer; stdcall;
type TSleepOn = function (m_HCom:THandle):integer; stdcall;

type TReadRO = function(m_HCom:THandle; Zeiger:PbyteArray):integer; stdcall;
type TWriteRO = function(m_HCom:THandle; Zeiger_Data:PbyteArray;lock:BYTE):integer; stdcall;
type TReadBlock = function(m_HCom:THandle; blockadress:Integer;Zeiger_Data:PbyteArray):integer; stdcall;
type TReadBlockEE = function(m_HCom:THandle; blockadress:Integer;Zeiger_Data:PbyteArray):integer; stdcall;
type TReadBlockEE64 = function(m_HCom:THandle; blockadress:Integer;Zeiger_Data:PbyteArray):integer; stdcall;
type TReadBlockEE128 = function(m_HCom:THandle; blockadress:Integer;Zeiger_Data:PbyteArray):integer; stdcall;
type TWriteBlock = function(m_HCom:THandle; blockadress:Integer;Zeiger_Data:PbyteArray;lock:BYTE):integer; stdcall;
type TWriteBlockEE = function(m_HCom:THandle; blockadress:Integer;Zeiger_Data:PbyteArray):integer; stdcall;
type TWriteBlockEE64 = function(m_HCom:THandle; blockadress:Integer;Zeiger_Data:PbyteArray):integer; stdcall;
type TWriteBlockEE128 = function(m_HCom:THandle; blockadress:Integer;Zeiger_Data:PbyteArray):integer; stdcall;
type TReadIn = function (m_HCom:THandle;param:PByte):integer; stdcall;
type TReadIn2 = function (m_HCom:THandle;param:PByte):integer; stdcall;
type TSetOut = function (m_HCom:THandle;param:Byte):integer; stdcall;
type TWriteConfig = function(m_HCom:THandle; Zeiger_Data:PbyteArray):integer; stdcall;
type TSetOut2 = function (m_HCom:THandle;param:Byte):integer; stdcall;

type TWriteProtectCode = function (m_HCom:THandle;OldPass,NewPass:PbyteArray):integer; stdcall;
type TSetProtection = function (m_HCom:THandle;param:Byte):integer; stdcall;
type TSendProtectCode = function (m_HCom:THandle;Password:PbyteArray):integer; stdcall;

type TReadController = function(m_HCom:THandle; Len_Data:Byte; pSendData, pData:PByteArray):integer; stdcall;
type TWriteController = function(m_HCom:THandle; Len_Data:Byte; pData:PByteArray):integer; stdcall;
type TGetSPI = function(m_HCom:THandle; SensorType,Len_Data:Byte; pData:PByteArray):integer; stdcall;
type TGetTemperatureTELID21x = function(m_HCom:THandle; PTemperaure:PDouble; pData:PByteArray):integer; stdcall;
type TGetDataRDM2 = function(m_HCom:THandle; PRDM:PDouble; pData:PByteArray):integer; stdcall;

//Additional imports from iID driver iID3000
//Imports for most important functions of iID-driver
type Tc_set_port_type = function (porttype:Byte;lpszPortName:String):byte;stdcall;
type Tc_set_interface_type = function (frequency:integer):byte; stdcall;
type Tc_set_timeout = function (newtimeout:integer):byte;stdcall;
type Tc_set_system_mask = function (newmask:integer):byte;stdcall;

type Tc_get_port_state = function (old_handle:THandle):THandle;stdcall;
type Tc_get_handle = function ():THandle;stdcall;

type Tc_initialize = function ():byte;stdcall;
type Tc_terminate = function ():byte; stdcall;
type Tc_identify = function (SerNr:PByteArray):byte;stdcall;
type Tc_readbytes = function (identifier:PByteArray;from:integer;length:integer;read:PByteArray):byte;stdcall;
type Tc_writebytes = function (identifier:PByteArray;from:integer;length:integer;read:PByteArray;lock:byte):byte;stdcall;

var OpenInterface : TOpenInterface;
    closeinterface :TCloseInterface;
    getportstate : TGetPortState;

    c_set_port_type : Tc_set_port_type;
    c_set_interface_type : Tc_set_interface_type;
    c_set_timeout : Tc_set_timeout;
    c_set_system_mask : Tc_set_system_mask;

    c_get_port_state : Tc_get_port_state;
    c_get_handle : Tc_get_handle;

    c_initialize : Tc_initialize;
    c_terminate : Tc_terminate;
    c_identify : Tc_identify;
    c_readbytes : Tc_readbytes;
    c_writebytes : Tc_writebytes;

    getdriverversion : TGetDriverVersion;

    iid3000_reader_read_id :TReadReaderID;
    iid3000_reader_set_rfid : TSetRFID;
    iid3000_reader_send_test : TSendTest;
    iid3000_reader_set_auto_off : TSetAutoOff;
    iid3000_reader_read_e2prom : TReadE2PROM;
    iid3000_reader_write_e2prom : TWriteE2PROM;
    iid3000_reader_led_on : TLedOn;
    iid3000_reader_led_off : TLedOff;
    iid3000_reader_sleep_on : TSleepOn;

    iidl_read_ro :TReadRO;
    iidl_write_ro :TWriteRO;
    iidl_write_config :TWriteConfig;
    iidl_read_in : TReadIn;
    iidl_read_in2 : TReadIn2;
    iidl_set_out : TSetOut;
    iidl_set_out2 : TSetOut2;
    iidl_read_block : TReadBlock;
    iidl_read_block_ee : TReadBlockEE;
    iidl_read_block_ee_64 : TReadBlockEE128;
    iidl_read_block_ee_128 : TReadBlockEE128;
    iidl_write_block : TWriteBlock;
    iidl_write_block_ee : TWriteBlockEE;
    iidl_write_block_ee_64 : TWriteBlockEE128;
    iidl_write_block_ee_128 : TWriteBlockEE128;

    iidl_prog_protect_code : TWriteProtectCode;
    iidl_set_protection : TSetProtection;
    iidl_send_protect_code : TSendProtectCode;

    iidl_read_controller : TReadController;
    iidl_write_controller : TWriteController;
    iidl_get_spi : TGetSPI;

    get_temperature_telid21x : TGetTemperatureTELID21x;
    get_data_rdm2 : TGetDataRDM2;

    Version1,Version2,Version3,Version4 : word;

var Port_library : THandle;

var interface_name : string;
    interface_nr   : integer;       //0=kein, seriell, 100=USB

const    dcb_Binary     = $0001;
         dcb_OutCTSFlow = $0004;
         dcb_OutDSRFlow = $0008;
         dcb_DTRControl1= $0010;
         dcb_DTRControl2= $0020;
         dcb_RTSControl1= $1000;
         dcb_RTSControl2= $2000;
         dcB_DSRSensitivity = $0040;

         DSR_Line = $10;
         CTS_Line = $20;

const    Status_Error : array [$23..$2F] of string =
         ('TAG-Error',
          'No TAG Near Receiver',
          '',
          'Unknown OP-Code',
          '',
          'Error in Protocol',
          'Unknown instruction for TAG',
          'Unknown TAG-error',
          'Error Writing TAG',
          'Error Reading TAG',
          '',
          'Error control-reading TAG',
          'Wrong data during control-reading TAG');
       {---------- Stringarray der StatusFehler des TAGS ----------}

{-------------------------------------------------------------------------------------}
{--Version 1 der jeweiligen DLL laden-------------------------------------------------}
{-------------------------------------------------------------------------------------}
const  DLL_NAME : array[0..20] of char = 'iiddrv30_pro.dll';


implementation

//Dummy-Prozedur fr neu hinzugefgte Routinen
function DummyProc(m_HCom:THandle):integer;
begin
result:=$FF;
end;

{-------------------------------------------------------------------------------------}
{--ldt die DLL und registriert die Bibliothek-Rckgabe true wenn erfolgreich---------}
{-------------------------------------------------------------------------------------}
{--bergabe : Port-type = 0 -> serielles interface------------------------------------}
{-------------------------1--> USB-Interface------------------------------------------}
{-------------------------------------------------------------------------------------}
function Load_interface_Dll(Port_Type:byte):boolean;
var library_name : Pchar;
    buildinfo : string;
begin
result:=false;
library_name:=DLL_NAME;
Port_library:=loadlibrary(library_name);
if Port_library=0 then
                  begin
                  {Interface-DLL konnte nicht geladen werden, meldung}
                  ShowMessage('Library '+library_name+' or component not found!');
                  exit;
                  end;
{jeweilige Interface-DLL konnte registriert werden->Rckgabe Erfolg}
GetBuildInfo(library_name);
result:=true;
end;

{-------------------------------------------------------------------------------------}
{--ldt die DLL und registriert die Bibliothek-Rckgabe true wenn erfolgreich---------}
{-------------------------------------------------------------------------------------}
{--bergabe : Port-type = 0 -> serielles interface------------------------------------}
{-------------------------1--> USB-Interface------------------------------------------}
{-------------------------------------------------------------------------------------}
function register_interface_procedures(Port_Type:byte):boolean;
begin
result:=false;
case port_Type of
              0: begin
                 {serielle und USB Prozeduren fr die Kommunikation laden}
                 @openinterface:=GetProcAddress(port_library,'c_openinterface');
                 @closeinterface:=GetProcAddress(port_library,'c_closeinterface');
                 @getportstate:=GetProcAddress(port_library,'c_get_port_state');

                 @getdriverversion:=GetProcAddress(port_library,'c_get_driver_version');

                 @c_set_port_type:=GetProcAddress(port_library,'c_set_port_type');
                 @c_set_interface_type:=GetProcAddress(port_library,'c_set_interface_type');
                 @c_set_timeout:=GetProcAddress(port_library,'c_set_timeout');
                 @c_set_system_mask:=GetProcAddress(port_library,'c_set_system_mask');

                 @c_get_port_state:=GetProcAddress(port_library,'c_get_port_state');
                 @c_get_handle:=GetProcAddress(port_library,'c_get_handle');

                 @c_initialize:=GetProcAddress(port_library,'c_initialize');
                 @c_terminate:=GetProcAddress(port_library,'c_terminate');
                 @c_identify:=GetProcAddress(port_library,'c_identify');
                 @c_readbytes:=GetProcAddress(port_library,'c_readbytes');
                 @c_writebytes:=GetProcAddress(port_library,'c_writebytes');

                 @iid3000_reader_set_rfid:=GetProcAddress(port_library,'c_reader_set_rfid_iid3000');
                 @iid3000_reader_send_test:=GetProcAddress(port_library,'c_reader_send_test_iid3000');
                 @iid3000_reader_read_id:=GetProcAddress(port_library,'c_read_reader_id_iid3000');
                 @iid3000_reader_led_on:=GetProcAddress(port_library,'c_led_on_iid3000');
                 @iid3000_reader_led_off:=GetProcAddress(port_library,'c_led_off_iid3000');
                 @iid3000_reader_read_e2prom:=GetProcAddress(port_library,'c_read_reader_e2prom_iid3000');
                 @iid3000_reader_write_e2prom:=GetProcAddress(port_library,'c_write_reader_e2prom_iid3000');
                 @iid3000_reader_set_auto_off:=GetProcAddress(port_library,'c_reader_set_auto_off_iid3000');
                 @iid3000_reader_sleep_on:=GetProcAddress(port_library,'c_reader_sleep_on_iid3000');

                 @iidl_write_ro:=GetProcAddress(port_library,'iidl_c_write_ro_code');
                 @iidl_read_ro:=GetProcAddress(port_library,'iidl_c_read_ro_code');
                 @iidl_read_block:=GetProcAddress(port_library,'iidl_c_read_block');
                 @iidl_write_block:=GetProcAddress(port_library,'iidl_c_write_block');
                 @iidl_prog_protect_code:=GetProcAddress(port_library,'iidl_c_prog_protect_code');
                 @iidl_set_protection:=GetProcAddress(port_library,'iidl_c_set_protection');
                 @iidl_send_protect_code:=GetProcAddress(port_library,'iidl_c_send_protect_code');
                 @iidl_write_config:=GetProcAddress(port_library,'iidl_c_write_configuration');

                 @iidl_read_block_ee:=GetProcAddress(port_library,'iidl_c_read_block_ee');
                 @iidl_write_block_ee:=GetProcAddress(port_library,'iidl_c_write_block_ee');
                 @iidl_read_in:=GetProcAddress(port_library,'telid2io_c_read_in');
                 @iidl_set_out:=GetProcAddress(port_library,'telid2io_c_set_out');
                 @iidl_set_out2:=GetProcAddress(port_library,'iidl_c_set_out2');

                 @iidl_read_block_ee_64:=GetProcAddress(port_library,'iidl_c_read_block_ee_64');
                 @iidl_write_block_ee_64:=GetProcAddress(port_library,'iidl_c_write_block_ee_64');

                 @iidl_read_block_ee_128:=GetProcAddress(port_library,'iidl_c_read_block_ee_128');
                 @iidl_write_block_ee_128:=GetProcAddress(port_library,'iidl_c_write_block_ee_128');

                 @iidl_read_controller:=GetProcAddress(port_library,'iidl_c_read_i2c_1');
                 @iidl_write_controller:=GetProcAddress(port_library,'iidl_c_write_i2c_1');

                 @iidl_get_spi:=GetProcAddress(port_library,'iidl_c_get_spi_0');

                 @get_temperature_telid21x:=GetProcAddress(port_library,'c_get_temperature_telid21x');
                 @get_data_rdm2:=GetProcAddress(port_library,'c_get_data_rdm2');
                 @iidl_read_in2:=GetProcAddress(port_library,'iidl_c_read_in2');
                 end;
              else
              begin
              ShowMessage('Port-library not defined-aborting program!');
              exit;
              end;
     end;
result:=true;
end;

procedure GetBuildInfo(filename:string );
var
  VerInfoSize: DWord;
  VerInfo: Pointer;
  VerValueSize: DWord;
  VerValue: PVSFixedFileInfo;
  Dummy: DWord;
begin
  VerInfoSize := GetFileVersionInfoSize( PChar( filename ), dummy );
  if verinfosize=0 then
     begin
     //keine Versionsinformation in Datei vorhanden
     //smtliche Versionen auf 0 setzen
     version1 := 0;version2 := 0;version3 := 0;version4 := 0;
     end
     else
     begin
     //Versionsinformation in DLL vorhanden
     GetMem( VerInfo, VerInfoSize );
     GetFileVersionInfo( PChar( filename ), 0, VerInfoSize, VerInfo );
     VerQueryValue( VerInfo, '\', Pointer( VerValue ), VerValueSize );
     with VerValue^ do
          begin
          version1 := dwFileVersionMS shr 16;
          version2 := dwFileVersionMS and $FFFF;
          version3 := dwFileVersionLS shr 16;
          version4 := dwFileVersionLS and $FFFF;
          end;
     FreeMem( VerInfo, VerInfoSize );
     end;
end;

//----------------------------------------------------------------------------
//---Funktion durchsucht die Ports nach angeschlossenem Interface-------------
//----------------------------------------------------------------------------
function search_interface(m_HCom:THandle;USB_Timer:TTimer;cancelread:PBool):THandle;
var library_name : Pchar;
    buildinfo : string;
    i, ergeb, pid : integer;
    pidarray : array[0..12] of byte;
    serialport : integer;
begin
result:=INVALID_HANDLE_VALUE;
exit;
end;

end.
