UNIT Poti_0;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Driver Unit for Electronic Pots                       }
{                                                       }
{ V 1.00                                                }
{ Okt 1997                                              }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

interface

uses crt,graph,cnt_0,IK410_0,IK410_1,IK410_2;

procedure turnpotis(board:IK410_pointr);

Implementation
(*________________________________________*)
procedure potiheader;
begin
  SetFillpattern(schw,3);
  bar(1,1,getmaxx,getmaxy);

  ctext3d(20,20,'DR. JOHANNES HEIDENHAIN GmbH',8,14);
  ctext3d(300,20,'EEPROM Potentiometer Adjustment',8,14);

  ctext3d(50,350,'+ : Increment',8,15);
  ctext3d(50,365,'- : Decrement',8,15);
  ctext3d(50,380,'> : Maximum',8,15);
  ctext3d(50,395,'< : Minimum',8,15);
  ctext3d(350,350,'n : Neutral',8,15);
  ctext3d(350,365,'s : Store Values',8,15);

  ctext3d(350,390,'q : Quit',8,15);

  text3d(20,50,'Phase axis 1');
  ctext3d(40,70,'A',8,14);
  text3d(170,50,'Ampl. axis 1');
  ctext3d(190,70,'B',8,15);

  text3d(20,200,'Off DG00 axis 1');
  ctext3d(40,220,'E',8,15);
  text3d(170,200,'Off DG90 axis 1');
  ctext3d(190,220,'F',8,15);

  digit(60,70);
  digit(210,70);
  digit(60,220);
  digit(210,220);

  uhr(50,130);
  uhr(200,130);
  uhr(50,280);
  uhr(200,280);

  ctext3d(100,110,'-',8,15);
  ctext3d(100,123,'.',8,15);
  ctext3d(100,140,'+',8,15);

  ctext3d(250,110,'-',8,15);
  ctext3d(250,123,'.',8,15);
  ctext3d(250,140,'+',8,15);

  ctext3d(100,260,'-',8,15);
  ctext3d(100,273,'.',8,15);
  ctext3d(100,290,'+',8,15);

  ctext3d(250,260,'-',8,15);
  ctext3d(250,273,'.',8,15);
  ctext3d(250,290,'+',8,15);

end;
(*________________________________________*)
procedure show_poti(board:IK410_pointr;nummer,color:byte);
var
  p : byte;
  error : boolean;
begin
  error:=false;

  case nummer of
    1 : begin
          p:=Read_phasepoti(board,error);
          digitpos(60,70,p,color);
          uhrpos(50,130,(p-31)*4,color);
        end;
    2 : begin
          p:=Read_sympoti(board,error);
          digitpos(210,70,p,color);
          uhrpos(200,130,(p-31)*4,color);
        end;
    5 : begin
          p:=(board^.offset00 div 2)+31;
          digitpos(60,220,p,color);
          uhrpos(50,280,(p-31)*4,color);
        end;
    6 : begin
          p:=(board^.offset90 div 2)+31;
          digitpos(210,220,p,color);
          uhrpos(200,280,(p-31)*4,color);
        end;
    end;
end;
(*________________________________________*)
procedure turnpotis(board:IK410_pointr);
var
  eing       : char;
  error,ende : boolean;
  poti_nr  : byte;

begin
  potiheader;
  show_poti(board,1,9);
  show_poti(board,2,9);
  show_poti(board,3,9);
  show_poti(board,4,9);
  show_poti(board,5,9);
  show_poti(board,6,9);
  show_poti(board,7,9);
  show_poti(board,8,9);

  poti_nr:=1;
  eing:=#32;
  ende:=false;


    while not ende do
    begin
      if keypressed then eing:=readkey;
      case eing of
        'q' : begin
                ende:=true;
              end;
        's' : begin
                ctext3d(350,365,'s : Store values',8,14);
                error:=false;
                store_offset(board,error);
                store_potis(board,error);
                ctext3d(350,365,'s : Store values',8,15);
              end;
        'a' : begin
                ctext3d(40,70,'A',8,14);
                ctext3d(190,70,'B',8,15);
                ctext3d(340,70,'C',8,15);
                ctext3d(490,70,'D',8,15);
                ctext3d(40,220,'E',8,15);
                ctext3d(190,220,'F',8,15);
                ctext3d(340,220,'G',8,15);
                ctext3d(490,220,'H',8,15);
                poti_nr:=1;
                eing:=#32;
              end;
        'b' : begin
                ctext3d(40,70,'A',8,15);
                ctext3d(190,70,'B',8,14);
                ctext3d(340,70,'C',8,15);
                ctext3d(490,70,'D',8,15);
                ctext3d(40,220,'E',8,15);
                ctext3d(190,220,'F',8,15);
                ctext3d(340,220,'G',8,15);
                ctext3d(490,220,'H',8,15);
                poti_nr:=2;
                eing:=#32;
              end;
        'c' : begin
                ctext3d(40,70,'A',8,15);
                ctext3d(190,70,'B',8,15);
                ctext3d(340,70,'C',8,14);
                ctext3d(490,70,'D',8,15);
                ctext3d(40,220,'E',8,15);
                ctext3d(190,220,'F',8,15);
                ctext3d(340,220,'G',8,15);
                ctext3d(490,220,'H',8,15);
                poti_nr:=3;
                eing:=#32;
              end;
        'd' : begin
                ctext3d(40,70,'A',8,15);
                ctext3d(190,70,'B',8,15);
                ctext3d(340,70,'C',8,15);
                ctext3d(490,70,'D',8,14);
                ctext3d(40,220,'E',8,15);
                ctext3d(190,220,'F',8,15);
                ctext3d(340,220,'G',8,15);
                ctext3d(490,220,'H',8,15);
                poti_nr:=4;
                eing:=#32;
              end;
        'e' : begin
                ctext3d(40,70,'A',8,15);
                ctext3d(190,70,'B',8,15);
                ctext3d(340,70,'C',8,15);
                ctext3d(490,70,'D',8,15);
                ctext3d(40,220,'E',8,14);
                ctext3d(190,220,'F',8,15);
                ctext3d(340,220,'G',8,15);
                ctext3d(490,220,'H',8,15);
                poti_nr:=5;
                eing:=#32;
              end;
        'f' : begin
                ctext3d(40,70,'A',8,15);
                ctext3d(190,70,'B',8,15);
                ctext3d(340,70,'C',8,15);
                ctext3d(490,70,'D',8,15);
                ctext3d(40,220,'E',8,15);
                ctext3d(190,220,'F',8,14);
                ctext3d(340,220,'G',8,15);
                ctext3d(490,220,'H',8,15);
                poti_nr:=6;
                eing:=#32;
              end;
        'g' : begin
                ctext3d(40,70,'A',8,15);
                ctext3d(190,70,'B',8,15);
                ctext3d(340,70,'C',8,15);
                ctext3d(490,70,'D',8,15);
                ctext3d(40,220,'E',8,15);
                ctext3d(190,220,'F',8,15);
                ctext3d(340,220,'G',8,14);
                ctext3d(490,220,'H',8,15);
                poti_nr:=7;
                eing:=#32;
              end;
        'h' : begin
                ctext3d(40,70,'A',8,15);
                ctext3d(190,70,'B',8,15);
                ctext3d(340,70,'C',8,15);
                ctext3d(490,70,'D',8,15);
                ctext3d(40,220,'E',8,15);
                ctext3d(190,220,'F',8,15);
                ctext3d(340,220,'G',8,15);
                ctext3d(490,220,'H',8,14);
                poti_nr:=8;
                eing:=#32;
              end;
        '+' : begin
                error:=false;
                ctext3d(50,350,'+ : Increment',8,14);
                show_poti(board,poti_nr,7);
                case poti_nr of
                  1: turn_phasepoti(board,1,true,error);
                  2: turn_sympoti(board,1,true,error);
                  5: turn_offsetdg00(board,1,true);
                  6: turn_offsetdg90(board,1,true);
                end;
                show_poti(board,poti_nr,9);
                ctext3d(50,350,'+ : Increment',8,15);
                eing:=#32;
              end;
        '-' : begin
                error:=false;
                ctext3d(50,365,'- : Decrement',8,14);
                show_poti(board,poti_nr,7);
                case poti_nr of
                  1: turn_phasepoti(board,1,false,error);
                  2: turn_sympoti(board,1,false,error);
                  5: turn_offsetdg00(board,1,false);
                  6: turn_offsetdg90(board,1,false);
                end;
                show_poti(board,poti_nr,9);
                ctext3d(50,365,'- : Decrement',8,15);
                eing:=#32;
              end;
        '>' : begin
                error:=false;
                ctext3d(50,380,'> : Maximum',8,14);
                show_poti(board,poti_nr,7);
                case poti_nr of
                  1: write_phasepoti(board,63,error);
                  2: write_sympoti(board,63,error);
                  5: write_offset00(board,63);
                  6: write_offset90(board,63);
                end;
                show_poti(board,poti_nr,9);
                ctext3d(50,380,'> : Maximum',8,15);
                eing:=#32;
              end;
        '<' : begin
                error:=false;
                ctext3d(50,395,'< : Minimum',8,14);
                show_poti(board,poti_nr,7);
                case poti_nr of
                  1: write_phasepoti(board,0,error);
                  2: write_sympoti(board,0,error);
                  5: write_offset00(board,-63);
                  6: write_offset90(board,-63);
                end;
                show_poti(board,poti_nr,9);
                ctext3d(50,395,'< : Minimum',8,15);
                eing:=#32;
              end;
        'n' : begin
                error:=false;
                ctext3d(350,350,'n : Neutral',8,14);
                show_poti(board,poti_nr,7);
                case poti_nr of
                  1: write_phasepoti(board,31,error);
                  2: write_sympoti(board,31,error);
                  5: write_offset00(board,0);
                  6: write_offset90(board,0);
                end;
                show_poti(board,poti_nr,9);
                ctext3d(350,350,'n : Neutral',8,15);
                eing:=#32;
              end;
      end;
      eing:=#32;
    end;
end;
(*________________________________________*)
END. {unit}
