UNIT IK410_2;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Driver Unit for ADJUST.EXE, POTIS.EXE and SCOPE.EXE   }
{                                                       }
{ V 1.00                                                }
{ Okt 1997                                              }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

interface

uses graph,IK410_0,IK410_1;

type
   single_pointr = ^singleshot;
   singleshot = record
                  dg00 : word;
                  dg90 : word;
                  intp : word;
                  next : single_pointr;
                end;

procedure init_analyze(board:IK410_pointr);
procedure get_single(axis:IK410_pointr;var samp : single_pointr);
procedure build_sample(var samp:single_pointr);
procedure get_sample(axis:IK410_pointr;samp:single_pointr);
procedure free_sample(samp:single_pointr);

Implementation
{----------------------------------------------------------}
procedure init_analyze(board:IK410_pointr);
BEGIN

  board^.timer:=$00FF;
  board^.inimain.mode1024:=true;
  board^.inimain.en_timer:=true;
  board^.inilatch.en_timer_reg1:=true;
  board^.softcomm.start:=true;
  board^.softcomm.clear:=true;
  board^.softcomm.clrfreq:=true;
  board^.softcomm.clrstat:=true;

  Init_Handler(board);
  Comm_Handler(board);
END;
{----------------------------------------------------------}
procedure get_single(axis:IK410_pointr;var samp : single_pointr);
var
  wert : word;
  dummy : word;
BEGIN
  repeat
  until ((read_counter(axis^.baseadr,14) and $0002)=$0002);
  samp^.dg00:=read_counter(axis^.baseadr,22);
  samp^.dg90:=read_counter(axis^.baseadr,24);
  wert:=read_counter(axis^.baseadr,6);
  dummy:=read_counter(axis^.baseadr,8);
  dummy:=read_counter(axis^.baseadr,10);
  samp^.intp:=wert and $03FF;
END;
{----------------------------------------------------------}
procedure build_sample(var samp:single_pointr);
var
  buffer1,buffer2 : single_pointr;
  i               : byte;
begin
  New(buffer1);
  samp:=buffer1;
  for i:=0 to 128 do
    begin
      new(buffer2);
      buffer1^.next:=buffer2;
      buffer1:=buffer2;
    end;
  buffer1^.next:=nil;
end;
{----------------------------------------------------------}
procedure get_sample(axis:IK410_pointr;samp:single_pointr);
var
  buffer : single_pointr;
begin
  buffer:=samp;
  get_single(axis,buffer);  (* Old value *)
  get_single(axis,buffer);
  while buffer^.next<>nil do
    begin
      buffer:=buffer^.next;
      get_single(axis,buffer);
    end;
end;
{----------------------------------------------------------}
procedure free_sample(samp:single_pointr);
var
  buffer0,buffer1 : single_pointr;
begin
  buffer0:=samp;
  while buffer0^.next<>nil do
    begin
      buffer1:=buffer0^.next;
      Dispose(buffer0);
      buffer0:=buffer1;
    end;
  Dispose(buffer0);
end;
(*________________________________________*)
END. {unit}
