UNIT CNT_1;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Display Unit for Counter Program                      }
{                                                       }
{ V 1.00                                                }
{ Okt 1997                                              }
{-------------------------------------------------------}

{$N+,E+}
{$V+}
{$R+}

interface

uses graph,IK410_1;

const
   Gray50  : Fillpatterntype = ($AA,$AA,$AA,$AA,
                                $AA,$AA,$AA,$AA);

TYPE

   device = (druck_lpt1,druck_lpt2,druck_file,none);

   axis_pointr   = ^axis_record;
   axis_record   = record
                     position      : real;    (* mm *)
                     position_new  : array[1..14] of char;
                     position_old  : array[1..14] of char;
                     wintext       : string[1];
                     win_xpos      : word;
                     win_ypos      : word;
                     digits        : byte;
                     dimension     : byte;
                     preset        : array[1..4] of real;
                     offset        : comp;
                     min           : real;
                     max           : real;
                     mode          : (min,max,pos);
                     lbound        : real;
                     hbound        : real;
                     periode       : word;
                     refmark       : byte;
                     resolution    : word;
                  end;

   count_pointr = ^count_record;
   count_record = record
                    board   : IK410_pointr;
                    count   : axis_pointr;
                    printer : device;
                  end;
   countstore   = record
                    count   : axis_record;
                    printer : device;
                  end;

PROCEDURE count_back(pointr:axis_pointr);
PROCEDURE count_display(pointr:axis_pointr);
PROCEDURE status_back(pointr:axis_pointr);
PROCEDURE status_display(pointr1:ik410_pointr;pointr0:axis_pointr);
PROCEDURE Build_Countwert(pointr0:ik410_pointr;pointr1:axis_pointr);
PROCEDURE setup_count(count:count_pointr);
PROCEDURE Write_Count(count:count_pointr);
PROCEDURE Read_Count(count:count_pointr);
(******************************************************************)
implementation
(******************************************************************)
PROCEDURE count_back(pointr:axis_pointr);
  VAR
    x,y : word;
  BEGIN

     (* Numbers *)
  x:=pointr^.win_xpos;
  y:=pointr^.win_ypos;

  setfillstyle(1,1);
  bar(x+43,y+3,x+463,y+53);
  setfillstyle(1,15);
  bar(x+40,y,x+460,y+50);
  setcolor(2);
  rectangle(x+40,y,x+460,y+50);

     (* Designation of axes *)

  setfillstyle(1,1);
  bar(x+3,y+3,x+33,y+53);
  setfillstyle(1,15);
  bar(x,y,x+33,y+50);
  rectangle(x,y,x+33,y+50);
  setcolor(4);
  settextstyle(0,0,3);
  moveto(x+7,y+17);
  setcolor(7);
  outtext(pointr^.wintext);
  moveto(x+5,y+15);
  setcolor(4);
  outtext(pointr^.wintext);

  (* Decimal point *)

  setcolor(7);
  x:=(pointr^.win_xpos+15)+((14-pointr^.digits)*30)+17;
  y:=pointr^.win_ypos+22;
  outtextxy(x,y,'.');

  setcolor(4);
  x:=(pointr^.win_xpos+15)+((14-pointr^.digits)*30)+15;
  y:=pointr^.win_ypos+20;
  outtextxy(x,y,'.');

  (* After 3 digits a decimal point *)

  if pointr^.digits>3 then
    begin
      setcolor(7);
      x:=(pointr^.win_xpos+15)+((14-pointr^.digits+3)*30)+17;
      y:=pointr^.win_ypos+22;
      outtextxy(x,y,'.');
      setcolor(4);
      x:=(pointr^.win_xpos+15)+((14-pointr^.digits+3)*30)+15;
      y:=pointr^.win_ypos+20;
      outtextxy(x,y,'.');
    end;
end;
(**********************************************************)
PROCEDURE count_display(pointr:axis_pointr);
VAR
  i               : byte;
  xpos,ypos       : word;

BEGIN
     ypos:=pointr^.win_ypos+15;
     settextstyle(0,0,3);
     For i:=1 to 14 do
        begin
          if pointr^.position_new[i]<>pointr^.position_old[i] then
            begin
              xpos:=(pointr^.win_xpos+15)+(i*30);
              setcolor(15);
              outtextxy(xpos,ypos,pointr^.position_old[i]);
              outtextxy(xpos+2,ypos+2,pointr^.position_old[i]);
              setcolor(7);
              outtextxy(xpos+2,ypos+2,pointr^.position_new[i]);
              setcolor(4);
              outtextxy(xpos,ypos,pointr^.position_new[i]);
            end;
        end;

END;
(******************************************************************)
PROCEDURE Draw_Button(x,y :word;text:string);

BEGIN
  x:=x+475;
  setfillstyle(1,7);
  bar(x,y,x+55,y+12);
  setcolor(4);
  rectangle(x,y,x+55,y+15);
  setcolor(8);
  line(x+1,y+14,x+54,y+14);
  line(x+2,y+13,x+53,y+13);
  line(x+54,y+1,x+54,y+14);
  line(x+53,y+2,x+53,y+13);
  setcolor(15);
  line(x+1,y+1,x+54,y+1);
  line(x+2,y+2,x+53,y+2);
  line(x+1,y+1,x+1,y+14);
  line(x+2,y+2,x+2,y+13);
  SetTextStyle(1,0,1);
  setcolor(8);
  outtextxy(x+5,y+4,text);
END;
(******************************************************************)
PROCEDURE Push_Button(x,y :word;text:string);
BEGIN
  x:=x+475;
  setcolor(15);
  line(x+1,y+14,x+54,y+14);
  line(x+2,y+13,x+53,y+13);
  line(x+54,y+1,x+54,y+14);
  line(x+53,y+2,x+53,y+13);
  setcolor(8);
  line(x+1,y+1,x+54,y+1);
  line(x+2,y+2,x+53,y+2);
  line(x+1,y+1,x+1,y+14);
  line(x+2,y+2,x+2,y+13);
  SetTextStyle(1,0,1);
  setcolor(14);
  outtextxy(x+5,y+4,text);
END;
(******************************************************************)
PROCEDURE Pop_Button(x,y :word;text:string);
BEGIN
  x:=x+475;
  setcolor(8);
  line(x+1,y+14,x+54,y+14);
  line(x+2,y+13,x+53,y+13);
  line(x+54,y+1,x+54,y+14);
  line(x+53,y+2,x+53,y+13);
  setcolor(15);
  line(x+1,y+1,x+54,y+1);
  line(x+2,y+2,x+53,y+2);
  line(x+1,y+1,x+1,y+14);
  line(x+2,y+2,x+2,y+13);
  SetTextStyle(1,0,1);
  setcolor(8);
  outtextxy(x+5,y+4,text);
END;
(******************************************************************)
PROCEDURE status_back(pointr:axis_pointr);
VAR
  xpos,ypos : word;
BEGIN
  Draw_Button(pointr^.win_xpos,pointr^.win_ypos,'Signal');
  Draw_Button(pointr^.win_xpos,pointr^.win_ypos+15,'Ref');
  Draw_Button(pointr^.win_xpos,pointr^.win_ypos+30,'<');
  Draw_Button(pointr^.win_xpos+60,pointr^.win_ypos+30,'>');
END;
(******************************************************************)
PROCEDURE status_display(pointr1:ik410_pointr;pointr0:axis_pointr);
VAR
  xpos,ypos       : word;
BEGIN
  xpos:=pointr0^.win_xpos+475;
  ypos:=pointr0^.win_ypos;

  if (pointr1^.cstatus.error_freq) or (pointr1^.sstatus.amp_act=$03) then
    begin
      Push_Button(pointr0^.win_xpos,pointr0^.win_ypos,'Signal');
    end
  else
    begin
      Pop_Button(pointr0^.win_xpos,pointr0^.win_ypos,'Signal');
    end;

  if (pointr1^.cstatus.ref_activ) then
    begin
      Push_Button(pointr0^.win_xpos,pointr0^.win_ypos+15,'Ref');
    end
  else
    begin
      Pop_Button(pointr0^.win_xpos,pointr0^.win_ypos+15,'Ref');
    end;

  if (pointr0^.position<pointr0^.lbound) then
    begin
      Push_Button(pointr0^.win_xpos,pointr0^.win_ypos+30,'<');
    end
  else
    begin
      Pop_Button(pointr0^.win_xpos,pointr0^.win_ypos+30,'<');
    end;

  if (pointr0^.position>pointr0^.hbound) then
    begin
      Push_Button(pointr0^.win_xpos+60,pointr0^.win_ypos+30,'>');
    end
  else
    begin
      Pop_Button(pointr0^.win_xpos+60,pointr0^.win_ypos+30,'>');
    end;

END;
(******************************************************************)
PROCEDURE Build_Countwert(pointr0:ik410_pointr;pointr1:axis_pointr);
  VAR
    counter  : comp;
    i,a,b    : byte;
    cx       : string[14];
    wert     : real;
    sign     : boolean;
BEGIN
      (* Convert increments to mm *)

      if pointr0^.inimain.mode1024 then
        begin
          counter:=pointr0^.register0+(pointr1^.offset*1024);
          wert:=0.001*counter*pointr1^.periode/1024;
        end
      else
        begin
          counter:=pointr0^.register0+pointr1^.offset;
          if (pointr0^.inimain.onefold) then
            begin
              wert:=0.001*counter*pointr1^.periode;
            end;
          if (pointr0^.inimain.twofold) then
            begin
              wert:=0.001*counter*(pointr1^.periode/2);
            end;
         if (pointr0^.inimain.fourfold) then
            begin
              wert:=0.001*counter*(pointr1^.periode/4);
            end;
        end;

      wert:=wert*1000000;  (* mm -> nm *)
      wert:=wert/pointr1^.resolution;
      wert:=int(wert);
      wert:=wert*pointr1^.resolution;
      wert:=wert/1000000;  (* nm -> mm *)

      pointr1^.position:=wert+pointr1^.preset[pointr1^.dimension];

      if pointr1^.position<pointr1^.min then pointr1^.min:=pointr1^.position;
      if pointr1^.position>pointr1^.max then pointr1^.max:=pointr1^.position;

      case pointr1^.mode of
        min : pointr1^.position:=pointr1^.min;
        max : pointr1^.position:=pointr1^.max;
      end;

      (* Generate characters *)

      wert:=pointr1^.position;

      (* Clear buffer: 14 digits *)
      For i:=1 to 14 do
        begin
          cx[i]:=' ';
        end;

      (* Get algebraic sign *)

      sign:=true;
      if wert<0 then
        begin
          wert:=abs(wert);
          sign:=false;
        end;

      a:=14-pointr1^.digits;
      b:=pointr1^.digits;
      (* Convert string *)
      str(wert:a:b,cx);

      (* Shift right *)

      While cx[14]=' ' do
        begin
          For i:=14 downto 2 do
            begin
              cx[i]:=cx[i-1];
            end;
          cx[1]:=' ';
        end;

      (* Remove decimal point *)

      For i:=a downto 2 do
        begin
          cx[i]:=cx[i-1];
        end;
      cx[1]:=' ';

      if sign then cx[1]:='+' else cx[1]:='-';

      For i:=1 to 14 do
        begin
          pointr1^.position_old[i]:=pointr1^.position_new[i];
          pointr1^.position_new[i]:=cx[i];
        end;
END;
(******************************************************************)
PROCEDURE setup_count(count:count_pointr);
VAR
  i : byte;
BEGIN

    count^.count^.wintext:='X';
    count^.count^.win_xpos:=25;
    count^.count^.win_ypos:=280;

    count^.count^.position:=0;
    count^.count^.position_new:='              ';
    count^.count^.position_old:='--------------';
    count^.count^.digits:=5;
    count^.count^.dimension:=1;
    count^.count^.preset[1]:=0;
    count^.count^.preset[2]:=0;
    count^.count^.preset[3]:=0;
    count^.count^.preset[4]:=0;
    count^.count^.offset:=0;
    count^.count^.min:=1000000;
    count^.count^.max:=-1000000;
    count^.count^.mode:=pos;
    count^.count^.lbound:=-5;
    count^.count^.hbound:=5;
    count^.count^.periode:=10;
    count^.count^.refmark:=0;
    count^.count^.resolution:=1;

    count^.printer:=none;
END;
(******************************************************************)
PROCEDURE Write_Count(count:count_pointr);
VAR
  initfile        : file of countstore;
  buffer          : countstore;
BEGIN
  Assign(initfile,'IK410.CNT');
  (*$I-*)
  Rewrite(initfile);
  (*$I+*)
  if ioresult=0 then
    begin
      buffer.count:=count^.count^;
      buffer.printer:=count^.printer;
      write(initfile,buffer);
      close(initfile);
    end;
END;
(******************************************************************)
PROCEDURE Read_Count(count:count_pointr);
VAR
  initfile          : file of countstore;
  buffer            : countstore;
  nofile            : boolean;
BEGIN
  setup_count(count);
  nofile:=true;
  Assign(initfile,'IK410.CNT');
  (*$I-*)
  Reset(initfile);
  (*$I+*)
  if ioresult=0 then
    begin
      (*$I-*)
      read(initfile,buffer);
      (*$I+*)
      if ioresult=0 then
        begin
          count^.count^.digits:=buffer.count.digits;
          count^.count^.min:=buffer.count.min;
          count^.count^.max:=buffer.count.max;
          count^.count^.mode:=buffer.count.mode;
          count^.count^.lbound:=buffer.count.lbound;
          count^.count^.hbound:=buffer.count.hbound;
          count^.count^.periode:=buffer.count.periode;
          count^.count^.refmark:=buffer.count.refmark;
          count^.count^.resolution:=buffer.count.resolution;
          (* V1.02 *)
          count^.count^.preset[1]:=buffer.count.preset[1];
          count^.count^.preset[2]:=buffer.count.preset[2];
          count^.count^.preset[3]:=buffer.count.preset[3];
          count^.count^.preset[4]:=buffer.count.preset[4];
          count^.count^.lbound:=buffer.count.lbound;
          count^.count^.hbound:=buffer.count.hbound;

          count^.printer:=buffer.printer;
          nofile:=false;
        end;
      close(initfile);
    end;
  if nofile then
    begin
      write_count(count);
    end;
END;
(******************************************************************)
(******************************************************************)
end.