UNIT adj_0;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Driver Unit for Adjust                                }
{                                                       }
{ V 1.00                                                }
{ Okt 1997                                              }
{-------------------------------------------------------}

{$N+,E+}
{$V+}
{$R+}

interface

uses crt,graph,cnt_0,IK410_0,IK410_1,IK410_2;

procedure adj(board:IK410_pointr);

Implementation
(*________________________________________*)
procedure adjustheader;
begin
  setbkcolor(9);
  setcolor(1);
  rectangle(2,2,636,346);
  setcolor(15);
  rectangle(4,4,632,342);
  setfillstyle(1,15);
  bar(10,10,626,40);
  setcolor(1);
  rectangle(10,10,626,40);
  settextstyle(0,0,2);
  setcolor(8);
  outtextxy(20,15,'Adjust');
  outtextxy(200,15,'Axis 1');
  settextstyle(0,0,1);
  outtextxy(350,15,'Turn encoder slowly');
  text3d(20,300,'q : Quit');
  text3d(270,310,'s : Store Settings');
  text3d(450,300,'o : Adj. Offset');
  text3d(450,315,'a : Adj. Amp.');
  text3d(450,330,'p : Adj. Phase');
  setcolor(1);
  moveto(100,58);
  lineto(100,250);
  moveto(162,58);
  lineto(162,250);
  moveto(225,58);
  lineto(225,250);
  moveto(287,58);
  lineto(287,250);
  moveto(350,58);
  lineto(350,250);
  moveto(412,58);
  lineto(412,250);
  moveto(475,58);
  lineto(475,250);
  moveto(537,58);
  lineto(537,250);
  moveto(600,58);
  lineto(600,250);

  scale(100,50,'%');
  scale(20,90,'lsb');

  text3d(100,130,'0%');
  text3d(225,130,'25%');
  text3d(350,130,'50%');
  text3d(475,130,'75%');
  text3d(580,130,'100%');

  scale(20,170,'%');
  scale(180,200,'');
  scale(20,230,'');

  text3d(20,60,'DG00');
  text3d(20,75,'DG90');

  text3d(20,100,'Off. DG00');
  text3d(20,115,'Off. DG90');

  text3d(20,140,'Amp. DG00');
  text3d(20,155,'Amp. DG90');

  text3d(20,180,'delta Amp');

  text3d(20,210,'Phase');
  text3d(20,240,'delta Ph.');

  balken(100,60);
  balken(100,75);
  balken(100,100);
  balken(100,115);
  balken(100,140);
  balken(100,155);
  balken(100,180);

  balken(100,210);
  balken(100,240);

end;
(*________________________________________*)
procedure calc0(    x,y,
                    minx,maxx,
                    miny,maxy:integer;
                var offx,offy,
                    ampx,ampy,ampdiff,
                    phi,dphi:integer);
var
  m,o,xpos,ypos               : real;
begin

(* x : -511 <-> +511 *)

(* Calculate Offset *)
      (* Mittelwert der Spitze-Spitze Werte *)
      offx:=maxx+minx;
      offy:=maxy+miny;

(* Calculate amplitude *)
      (* Amplitude 0 - 1023 *)
      ampx:=maxx-minx;
      ampy:=maxy-miny;

(* Calculate the difference of the amplitudes *)
      ampdiff:=ampx-ampy;

(* Calculate phase *)
      (* Standardise amplitude X to -1 <-> +1 *)
      if ampx>0 then
        begin
          m:=(2*x/ampx);
        end
      else
        begin
          if x>0 then m:=0.999 else m:=-0.999;
        end;
      if m>1 then m:=1;
      if m<-1 then m:=-1;

      (* ARCSIN of the standardised amplitude *)
      o:=sqrt(1-(m*m));
      if o=0 then o:=10000 else o:=m/o;
      xpos:=arctan(o);

      (* Standardise amplitude Y to -1 <-> +1 *)
      if ampy>0 then
        begin
          m:=(2*y/ampy);
        end
      else
        begin
          if y>0 then m:=0.999 else m:=-0.999;
        end;
      if m>1 then m:=1;
      if m<-1 then m:=-1;

      (* ARCSIN of the standardised amplitude *)
      o:=sqrt(1-(m*m));
      if o=0 then o:=10000 else o:=m/o;
      ypos:=arctan(o);

      (* Calculation only valid in the first quadrant *)
      if (xpos>0.1) and (xpos<0.9) and (ypos>-0.9) and (ypos<-0.1) then
        begin
          phi:=round((xpos-ypos)*360/(2*pi));
        end;

      (* Difference of phases *)
      dphi:=90-phi;
end;
(*________________________________________*)
procedure correct_offset(    board     : IK410_pointr;
                             offx,offy : integer);

begin
         if (offx>1) then
            begin
              if board^.offset00>-63 then
                board^.offset00:=board^.offset00-1;
                write_offset(board^.baseadr,
                             board^.offset00,
                             board^.offset90);
            end;

         if (offx<-1) then
            begin
              if board^.offset00<63 then
                board^.offset00:=board^.offset00+1;
                write_offset(board^.baseadr,
                             board^.offset00,
                             board^.offset90);
            end;

         if (offy>1) then
            begin
              if board^.offset90>-63 then
                board^.offset90:=board^.offset90-1;
                write_offset(board^.baseadr,
                             board^.offset00,
                             board^.offset90);
            end;

         if (offy<-1) then
            begin
              if board^.offset90<63 then
                board^.offset90:=board^.offset90+1;
                write_offset(board^.baseadr,
                             board^.offset00,
                             board^.offset90);
            end;
end;
(*________________________________________*)
procedure correct_amp(    board  : IK410_pointr;
                          ampdiff: integer);
var
  error : boolean;
begin
          if (ampdiff>5) then
            begin
              error:=false;
              Turn_sympoti(board,3,false,error);
            end;
          if (ampdiff<-5) then
            begin
              error:=false;
              Turn_sympoti(board,3,true,error);
            end;
          if (ampdiff>1) and (ampdiff<=5) then
            begin
              error:=false;
              Turn_sympoti(board,1,false,error);
            end;
          if (ampdiff<-1) and (ampdiff>=-5) then
            begin
              error:=false;
              Turn_sympoti(board,1,true,error);
            end;
end;
(*________________________________________*)
procedure correct_phase(  board  : IK410_pointr;
                          dphi   : integer);
var
  error : boolean;
begin
          if (dphi>5) then
            begin
              error:=false;
              Turn_phasepoti(board,3,false,error);
            end;
          if (dphi<-5) then
            begin
              error:=false;
              Turn_phasepoti(board,3,true,error);
            end;
          if (dphi<5) and (dphi>1) then
            begin
              error:=false;
              Turn_phasepoti(board,1,false,error);
            end;
          if (dphi>-5) and(dphi<-1) then
            begin
              error:=false;
              Turn_phasepoti(board,1,true,error);
            end;
end;
(*________________________________________*)
procedure adj(board:IK410_pointr);
var
  error,offset,amplitude,phaseadj,
  quad1,quad2,quad3,quad4,
  ende                                : boolean;
  eing                                : char;
  pointr                              : single_pointr;
  s,ampli                             : real;
  perioden,
  of0_1,of9_1,of0_2,of9_2             : integer;
  x,y,maxx,maxy,minx,miny,offx,offy,
  ampx,ampy,phi,dphi,adphi,adphi2,
  off0,off9,
  dg00,dg90,
  amp00,amp90,
  ampdiff,damp,
  phase,phasediff,
  min0,min9,
  max0,max9,
  alt_off0,alt_off9,
  alt_dg00,alt_dg90,
  alt_max0,alt_max9,
  alt_min0,alt_min9,
  alt_amp00,alt_amp90,
  alt_damp,
  alt_phase,
  alt_phasediff                       : integer;

begin

  SetFillpattern(schw,3);
  bar(1,1,getmaxx,getmaxy);

  init_analyze(board);

  offset:=false;
  amplitude:=false;
  phaseadj:=false;

  dphi:=0;
  adphi:=0;
  adphi2:=0;

  maxx:=0;
  minx:=0;
  maxy:=0;
  miny:=0;
  ampx:=0;
  ampy:=0;
  ampdiff:=0;
  phase:=0;
  phasediff:=0;

  alt_dg00:=1;
  alt_dg90:=1;
  alt_off0:=1;
  alt_off9:=1;
  alt_max9:=1;
  alt_min0:=1;
  alt_max0:=1;
  alt_min9:=1;
  alt_amp00:=1;
  alt_amp90:=1;
  alt_damp:=1;
  alt_phase:=1;
  alt_phasediff:=1;

  quad1:=false;
  quad2:=false;
  quad3:=false;
  quad4:=false;

  New(pointr);

  perioden:=0;
  adjustheader;
  ende:=false;
  eing:=' ';
  while not ende do
    begin
      if keypressed then
        begin
          eing:=readkey;
          case eing of
         'q' : begin
                 ende:=true;
               end;
         'Q' : begin
                 ende:=true;
               end;
         's' : begin
                 settextstyle(0,0,1);
                 setcolor(14);
                 outtextxy(271,311,'s : Store Settings');
                 error:=false;
                 Store_potis(board,error);     (* EE-Poti fixieren *)
                 Store_offset(board,error);    (* Offset in EE-Poti *)
                 init_analyze(board);
                 setcolor(15);
                 outtextxy(271,311,'s : Store Settings');
                 eing:=#32;
               end;
         'o' : begin
                 if not offset then
                   begin
                     offset:=true;
                     phaseadj:=false;
                     amplitude:=false;
                     settextstyle(0,0,1);
                     setcolor(14);
                     outtextxy(451,301,'o : Adj. Offset');
                     setcolor(15);
                     outtextxy(451,316,'a : Adj. Amp.');
                     outtextxy(451,331,'p : Adj. Phase');
                   end
                 else
                   begin
                     offset:=false;
                     phaseadj:=false;
                     amplitude:=false;
                     settextstyle(0,0,1);
                     setcolor(15);
                     outtextxy(451,316,'a : Adj. Amp.');
                     outtextxy(451,331,'p : Adj. Phase');
                     outtextxy(451,301,'o : Adj. Offset');
                   end;
                 eing:=#32;
               end;
         'a' : begin
                 if not amplitude then
                   begin
                     offset:=false;
                     phaseadj:=false;
                     amplitude:=true;
                     settextstyle(0,0,1);
                     setcolor(14);
                     outtextxy(451,316,'a : Adj. Amp.');
                     setcolor(15);
                     outtextxy(451,331,'p : Adj. Phase');
                     outtextxy(451,301,'o : Adj. Offset');
                   end
                 else
                   begin
                     offset:=false;
                     phaseadj:=false;
                     amplitude:=false;
                     settextstyle(0,0,1);
                     setcolor(15);
                     outtextxy(451,316,'a : Adj. Amp.');
                     outtextxy(451,331,'p : Adj. Phase');
                     outtextxy(451,301,'o : Adj. Offset');
                   end;
                 eing:=#32;
               end;
         'p' : begin
                 if not phaseadj then
                   begin
                     offset:=false;
                     phaseadj:=true;
                     amplitude:=false;
                     settextstyle(0,0,1);
                     setcolor(14);
                     outtextxy(451,331,'p : Adj. Phase');
                     setcolor(15);
                     outtextxy(451,316,'a : Adj. Amp.');
                     outtextxy(451,301,'o : Adj. Offset');
                   end
                 else
                   begin
                     offset:=false;
                     phaseadj:=false;
                     amplitude:=false;
                     settextstyle(0,0,1);
                     setcolor(15);
                     outtextxy(451,316,'a : Adj. Amp.');
                     outtextxy(451,331,'p : Adj. Phase');
                     outtextxy(451,301,'o : Adj. Offset');
                   end;
                 eing:=#32;
               end;
          end;
        end;

      get_single(board,pointr);

      (* Value x,y -511 <-> +511 *)
      x:=(pointr^.dg00);
      x:=x-511;
      y:=(pointr^.dg90);
      y:=y-511;
      (* Max. and min. of amplitude *)
      if x>maxx then maxx:=x;
      if x<minx then minx:=x;
      if y>maxy then maxy:=y;
      if y<miny then miny:=y;
      calc0(x,y,minx,maxx,miny,maxy,offx,offy,ampx,ampy,ampdiff,phi,dphi);
      adphi:=(adphi2+adphi) div 2;
      dphi:=(adphi+dphi) div 2;
      adphi2:=adphi;
      adphi:=dphi;

      if (x>0) and (y<0) then quad1:=true;
      if (x>0) and (y>0) then quad2:=true;
      if (x<0) and (y>0) then quad3:=true;
      if (x<0) and (y<0) then quad4:=true;
      if (quad1 and quad2 and quad3 and quad4) then
        begin
          perioden:=perioden+1;
          quad1:=false;
          quad2:=false;
          quad3:=false;
          quad4:=false;
        end;

      if perioden=30 then
        begin
          perioden:=0;
          sound(200);
          delay(50);
          nosound;
          if offset    then correct_offset(board,offx,offy);
          if amplitude then correct_amp(board,ampdiff);
          if phaseadj  then correct_phase(board,dphi);
          minx:=0;
          miny:=0;
          maxx:=0;
          maxy:=0;
          max0:=0;
          max9:=0;
          min0:=0;
          min9:=0;
          offx:=0;
          offy:=0;
        end;

      dg00:=round(x/2.844444);   (* -180 - +180 *)
      dg90:=round(y/2.844444);
      max0:=round(maxx/2.844444);
      max9:=round(maxy/2.844444);
      min0:=round(minx/2.844444);
      min9:=round(miny/2.844444);
      off0:=offx*9;
      off9:=offy*9;
      if off0>180 then off0:=180;
      if off0<-180 then off0:=-180;
      if off9>180 then off9:=180;
      if off9<-180 then off9:=-180;

      amp00:=round((ampx/2.84444)-180);
      amp90:=round((ampy/2.84444)-180);
      if ampx>0.5 then
        begin
          s:=ampdiff*(100/ampx)*9;
          if s>180 then s:=180;
          if s<-180 then s:=-180;
          damp:=round(s);
        end
      else
        begin
          damp:=0;
        end;
      phase:=phi;
      phasediff:=9*dphi;
      if phasediff>180 then phasediff:=180;
      if phasediff<-180 then phasediff:=-180;

      if perioden>10 then
      begin
      if (alt_dg00<>dg00) or (alt_max0<>max0) or (alt_min0<>min0) then
        begin
          anzeige(100,60,alt_dg00,alt_max0,alt_min0,7);
          anzeige(100,60,dg00,max0,min0,4);
          alt_dg00:=dg00;
          alt_max0:=max0;
          alt_min0:=min0;
        end;

      if (alt_dg90<>dg90) or (alt_max9<>max9) or (alt_min9<>min9) then
        begin
          anzeige(100,75,alt_dg90,alt_max9,alt_min9,7);
          anzeige(100,75,dg90,max9,min9,4);
          alt_dg90:=dg90;
          alt_max9:=max9;
          alt_min9:=min9;
        end;

      if (alt_off0<>off0) then
        begin
          anzeige(100,100,alt_off0,0,0,7);
          anzeige(100,100,off0,0,0,4);
          alt_off0:=off0;
        end;
      if (alt_off9<>off9) then
        begin
          anzeige(100,115,alt_off9,0,0,7);
          anzeige(100,115,off9,0,0,4);
          alt_off9:=off9;
        end;

      if (alt_amp00<>amp00) then
        begin
          anzeigepos(100,140,alt_amp00,7);
          anzeigepos(100,140,amp00,4);
          alt_amp00:=amp00;
        end;

      if (alt_amp90<>amp90) then
        begin
          anzeigepos(100,155,alt_amp90,7);
          anzeigepos(100,155,amp90,4);
          alt_amp90:=amp90;
        end;

      if (alt_damp<>damp) then
        begin
          anzeige(100,180,alt_damp,0,0,7);
          anzeige(100,180,damp,0,0,4);
          alt_damp:=damp;
        end;

      if (alt_phase<>phase) then
        begin
          anzeige(100,210,alt_phase,0,0,7);
          anzeige(100,210,phase,0,0,4);
          alt_phase:=phase;
        end;

      if (alt_phasediff<>phasediff) then
        begin
          anzeige(100,240,alt_phasediff,0,0,7);
          anzeige(100,240,phasediff,0,0,4);
          alt_phasediff:=phasediff;
        end;
      end;
    end;

    Dispose(pointr);
end;
(*________________________________________*)
end.