/*----------------------------POTI_1.CPP---------------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Functions for adjusting EEPROM Potentiometers  

  V 1.00
  October 1997
 ---------------------------------------------------------------------------*/
#include <conio.h>
#include "IK410_1.h"


const unsigned char CLEFT = 75;
const unsigned char CRIGHT = 77;
const unsigned char CUP = 72;
const unsigned char CDOWN = 80;
const unsigned char ESC = 27;

const unsigned char att_wsonsw =		0x0f;
const unsigned char att_wsongr =		0x7f;
const unsigned char att_gbongr =		0x7e;
const unsigned char att_blongr =		0x71;      
const unsigned char att_wsonbl =		0x1f;



void CrtInit()
{
	textbackground(LIGHTGRAY);
	textcolor(BLACK);
	clrscr();
	highvideo();
	window(1,1,80,25);     
	textattr(att_blongr);
	gotoxy(2,1);	cputs("EEPROM-Potentiometer Adjustment");
	textattr(att_wsongr);
	gotoxy(10,4);	cputs("   Phase axis1");
	gotoxy(10,7);	cputs(" Amplitude axis1");
	gotoxy(10,11);	cputs("Offset DG00 axis1");
	gotoxy(10,15);	cputs("Offset DG90 axis1");
	gotoxy(42,4);	cputs("   Phase axis2");
	gotoxy(42,7);	cputs(" Amplitude axis2");
	gotoxy(42,11);	cputs("Offset DG00 axis2");
	gotoxy(42,15);	cputs("Offset DG90 axis2");
	gotoxy(2,21);	cputs(" +: Increment");
	gotoxy(2,22);	cputs(" -: Decrement");
	gotoxy(2,23);	cputs(" >: Maximum");
	gotoxy(2,24);	cputs(" <: Minimum");
	gotoxy(2,25);	cputs(" n: Neutral   N: Neutral all");
	gotoxy(50,24);	cputs(" s: Store values");
	textattr(att_gbongr);
	gotoxy(50,25);	cputs(" q: Quit");
}

void ShowPotis(pIK410 card)
{	
	for(int i=1; i<=8; i++)
	ShowPoti(card, i, att_wsonsw);
}

void ShowPoti(pIK410 card, unsigned char poti_nr, unsigned char color_attr)
{
	switch(poti_nr)
		{
		case 1:
		textattr(color_attr);
		window(16,5,26,5);
		cprintf(" %3d ",ReadPhasepoti(card,1));
		break;
		case 2:
		textattr(color_attr);
		window(16,8,26,8);
		cprintf(" %3d ",ReadSympoti(card,1));
		break;
		case 3:
		textattr(color_attr);
		window(16,12,26,12);
		cprintf(" %3d ",card->axis[1]->offset00);
		break;
		case 4:
		textattr(color_attr);
		window(16,16,26,16);
		cprintf(" %3d ",card->axis[1]->offset90);
		break;
		case 5:
		textattr(color_attr);
		window(48,5,58,5);
		cprintf(" %3d ",ReadPhasepoti(card,2));
		break;
		case 6:
		textattr(color_attr);
		window(48,8,58,8);
		cprintf(" %3d ",ReadSympoti(card,2));
		break;
		case 7:
		textattr(color_attr);
		window(48,12,58,12);
		cprintf(" %3d ",card->axis[2]->offset00);
		break;
		case 8:
		textattr(color_attr);
		window(48,16,58,16);
		cprintf(" %3d ",card->axis[2]->offset90);
		break;
		default:
		break;
		}
}

void TurnPotis(pIK410 card)
{
	short c, poti_nr =1;
	
	ShowPoti(card, poti_nr, att_wsonbl);
	while(kbhit()) getch();
	do
	{
	c = getch();
	switch(c)
		{
		case 0:					//Key CLEFT,CRIGHT,CUP,CDOWN,ESC
			c = getch();
			switch(c)
				{
				case CLEFT:
					if(poti_nr <= 4)
						poti_nr += 4;
					else
						poti_nr -= 4;
				ShowPotis(card);
				ShowPoti(card, poti_nr,att_wsonbl);
				break;   
				case CRIGHT:
					if(poti_nr <= 4)
						poti_nr += 4;
					else
						poti_nr -= 4;
				ShowPotis(card);
				ShowPoti(card, poti_nr,att_wsonbl);
				break;
				case CUP:
				poti_nr -= 1;
				if (poti_nr <= 0) poti_nr = 8;
				ShowPotis(card);
				ShowPoti(card, poti_nr,att_wsonbl);
				break;       
				case CDOWN:
				poti_nr += 1;
				if (poti_nr >= 9) poti_nr = 1;  					 
				ShowPotis(card);
				ShowPoti(card, poti_nr,att_wsonbl);
				break;       
				default:
				break;
				}		
			break;
		case '+':
				switch(poti_nr)
					{
					case 1:
						TurnPhasepoti(card,1,1,1);
						ShowPoti(card, 1, att_wsonbl);
						break;
					case 2:
						TurnSympoti(card,1,1,1);
						ShowPoti(card, 2, att_wsonbl);
						break;
					case 3:
						TurnOffsetdg00(card,1,1,1);
						ShowPoti(card, 3, att_wsonbl);
						break;
					case 4:
						TurnOffsetdg90(card,1,1,1);
						ShowPoti(card, 4, att_wsonbl);
						break;
					case 5:
						TurnPhasepoti(card,2,1,1);
						ShowPoti(card, 5, att_wsonbl);
						break;
					case 6:
						TurnSympoti(card,2,1,1);
						ShowPoti(card, 6, att_wsonbl);
						break;
					case 7:
						TurnOffsetdg00(card,2,1,1);
						ShowPoti(card, 7, att_wsonbl);
						break;
					case 8:
						TurnOffsetdg90(card,2,1,1);
						ShowPoti(card, 8, att_wsonbl);
						break;
					default:    
					break;
					}
			break;
		case '-':
				switch(poti_nr)
					{
					case 1:
						TurnPhasepoti(card,1,1,0);
						ShowPoti(card, 1, att_wsonbl);
						break;
					case 2:
						TurnSympoti(card,1,1,0);
						ShowPoti(card, 2, att_wsonbl);
						break;
					case 3:
						TurnOffsetdg00(card,1,1,0);
						ShowPoti(card, 3, att_wsonbl);
						break;
					case 4:
						TurnOffsetdg90(card,1,1,0);
						ShowPoti(card, 4, att_wsonbl);
						break;
					case 5:
						TurnPhasepoti(card,2,1,0);
						ShowPoti(card, 5, att_wsonbl);
						break;
					case 6:
						TurnSympoti(card,2,1,0);
						ShowPoti(card, 6, att_wsonbl);
						break;
					case 7:
						TurnOffsetdg00(card,2,1,0);
						ShowPoti(card, 7, att_wsonbl);
						break;
					case 8:
						TurnOffsetdg90(card,2,1,0);
						ShowPoti(card, 8, att_wsonbl);
						break;
					default:    
					break;
					}
			break;
		case '>':              
				switch(poti_nr)
					{
					case 1:
						WritePhasepoti(card,1,63);
						ShowPoti(card, 1, att_wsonbl);
						break;
					case 2:
						WriteSympoti(card,1,63);
						ShowPoti(card, 2, att_wsonbl);
						break;
					case 3:
						WriteOffset00(card,1,63);
						ShowPoti(card, 3, att_wsonbl);
						break;
					case 4:
						WriteOffset90(card,1,63);
						ShowPoti(card, 4, att_wsonbl);
						break;
					case 5:
						WritePhasepoti(card,2,63);
						ShowPoti(card, 5, att_wsonbl);
						break;
					case 6:
						WriteSympoti(card,2,63);
						ShowPoti(card, 6, att_wsonbl);
						break;
					case 7:
						WriteOffset00(card,2,63);
						ShowPoti(card, 7, att_wsonbl);
						break;
					case 8:
						WriteOffset90(card,2,63);
						ShowPoti(card, 8, att_wsonbl);
						break;
					default:    
					break;
					}
			break;
		case '<':
				switch(poti_nr)
					{
					case 1:
						WritePhasepoti(card,1,0);
						ShowPoti(card, 1, att_wsonbl);
						break;
					case 2:
						WriteSympoti(card,1,0);
						ShowPoti(card, 2, att_wsonbl);
						break;
					case 3:
						WriteOffset00(card,1,-63);
						ShowPoti(card, 3, att_wsonbl);
						break;
					case 4:
						WriteOffset90(card,1,-63);
						ShowPoti(card, 4, att_wsonbl);
						break;
					case 5:
						WritePhasepoti(card,2,0);
						ShowPoti(card, 5, att_wsonbl);
						break;
					case 6:
						WriteSympoti(card,2,0);
						ShowPoti(card, 6, att_wsonbl);
						break;
					case 7:
						WriteOffset00(card,2,-63);
						ShowPoti(card, 7, att_wsonbl);
						break;
					case 8:
						WriteOffset90(card,2,-63);
						ShowPoti(card, 8, att_wsonbl);
						break;
					default:    
					break;
					}
			break;
		case 'n':
				switch(poti_nr)
					{
					case 1:
						WritePhasepoti(card,1,32);
						ShowPoti(card, 1, att_wsonbl);
						break;
					case 2:
						WriteSympoti(card,1,32);
						ShowPoti(card, 2, att_wsonbl);
						break;
					case 3:
						WriteOffset00(card,1,0);
						ShowPoti(card, 3, att_wsonbl);
						break;
					case 4:
						WriteOffset90(card,1,0);
						ShowPoti(card, 4, att_wsonbl);
						break;
					case 5:
						WritePhasepoti(card,2,32);
						ShowPoti(card, 5, att_wsonbl);
						break;
					case 6:
						WriteSympoti(card,2,32);
						ShowPoti(card, 6, att_wsonbl);
						break;
					case 7:
						WriteOffset00(card,2,0);
						ShowPoti(card, 7, att_wsonbl);
						break;
					case 8:
						WriteOffset90(card,2,0);
						ShowPoti(card, 8, att_wsonbl);
						break;
					default:    
					break;
					}
			break;
		case 'N':
			PotiDefault(card);
			LoadOffset(card);
			ShowPotis(card);
			ShowPoti(card, poti_nr,att_wsonbl);
			break;
		case 's':
			StoreOffset(card);
			StorePotis(card);
			break;
		case 'q':
			break;
		default:
			break;
		}	
	}
	while((kbhit) && c != 'q');
}


