{-------------------------------------------------------------------------}
{ Dr JOHANNES HEIDENHAIN, Traunreut, West Germany                         }
{                                                                         }
{ Demonstration program to illustrate the programming of the interface    }
{ card IK120 using the unit IK120.PAS.                                    }
{                                                                         }
{-------------------------------------------------------------------------}

program EXTLATCH;

uses IK120, crt;

var
   Period: real;
   SubDivision : integer;
   s,sz:string;
   error: boolean;

Procedure SetupCounters;
{------------------------------------------------------------}
{ Standard sequence for initialising counters                }
{------------------------------------------------------------}
begin
    Init_Interface(0);
    Init_Interface(1);
    Interpolation(0,m_interpol);
    Interpolation(1,m_interpol);
    Init_Counter (0,reset_start,fourfold,normal,linear);
    Init_Counter (1,reset_start,fourfold,normal,linear);
    Reset_uas(0);
    Reset_uas(1);
    Reset_Status(0);
    Reset_Status(1);
end;



BEGIN
    Clrscr;
    Writeln('EXTLATCH - External latching of IK 120 using input X3');
    Writeln('');
    Writeln;
    Writeln('X3/1        X3/2        X3/3        X3/4');
    Writeln('Blue        Green       Red         White');
    Writeln('LatchInX1   LatchInX2   LatchOut    0 Volt');

    Period := 0.010;   { Grating period in mm }
    Subdivision := 200;
    m_interpol:=I_50;

    SetupCounters;

    {------------------------------------------------------------------}
    { Enable external latch signal.                                    }
    { Data is latched to storage register 0 and not 1 as usually used. }
    {------------------------------------------------------------------}
    Latch_Disable(0,Internal);
    Latch_Disable(0,LatchOut);
    Latch_Enable(0,ExternalX1X2);

    repeat
       delay(50);                     { Filters bounce contacts on switch }
       if Latched(0,1) then
       begin
            Read_Count(0,1,Count);         { Register 0 for external latch }
            writeln( 'Axis X1 = ',Count*Period/Subdivision :10:4);
       end;
       if Latched(1,1) then
       begin
            Read_Count(1,1,Count);         { Register 0 for external latch }
            writeln( 'Axis X2 = ',Count*Period/Subdivision :10:4);
       end;
    until keypressed;
END.
