program sample4;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{                                                       }
{ V 1.00                                                }
{ Nov 1995                                              }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

uses crt,ik120_1;

var
  board                   : ik120_pointr;
  axis1,axis2             : g6_pointr;
  ende                    : boolean;
  reg                     : word;
  eing                    : char;
(*________________________________________*)
procedure main;
var
  p,i  : comp;

begin
  clrscr;
  textcolor(15);
  writeln(' Interpolation Mode');
  writeln;
  writeln(' Start counter                        ->Press a ');
  writeln(' Reset counter                        ->Press b ');
  writeln(' Stop counter                         ->Press c ');
  writeln(' Software latch in register 1         ->Press d ');
  writeln(' Special software latch in register 1 ->Press e ');
  writeln(' Start with ref                       ->Press h ');
  writeln(' Start and reset with ref             ->Press i ');
  writeln(' Stop with ref                        ->Press j ');
  writeln(' Latch in register 0 with ref         ->Press k ');
  writeln(' Latch in register 1 with ref         ->Press l ');
  writeln(' Reset with ref                       ->Press m ');
  writeln(' Clear Error                          ->Press n ');
  writeln;
  writeln(' Quit                                 ->Press q ');
  textcolor(4);

  ende:=false;
  repeat
    eing:=#32;
    delay(100);

    (* Software latch *)
    Soft_latch0(board^.axis[1]);
    Soft_latch0(board^.axis[2]);

    (* Read status X1 *)
    read_count_status(board^.axis[1]);
    gotoxy(45,17);
    textcolor(1);
    if board^.axis[1]^.cstatus.latch0 then write('Latch0') else write('      ');
    gotoxy(45,18);
    if board^.axis[1]^.cstatus.latch1 then write('Latch1') else write('      ');
    gotoxy(45,19);
    if board^.axis[1]^.cstatus.stop then write('Stop') else write('      ');
    gotoxy(65,17);
    if board^.axis[1]^.cstatus.error then write('Error') else write('      ');
    gotoxy(65,18);
    if board^.axis[1]^.cstatus.ref then write('Ref') else write('      ');

    (* Read status X2 *)
    read_count_status(board^.axis[2]);
    gotoxy(45,20);
    textcolor(1);
    if board^.axis[2]^.cstatus.latch0 then write('Latch0') else write('      ');
    gotoxy(45,21);
    if board^.axis[2]^.cstatus.latch1 then write('Latch1') else write('      ');
    gotoxy(45,22);
    if board^.axis[2]^.cstatus.stop then write('Stop') else write('      ');
    gotoxy(65,20);
    if board^.axis[2]^.cstatus.error then write('Error') else write('      ');
    gotoxy(65,21);
    if board^.axis[2]^.cstatus.ref then write('Ref') else write('      ');
    textcolor(4);

    (* Read status bit for "latched" and read data register *)
    Read_Reg0(board^.axis[1]);
    Read_Reg1(board^.axis[1]);

    (* Display registers on screen *)
    gotoxy(1,17);
    writeln(' Axis 1 - Reg0:  ',board^.axis[1]^.register0:10:0,'            ');
    writeln(' Axis 1 - Reg1:  ',board^.axis[1]^.register1:10:0,'            ');

    gotoxy(1,20);
    writeln(' Axis 2 - Reg0:  ',board^.axis[2]^.register0:10:0,'            ');
    writeln(' Axis 2 - Reg1:  ',board^.axis[2]^.register1:10:0,'            ');

    (* Read Registers *)

    Read_Reg0(board^.axis[1]);
    Read_Reg0(board^.axis[2]);
    Read_Reg1(board^.axis[1]);
    Read_Reg1(board^.axis[2]);

    if keypressed then eing:=readkey;
    case eing of
      'a': begin
             board^.axis[1]^.softcomm.start:=true;
             Comm_G6Handler(board^.axis[1]);
             board^.axis[2]^.softcomm.start:=true;
             Comm_G6Handler(board^.axis[2]);
           end;
      'b': begin
             board^.axis[1]^.softcomm.clear:=true;
             Comm_G6Handler(board^.axis[1]);
             board^.axis[2]^.softcomm.clear:=true;
             Comm_G6Handler(board^.axis[2]);
           end;
      'c': begin
             board^.axis[1]^.softcomm.stop:=true;
             Comm_G6Handler(board^.axis[1]);
             board^.axis[2]^.softcomm.stop:=true;
             Comm_G6Handler(board^.axis[2]);
           end;
      'd': begin
             board^.axis[1]^.softcomm.latch1:=true;
             Comm_G6Handler(board^.axis[1]);
             board^.axis[2]^.softcomm.latch1:=true;
             Comm_G6Handler(board^.axis[2]);
           end;
      'e': begin
             board^.axis[1]^.softcomm.strobe:=true;
             Comm_G6Handler(board^.axis[1]);
           end;
      'h': begin
             board^.axis[1]^.refcomm.ristart:=true;
             Comm_G6Handler(board^.axis[1]);
             board^.axis[2]^.refcomm.ristart:=true;
             Comm_G6Handler(board^.axis[2]);
           end;
      'i': begin
             board^.axis[1]^.refcomm.ristart:=true;
             board^.axis[1]^.refcomm.riclear:=true;
             Comm_G6Handler(board^.axis[1]);
             board^.axis[2]^.refcomm.ristart:=true;
             board^.axis[2]^.refcomm.riclear:=true;
             Comm_G6Handler(board^.axis[2]);
           end;
      'j': begin
             board^.axis[1]^.refcomm.ristop:=true;
             Comm_G6Handler(board^.axis[1]);
             board^.axis[2]^.refcomm.ristop:=true;
             Comm_G6Handler(board^.axis[2]);
           end;
      'k': begin
             board^.axis[1]^.inilatch.en_ref:=l0;
             Init_G6Handler(board^.axis[1]);
             board^.axis[2]^.inilatch.en_ref:=l0;
             Init_G6Handler(board^.axis[2]);

             board^.axis[1]^.refcomm.rilatch:=true;
             Comm_G6Handler(board^.axis[1]);
             board^.axis[2]^.refcomm.rilatch:=true;
             Comm_G6Handler(board^.axis[2]);
           end;
      'l': begin
             board^.axis[1]^.inilatch.en_ref:=l1;
             Init_G6Handler(board^.axis[1]);
             board^.axis[2]^.inilatch.en_ref:=l1;
             Init_G6Handler(board^.axis[2]);

             board^.axis[1]^.refcomm.rilatch:=true;
             Comm_G6Handler(board^.axis[1]);
             board^.axis[2]^.refcomm.rilatch:=true;
             Comm_G6Handler(board^.axis[2]);
           end;
      'm': begin
             board^.axis[1]^.refcomm.riclear:=true;
             Comm_G6Handler(board^.axis[1]);
             board^.axis[2]^.refcomm.riclear:=true;
             Comm_G6Handler(board^.axis[2]);
           end;
      'n': begin
             board^.axis[1]^.softcomm.clrerror:=true;
             Comm_IKHandler(board);
             board^.axis[2]^.softcomm.clrerror:=true;
             Comm_IKHandler(board);
           end;
      'q': begin
             ende:=true;
           end;
     end;
  until ende;
end;
(*________________________________________*)
begin
  textbackground(7);
  clrscr;
  New(board);
  New(axis1);
  New(axis2);
  board^.axis[1]:=axis1;
  board^.axis[2]:=axis2;
  init_ik120(board);
  if (look_for_ik120(board)) then
    begin
      main;
    end
  else
    begin
      clrscr;
      write('No hardware!!');;
      readln;
    end;

  Dispose(board);
  Dispose(axis1);
  Dispose(axis2);
  textbackground(0);
  clrscr;
end.
(*________________________________________*)