unit Main;

//-----------------------------------------------------------------------
//---Sample Code Borland Delphi 7----------------------------------------
//---for MICROSENSYS iID(R) driver engine--------------------------------
//-----------------------------------------------------------------------
//---Author: SJ----------------------------------------------------------
//---Date: 2004-06-27 - 2004-06-28---------------------------------------
//---------2004-08-18 - Implementation and Test USB support--------------
//---------2005-01-31 - Test of EPROM support for PEN-BT----------------
//---------2005-04-28 - Test of DCC functions ---------------------------
//---------2005-05-23 - Test of 125kHz functions-------------------------
//---------2005-08-04 - Test of LED command------------------------------
//---------2007-01 - Reworked as sample code iID driver 2000 1.9x--------
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Spin;

type
  TForm_Main = class(TForm)
    Memo_Output: TMemo;
    Timer_CheckPort: TTimer;
    GroupBox_Param: TGroupBox;
    Label2: TLabel;
    SpinEdit_From: TSpinEdit;
    SpinEdit_Length: TSpinEdit;
    Label3: TLabel;
    Label1: TLabel;
    Label4: TLabel;
    SpinEdit_TimeOut: TSpinEdit;
    Edit_Text: TMemo;
    GroupBox_Init: TGroupBox;
    Label_PortName: TLabel;
    ComboBox_Port: TComboBox;
    Button_Initialize: TButton;
    Label_PortType: TLabel;
    ComboBox_PortType: TComboBox;
    Panel_PortState: TPanel;
    GroupBox1: TGroupBox;
    Button_Identify: TButton;
    Button_CReadBytes: TButton;
    Button_CWriteBytes: TButton;
    GroupBox_15693_Functions: TGroupBox;
    Button_ReadUID: TButton;
    Button_WriteBlock: TButton;
    Button_ReadBlock: TButton;
    Button_LockBlock: TButton;
    CheckBox_mydcustom: TCheckBox;
    CheckBox_LOCK: TCheckBox;
    procedure Button_InitializeClick(Sender: TObject);
    procedure OutputMemo(Txt:String;Result:integer);
    procedure Button_IdentifyClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Timer_CheckPortTimer(Sender: TObject);
    procedure Button_CReadBytesClick(Sender: TObject);
    procedure Button_CWriteBytesClick(Sender: TObject);
    procedure SpinEdit_TimeOutChange(Sender: TObject);
    procedure Button_WriteBlockClick(Sender: TObject);
    procedure Button_ReadBlockClick(Sender: TObject);
    procedure Button_LockBlockClick(Sender: TObject);
    procedure Button_ReadUIDClick(Sender: TObject);
    procedure CheckBox_mydcustomClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form_Main: TForm_Main;


const DLL_NAME='iiddrv_20.dll';

//Imports for most important functions of iID-driver
function c_set_port_type(porttype:Byte;lpszPortName:String):byte;stdcall; external DLL_NAME name 'c_set_port_type';
function c_set_interface_type(frequency:integer):byte; stdcall; external DLL_NAME name 'c_set_interface_type';
function c_set_timeout(newtimeout:integer):byte;stdcall; external DLL_NAME name 'c_set_timeout';
function c_set_system_mask(newmask:integer):byte;stdcall; external DLL_NAME name 'c_set_system_mask';
function c_get_driver_version(mainver:PInteger;subver:pinteger):byte;stdcall; external DLL_NAME name 'c_get_driver_version';
function c_get_transponder_parameters(ptagtype_PInteger, pmaxlength:PInteger; ptagsystem:PInteger; pxtraparam:PInteger; piIDByteArray:PByteArray):byte;stdcall; external DLL_NAME name 'c_get_transponder_parameters';

function c_get_port_state(old_handle:THandle):THandle;stdcall; external DLL_NAME name 'c_get_port_state';
function c_get_handle():THandle;stdcall; external DLL_NAME name 'c_get_handle';

function c_initialize():byte;stdcall; external DLL_NAME name 'c_initialize';
function c_terminate():byte; stdcall;external DLL_NAME name 'c_terminate';
function c_identify(SerNr:PByteArray):byte;stdcall; external DLL_NAME name 'c_identify';
function c_readbytes(identifier:PByteArray;from:integer;length:integer;read:PByteArray):byte;stdcall; external DLL_NAME name 'c_readbytes';
function c_writebytes(identifier:PByteArray;from:integer;length:integer;read:PByteArray;lock:byte):byte;stdcall; external DLL_NAME name 'c_writebytes';
function c_read_reader_id(ID:PInteger;PArray:PByteArray):byte;stdcall; external DLL_NAME name 'c_read_reader_id';

function iidd_c_read_ro_code(m_HCom:THandle;zeiger_data:PByteArray):byte;stdcall; external DLL_NAME name 'iidd_c_read_ro_code';
function iidd_c_read_block(m_HCom:THandle;address:byte;zeiger_data:PByteArray):byte;stdcall; external DLL_NAME name 'iidd_c_read_block';
function iidd_c_write_block(m_HCom:THandle;address:byte;zeiger_data:PByteArray):byte;stdcall; external DLL_NAME name 'iidd_c_write_block';
function iidd_c_read_block_pw(m_HCom:THandle;address:byte;zeiger_data:PByteArray;zeiger_pw:PByteArray):byte;stdcall; external DLL_NAME name 'iidd_c_read_block_pw';
function iidd_c_write_block_pw(m_HCom:THandle;address:byte;zeiger_data:PByteArray;zeiger_pw:PByteArray):byte;stdcall; external DLL_NAME name 'iidd_c_write_block_pw';
function iidd_c_send_read_protect_code(m_HCom:THandle;zeiger_data:PByteArray):byte;stdcall; external DLL_NAME name 'iidd_c_send_read_protect_code';
function iidd_c_send_write_protect_code(m_HCom:THandle;zeiger_data:PByteArray):byte;stdcall; external DLL_NAME name 'iidd_c_send_write_protect_code';

function iso15693_read_uid(m_HCom:THandle;zeiger_data:PByteArray):byte;stdcall; external DLL_NAME name 'iso15693_read_uid';
function iso15693_read_block(m_HCom:THandle;Address:integer;zeiger_data:PByteArray):byte;stdcall; external DLL_NAME name 'iso15693_read_block';
function iso15693_write_block(m_HCom:THandle;Address:integer;zeiger_data:PByteArray):byte;stdcall; external DLL_NAME name 'iso15693_write_block';
function iso15693_lock_block(m_HCom:THandle;Address:integer):byte;stdcall; external DLL_NAME name 'iso15693_lock_block';
function iso15693_set_myd_custom_mode(new_mode:byte):byte;stdcall; external DLL_NAME name 'iso15693_set_myd_custom_mode';
function iso15693_get_myd_custom_mode():byte;stdcall; external DLL_NAME name 'iso15693_get_myd_custom_mode';

function iidg_c_read_uid(m_HCom:THandle;zeiger_data:PByteArray):byte;stdcall; external DLL_NAME name 'iidg_c_read_uid';
function iidg_c_read_block_16(m_HCom:THandle;address:integer;param:byte;zeiger_data:PByteArray):byte;stdcall; external DLL_NAME name 'iidg_c_read_block_16';
function iidg_c_write_block_16(m_HCom:THandle;address:integer;param:byte;zeiger_data:PByteArray):byte;stdcall; external DLL_NAME name 'iidg_c_write_block_16';

function iid2000_c_reader_led_on(m_HCom:THandle):byte;stdcall; external DLL_NAME name 'iid2000_c_reader_led_on';
function iid2000_c_reader_led_off(m_HCom:THandle):byte;stdcall; external DLL_NAME name 'iid2000_c_reader_led_off';


implementation

uses RegistryRead;

{$R *.DFM}

const PortType_Serial : byte = 0;
const PortType_BlueSPP : byte = 2;
const PortType_USB : byte = 4;
const PortName : String = 'COM4:';

const IntType_125KHZ : integer = 125;
const IntType_1356MHZ : integer = 1356;
const IntType_BLUE_MEM : integer = $10;

const SystemMask_ISO15693 : integer = 1;
const SystemMask_ICODE1 : integer = 2;
const SystemMask_IIDD : integer = 4;
const SystemMask_IIDG : integer = 8;
const SystemMask_64BITRO : integer = $10;

const SystemArray : Array[0..7] of string = ('ISO15693 compatible','I-Code 1','iID-D','iID-G','ARIO readonly','','','');

const ScanTimeout : integer = 1000;

var   MSS_Ergeb, i : integer;
      readarray, writearray : array[0..2100] of byte;
      Identifier : array[0..10] of byte;
      PortType   : byte;
      m_HCom     : THandle;
      start,stop : DWORD;
      RFState    : integer;
      ReadWriteTimeout : integer = 1000;

const readwrite_from : integer = 1800;
const readwrite_length : integer = 200;

procedure TForm_Main.OutputMemo(Txt:String;Result:integer);
begin
if (Form_Main.Memo_Output.Lines.Count>20) then Form_Main.Memo_Output.Clear();
Form_Main.Memo_Output.Lines.Add(txt+Format('  ---> 0x%X.',[Result]));
end;

procedure TForm_Main.Button_InitializeClick(Sender: TObject);
begin
//if Port is open, try to close first
m_HCom:=c_get_handle();
if (m_HCom<>INVALID_HANDLE_VALUE) then c_terminate();

//select the serial port and type of interface to work with
//necessary for setting port parameters
case ComboBox_PortType.ItemIndex of
  0 : PortType:=PortType_Serial;
  1 : PortType:=PortType_BlueSPP;
  2 : PortType:=PortType_USB;
  else
  PortType:=PortType_Serial;
  end;

PortName:=ComboBox_Port.Text;

//set port type and port name
MSS_ergeb:=c_set_port_type(PortType,PortName);
OutputMemo(Format('C_SET_PORT_TYPE %d/'+PortName,[PortType]),MSS_Ergeb);
if (Mss_ergeb<>PortType) then begin Memo_Output.Lines.Add('### Error ####'); exit; end;

//select interface frequency to work with
//necessary, standard is 1356
//MSS_ergeb:=c_set_interface_type(IntType_125kHz);
MSS_ergeb:=c_set_interface_type(IntType_1356MHz);
OutputMemo('C_SET_INTERFACE_TYPE',MSS_Ergeb);
if (Mss_ergeb<>0) then begin Memo_Output.Lines.Add('### Error ####'); exit; end;

//select timeout (msec) for iID(R) driver functions
//optional function
MSS_ergeb:=c_set_timeout(ScanTimeOut);
OutputMemo('C_SET_TIMEOUT',MSS_Ergeb);
if (Mss_ergeb<>0) then begin Memo_Output.Lines.Add('### Error ####'); exit; end;

//select System-Mask for iID(R) driver functions
//optional function for increasing performance
MSS_ergeb:=c_set_system_mask(SystemMask_ISO15693 or SystemMask_ICODE1 or SystemMask_IIDD or SystemMask_IIDG or SystemMask_64BITRO);
OutputMemo('C_SET_SYSTEM_MASK',MSS_Ergeb);
if (Mss_ergeb<>0) then begin Memo_Output.Lines.Add('### Error ####'); exit; end;

MSS_ergeb:=c_initialize();
OutputMemo('C_INITIALIZE',MSS_Ergeb);
if (Mss_ergeb<>0) then
   begin
   //ERROR during initialize, port not open
   Memo_Output.Lines.Add('### Error ####');
   end;

//get handle of device (required for USB plug&play, not required for iid driver functions)
m_HCom:=c_get_handle();

//enable timer for plug/unplug detection
Timer_CheckPort.Enabled:=true;
end;

procedure TForm_Main.Button_IdentifyClick(Sender: TObject);
var start : DWORD;
    strg : string;
    TAGType, TAGMaxLength, TAGSystem, TAGxTraParam : integer;
begin
Memo_Output.Lines.Add('Begin searching for a transponder...');

//set new reader timeout
MSS_ergeb:=c_set_timeout(ReadWriteTimeOut);

//POWER on READER LED, if supported
MSS_ergeb:=iid2000_c_reader_led_on(m_HCom);

start:=GetTickCount();
//search for max. xxx msec for TAG
MSS_ergeb:=c_identify(@readarray);
if (not bool(Mss_ergeb)) then
    begin
    //Transponder found -> output Code
    stop:=GetTickCount();
    OutputMemo('C_IDENTIFY',MSS_Ergeb);
    //Output code
    //readarray[0] contains length of Identifier
    strg:='';
    //readarray[1..n] contains data
    for i:=1 to (readarray[0]) do
        begin
        //store identifier for readbytes and writebytes
        Identifier[i-1]:=readarray[i];
        strg:=strg+' '+Format('%2X',[readarray[i]]);
        end;
    Memo_Output.Lines.Add('Identifier '+strg+' found.');
    c_get_transponder_parameters(@TAGType, @TAGMaxLength, @TAGSystem, @TAGxTraParam, @ReadArray[0]);
    Memo_Output.Lines.Add(Format('TAG type : 0x%x',[TagType]));
    Memo_Output.Lines.Add(Format('TAG Max Length : %d bytes',[TagMaxLength]));
    strg:='';
    for i:=0 to 7 do
      begin
      if bool(TagSystem and (1 shl i)) then strg:=strg+SystemArray[i]+', ';
      end;
    Memo_Output.Lines.Add(Format('TAG System : 0x%x ,',[TagSystem])+strg);
    end
    else
    begin
    stop:=GetTickCount();
    //no Transponder found
    OutputMemo('C_IDENTIFY',MSS_Ergeb);
    end;

//POWER OFF READER LED, if supported
MSS_ergeb:=iid2000_c_reader_led_off(m_HCom);

Memo_Output.Lines.Add(Format('Time required: %d msec',[stop-start]));
end;



procedure TForm_Main.FormActivate(Sender: TObject);
var main_ver, sub_ver : integer;
    PortArray : Array[0..255] of byte;
    i : integer;
begin
Memo_Output.Clear;
c_get_driver_version(@main_ver, @sub_ver);
Memo_output.Lines.Add(Format('iID(R) driver version %d.%d detected!',[main_ver,sub_ver]));
Memo_output.Lines.Add('');
//Get list of available PC-Ports
GetRegistryPorts(@PortArray[0],sizeof(PortArray));
with ComboBox_Port do
  begin
  Items.Clear;
  i:=0;
  while ((i<sizeof(PortArray)) and (PortArray[i]<>0)) do
    begin
    Items.Add(Format('COM%d:',[PortArray[i]]));
    inc(i);
    end;
  Items.Add('USB direct');
  Itemindex:=0;
  end;
with ComboBox_PortType do
  begin
  Clear;
  Items.Add('0 - Serial');
  Items.Add('2 - Bluetooth(TM) SPP');
  Items.Add('4 - USB');
  ItemIndex:=0;
  end;
end;

procedure TForm_Main.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
Timer_CheckPort.Enabled:=false;
//Form should be closed, cancel Interface connection
MSS_Ergeb:=c_terminate();
OutputMemo('C_TERMINATE',MSS_Ergeb);
end;

procedure TForm_Main.Timer_CheckPortTimer(Sender: TObject);
var Reader_ID : integer;
    ID_Array : Array[0..9] of byte;
    Ergeb : byte;
begin
m_HCom:=c_get_port_state(m_HCom);
if (m_HCom<>INVALID_HANDLE_VALUE) then
  begin
  Ergeb:=c_read_reader_id(@Reader_ID,@ID_Array);
  if not bool(Ergeb) then
      begin
      Panel_Portstate.Caption:=Format('Reader ID %d connected.',[Reader_ID]);
      Panel_PortState.Color:=clLime;
      end
      else
      begin
      Panel_Portstate.Caption:='No reader detected.';
      Panel_PortState.Color:=clYellow;
      end;
  end
  else
  begin
  Panel_Portstate.Caption:='Port state FAIL';
  Panel_PortState.Color:=clRed;
  if (PortType<>4) then
    begin
    c_terminate();
    c_initialize();
    end;
  Panel_Portstate.Caption:='Trying to re-initialize...';
  end;
end;


procedure TForm_Main.Button_CReadBytesClick(Sender: TObject);
var   strg : string;
begin
//set new reader timeout
MSS_ergeb:=c_set_timeout(ReadWriteTimeOut);

//try reading the transponder (here without loop) - timeout of driver is used
start:=GetTickCount();
readwrite_from:=SpinEdit_From.Value;
readwrite_length:=SpinEdit_Length.Value;

MSS_ergeb:=c_readbytes(@identifier,readwrite_from, readwrite_length, @readarray);
if (not bool(Mss_ergeb)) then
   begin
   //Transponder found -> display ASCII Text
   Beep;
   OutputMemo(Format('C_READBYTES (%d)',[readwrite_length]),MSS_Ergeb);
   //Output code
   //readarray[0] contains length of Identifier
   strg:='';
   for i:=1 to (readwrite_length) do strg:=strg+' '+Chr(readarray[i]);
   //readarray[1..n] contains data
   Memo_Output.Lines.Add('Read from transponder: '+strg+' .');
   Memo_Output.Lines.Add('Successfull.......');
   end
   else
   begin
   //no Transponder found
   OutputMemo('C_READBYTES',MSS_Ergeb);
   end;
stop:=GetTickCount();

Memo_Output.Lines.Add(Format('Time required: %d msec',[stop-start]));
end;

procedure TForm_Main.Button_CWriteBytesClick(Sender: TObject);
var   strg : string;
begin
if (CheckBox_Lock.Checked) then
  if (Application.MessageBox('Do you really want to WRITE AND LOCK ?','Attention',MB_YESNO)=ID_NO) then exit;
//set new reader timeout
MSS_ergeb:=c_set_timeout(ReadWriteTimeOut);

//try reading the transponder (here without loop) - timeout of driver is used
start:=GetTickCount();
readwrite_from:=SpinEdit_From.Value;
readwrite_length:=SpinEdit_Length.Value;

for i:=0 to 256 do writearray[i]:=0;
for i:=0 to (readwrite_length -1) do
    begin
    if (i<length(Edit_Text.Text)) then writearray[i]:=Ord(Edit_Text.Text[i+1]);
    end;

if (CheckBox_Lock.Checked) then
    MSS_ergeb:=c_writebytes(@identifier,readwrite_from, readwrite_length, @writearray,1)
    else
    MSS_ergeb:=c_writebytes(@identifier,readwrite_from, readwrite_length, @writearray,0);
if (not bool(Mss_ergeb)) then
   begin
   //Transponder found -> display ASCII Text
   Beep;
   OutputMemo(Format('C_WRITEBYTES (%d)',[readwrite_length]),MSS_Ergeb);
   Memo_Output.Lines.Add('Successfull.......');
   end
   else
   begin
   //no Transponder found
   OutputMemo(Format('C_WRITEBYTES (%d)',[readwrite_length]),MSS_Ergeb);
   end;

stop:=GetTickCount();
Memo_Output.Lines.Add(Format('Time required: %d msec',[stop-start]));
end;

procedure TForm_Main.SpinEdit_TimeOutChange(Sender: TObject);
begin
ReadWriteTimeout:=SpinEdit_TimeOut.Value;
end;

procedure TForm_Main.Button_WriteBlockClick(Sender: TObject);
var   strg : string;
begin
readwrite_from:=SpinEdit_From.Value;

for i:=0 to 256 do writearray[i]:=0;
for i:=0 to (8 -1) do
    begin
    if (i<length(Edit_Text.Text)) then writearray[i]:=Ord(Edit_Text.Text[i+1]);
    end;

start:=GetTickCount();
MSS_ergeb:=iso15693_write_block(m_HCom,readwrite_from, @writearray);
if (not bool(Mss_ergeb)) then
   begin
   //Transponder found -> display ASCII Text
   Beep;
   OutputMemo(Format('WRITE BLOCK (%d)',[readwrite_from]),MSS_Ergeb);
   Memo_Output.Lines.Add('Successfull.......');
   end
   else
   begin
   //no Transponder found
   OutputMemo(Format('WRITE BLOCK (%d)',[readwrite_from]),MSS_Ergeb);
   end;
MSS_ergeb:=c_set_timeout(ScanTimeOut);
stop:=GetTickCount();
Memo_Output.Lines.Add(Format('Time required: %d msec',[stop-start]));
end;

procedure TForm_Main.Button_ReadBlockClick(Sender: TObject);
var   strg : string;
begin
//try reading the transponder (here without loop) - timeout of driver is used
start:=GetTickCount();
readwrite_from:=SpinEdit_From.Value;
//MSS_ergeb:=c_readbytes(@identifier,readwrite_from, readwrite_length, @readarray);
MSS_ergeb:=iso15693_read_block(m_HCom,readwrite_from, @readarray);
if (not bool(Mss_ergeb)) then
   begin
   //Transponder found -> display ASCII Text
   Beep;
   OutputMemo(Format('READ BLOCK (%d)',[readwrite_from]),MSS_Ergeb);
   //Output code
   //readarray[0] contains length of Data
   strg:='';
   for i:=1 to 8 do strg:=strg+' '+Chr(readarray[i]);
   //readarray[1..n] contains data
   Memo_Output.Lines.Add('Read from transponder: '+strg+' .');
   Memo_Output.Lines.Add('Successfull.......');
   end
   else
   begin
   //no Transponder found
   OutputMemo(Format('READ BLOCK (%d)',[readwrite_from]),MSS_Ergeb);
   end;
stop:=GetTickCount();
Memo_Output.Lines.Add(Format('Time required: %d msec',[stop-start]));
end;

procedure TForm_Main.Button_LockBlockClick(Sender: TObject);
begin
if (Application.MessageBox('Do you really want to LOCK ?','Attention',MB_YESNO)=ID_NO) then exit;

readwrite_from:=SpinEdit_From.Value;

start:=GetTickCount();
MSS_ergeb:=iso15693_lock_block(m_HCom,readwrite_from);
if (not bool(Mss_ergeb)) then
   begin
   //Transponder found -> display ASCII Text
   Beep;
   OutputMemo(Format('LOCK BLOCK (%d)',[readwrite_from]),MSS_Ergeb);
   Memo_Output.Lines.Add('Successfull.......');
   end
   else
   begin
   //no Transponder found
   OutputMemo(Format('LOCK BLOCK (%d)',[readwrite_from]),MSS_Ergeb);
   end;
stop:=GetTickCount();
Memo_Output.Lines.Add(Format('Time required: %d msec',[stop-start]));
end;

procedure TForm_Main.Button_ReadUIDClick(Sender: TObject);
var start : DWORD;
    strg : string;
begin
Memo_Output.Lines.Add('Begin searching for a transponder...');
start:=GetTickCount();
//scan ISO15693 UID for xx msec
while (GetTickCount()<(start+ReadWriteTimeOut)) do
      begin
      //search for max. 10000 msec for TAG
      start:=GetTickCount();
      MSS_ergeb:=iso15693_read_uid(m_HCom,@readarray);
      stop:=GetTickCount();
      if (not bool(Mss_ergeb)) then
         begin
         //Transponder found -> output Code
         OutputMemo('READ UID',MSS_Ergeb);
         //Output code
         //readarray[0] contains length of Identifier
         strg:='';
         for i:=1 to (readarray[0]) do
             begin
             //store identifier for readbytes and writebytes
             Identifier[i-1]:=readarray[i];
             strg:=strg+' '+Format('%2X',[readarray[i]]);
             end;
         //readarray[1..n] contains data
         Memo_Output.Lines.Add('Identifier '+strg+' found.');
         break;
         end;
      Application.ProcessMessages;
      end;
if (bool(Mss_ergeb)) then
   begin
   //no Transponder found
   OutputMemo('READ UID',MSS_Ergeb);
   end;
Memo_Output.Lines.Add(Format('Time required: %d msec',[stop-start]));
end;

procedure TForm_Main.CheckBox_mydcustomClick(Sender: TObject);
begin
if (sender as tCheckBox).Checked then iso15693_set_myd_custom_mode(1) else iso15693_set_myd_custom_mode(0);
end;

end.
