Imports System
Imports System.Threading
Imports System.Runtime.InteropServices

'-------------------------------------------------------------------------------
'-Sample-Code VB.Net iID driver 3000 PRO----------------------------------------
'-last mod. 2007-07-16----------------------------------------------------------
'-------------------------------------------------------------------------------

Public Class Form_Main
    Inherits System.Windows.Forms.Form

    Dim PortType_Serial As Byte = 0
    Dim PortType_CF As Byte = 1
    Dim PortType_BlueSPP As Byte = 2
    Dim PortType_USB As Byte = 4

    Dim SystemMask_ISO15693 As Byte = &H1
    Dim SystemMask_IIDL As Byte = &H2
    Dim SystemMask_iIDD As Byte = &H4
    Dim SystemMask_iIDG As Byte = &H8
    Dim SystemMask_64BitRO As Byte = &H10
    Dim SystemMask_ICodeUID As Byte = &H20
    Dim SystemMask_ICode1 As Byte = &H40

    Dim PortName As String = "COM2:"
    Dim ActualPort As Int32
    Dim Identifier As Byte()
    Dim DataArray As Byte()
    Dim i As Integer

    Friend WithEvents GroupBox_Terminate As System.Windows.Forms.GroupBox
    Friend WithEvents Timer_PortState As System.Windows.Forms.Timer
    Friend WithEvents ComboBox_PortType As System.Windows.Forms.ComboBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents ComboBox_PortName As System.Windows.Forms.ComboBox
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents Button_Initialize As System.Windows.Forms.Button
    Friend WithEvents GroupBox_Results As System.Windows.Forms.GroupBox
    Friend WithEvents TextBox_Result As System.Windows.Forms.TextBox
    Friend WithEvents Button_Identify As System.Windows.Forms.Button
    Dim Ergeb As Byte



#Region " Vom Windows Form Designer generierter Code "

    Public Sub New()
        MyBase.New()

        ' Dieser Aufruf ist fr den Windows Form-Designer erforderlich.
        InitializeComponent()

        ' Initialisierungen nach dem Aufruf InitializeComponent() hinzufgen

    End Sub

    ' Die Form berschreibt den Lschvorgang der Basisklasse, um Komponenten zu bereinigen.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    ' Fr Windows Form-Designer erforderlich
    Private components As System.ComponentModel.IContainer

    'HINWEIS: Die folgende Prozedur ist fr den Windows Form-Designer erforderlich
    'Sie kann mit dem Windows Form-Designer modifiziert werden.
    'Verwenden Sie nicht den Code-Editor zur Bearbeitung.
    Friend WithEvents Label_GetPortState As System.Windows.Forms.Label
    Friend WithEvents BClose As System.Windows.Forms.Button
    Friend WithEvents GroupBox_Settings As System.Windows.Forms.GroupBox
    Friend WithEvents GroupBox_TagOP As System.Windows.Forms.GroupBox
    Friend WithEvents Button_Write As System.Windows.Forms.Button
    Friend WithEvents Button_Read As System.Windows.Forms.Button
    Friend WithEvents TextBox_ReadWrite As System.Windows.Forms.TextBox
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Me.Label_GetPortState = New System.Windows.Forms.Label
        Me.BClose = New System.Windows.Forms.Button
        Me.GroupBox_Settings = New System.Windows.Forms.GroupBox
        Me.Button_Initialize = New System.Windows.Forms.Button
        Me.ComboBox_PortName = New System.Windows.Forms.ComboBox
        Me.Label2 = New System.Windows.Forms.Label
        Me.ComboBox_PortType = New System.Windows.Forms.ComboBox
        Me.Label1 = New System.Windows.Forms.Label
        Me.GroupBox_TagOP = New System.Windows.Forms.GroupBox
        Me.TextBox_ReadWrite = New System.Windows.Forms.TextBox
        Me.Button_Write = New System.Windows.Forms.Button
        Me.Button_Read = New System.Windows.Forms.Button
        Me.GroupBox_Terminate = New System.Windows.Forms.GroupBox
        Me.Timer_PortState = New System.Windows.Forms.Timer(Me.components)
        Me.GroupBox_Results = New System.Windows.Forms.GroupBox
        Me.TextBox_Result = New System.Windows.Forms.TextBox
        Me.Button_Identify = New System.Windows.Forms.Button
        Me.GroupBox_Settings.SuspendLayout()
        Me.GroupBox_TagOP.SuspendLayout()
        Me.GroupBox_Terminate.SuspendLayout()
        Me.GroupBox_Results.SuspendLayout()
        Me.SuspendLayout()
        '
        'Label_GetPortState
        '
        Me.Label_GetPortState.Location = New System.Drawing.Point(293, 80)
        Me.Label_GetPortState.Name = "Label_GetPortState"
        Me.Label_GetPortState.Size = New System.Drawing.Size(134, 20)
        Me.Label_GetPortState.TabIndex = 4
        Me.Label_GetPortState.Text = "c_get_port_state"
        '
        'BClose
        '
        Me.BClose.Location = New System.Drawing.Point(9, 30)
        Me.BClose.Name = "BClose"
        Me.BClose.Size = New System.Drawing.Size(191, 29)
        Me.BClose.TabIndex = 10
        Me.BClose.Text = "C_Terminate"
        '
        'GroupBox_Settings
        '
        Me.GroupBox_Settings.Controls.Add(Me.Label_GetPortState)
        Me.GroupBox_Settings.Controls.Add(Me.Button_Initialize)
        Me.GroupBox_Settings.Controls.Add(Me.ComboBox_PortName)
        Me.GroupBox_Settings.Controls.Add(Me.Label2)
        Me.GroupBox_Settings.Controls.Add(Me.ComboBox_PortType)
        Me.GroupBox_Settings.Controls.Add(Me.Label1)
        Me.GroupBox_Settings.Dock = System.Windows.Forms.DockStyle.Top
        Me.GroupBox_Settings.Location = New System.Drawing.Point(0, 0)
        Me.GroupBox_Settings.Name = "GroupBox_Settings"
        Me.GroupBox_Settings.Size = New System.Drawing.Size(453, 117)
        Me.GroupBox_Settings.TabIndex = 13
        Me.GroupBox_Settings.TabStop = False
        Me.GroupBox_Settings.Text = "Parameter setting / Initialize Interface"
        '
        'Button_Initialize
        '
        Me.Button_Initialize.Location = New System.Drawing.Point(9, 73)
        Me.Button_Initialize.Name = "Button_Initialize"
        Me.Button_Initialize.Size = New System.Drawing.Size(232, 27)
        Me.Button_Initialize.TabIndex = 13
        Me.Button_Initialize.Text = "C_Initialize"
        Me.Button_Initialize.UseVisualStyleBackColor = True
        '
        'ComboBox_PortName
        '
        Me.ComboBox_PortName.FormattingEnabled = True
        Me.ComboBox_PortName.Location = New System.Drawing.Point(88, 46)
        Me.ComboBox_PortName.Name = "ComboBox_PortName"
        Me.ComboBox_PortName.Size = New System.Drawing.Size(153, 21)
        Me.ComboBox_PortName.TabIndex = 12
        '
        'Label2
        '
        Me.Label2.AutoSize = True
        Me.Label2.Location = New System.Drawing.Point(9, 49)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(60, 13)
        Me.Label2.TabIndex = 11
        Me.Label2.Text = "Port-Name:"
        '
        'ComboBox_PortType
        '
        Me.ComboBox_PortType.FormattingEnabled = True
        Me.ComboBox_PortType.Items.AddRange(New Object() {"0 = Serial / CF Serial / USB Serial", "1 = CF direct (only PPC)", "2 = Bluetooth (TM) SPP", "3 = reserved", "4 = USB direct"})
        Me.ComboBox_PortType.Location = New System.Drawing.Point(88, 19)
        Me.ComboBox_PortType.Name = "ComboBox_PortType"
        Me.ComboBox_PortType.Size = New System.Drawing.Size(272, 21)
        Me.ComboBox_PortType.TabIndex = 10
        '
        'Label1
        '
        Me.Label1.AutoSize = True
        Me.Label1.Location = New System.Drawing.Point(9, 27)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(56, 13)
        Me.Label1.TabIndex = 9
        Me.Label1.Text = "Port-Type:"
        '
        'GroupBox_TagOP
        '
        Me.GroupBox_TagOP.Controls.Add(Me.Button_Identify)
        Me.GroupBox_TagOP.Controls.Add(Me.TextBox_ReadWrite)
        Me.GroupBox_TagOP.Controls.Add(Me.Button_Write)
        Me.GroupBox_TagOP.Controls.Add(Me.Button_Read)
        Me.GroupBox_TagOP.Location = New System.Drawing.Point(1, 123)
        Me.GroupBox_TagOP.Name = "GroupBox_TagOP"
        Me.GroupBox_TagOP.Size = New System.Drawing.Size(449, 125)
        Me.GroupBox_TagOP.TabIndex = 15
        Me.GroupBox_TagOP.TabStop = False
        Me.GroupBox_TagOP.Text = "Read and Write transponder"
        '
        'TextBox_ReadWrite
        '
        Me.TextBox_ReadWrite.Location = New System.Drawing.Point(221, 75)
        Me.TextBox_ReadWrite.MaxLength = 0
        Me.TextBox_ReadWrite.Name = "TextBox_ReadWrite"
        Me.TextBox_ReadWrite.Size = New System.Drawing.Size(205, 20)
        Me.TextBox_ReadWrite.TabIndex = 13
        Me.TextBox_ReadWrite.Text = "...."
        '
        'Button_Write
        '
        Me.Button_Write.Location = New System.Drawing.Point(8, 89)
        Me.Button_Write.Name = "Button_Write"
        Me.Button_Write.Size = New System.Drawing.Size(194, 25)
        Me.Button_Write.TabIndex = 12
        Me.Button_Write.Text = "Write to transponder"
        Me.Button_Write.UseVisualStyleBackColor = True
        '
        'Button_Read
        '
        Me.Button_Read.Location = New System.Drawing.Point(8, 58)
        Me.Button_Read.Name = "Button_Read"
        Me.Button_Read.Size = New System.Drawing.Size(194, 25)
        Me.Button_Read.TabIndex = 11
        Me.Button_Read.Text = "Read from transponder"
        Me.Button_Read.UseVisualStyleBackColor = True
        '
        'GroupBox_Terminate
        '
        Me.GroupBox_Terminate.Controls.Add(Me.BClose)
        Me.GroupBox_Terminate.Dock = System.Windows.Forms.DockStyle.Bottom
        Me.GroupBox_Terminate.Location = New System.Drawing.Point(0, 405)
        Me.GroupBox_Terminate.Name = "GroupBox_Terminate"
        Me.GroupBox_Terminate.Size = New System.Drawing.Size(453, 78)
        Me.GroupBox_Terminate.TabIndex = 16
        Me.GroupBox_Terminate.TabStop = False
        Me.GroupBox_Terminate.Text = "Terminate"
        '
        'Timer_PortState
        '
        Me.Timer_PortState.Interval = 3000
        '
        'GroupBox_Results
        '
        Me.GroupBox_Results.Controls.Add(Me.TextBox_Result)
        Me.GroupBox_Results.Dock = System.Windows.Forms.DockStyle.Bottom
        Me.GroupBox_Results.Location = New System.Drawing.Point(0, 254)
        Me.GroupBox_Results.Name = "GroupBox_Results"
        Me.GroupBox_Results.Size = New System.Drawing.Size(453, 151)
        Me.GroupBox_Results.TabIndex = 17
        Me.GroupBox_Results.TabStop = False
        Me.GroupBox_Results.Text = "Results"
        '
        'TextBox_Result
        '
        Me.TextBox_Result.Dock = System.Windows.Forms.DockStyle.Fill
        Me.TextBox_Result.Location = New System.Drawing.Point(3, 16)
        Me.TextBox_Result.Multiline = True
        Me.TextBox_Result.Name = "TextBox_Result"
        Me.TextBox_Result.ScrollBars = System.Windows.Forms.ScrollBars.Both
        Me.TextBox_Result.Size = New System.Drawing.Size(447, 132)
        Me.TextBox_Result.TabIndex = 0
        '
        'Button_Identify
        '
        Me.Button_Identify.Location = New System.Drawing.Point(9, 25)
        Me.Button_Identify.Name = "Button_Identify"
        Me.Button_Identify.Size = New System.Drawing.Size(192, 24)
        Me.Button_Identify.TabIndex = 14
        Me.Button_Identify.Text = "Identify transponder"
        Me.Button_Identify.UseVisualStyleBackColor = True
        '
        'Form_Main
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(453, 483)
        Me.Controls.Add(Me.GroupBox_Results)
        Me.Controls.Add(Me.GroupBox_Terminate)
        Me.Controls.Add(Me.GroupBox_Settings)
        Me.Controls.Add(Me.GroupBox_TagOP)
        Me.Name = "Form_Main"
        Me.Text = "VB.Net sample application"
        Me.GroupBox_Settings.ResumeLayout(False)
        Me.GroupBox_Settings.PerformLayout()
        Me.GroupBox_TagOP.ResumeLayout(False)
        Me.GroupBox_TagOP.PerformLayout()
        Me.GroupBox_Terminate.ResumeLayout(False)
        Me.GroupBox_Results.ResumeLayout(False)
        Me.GroupBox_Results.PerformLayout()
        Me.ResumeLayout(False)

    End Sub

#End Region

#Region "DLLIMPORTs iID Driver 3000 PRO"
    <DllImport("iiddrv30_pro.dll", EntryPoint:="c_set_port_type", SetLastError:=True, CharSet:=CharSet.Ansi, ExactSpelling:=True, CallingConvention:=CallingConvention.StdCall)> Public Shared Function c_set_port_type(ByVal porttype As Byte, ByVal lpszPortName As String) As Byte
    End Function
    <DllImport("iiddrv30_pro.dll", EntryPoint:="c_set_system_mask", SetLastError:=True, CharSet:=CharSet.Ansi, ExactSpelling:=True, CallingConvention:=CallingConvention.StdCall)> Public Shared Function c_set_system_mask(ByVal mask As Int32) As Byte
    End Function
    <DllImport("iiddrv30_pro.dll", EntryPoint:="c_set_interface_type", SetLastError:=True, CharSet:=CharSet.Ansi, ExactSpelling:=True, CallingConvention:=CallingConvention.StdCall)> Public Shared Function c_set_interface_type(ByVal frequency As Int32) As Byte
    End Function
    <DllImport("iiddrv30_pro.dll", EntryPoint:="c_set_timeout")> _
    Public Shared Function C_Set_Timeout(ByVal newtimeout As Integer) As Byte
    End Function
    <DllImport("iiddrv30_pro.dll", EntryPoint:="c_initialize", SetLastError:=True, CharSet:=CharSet.Ansi, ExactSpelling:=True, CallingConvention:=CallingConvention.StdCall)> Public Shared Function c_initialize() As Byte
    End Function
    <DllImport("iiddrv30_pro.dll", EntryPoint:="c_get_handle", SetLastError:=True, CharSet:=CharSet.Ansi, ExactSpelling:=True, CallingConvention:=CallingConvention.StdCall)> Public Shared Function c_get_handle() As Int32
    End Function
    <DllImport("iiddrv30_pro.dll", EntryPoint:="c_get_port_state", SetLastError:=True, CharSet:=CharSet.Ansi, ExactSpelling:=True, CallingConvention:=CallingConvention.StdCall)> Public Shared Function c_get_port_state(ByVal ActualPort As Integer) As Int32
    End Function
    <DllImport("iiddrv30_pro.dll", EntryPoint:="c_identify", SetLastError:=True, CharSet:=CharSet.Ansi, ExactSpelling:=True, CallingConvention:=CallingConvention.StdCall)> Public Shared Function c_identify(ByVal pByte As Byte()) As Byte
    End Function
    <DllImport("iiddrv30_pro.dll", EntryPoint:="c_readbytes", SetLastError:=True, CallingConvention:=CallingConvention.Winapi)> _
    Public Shared Function C_Readbytes(ByVal bIdentifier() As Byte, ByVal from As Integer, ByVal length As Integer, ByVal Data() As Byte) As Byte
    End Function
    <DllImport("iiddrv30_pro.dll", EntryPoint:="c_writebytes", CallingConvention:=CallingConvention.Winapi)> _
    Public Shared Function C_Writebytes(ByVal bIdentifier() As Byte, ByVal from As Integer, ByVal length As Integer, ByVal Data() As Byte, ByVal locked As Byte) As Byte
    End Function
    <DllImport("iiddrv30_pro.dll", EntryPoint:="c_terminate", SetLastError:=True, CharSet:=CharSet.Ansi, ExactSpelling:=True, CallingConvention:=CallingConvention.StdCall)> Public Shared Function c_terminate() As Byte
    End Function
#End Region

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim i As Integer

        Me.ComboBox_PortName.Items.Clear()
        i = 0
        Me.ComboBox_PortName.Items.Add("USB")
        While (i < 32)
            Me.ComboBox_PortName.Items.Add("COM" & (i + 1) & ":")
            i = i + 1
        End While
        Me.ComboBox_PortName.SelectedIndex = 1
        Me.ComboBox_PortType.SelectedIndex = 0
        Me.TextBox_Result.Text = ""

    End Sub

    Private Sub BClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BClose.Click
        If (ActualPort <> -1) Then
            'Close interface communication, if open
            EnterResultText("c_terminate", False)
            EnterResultText(c_terminate(), False)
        End If
    End Sub

    Private Sub Timer_PortState_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer_PortState.Tick
        'Interface communication OKAY ?
        ActualPort = c_get_port_state(ActualPort)
        If (ActualPort = -1) Then
            Me.Label_GetPortState.BackColor = Color.Red
        Else
            Me.Label_GetPortState.BackColor = Color.Green
        End If
    End Sub

    Private Sub Button_Read_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Read.Click
        'pre-initialize arrays
        ReDim Preserve DataArray(100)
        ReDim Preserve Identifier(8)

        'First identify the transponder
        EnterResultText("c_identify", False)
        Ergeb = c_identify(DataArray)
        EnterResultText(Ergeb, False)
        If Ergeb <> 0 Then
            Exit Sub
        End If

        'put Identifier into array
        i = 0
        While (i < DataArray(0))
            Identifier(i) = DataArray(i + 1)
            i = i + 1
        End While

        'Read xx bytes from offset 0 of transponder
        EnterResultText("c_readbytes", False)
        Ergeb = C_Readbytes(Identifier, 0, 64, DataArray)
        If Ergeb <> 0 Then
            Exit Sub
        End If
        EnterResultText(Ergeb, False)

        'concat data bytes to string and display
        Me.TextBox_ReadWrite.Text = ""
        i = 0
        While ((i < DataArray(0)) And (DataArray(i + 1) <> 0))
            Me.TextBox_ReadWrite.Text = Me.TextBox_ReadWrite.Text + Chr(DataArray(i + 1))
            i = i + 1
        End While
        Me.Refresh()
    End Sub

    Private Sub Button_Write_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Write.Click
        'pre-initialize arrays
        ReDim Preserve DataArray(100)
        ReDim Preserve Identifier(8)

        'First identify the transponder
        EnterResultText("c_identify", False)
        Ergeb = c_identify(DataArray)
        EnterResultText(Ergeb, False)
        If Ergeb <> 0 Then
            Exit Sub
        End If

        'put Identifier into array
        i = 0
        While (i < DataArray(0))
            Identifier(i) = DataArray(i + 1)
            i = i + 1
        End While

        'copy data bytes from string to data array
        i = 0
        While (i < 48)
            If (i < Me.TextBox_ReadWrite.Text.Length) Then
                DataArray(i) = Convert.ToByte(Me.TextBox_ReadWrite.Text(i))
            Else
                DataArray(i) = 0
            End If
            i = i + 1
        End While

        'Write 48 bytes beginning from offset 0 of transponder without LOCK
        EnterResultText("c_writebytes", False)
        Ergeb = C_Writebytes(Identifier, 0, 64, DataArray, 0)
        EnterResultText(Ergeb, False)
        Me.Refresh()
    End Sub


    Private Sub EnterResultText(ByVal Text As String, ByVal Clear As Boolean)
        If (Clear = True) Then
            Me.TextBox_Result.Text = ""
        End If
        Me.TextBox_Result.Text = Me.TextBox_Result.Text & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & Text
    End Sub

    Private Sub EnterResultText(ByVal ErrorCode As Integer, ByVal Clear As Boolean)
        If (Clear = True) Then
            Me.TextBox_Result.Text = ""
        End If
        Me.TextBox_Result.Text = Me.TextBox_Result.Text & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "Operation Result: " & ErrorCode
    End Sub


    Private Sub Button_Initialize_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Initialize.Click
        'port type USB, portname COMx: without meaning
        EnterResultText("c_set_port_type", True)
        EnterResultText(c_set_port_type(Me.ComboBox_PortType.SelectedIndex, Me.ComboBox_PortName.Items(Me.ComboBox_PortName.SelectedIndex)), False)
        'Interface type 13,56MHz
        EnterResultText("c_set_interface_type", False)
        EnterResultText(c_set_interface_type(1356), False)
        'handle iID-G transponders
        EnterResultText("c_set_system_mask", False)
        EnterResultText(c_set_system_mask(SystemMask_ISO15693 Or SystemMask_iIDG Or SystemMask_IIDL), False)
        'scan for 500msec driver-internally
        EnterResultText("c_set_timeout", False)
        EnterResultText(C_Set_Timeout(500), False)
        'initialize the reader communication

        EnterResultText("c_initialize", False)
        Ergeb = c_initialize()
        EnterResultText(Ergeb, False)
        If (Ergeb = 0) Then
            EnterResultText("c_get_handle", False)
            ActualPort = c_get_handle()
            EnterResultText(ActualPort, False)
            Me.Timer_PortState.Enabled = True
        End If
    End Sub

    Private Sub Button_Identify_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Identify.Click

        ReDim Preserve DataArray(50)
        ReDim Preserve Identifier(8)
        Dim Identifier_Strg As String


        'First identify the transponder
        EnterResultText("c_identify", False)
        Ergeb = c_identify(DataArray)
        EnterResultText(Ergeb, False)
        If Ergeb <> 0 Then
            Exit Sub
        End If

        'put Identifier into array
        Identifier_Strg = ""
        i = 0
        While (i < DataArray(0))
            Identifier(i) = DataArray(i + 1)
            'make hexadecimal string from identifier
            If (Identifier(i).ToString("X").Length < 2) Then
                Identifier_Strg = Identifier_Strg + "0" + Identifier(i).ToString("X") + " "
            Else
                Identifier_Strg = Identifier_Strg + Identifier(i).ToString("X") + " "
            End If
            i = i + 1
        End While
        EnterResultText("UID: " & Identifier_Strg, False)

    End Sub
End Class
