unit main;

{--------------------------------------------------------------------------}
{--------------------------------------------------------------------------}
{--------------------------------------------------------------------------}
{---Demo/Sample Code iID3000-----------------------------------------------}
{---Verfasser : SJ---------------------------------------------------------}
{---Start : 2004-12-13-----------------------------------------------------}
{---History : 2005-03-24 Implementation of command READ_IN2----------------}
{-------------2005-06-09 Modification to iID driver iID3000----------------}
{------------------------iIDDrv30.dll--------------------------------------}
{--------------------------------------------------------------------------}
{--------------------------------------------------------------------------}
{---Component TCrossEdit was used for this sample and can be found in -----}
{---the web.---------------------------------------------------------------}
{--------------------------------------------------------------------------}
{-------------2007-07-17 extension as sample code iID3000 PRO--------------}
{--------------------------------------------------------------------------}
{--------------------------------------------------------------------------}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, ComCtrls, ExtCtrls, ImgList, Buttons, Spin, CrossEdit;

function Smallfonts : Boolean;

type
  TForm_Main = class(TForm)
    GroupBox2: TGroupBox;
    MainMenu: TMainMenu;
    Menu_Program: TMenuItem;
    Menu_Info: TMenuItem;
    Menu_Quit: TMenuItem;
    Menu_Settings: TMenuItem;
    Menu_PortSettings: TMenuItem;
    StatusBar_FormMain: TStatusBar;
    Panel_Test: TPanel;
    Label4: TLabel;
    PageControl_Main: TPageControl;
    TabSheet_Instructions: TTabSheet;
    GroupBox_Param: TGroupBox;
    GroupBox_Results: TGroupBox;
    Memo_Result: TMemo;
    GroupBox_Commands: TGroupBox;
    ListBox_OP: TListBox;
    GroupBox_ReadWrite: TGroupBox;
    Label1: TLabel;
    Label_Txt: TLabel;
    ComboBox_address: TComboBox;
    Edit_TextToWrite: TEdit;
    CheckBox_cycle: TCheckBox;
    TrackBar_SamplingRate: TTrackBar;
    Label5: TLabel;
    Label6: TLabel;
    Memo_Output: TMemo;
    Label7: TLabel;
    Label8: TLabel;
    ComboBox_DataLen: TComboBox;
    CrossEdit1: TCrossEdit;
    CrossEdit2: TCrossEdit;
    CrossEdit3: TCrossEdit;
    CrossEdit4: TCrossEdit;
    CrossEdit5: TCrossEdit;
    CrossEdit6: TCrossEdit;
    CrossEdit7: TCrossEdit;
    CrossEdit8: TCrossEdit;
    CrossEdit9: TCrossEdit;
    CrossEdit10: TCrossEdit;
    CrossEdit11: TCrossEdit;
    CrossEdit12: TCrossEdit;
    CrossEdit13: TCrossEdit;
    CrossEdit14: TCrossEdit;
    CrossEdit15: TCrossEdit;
    CrossEdit16: TCrossEdit;
    CrossEdit17: TCrossEdit;
    CrossEdit18: TCrossEdit;
    CrossEdit19: TCrossEdit;
    CrossEdit20: TCrossEdit;
    CrossEdit21: TCrossEdit;
    CrossEdit22: TCrossEdit;
    CrossEdit23: TCrossEdit;
    CrossEdit24: TCrossEdit;
    Timer_ReadId: TTimer;
    GroupBox_ReadIn: TGroupBox;
    CheckBox_In0: TCheckBox;
    CheckBox_In1: TCheckBox;
    CheckBox_In2: TCheckBox;
    CheckBox_In3: TCheckBox;
    Panel_OP: TPanel;
    BitBtn_Execute: TBitBtn;
    BitBtn_Cancel: TBitBtn;
    GroupBox_SetOut: TGroupBox;
    CheckBox_Out0: TCheckBox;
    CheckBox_Out1: TCheckBox;
    CheckBox_Lock: TCheckBox;
    Button_AcceptText: TButton;
    Button_ClearMemo: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Menu_InfoClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Menu_PortSettingsClick(Sender: TObject);
    procedure Menu_QuitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure StatusBar_FormMainDrawPanel(StatusBar: TStatusBar;
      Panel: TStatusPanel; const Rect: TRect);
    procedure FormResize(Sender: TObject);
    procedure Timer_ReadIdTimer(Sender: TObject);
    procedure BitBtn_CancelClick(Sender: TObject);
    procedure PageControl_MainChange(Sender: TObject);
    procedure WriteErrorCode(Sender: TObject);
    procedure BitBtn_ExecuteClick(Sender: TObject);
    procedure UpdateSendString(Sender: TObject);
    procedure Button_AcceptTextClick(Sender: TObject);
    procedure Button_ClearMemoClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form_Main: TForm_Main;
  Info_Programmstart  :   boolean;

  zwischen            :   integer;
  liststr             :   String;
  start_status        :   boolean;
  wait                :   integer;
  s                   :   string;
  m_hCom              :   Thandle; {Handle auf COM-Umstellung auf DLL 3.4.01}
  ergeb               :   integer;
  h4006               :   boolean;
  readarray,writearray : array[1..512] of byte;
  writebuf             : array[1..128] of byte;
  m_commopen           : boolean;
  USB_Device_Present   : boolean = false;
  id                   : integer;

  errorcode            : integer;

const                  delay = 100;

implementation

uses  globalvar, Info, start, Selectport_Old, iID3000PRO_Interface;
{$R *.DFM}

{-----------------------------------------------------------------------------}
{---ProgrammEnde Schnittstelle schliessen, wenn geffnet----------------------}
{-----------------------------------------------------------------------------}
procedure TForm_Main.FormClose(Sender: TObject; var Action: TCloseAction);
begin
if m_HCom<>INVALID_HANDLE_VALUE then
                                begin
                                if (@closeinterface<>nil) then CloseInterface(m_HCom);
                                end;
end;

{-----------------------------------------------------------------------------}
{--Info-Fenster zeigen--------------------------------------------------------}
{-----------------------------------------------------------------------------}
procedure TForm_Main.Menu_InfoClick(Sender: TObject);
begin
Form_Info.Showmodal;
end;

{-----------------------------------------------------------------------------}
{--FormActivate : DLL's laden und Init----------------------------------------}
{-----------------------------------------------------------------------------}
procedure TForm_Main.FormActivate(Sender: TObject);
var i : integer;
begin
Homedir:=ExtractFilePath(Application.EXEName);
if start_status then
   begin
   //Initialize Combo-Boxes
   combobox_address.Clear;
   for i:=0 to (256*1024 div 8 div 16) do combobox_address.Items.add(Format('0x%x',[i]));
   combobox_address.itemindex:=0;
   combobox_datalen.Clear;
   for i:=0 to 24 do combobox_datalen.Items.add(Format('%d',[i]));
   combobox_datalen.itemindex:=0;

   Listbox_op.ItemIndex:=0;
   start_status:=false;
   if (not Load_interface_Dll(0)) then
      begin
      Form_Main.Close;
      Application.Terminate; {standardmig DLL mit Port-typ seriell laden}
      exit;
      end;
   if (not register_interface_procedures(0)) then
      begin
      Form_Main.Close;
      Application.Terminate; {Prozeduren registrieren}
      exit;
      end;
   Form_info.ProductName.Caption:='Sensor-Demo Delphi iID3000PRO';
   Form_info.Version.Caption:='Ver0x10.0xB/Jul2007';
   Form_start.ProductName.Caption:='Sensor-Demo Delphi iID3000PRO';
   Form_info.Version.Caption:='Ver0x10.0xB/Jul2007';
   Form_main.Cursor:=crHourGlass;
   Form_Main.Update;
   Form_start.Show;
   Form_start.Update;
   wait:=GetTickCount+1500;
   while GetTickCount<wait do begin end;
   Form_start.Free;
   Form_main.Cursor:=crDefault;
   Comport:=2;     {Standardport}
   LoadComPort;
   val(ParamStr(1),zwischen,code);
   If code=0 then Comport:=zwischen;
   m_Hcom:=INVALID_HANDLE_VALUE;
   {zuerst DLL-Prozeduren zuweisen}
   if (comport<=8) then     {serieller Port gewhlt}
                   begin
                   if (not Load_interface_Dll(0)) then Application.Terminate;  {DLL mit Port-typ seriell laden}
                   if (not register_interface_procedures(0)) then Application.Terminate;   {Prozeduren registrieren}
                   {serielle Kommunikation->Port wird geffnet}
                   c_set_port_type(0,PChar(Format('COM%d:',[comport])));   //Port type = serial port
                   c_set_interface_type(1356);
                   c_set_timeout(150);

                   ergeb:=c_initialize();

                   m_HCom:=c_get_handle();
                   if (m_HCom=INVALID_HANDLE_VALUE) then
                      begin
                      Memo_output.lines.Add('** ERROR ** Serial port NOT initialized ...');
                      Memo_output.lines.Add('Please select another.');exit;
                      end;
                   memo_output.lines.add('Serial Port open ...');
                   Memo_output.lines.Add('Serial port initialized ...');
                   m_Commopen:=True;
                   end
                   else    {USB Port gewhlt}
                   begin
                   if (not Load_interface_Dll(0)) then {only one DLL for USB / serial}
                      begin
                      comport:=2;                 {Fehler beim Laden USB-DLL,Rckstellen auf ser.Port 2}
                      storeComport;
                      Application.Terminate;
                      end;
                   if (not register_interface_procedures(0)) then {Prozeduren registrieren}
                      begin
                      comport:=2;                 {Fehler beim Laden USB-DLL,Rckstellen auf ser.Port 2}
                      storeComport;
                      Application.Terminate;
                      end;
                   {serielle Kommunikation->Port wird geffnet}
                   c_set_port_type(4,PChar(Format('COM%d:',[comport])));   //Port type = USB port
                   c_set_interface_type(1356);
                   c_set_timeout(150);

                   ergeb:=c_initialize();

                   m_HCom:=c_get_handle();
                   
                   StatusBar_FormMain.Repaint;                 {Neuzeichnen Statusbar, wenn USB-Status gendert}

                   Memo_Output.Lines.Add('USB interface selected.');
                   m_Commopen:=True;
                   end;
   getdriverversion(@Driver_Version_Main, @Driver_Version_Sub);
   Timer_ReadID.Enabled:=true;
   if (comport<=8) then
      begin
      Form_Main.StatusBar_FormMain.SimpleText:=Format('Ready. Port: %d, Driver version: %d.%d',[comport,Driver_Version_Main,Driver_Version_Sub]);
      end
      else
      begin
      Form_Main.StatusBar_FormMain.SimpleText:=Format('Ready. Port: USB, Driver version: %d.%d',[Driver_Version_Main,Driver_Version_Sub]);
      end;
   Form_Main.Update;
   end;
end;

procedure TForm_Main.WriteErrorCode(Sender: TObject);
begin
(Sender as TMemo).Lines.Add(Format('<<<< ERROR, CODE 0x%2X >>>>',[errorcode]));
end;

{-----------------------------------------------------------------------------}
{-----------------------------------------------------------------------------}
{-- ffnet Dialog fr Schnittstellenauswahl, wenn ok, dann Ende Programm------}
{-----------------------------------------------------------------------------}
{-----------------------------------------------------------------------------}
procedure TForm_Main.Menu_PortSettingsClick(Sender: TObject);
begin
Form_SelectPort.Showmodal;
if Form_SelectPort.ModalResult=mrOk then
   Form_Main.Close;
end;

{-----------------------------------------------------------------------------}
{--Programm beenden, Schnittstelle schliessen---------------------------------}
{-----------------------------------------------------------------------------}
procedure TForm_Main.Menu_QuitClick(Sender: TObject);
begin
Form_Main.Close;
end;

{-------Funktionen Prfung, ob kleine Schriftarten installiert    ------}
function Smallfonts : Boolean;
var dc : hdc;
begin
dc:=GetDC(0);
Result:=(GetDeviceCaps(dc,LOGPIXELSX)=96);
ReleaseDC(0,DC);
end;

{-----------------------------------------------------------------------------}
{--FormCreate : Fenstergroesse bei Large Fonts anpassen-----------------------}
{-----------------------------------------------------------------------------}
procedure TForm_Main.FormCreate(Sender: TObject);
var DC : HDC;
begin
if (not SmallFonts) then
   begin
   DC:=GETDC(0);
   Self.ScaleBy(96,GetDeviceCaps(DC, LOGPIXELSX));
   ReleaseDC(0,DC);
   Refresh;
   end;
start_status:=true;
end;


{-----------------------------------------------------------------------------}
{--StatusBar neu zeichnen, wenn USB gewhlt und Statusnderung----------------}
{-----------------------------------------------------------------------------}
procedure TForm_Main.StatusBar_FormMainDrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
begin
end;

{-----------------------------------------------------------------------------}
{--Gre der Status-Panels anpassen, wenn Formular-Zoom-----------------------}
{-----------------------------------------------------------------------------}
procedure TForm_Main.FormResize(Sender: TObject);
begin
StatusBar_FormMain.Panels[0].Width:=form_Main.Width-80;
end;



procedure TForm_Main.Timer_ReadIdTimer(Sender: TObject);
var id : integer;
    id_array : array[0..8] of byte;
begin
{Port-Status checken}
If(c_get_handle()=INVALID_HANDLE_VALUE) then
                                        begin
                                        StatusBar_FormMain.SimpleText:='Port not valid...';
                                        StatusBar_FormMain.Repaint;              {Neuzeichnen Statusbar, wenn Status gendert}
                                        exit;
                                        end;
//Reader-ID lesen und im StatusBar anzeigen
if (bool(iid3000_reader_read_id(m_HCom,@id,@id_array))) then
   begin
   Form_Main.StatusBar_FormMain.SimpleText:=Format('Ready. No reader detected, iID Driver 3000 version: %d.%d',[Driver_Version_Main,Driver_Version_Sub]);
   end
   else
   begin
   Form_Main.StatusBar_FormMain.SimpleText:=Format('Ready. Reader-ID: %d, iID Driver 3000 version: %d.%d',[id,Driver_Version_Main,Driver_Version_Sub]);
   end;
StatusBar_FormMain.Repaint;                 {Neuzeichnen Statusbar}
end;

procedure TForm_Main.BitBtn_CancelClick(Sender: TObject);
begin
cancelread:=true;
end;

procedure TForm_Main.PageControl_MainChange(Sender: TObject);
begin
cancelread:=true;
end;

procedure TForm_Main.BitBtn_ExecuteClick(Sender: TObject);
var       i                   : integer;
          strg                : string;
          id                  : integer;
          param               : byte;
          data                : double;
begin
for i:=1 to sizeof(writebuf) do writearray[i]:=writebuf[i];
cancelread:=false;
Memo_Result.Lines.Add('');
case ListBox_Op.ItemIndex of
     0 : begin
         //READ INTERFACE-ID
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=iid3000_reader_read_id(m_HCom,@id,@readarray);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  strg:='';
                  for i:=1 to 8 do strg:=strg+Format('%x ',[readarray[i]]);
                  memo_result.Lines.add('Operation result (hex) was '+strg+'.');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     1:  begin
         //SET AUTO_OFF
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=iid3000_reader_set_auto_off(m_HCom,writearray[1]);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  strg:='';
                  for i:=1 to 1 do strg:=strg+Format('%x ',[writearray[i]]);
                  memo_result.Lines.add('Written (HEX) : '+strg+'.');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     2:  begin
         //SLEEP_ON
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=iid3000_reader_sleep_on(m_HCom);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  memo_result.Lines.add('Interface switched into SLEEP mode.');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     4 : begin
         //READ RO-CODE
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=iidl_read_ro(m_HCom,@readarray);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  strg:='';
                  for i:=1 to 8 do strg:=strg+Format('%x ',[readarray[i+1]]);
                  memo_result.Lines.add('Operation result (hex) was '+strg+'.');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     5 : begin
         if (BYTE(checkBox_Lock.Checked)=1) then
            begin
            ergeb:=Application.MessageBox('Do you really want to lock?','Attention',MB_YESNO);
            if (ergeb=ID_NO) then exit;
            end;
         //WRITE RO-CODE
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=iidl_write_ro(m_HCom,@writearray,BYTE(CheckBox_Lock.Checked));
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  strg:='';
                  for i:=1 to 4 do strg:=strg+Format('%x ',[writearray[i]]);
                  memo_result.Lines.add('Written (hex): '+strg+'.');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     6 : begin
         //READ BLOCK
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=iidl_read_block(m_HCom,combobox_address.ItemIndex,@readarray);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  strg:='';
                  for i:=1 to 4 do strg:=strg+Format('%x ',[readarray[i+1]]);
                  memo_result.Lines.add('Operation result (HEX) was '+strg+'.');
                  strg:='';
                  for i:=1 to 4 do if (readarray[i]<>0) then strg:=strg+Chr(readarray[i+1]);
                  memo_result.Lines.add('Operation result (ASCII) was '+strg+'.');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     7 : begin
         if (checkBox_Lock.Checked) then
            begin
            ergeb:=Application.MessageBox('Do you really want to lock?','Attention',MB_YESNO);
            if (ergeb=ID_NO) then exit;
            end;
         //WRITE BLOCK
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=iidl_write_block(m_HCom,combobox_address.ItemIndex,@writearray, BYTE(CheckBox_Lock.Checked));
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  strg:='';
                  for i:=1 to 4 do strg:=strg+Format('%x',[writearray[i]]);
                  memo_result.Lines.add('Written (HEX) : '+strg+'.');
                  memo_result.Lines.add('Written (ASCII) : '+Edit_TextToWrite.Text+'.');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     9 : begin
         //READ BLOCK_EE
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=iidl_read_block_ee(m_HCom,combobox_address.ItemIndex,@readarray);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  strg:='';
                  for i:=1 to 16 do strg:=strg+Format('%x',[readarray[i+1]]);
                  memo_result.Lines.add('Operation result (HEX) was '+strg+'.');
                  strg:='';
                  for i:=1 to 16 do if (readarray[i]<>0) then strg:=strg+Chr(readarray[i+1]);
                  memo_result.Lines.add('Operation result (ASCII) was '+strg+'.');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     10 : begin
         //WRITE BLOCK_EE
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=iidl_write_block_ee(m_HCom,combobox_address.ItemIndex,@writearray);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  strg:='';
                  for i:=1 to 16 do strg:=strg+Format('%x',[writearray[i]]);
                  memo_result.Lines.add('Written (HEX) : '+strg+'.');
                  memo_result.Lines.add('Written (ASCII) : '+Edit_TextToWrite.Text+'.');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     11: begin
         //READ BLOCK_EE_64
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               if (@iidl_read_block_ee_64=nil) then exit;
               errorcode:=iidl_read_block_ee_64(m_HCom,combobox_address.ItemIndex,@readarray);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  strg:='';
                  for i:=1 to 64 do if (readarray[i]<>0) then strg:=strg+Chr(readarray[i+1]);
                  memo_result.Lines.add('Operation result (ASCII) was '+strg+'.');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     12: begin
         //WRITE BLOCK_EE_64
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=iidl_write_block_ee_64(m_HCom,combobox_address.ItemIndex,@writearray);
               memo_result.Lines.add(Format('%d msec',[GetTickCount-wait]));
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  memo_result.Lines.add('Written (ASCII) : '+Edit_TextToWrite.Text+'.');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     13: begin
         //READ BLOCK_EE_128
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=iidl_read_block_ee_128(m_HCom,combobox_address.ItemIndex,@readarray);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  strg:='';
                  for i:=1 to 128 do if (readarray[i]<>0) then strg:=strg+Chr(readarray[i+1]);
                  memo_result.Lines.add('Operation result (ASCII) was '+strg+'.');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     14: begin
         //WRITE BLOCK_EE_128
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=iidl_write_block_ee_128(m_HCom,combobox_address.ItemIndex,@writearray);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  memo_result.Lines.add('Written (ASCII) : '+Edit_TextToWrite.Text+'.');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     16: begin
         //READ IN
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=iidl_read_in(m_HCom,@param);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  checkbox_in0.Checked:=false;
                  checkbox_in1.Checked:=false;
                  checkbox_in2.Checked:=false;
                  checkbox_in3.Checked:=false;
                  if bool(param and $20) then checkbox_in0.Checked:=true;
                  if bool(param and $10) then checkbox_in1.Checked:=true;
                  if bool(param and $08) then checkbox_in2.Checked:=true;
                  if bool(param and $04) then checkbox_in3.Checked:=true;
                  memo_result.Lines.add('Operation successfull, see "Read In" for result...');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     17: begin
         //READ IN 2
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=iidl_read_in2(m_HCom,@param);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  checkbox_in0.Checked:=false;
                  checkbox_in1.Checked:=false;
                  checkbox_in2.Checked:=false;
                  checkbox_in3.Checked:=false;
                  if bool(param and $1) then checkbox_in0.Checked:=true;
                  if bool(param and $2) then checkbox_in1.Checked:=true;
                  memo_result.Lines.add('Operation successfull, see "Read In" for result...');
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
      18: begin
         //SET OUT
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               param:=0;
               if Checkbox_out0.checked then param:=param or $02;
               if Checkbox_out1.checked then param:=param or $01;
               errorcode:=iidl_set_out(m_HCom,param);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  memo_result.Lines.add(Format('Out parameter 0x%x has been set.',[param]))
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
      19: begin
         //SET OUT 2
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               param:=0;
               if Checkbox_out0.checked then param:=param or $02;
               if Checkbox_out1.checked then param:=param or $01;
               errorcode:=iidl_set_out2(m_HCom,param);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  memo_result.Lines.add(Format('Out parameter 0x%x has been set.',[param]))
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end;
     21: begin
         //READ TEMPERATURE TELID211
         while (not cancelread) do
               begin
               if (memo_result.Lines.count>100) then memo_result.Clear;
               wait:=gettickcount();
               errorcode:=get_temperature_telid21x(m_HCom,@data,@readarray);
               if (bool(errorcode)) then
                  Form_Main.WriteErrorCode(Memo_result)
                  else
                  begin
                  memo_result.Lines.add(Format('Temperature %3.1fC read from TELID21x.',[data]));
                  end;
               if (checkbox_cycle.checked=false) then cancelread:=true;
               repeat
                     Application.ProcessMessages();
               until (gettickcount()>wait+(TrackBar_SamplingRate.Position * 10));
               end;
         end
         else
         begin
         //If other Line selected do nothing, but clear last line...
         Memo_Result.Lines.Delete(Memo_Result.Lines.Count-1);
         end;
     end;
end;

procedure TForm_Main.UpdateSendString(Sender: TObject);
var counter : integer;
begin
if (Sender.ClassName='TCrossEdit') then
   begin
   writebuf[(Sender as TCrossEdit).Tag]:=(Sender as TCrossEdit).GetInteger;
   end
   else
   begin
   for counter:=1 to sizeof(writebuf) do writebuf[counter]:=0;
   counter:=0;
   while (counter<(length((Sender as TEdit).Text))) do
         begin
         writebuf[counter+1]:=Ord((Sender as TEdit).Text[counter+1]);
         inc(counter);
         end;
   CrossEdit1.SetInteger(writebuf[1]);
   CrossEdit2.SetInteger(writebuf[2]);
   CrossEdit3.SetInteger(writebuf[3]);
   CrossEdit4.SetInteger(writebuf[4]);
   CrossEdit5.SetInteger(writebuf[5]);
   CrossEdit6.SetInteger(writebuf[6]);
   CrossEdit7.SetInteger(writebuf[7]);
   CrossEdit8.SetInteger(writebuf[8]);
   CrossEdit9.SetInteger(writebuf[9]);
   CrossEdit10.SetInteger(writebuf[10]);
   CrossEdit11.SetInteger(writebuf[11]);
   CrossEdit12.SetInteger(writebuf[12]);
   CrossEdit13.SetInteger(writebuf[13]);
   CrossEdit14.SetInteger(writebuf[14]);
   CrossEdit15.SetInteger(writebuf[15]);
   CrossEdit16.SetInteger(writebuf[16]);
   CrossEdit17.SetInteger(writebuf[9]);
   CrossEdit18.SetInteger(writebuf[10]);
   CrossEdit19.SetInteger(writebuf[11]);
   CrossEdit20.SetInteger(writebuf[12]);
   CrossEdit21.SetInteger(writebuf[13]);
   CrossEdit22.SetInteger(writebuf[14]);
   CrossEdit23.SetInteger(writebuf[15]);
   CrossEdit24.SetInteger(writebuf[16]);
   end;
counter:=0;
Edit_TextToWrite.Text:='';
while (counter<sizeof(writebuf)) do
      begin
      Edit_TextToWrite.Text:=Edit_TextToWrite.Text+Chr(writebuf[counter+1]);
      inc(counter)
      end;
end;

procedure TForm_Main.Button_AcceptTextClick(Sender: TObject);
begin
UpdateSendString(Edit_TextToWrite);
end;

procedure TForm_Main.Button_ClearMemoClick(Sender: TObject);
begin
Memo_Result.Clear();
end;


end.
