unit Selectport_old;
{----------------------------------------------------------------}
{--Aktualisierung fr selectComport, hier wird USB-Auswahl mit---}
{--angezeigt (entspricht COM5)-----------------------------------}
{----------------------------------------------------------------}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, main, ComCtrls;

function StoreComport : boolean;
function LoadComport:boolean;

type
  TForm_SelectPort = class(TForm)
    Label_Text1: TLabel;
    Label_Text2: TLabel;
    BitBtn_Save: TBitBtn;
    BitBtn_Cancel: TBitBtn;
    RadioGroup_Port: TRadioGroup;
    BitBtn_DetectInterface: TBitBtn;
    StatusBar: TStatusBar;
    procedure BitBtn_SaveClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RadioGroup_PortClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form_SelectPort: TForm_SelectPort;

var       cancelread : boolean;

implementation

uses globalvar;
// SearchInterface;

{$R *.DFM}


{-----------------------------------------------------------------------------}
{-----------------------------------------------------------------------------}
{----- Ldt aktuellen Com-port aus Datei comport.def , wenn Schreibrechte
 vorhanden --- Variable Comport enthlt die Porteinstellung ------------------}
{-----------------------------------------------------------------------------}
{-----------------------------------------------------------------------------}
function LoadComport:boolean;
begin
{$I-}
LoadComport:=False;
AssignFile(ComPortFile,homedir+'Comport.def');
with portRec do
     begin
     port :=Comport;
     mach :=machine;
     p:=path;
     end;
Reset(ComportFile);
If IOResult<>0 then
               begin
               Rewrite(ComPortFile);
               If IOResult<>0 then
                  begin
                  MessageDlg('Error - No write access on program path'
                  +#13+'- standard port COM 2 selected !', mtConfirmation
                  ,[mbCancel], 0);
                  exit;
                  end {Abbruch, weil keine Schreibrechte auf Programmpfad}
                  else
                  begin
                  Write(ComportFile,PortRec);  {standardmig mit 2 belegen}
                  end;
               end
               else
               begin
               {$I+}
               Seek(ComportFile,0);
               Read(ComportFile,PortRec);
               CloseFile(ComportFile);
               LoadComport:=True;
               end;
with portRec do
     begin
     Comport:=port;
     machine:=mach;
     path:=p;
     end;
end;

{-----------------------------------------------------------------------------}
{-----------------------------------------------------------------------------}
{----- Speichert aktuellen Com-port in Datei comport.def ab, wenn Schreibrechte
 vorhanden --- Variable Comport enthlt die Porteinstellung ------------------}
{-----------------------------------------------------------------------------}
{-----------------------------------------------------------------------------}
function StoreComport : boolean;
begin
{$I-}
storeComport:=false;
with portRec do
     begin
     port :=Comport;
     mach :=machine;
     p:=path;
     end;
AssignFile(ComPortFile,homedir+'Comport.def');
Rewrite(ComPortFile);
If IOResult<>0 then
               begin
               MessageDlg('Error - No write access on program path'
               +#13+'- unable to save settings !', mtConfirmation
               ,[mbCancel], 0);
               {$I+}
               exit;
               end {Abbruch, weil keine Schreibrechte auf Programmpfad}
               else
               begin
               Write(ComportFile,PortRec);
               CloseFile(ComportFile);
               StoreComport:=true;
               end;
end;


procedure TForm_SelectPort.BitBtn_SaveClick(Sender: TObject);
begin
StoreComport;
Showmessage(
'Settings changed.The Program should become closed now and must be restarted.');
comport:=radiogroup_port.itemindex+1;
Application.Terminate;
end;

procedure TForm_SelectPort.FormActivate(Sender: TObject);
begin
RadioGroup_Port.ItemIndex:=1;
LoadComport;
if ((comport>=1) and (comport<=9)) then RadioGroup_Port.ItemIndex:=comport-1;
StatusBar.SimpleText:='Interface ' + Radiogroup_Port.Items[Radiogroup_Port.ItemIndex]+' selected ...';
modalresult:=mrOK;
end;

procedure TForm_SelectPort.FormCreate(Sender: TObject);
var DC : HDC;
begin
if (not SmallFonts) then
   begin
   DC:=GETDC(0);
   Self.ScaleBy(96,GetDeviceCaps(DC, LOGPIXELSX));
   ReleaseDC(0,DC);
   Refresh;
   end;
end;

procedure TForm_SelectPort.RadioGroup_PortClick(Sender: TObject);
begin
StatusBar.SimpleText:='Interface ' + Radiogroup_Port.Items[Radiogroup_Port.ItemIndex]+' selected ...';
comport:=Radiogroup_Port.ItemIndex+1;
end;

end.
