#ifndef iiddrv_20_InterfaceH
#define iiddrv_20_InterfaceH

//-------------------------------------------------------------
//Header-File for partial implementation of iiddrv_20.dll------
//-------------------------------------------------------------
//-authors: SJ/ MSS--------------------------------------------
//-last modified: 2007-01-20-----------------------------------
//-------------------------------------------------------------
	

//constants for setting masks for iID driver functions 
const	BYTE GROUP_ISO15693 = 1;
const	BYTE GROUP_ICODE1   = 2;
const   BYTE GROUP_IID_D    = 4;
const   BYTE GROUP_IID_G	   = 8;
const   BYTE GROUP_64BITRO  = 0x10;	
const   BYTE GROUP_ICODEUID = 0x20;	

//define DLL-functions 
typedef HANDLE	(CALLBACK* MP_reader_open_interface) (LPTSTR lpszPort);
typedef BYTE	(CALLBACK* MP_reader_close_interface) (HANDLE hPort);
typedef HANDLE	(CALLBACK* MP_reader_get_port_state) (HANDLE hPort);
typedef BYTE	(CALLBACK* MP_reader_set_port_type) (BYTE porttype, LPTSTR lpszPort);
typedef BYTE	(CALLBACK* MP_reader_set_interface_type) (INT32 frequency);

typedef HANDLE  (CALLBACK* MP_reader_get_handle) ();
typedef BYTE    (CALLBACK* MP_driver_set_timeout) (INT32 NewTimeOut);
typedef INT32   (CALLBACK* MP_driver_get_timeout) ();
typedef BYTE    (CALLBACK* MP_driver_set_system_mask) (INT32 NewMask);
typedef INT32   (CALLBACK* MP_driver_get_system_mask) ();
typedef BYTE	(CALLBACK* MP_driver_get_driver_version)  (INT32* main_version, INT32* sub_version);

//type definitions for iid-driver-specification
typedef BYTE (CALLBACK* MP_initialize) ();
typedef BYTE (CALLBACK* MP_terminate) ();
typedef BYTE (CALLBACK* MP_readBytes) (BYTE identifier[],INT32 from,INT32 length,BYTE *pByteArray);
typedef BYTE (CALLBACK* MP_writeBytes) (BYTE identifier[],INT32 from,INT32 length,BYTE *pByteArray, BYTE lock);
typedef BYTE (CALLBACK* MP_identify) (BYTE *pByteArray);
typedef BYTE (CALLBACK* MP_read_reader_id) (INT32* reader_id, BYTE *pByteArray);
typedef BYTE (CALLBACK* MP_c_get_temperature) (double *temp,BYTE *pByteArray);
typedef BYTE (CALLBACK* MP_c_get_transponder_parameters) (INT32 *ptagtype, INT32 *pmaxlength, INT32 *tagsystem, INT32 *pxtraparam, BYTE *piIDByteArray);	

//PEN BT-mem specific functions
typedef BYTE (CALLBACK* MP_mem_c_read_datacount) (HANDLE m_HCom,INT32 *mem_counter,INT32 *com_count);
typedef BYTE (CALLBACK* MP_mem_c_reset_datacount) (HANDLE m_HCom);
typedef BYTE (CALLBACK* MP_mem_c_read_dataset) (HANDLE m_HCom,INT32 *datatype, INT32 *mem_counter, BYTE *pByteArray);

//ISO15693 specific commands
typedef BYTE    (CALLBACK* MP_iso15693_set_myd_custom_mode) (BYTE EnableMode);

//necessary for emulation
typedef int (CALLBACK* MP_emul_On) ();
typedef int (CALLBACK* MP_emul_Off) ();
typedef int (CALLBACK* MP_tagAppeared) ();
typedef int (CALLBACK* MP_tagDisappeared) ();

//Variables
static MP_reader_open_interface PROC_reader_openinterface;
static MP_reader_close_interface PROC_reader_closeinterface;
static MP_reader_get_port_state PROC_reader_get_port_state;
static MP_reader_set_port_type PROC_reader_set_port_type;
static MP_reader_set_interface_type PROC_reader_set_interface_type;
static MP_reader_get_handle PROC_reader_get_handle;
static MP_driver_set_timeout PROC_driver_set_timeout;
static MP_driver_get_timeout PROC_driver_get_timeout;
static MP_driver_set_system_mask PROC_driver_set_system_mask;
static MP_driver_get_system_mask PROC_driver_get_system_mask;
static MP_driver_get_driver_version PROC_driver_get_driver_version;
static MP_c_get_temperature PROC_get_temperature;
static MP_c_get_transponder_parameters PROC_c_get_transponder_parameters;

//functions for iid-driver-specification
static MP_initialize PROC_initialize;
static MP_terminate PROC_terminate;
static MP_readBytes PROC_readBytes;
static MP_writeBytes PROC_writeBytes;
static MP_identify PROC_identify;
static MP_read_reader_id PROC_read_reader_id;
//PEN BT-mem specific functions
static MP_mem_c_read_datacount PROC_mem_c_read_datacount;
static MP_mem_c_reset_datacount PROC_mem_c_reset_datacount;
static MP_mem_c_read_dataset PROC_mem_c_read_dataset;
//ISO15693 specific commands
static MP_iso15693_set_myd_custom_mode PROC_iso15693_set_myd_custom_mode;
//necessary for emulation
static MP_emul_On PROC_emul_On;
static MP_emul_Off PROC_emul_Off;
static MP_tagAppeared PROC_tagAppeared;
static MP_tagDisappeared PROC_tagDisappeared;

//global variables e.g. for startup status		
static	BOOL	startup			 = TRUE;
static  BYTE	UIDARRAY[8];
	
//define functions for port and data handling
BOOL Init_Driver();
BOOL InitializePort(BYTE PortType, LPTSTR PortName);
BOOL ClosePort();
BOOL ReadID();
BOOL ReadUID();
BOOL GetTransponderParameters();
BOOL WriteBytes();
BOOL ReadBytes();
BOOL GetTemperature();

#endif
