UNIT cnt_2;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Counter Program                                       }
{                                                       }
{ V 1.00                                                }
{ Okt 1997                                              }
{-------------------------------------------------------}

{$N+,E+}
{$V+}
{$R+}

interface

uses crt,graph,cnt_0,cnt_1,IK410_0,IK410_1,IK410_2,adj_0,scope_0,poti_0;

procedure display_panel(count:count_pointr);
procedure menu(var restart:boolean;count:count_pointr);

implementation

var
 i                                   : byte;
 tfile                               : Text;
 mwin                                : wpointr;
 win                                 : array[0..10] of wpointr;
 hmwin                               : hpointr;
 hwin                                : array[0..10] of hpointr;
 winvector                           : cpointr;
 text                                : string;
 buffer                              : integer;
 hardware                            : boolean;
 hw                                  : string4;
 refmark0,refmark1                   : comp;
 printval                            : string;
(**********************************************************)
procedure range(var wert:integer;min,max:word);
begin
  if wert>max then wert:=max;
  if wert<min then wert:=min;
end;
(**********************************************************)
(*$I IK410.win*)
(*$I IK410.hlp*)
(**********************************************************)
procedure draw_mainwin(count:count_pointr);
begin
  (* Main window *)
  setcolor(4);
  rectangle(mwin^.x+8,mwin^.y+21,mwin^.x+mwin^.dx-8,mwin^.y+41);
  moveto((mwin^.x+mwin^.dx div 3),mwin^.y+8);
  setcolor(15);
  outtext('DR. JOHANNES HEIDENHAIN GmbH');
  setcolor(2);
  rectangle(mwin^.x+6,count^.count^.win_ypos-20,mwin^.x+mwin^.dx-6,mwin^.y+mwin^.dy-30);
  bar(mwin^.x+6,count^.count^.win_ypos-20,mwin^.x+mwin^.dx-6,mwin^.y+mwin^.dy-30);
  setcolor(15);
  moveto(mwin^.x+8,mwin^.y+mwin^.dy-16);
  outtext('F1=Help');
  moveto(mwin^.x+130,mwin^.y+mwin^.dy-16);
  outtext('ESC=Close window');
  moveto(mwin^.x+320,mwin^.y+mwin^.dy-16);
  outtext('F10=Quit');

end;
(**********************************************************)
procedure init_counter(count:count_pointr);
  BEGIN

  init_IK410(count^.board);
  read_count(count);

  (* Any hardware? *)
  hardware:=look_for_IK410(count^.board);

  count^.count^.win_xpos:=mwin^.x+25;
  count^.count^.win_ypos:=mwin^.y+mwin^.dy-160;

  if hardware then
    begin
      count^.board^.inimain.mode1024:=true;
      count^.board^.inimain.en_timer:=true;
      count^.board^.timer:=$FFFF;
      count^.board^.inilatch.en_timer_reg0:=true;
      count^.board^.inisync.en_timer_axis2:=true;  (* Timer on cascaded axis *)
      count^.board^.inimain.sel_ri_1st:=true;
      count^.board^.inimain.sel_ri_2nd:=true;

      count^.board^.softcomm.stop:=true;
      count^.board^.softcomm.clear:=true;
      count^.board^.softcomm.latch0:=true;
      count^.board^.softcomm.clrfreq:=true;
      count^.board^.softcomm.clrstat:=true;

      Init_Handler(count^.board);
      Comm_Handler(count^.board);

      case count^.count^.refmark of
      0 :
        begin
          count^.board^.softcomm.start:=true;
          count^.board^.softcomm.clear:=true;
        end;
      1 :
        begin
          count^.board^.refcomm.ristart:=true;
          count^.board^.refcomm.riclear:=true;
        end;
      2 :
        begin
          count^.board^.refcomm.ristart:=true;
          count^.board^.refcomm.riclear:=true;
          count^.board^.refcomm.rilatch2:=true;
        end;
      end;

      Comm_Handler(count^.board);

    end;
end;
(**********************************************************)
procedure display_panel(count:count_pointr);
begin
  read_reg0(count^.board);           (* Timer latches *)
  Build_Countwert(count^.board,count^.count);
  count_display(count^.count);
  read_count_status(count^.board);
  read_signal_status(count^.board);
  status_display(count^.board,count^.count);
end;
(**********************************************************)
procedure menu(var restart:boolean;count:count_pointr);
begin
  New(winvector);
  New(mwin);
  for i:=0 to 10 do
    begin
      New(win[i]);
    end;
  New(hmwin);
  for i:=0 to 10 do
    begin
      New(hwin[i]);
    end;

  init_mainwin;
  init_counter(count);
  init_windows(count);
  init_help;

  winvector^.enmouse:=mousedriver;
  winvector^.window:=mwin;
  init_defaults(winvector);
  open_window(winvector^.window);
  winvector^.x:=35;
  winvector^.y:=40;
  setmousepos(winvector);
  draw_cursor(winvector);
  draw_mainwin(count);

  count_back(count^.count);
  count_display(count^.count);
  status_back(count^.count);

  if not(hardware) then
    begin
      moveto(100,120);
      setcolor(4);
      settextstyle(0,0,3);
      outtext('NO HARDWARE!!');
      moveto(100,150);
      settextstyle(0,0,1);
      outtext('Press Return - Run INSTALL.EXE');
      readln;
      moveto(100,120);
      setcolor(15);
      settextstyle(0,0,3);
      outtext('NO HARDWARE!!');
      moveto(100,150);
      settextstyle(0,0,1);
      outtext('Press Return - Run INSTALL.EXE');
    end;

  if count^.printer=druck_lpt1 then
    begin
      Assign(tfile,'LPT1');
      (*$I-*)
      Rewrite(tfile);
      (*$I+*)
    end;
  if count^.printer=druck_lpt2 then
    begin
      Assign(tfile,'LPT2');
      (*$I-*)
      Rewrite(tfile);
      (*$I+*)
    end;
  if count^.printer=druck_file then
    begin
      Assign(tfile,'IK410.DAT');
      (*$I-*)
      Rewrite(tfile);
      (*$I+*)
    end;

  while not(winvector^.exit) do
    begin

      win_handler(winvector);

      case winvector^.proc_sel of
        1 :  begin   (* Save *)
               write_count(count);
               write_adr(count^.board^.baseadr);
             end;
        2 :  begin   (* Preset X *)
               i:=count^.count^.dimension;
               count^.count^.preset[i]:=-(count^.count^.position-
                                           count^.count^.preset[i])+
                                           winvector^.wert;
               write_count(count);  (* V1.02 *)
             end;
        4 :  begin    (* Basic address *)
               buffer:=round(winvector^.wert);
               range(buffer,0,1024);
               buffer:=buffer and $0FF0;
               count^.board^.baseadr:=buffer;
               word_hex(buffer,hw);
               win[6]^.zeile[1].lines:='Base addr.: '+hw[4]+hw[3]+hw[2]+hw[1]+'H';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
               write_count(count);  (* V1.02 *)
               write_adr(count^.board^.baseadr);
             end;
        5 :  begin    (* Resolution axis 1 *)
               buffer:=round(winvector^.wert);
               range(buffer,0,10000);
               if buffer<>0 then count^.count^.resolution:=buffer;
               str(buffer,text);
               win[4]^.zeile[1].lines:='Resol.: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
               write_count(count);  (* V1.02 *)
             end;
        6 :  begin    (* Period axis 1 *)
               buffer:=round(winvector^.wert);
               range(buffer,1,1000);
               count^.count^.periode:=buffer;
               str(buffer,text);
               win[4]^.zeile[2].lines:='Period: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
               write_count(count);  (* V1.02 *)
             end;
        7 :  begin    (* Reference-pulse axis 1 *)
               buffer:=round(winvector^.wert);
               range(buffer,0,2);
               count^.count^.refmark:=buffer;
               str(buffer,text);
               win[4]^.zeile[3].lines:='Ref. marks: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
               write_count(count);  (* V1.02 *)
             end;
         8 : begin
               if count^.board^.z1spur then
                 begin
                   count^.board^.z1spur:=false;
                   win[5]^.zeile[1].lines:='Z1 : off';
                 end
               else
                 begin
                   count^.board^.z1spur:=true;
                   win[5]^.zeile[1].lines:='Z1 : on';
                 end;
               switch_z1(count^.board^.baseadr,count^.board^.z1spur);
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        11 : begin
               if count^.printer<>none then
                 (* $I-*)
                 close(tfile);
                 (* $I+*)
               count^.printer:=none;
               win[7]^.zeile[2].lines:='LPT1: off';
               win[7]^.zeile[3].lines:='LPT2: off';
               win[7]^.zeile[4].lines:='File: off';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
               write_count(count);  (* V1.02 *)
             end;
        12 : begin (* LPT1 *)
               if count^.printer<>none then
                 begin
                   (*$I-*)
                   close(tfile);
                   (*$I+*)
                 end;
               Assign(tfile,'LPT1');
               (*$I-*)
               Rewrite(tfile);
               (*$I+*)
               if ioresult=0 then
                 begin
                   count^.printer:=druck_lpt1;
                   win[7]^.zeile[2].lines:='LPT1: on';
                   win[7]^.zeile[3].lines:='LPT2: off';
                   win[7]^.zeile[4].lines:='File: off';
                   draw_cursor(winvector);
                   refresh_window(winvector^.window);
                   draw_cursor(winvector);
                 end;
               write_count(count);  (* V1.02 *)
             end;
        13 : begin (* LPT2 *)
               if count^.printer<>none then
                 begin
                   (*$I-*)
                   close(tfile);
                   (*$I+*)
                 end;
               Assign(tfile,'LPT2');
               (*$I-*)
               Rewrite(tfile);
               (*$I+*)
               if ioresult=0 then
                 begin
                   count^.printer:=druck_lpt2;
                   win[7]^.zeile[2].lines:='LPT1: off';
                   win[7]^.zeile[3].lines:='LPT2: on';
                   win[7]^.zeile[4].lines:='File: off';
                   draw_cursor(winvector);
                   refresh_window(winvector^.window);
                   draw_cursor(winvector);
                 end;
               write_count(count);  (* V1.02 *)
             end;
        14 : begin (* File *)
               if count^.printer<>none then
                 begin
                   (*$I-*)
                   close(tfile);
                   (*$I+*)
                 end;
               Assign(tfile,'IK410.DAT');
               (*$I-*)
               Rewrite(tfile);
               (*$I+*)
               if ioresult=0 then
                 begin
                   count^.printer:=druck_file;
                   win[7]^.zeile[2].lines:='LPT1: off';
                   win[7]^.zeile[3].lines:='LPT2: off';
                   win[7]^.zeile[4].lines:='File: on';
                   draw_cursor(winvector);
                   refresh_window(winvector^.window);
                   draw_cursor(winvector);
                 end;
               write_count(count);  (* V1.02 *)
             end;
        15 : begin  (* Print *)
               moveto(100,150);
               settextstyle(0,0,1);
               setcolor(4);
               if count^.printer=druck_lpt2 then outtext('Printing to LPT2');
               if count^.printer=druck_lpt1 then outtext('Printing to LPT1');
               if count^.printer=druck_file then outtext('Printing to IK410.DAT');
               if count^.printer=none then outtext('No print device');
               sound(100);
               if count^.printer<>none then
                 begin
                   (*$I-*)
                   str(count^.count^.position:10:count^.count^.digits,printval);
                   writeln(tfile,' X: ',printval);
                   (*$I+*)
                 end;
               delay(500);
               nosound;
               moveto(100,150);
               setcolor(15);
               if count^.printer=druck_lpt2 then outtext('Printing to LPT2');
               if count^.printer=druck_lpt1 then outtext('Printing to LPT1');
               if count^.printer=druck_file then outtext('Printing to IK410.DAT');
               if count^.printer=none then outtext('No print device');
             end;
        16 : begin  (* Reference axis 1 *)
               for i:=1 to 4 do
               count^.count^.preset[i]:=0;
               if count^.count^.refmark=1 then
                 begin
                   count^.board^.refcomm.ristart:=true;
                   count^.board^.refcomm.riclear:=true;
                   Comm_handler(count^.board);
                 end;
               if count^.count^.refmark=2 then
                 begin
                   count^.board^.refcomm.ristart:=true;
                   count^.board^.refcomm.riclear:=true;
                   count^.board^.refcomm.rilatch2:=true;
                   Comm_handler(count^.board);
                 end;
             end;
        18 : begin
               adj(count^.board);
               restart:=true;
               winvector^.act_sel:=13;   (* Exit *)
             end;
        19 : begin
               oszi(count^.board);
               restart:=true;
               winvector^.act_sel:=13;   (* Exit *)
             end;
        20:  begin    (* Reset axis 1 *)
               i:=count^.count^.dimension;
               count^.count^.preset[i]:=-(count^.count^.position-
                                             count^.count^.preset[i]);
             end;
        22 : begin     (* Number of digits axis 1 *)
               buffer:=round(winvector^.wert);
               range(buffer,1,5);
               count^.count^.digits:=buffer;
               str(buffer,text);
               win[4]^.zeile[4].lines:='Digits: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
               write_count(count);
               restart:=true;
               winvector^.act_sel:=13;   (* Exit *)
               write_count(count);  (* V1.02 *)
             end;
        24 : begin  (* Min. axis 1 *)
               count^.count^.lbound:=winvector^.wert;
               str(count^.count^.lbound:5:5,text);
               win[8]^.zeile[1].lines:='Min X: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
               write_count(count);  (* V1.02 *)
             end;
        25 : begin  (* Max. axis 1 *)
               count^.count^.hbound:=winvector^.wert;
               str(count^.count^.hbound:5:5,text);
               win[8]^.zeile[2].lines:='Max X: '+text;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
               write_count(count);  (* V1.02 *)
             end;
        28 : begin  (* Dimension 1 axis 1 *)
               count^.count^.dimension:=1;
               win[9]^.zeile[1].lines:='X datum 1: on';
               win[9]^.zeile[2].lines:='X datum 2:';
               win[9]^.zeile[3].lines:='X datum 3:';
               win[9]^.zeile[4].lines:='X datum 4:';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        29 : begin  (* Dimension 2 axis 1 *)
               count^.count^.dimension:=2;
               win[9]^.zeile[1].lines:='Y datum 1:';
               win[9]^.zeile[2].lines:='Y datum 2: on';
               win[9]^.zeile[3].lines:='Y datum 3:';
               win[9]^.zeile[4].lines:='Y datum 4:';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        30 : begin  (* Dimension 3 axis 1 *)
               count^.count^.dimension:=3;
               win[9]^.zeile[1].lines:='X datum 1:';
               win[9]^.zeile[2].lines:='X datum 2:';
               win[9]^.zeile[3].lines:='X datum 3: on';
               win[9]^.zeile[4].lines:='X datum 4:';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        31 : begin  (* Dimension 4 axis 1 *)
               count^.count^.dimension:=4;
               win[9]^.zeile[1].lines:='X datum 1:';
               win[9]^.zeile[2].lines:='X datum 2:';
               win[9]^.zeile[3].lines:='X datum 3:';
               win[9]^.zeile[4].lines:='X datum 4: on';
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
             end;
        36 : begin  (* Min-mode axis 1 *)
               if count^.count^.mode=min then
                 begin
                   win[10]^.zeile[1].lines:='X min: off';
                   win[10]^.zeile[2].lines:='X max: off';
                   count^.count^.mode:=pos;
                   count^.count^.min:=1000000;
                 end
               else
                 begin
                   win[10]^.zeile[1].lines:='X min: on';
                   win[10]^.zeile[2].lines:='X max: off';
                   count^.count^.mode:=min;
                   count^.count^.min:=1000000;
                 end;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
               write_count(count);  (* V1.02 *)
             end;
        37 : begin  (* Max-mode axis 1 *)
             if count^.count^.mode=max then
                 begin
                   win[10]^.zeile[1].lines:='X min: off';
                   win[10]^.zeile[2].lines:='X max: off';
                   count^.count^.mode:=pos;
                   count^.count^.max:=-1000000;
                 end
               else
                 begin
                   win[10]^.zeile[1].lines:='X min: off';
                   win[10]^.zeile[2].lines:='X max: on';
                   count^.count^.mode:=max;
                   count^.count^.max:=-1000000;
                 end;
               draw_cursor(winvector);
               refresh_window(winvector^.window);
               draw_cursor(winvector);
               write_count(count);  (* V1.02 *)
             end;
        40 : begin
               turnpotis(count^.board);
               restart:=true;
               winvector^.act_sel:=13;   (* Exit *)
             end;
        41 : begin  (* Clear Preset axis 1 *)
               count^.count^.preset[count^.count^.dimension]:=0;
               write_count(count);  (* V1.02 *)
             end;
       100 : begin  (* Restart *)
               restart:=true;
               winvector^.act_sel:=13;   (* Exit *)
             end;
      end;
      winvector^.proc_sel:=0;

      if (hardware) then
        begin
          display_panel(count);

          if count^.count^.refmark=2 then        (* Distance-coded ref. marks *)
            begin
              if (count^.board^.cstatus.latch1) then
                begin
                  Read_Reg1(count^.board);
                  refmark0:=count^.board^.register1;

                  if count^.board^.inimain.mode1024 then
                    begin
                      refmark0:=refmark0/1024;
                    end;

                  if (refmark0>500) then  (* Positive direction *)
                     begin
                       count^.count^.offset:=((refmark0-501)*1000);
                       for i:=1 to 4 do
                       count^.count^.preset[i]:=0;
                     end;
                  if (refmark0<500) and (refmark0>0) then
                     begin
                       count^.count^.offset:=((500-refmark0)*1000)-refmark0;
                       for i:=1 to 4 do
                       count^.count^.preset[i]:=0;
                     end;
                  if (refmark0<-500) then  (* Negative direction *)
                     begin
                       count^.count^.offset:=((-refmark0-501)*1000)-refmark0;
                       for i:=1 to 4 do
                       count^.count^.preset[i]:=0;
                     end;
                  if (refmark0>-500) and (refmark0<0) then
                    begin
                      count^.count^.offset:=((500+refmark0)*1000);
                      for i:=1 to 4 do
                      count^.count^.preset[i]:=0;
                    end;
                  if (refmark0=0) then
                    begin
                      count^.board^.refcomm.ristart:=true;
                      count^.board^.refcomm.riclear:=true;
                      count^.board^.refcomm.rilatch2:=true;
                      Comm_handler(count^.board);
                    end;

                end; (* Latched1 *)
            end; (* Ref2 *)

        end; (* Hardware *)
    end; (* Loop *)

  if count^.printer<>none then
    begin
      (*$I-*)
      close(tfile);
      (*$I+*)
    end;

  for i:=0 to 10 do
    begin
      Dispose(win[i]);
    end;
  Dispose(mwin);
  for i:=0 to 10 do
    begin
      Dispose(hwin[i]);
    end;
  Dispose(hmwin);
  Dispose(winvector);
end;
(*****************************)
end.