UNIT CNT_0;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Window Unit for Counter Program                       }
{                                                       }
{ V 1.00                                                }
{ Okt 1997                                              }
{-------------------------------------------------------}

interface

uses dos,crt,graph;

type
     string4  = string[4];
     string12 = string[12];
     string16 = string[16];

     hpointr = ^helppointr;
     helppointr = array[1..16] of string[32];

     wpointr = ^fenster;
     item   = record
                lines     : string16;        (* Menu line *)
                color     : byte;            (* Color of menu line *)
                invert    : boolean;         (* Frame for lines *)
                x0        : word;            (* Relative pos. X *)
                y0        : word;            (* Relative pos. Y *)
                dx        : word;            (* Active window width *)
                dy        : word;            (* Active window height *)
                kind      : byte;            (* Command type *)
                newpointr : wpointr;         (* Pointer to new window *)
                proc      : byte;            (* Procedure selector *)
              end;
     fenster = record
                main       : boolean;                 (* Main window flag *)
                 x         : word;                    (* Left corner X *)
                 y         : word;                    (* Left corner Y *)
                dx         : word;                    (* Window width *)
                dy         : word;                    (* Window height *)
                header     : string16;                (* Headline *)
                headercolor: byte;                    (* Headline color *)
                items      : byte;                    (* Number of menu items *)
                select     : byte;                    (* Active menu item *)
                activ      : byte;                    (* Active switch *)
                zeile      : array[1..16] of item;    (* Menu text *)
                spointr    : pointer;                 (* Background memory *)
                ssize      : word;                    (* Memory capacity *)
                backpointr : wpointr;                 (* Pointer to previous window *)
                help       : hpointr;                 (* Pointer to help *)
               end;

     cpointr = ^global;
     global    = record
                 window   : wpointr;                  (* Pointer to active window *)
                 x        : word;
                 y        : word;
                 xmax     : word;
                 ymax     : word;
                 xmin     : word;
                 ymin     : word;
                 clickx   : word;
                 clicky   : word;
                 enmouse  : boolean;
                 taste    : word;
                 ltaste   : boolean;
                 mtaste   : boolean;
                 rtaste   : boolean;
                 ltasteoff: boolean;
                 mtasteoff: boolean;
                 rtasteoff: boolean;
                 keycode1 : char;
                 keycode2 : char;
                 wert     : real;
                 enter    : boolean;
                 exit     : boolean;
                 shift    : boolean;
                 proc_sel : byte;     (* Code from xwin to user *)
                 act_sel  : byte;     (* Code from user to xwin *)
                 message  : string16;
                 messpos  : byte;
                 messstat : (edit,backspc,action,standby);
               end;

const
  grau : Fillpatterntype = ($AA,$55,$AA,$55,$AA,$55,$AA,$55);
  schw : Fillpatterntype = ($FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF);

procedure text3d(x,y:word;satz:string);
procedure ctext3d(x,y:word;satz:string;color1,color2:byte);
procedure digit(x,y:word);
procedure digitpos(x,y:word;wert:real;color:byte);
procedure uhr(x,y:word);
procedure uhrpos(x,y:word;wert:real;color:byte);
procedure balken(x,y:word);
procedure anzeige(x,y:word;wert,max,min:real;color:byte);
procedure anzeigepos(x,y:word;wert:real;color:byte);
procedure scale(max,y:word;kind:string);

procedure word_hex(wert:word;var t:string4);
function  mousedriver:boolean;
procedure init_graphic;
procedure init_defaults(pointr:cpointr);
procedure autosize(pointr:wpointr);
procedure Setmousepos(pointr:cpointr);
procedure Use_Mouse(pointr:cpointr);
procedure Use_Key(pointr:cpointr);
procedure draw_cursor(pointr:cpointr);
procedure open_window(pointr:wpointr);
procedure refresh_window(pointr:wpointr);
procedure win_handler(vector:cpointr);

implementation
var
   Regs        : Registers;
   H1,H2,H3,H4 : word;
(*________________________________________*)
procedure text3d(x,y:word;satz:string);
begin
  settextstyle(0,0,1);
  setcolor(8);
  outtextxy(x,y,satz);
  setcolor(15);
  outtextxy(x+1,y+1,satz);
end;
(*________________________________________*)
procedure ctext3d(x,y:word;satz:string;color1,color2:byte);
begin
  settextstyle(0,0,1);
  setcolor(color1);
  outtextxy(x,y,satz);
  setcolor(color2);
  outtextxy(x+1,y+1,satz);
end;
(*________________________________________*)
procedure balken(x,y:word);
begin
  setfillstyle(1,7);
  bar(x,y,x+500,y+10);
  setcolor(15);
  moveto(x,y+10);
  lineto(x,y);
  lineto(x+500,y);
  setcolor(1);
  lineto(x+500,y+10);
  lineto(x,y+10);
end;
(*________________________________________*)
procedure uhr(x,y:word);
begin
  setcolor(7);
  circle(x,y,40);
  setfillstyle(1,7);
  Floodfill(x,y,7);
  setcolor(15);
  circle(x,y,41);
  setcolor(1);
  circle(x,y,39);
end;
(*________________________________________*)
procedure digit(x,y:word);
begin
  setfillstyle(1,7);
  bar(x,y,x+40,y+10);
  setcolor(15);
  moveto(x,y+10);
  lineto(x,y);
  lineto(x+40,y);
  setcolor(1);
  lineto(x+40,y+10);
  lineto(x,y+10);
end;
(*________________________________________*)
procedure anzeige(x,y:word;wert,max,min:real;color:byte);
var
  pos: word;
begin
  setcolor(color);
  if (wert>=0) then pos:=round(wert*(500/360))+350
  else pos:=350+round(wert*(500/360));
  moveto(x+250,y+5);
  lineto(pos,y+5);
  moveto(x+250,y+6);
  lineto(pos,y+6);
  moveto(x+250,y+7);
  lineto(pos,y+7);
  moveto(x+250,y+8);
  lineto(pos,y+8);
  if max>=0 then pos:=round(max*(500/360))+350
  else pos:=350+round(max*(500/360));
  moveto(pos,y+5);
  lineto(pos,y+8);
  if min>=0 then pos:=round(min*(500/360))+350
  else pos:=350+round(min*(500/360));
  moveto(pos,y+5);
  lineto(pos,y+8);
end;
(*________________________________________*)
procedure uhrpos(x,y:word;wert:real;color:byte);
var
  pos : word;
begin
  setcolor(color);
  moveto(x,y);
  x:=x+round(38*cos(wert*2*pi/360));
  y:=y+round(28*sin(wert*2*pi/360));
  lineto(x,y);
end;
(*________________________________________*)
procedure digitpos(x,y:word;wert:real;color:byte);
var
  pos  : integer;
  w    : string;
begin
  pos:=round(wert);
  settextstyle(1,0,0);
  setcolor(color);
  str(pos,w);
  moveto(x+5,y+2);
  settextstyle(1,0,0);
  outtext(w);
end;
(*________________________________________*)
procedure anzeigepos(x,y:word;wert:real;color:byte);
var
  pos: word;
begin
  (* Input values 0 to 360 converted into -180 to +180 *)
  setcolor(color);
  if wert<=180 then pos:=round(wert*(500/360))+350
  else pos:=round(wert*(500/360))-150;
  moveto(pos,y+4);
  lineto(pos,y+7);
  moveto(pos-1,y+4);
  lineto(pos-1,y+7);
  moveto(pos+1,y+4);
  lineto(pos+1,y+7);
end;
(*________________________________________*)
procedure scale(max,y:word;kind:string);
var
  s      : string;
  medmax : word;
begin
  medmax:=max div 2;
  s:='0';
  s:=s+kind;
  text3d(350,y,s);
  str(max,s);
  s:='-'+s+kind;
  text3d(100,y,s);
  str(max,s);
  s:=s+kind;
  text3d(580,y,s);
  str(medmax,s);
  s:='-'+s+kind;
  text3d(225,y,s);
  str(medmax,s);
  s:=s+kind;
  text3d(475,y,s);
end;
(*****************************)
procedure zahl_hex(a:byte;var ch:char);
begin
  a:=a and $0F;
  case a of
         0 : ch:='0';
         1 : ch:='1';
         2 : ch:='2';
         3 : ch:='3';
         4 : ch:='4';
         5 : ch:='5';
         6 : ch:='6';
         7 : ch:='7';
         8 : ch:='8';
         9 : ch:='9';
        10 : ch:='A';
        11 : ch:='B';
        12 : ch:='C';
        13 : ch:='D';
        14 : ch:='E';
        15 : ch:='F';
  end;
end;
(*****************************)
procedure word_hex(wert:word;var t:string4);
var
  a  : byte;
  ch : char;
begin
      a:=wert div 4096;
      zahl_hex(a,ch);
      t[4]:=ch;
      wert:=wert-(a*4096);
      a:=wert div 256;
      zahl_hex(a,ch);
      t[3]:=ch;
      wert:=wert-(a*256);
      a:=wert div 16;
      zahl_hex(a,ch);
      t[2]:=ch;
      wert:=wert-(a*16);
      a:=wert;
      zahl_hex(a,ch);
      t[1]:=ch;
end;
(**************************************)
procedure draw_cursor(pointr:cpointr);
  var
    i   : byte;
  begin
        (* Inversion of pixels *)

        if pointr^.shift then
          begin
            if pointr^.x<pointr^.xmin then pointr^.x:=pointr^.xmin;
            if pointr^.x>pointr^.xmax-pointr^.window^.dx then pointr^.x:=pointr^.xmax-pointr^.window^.dx;
            if pointr^.y<pointr^.ymin then pointr^.y:=pointr^.ymin;
            if pointr^.y>290-pointr^.window^.dy then pointr^.y:=290-pointr^.window^.dy;
            i:=0;
            while i<=pointr^.window^.dx do
              begin
                putpixel(pointr^.x+i,pointr^.y,16-(getpixel(pointr^.x+i,pointr^.y)));
                putpixel(pointr^.x+i,pointr^.y+pointr^.window^.dy,16-(getpixel(pointr^.x+i,pointr^.y+pointr^.window^.dy)));
                i:=i+4;
              end;
            i:=0;
            while i<=pointr^.window^.dy do
              begin
                putpixel(pointr^.x,pointr^.y+i,16-(getpixel(pointr^.x,pointr^.y+i)));
                putpixel(pointr^.x+pointr^.window^.dx,pointr^.y+i,16-(getpixel(pointr^.x+pointr^.window^.dx,pointr^.y+i)));
                i:=i+4;
              end;
          end
        else
          begin
            if pointr^.x<pointr^.xmin then pointr^.x:=pointr^.xmin;
            if pointr^.x>pointr^.xmax-5 then pointr^.x:=pointr^.xmax-5;
            if pointr^.y<pointr^.ymin then pointr^.y:=pointr^.ymin;
            if pointr^.y>290 then pointr^.y:=290;
            for i:= 1 to 5 do
              begin
                putpixel(pointr^.x+i,pointr^.y,16-(getpixel(pointr^.x+i,pointr^.y)));
                putpixel(pointr^.x+i+1,pointr^.y+1,16-(getpixel(pointr^.x+i+1,pointr^.y+1)));

                putpixel(pointr^.x,pointr^.y+i,16-(getpixel(pointr^.x,pointr^.y+i)));
                putpixel(pointr^.x+1,pointr^.y+i+1,16-(getpixel(pointr^.x+1,pointr^.y+i+1)));
              end;
          end;
  end;
(**************************************)
procedure mouse(var M1,M2,M3,M4 : word);
  begin
     with Regs do
       begin
         AX:=M1;
         BX:=M2;
         CX:=M3;
         DX:=M4;
         Intr(51,Regs);
         M1:=AX;
         M2:=BX;
         M3:=CX;
         M4:=DX;
       end;
  end;
(**************************************)
function mousedriver:boolean;
  const IntRet=207;
  var MouseOffset  : Integer absolute 0:204;
      MouseSegment : Integer absolute 0:206;
  begin
    if (MouseSegment<>0) and
       (MouseOffset<>0) and
       (Mem[MouseSegment:MouseOffset] <> IntRet)
       then mousedriver:=true
       else mousedriver:=false;
  end;
(**************************************)
procedure Setmousepos(pointr:cpointr);
  begin
    if pointr^.enmouse then
      begin
        H1:=4;
        Mouse(H1,H2,pointr^.x,pointr^.y);
      end;
  end;
(**************************************)
procedure Use_Mouse(pointr:cpointr);
var
  dx,dy : integer;
begin
  if pointr^.enmouse then
  begin
    H1:=3;
    Mouse(H1,H2,H3,H4);
    if (H2<>pointr^.taste) then
      begin
        if H2=0 then
          begin
            if pointr^.taste=1 then   (* L-key was pressed *)
              begin
                pointr^.ltasteoff:=true;
              end;
            if pointr^.taste=2 then   (* M-key was pressed *)
              begin
                pointr^.mtasteoff:=true;
              end;
            if pointr^.taste=3 then   (* R-key was pressed *)
              begin
                pointr^.rtasteoff:=true;
              end;
          end;
        if H2=1 then
          begin
            pointr^.clickx:=H3;      (* L-key is depressed *)
            pointr^.clicky:=H4;
            pointr^.ltaste:=true;
          end;
       if H2=2 then
         begin
            pointr^.mtaste:=true;
          end;
       if H2=3 then
         begin
            pointr^.rtaste:=true;
          end;
      end
    else
      begin
        pointr^.ltaste:=false;
        pointr^.mtaste:=false;
        pointr^.rtaste:=false;
        pointr^.ltasteoff:=false;
        pointr^.mtasteoff:=false;
        pointr^.rtasteoff:=false;
      end;
    pointr^.taste:=H2;
    if (pointr^.x<>H3) or (pointr^.y<>H4) then
      begin
        draw_cursor(pointr);
        pointr^.x:=H3;
        pointr^.y:=H4;
        draw_cursor(pointr);
      end;
  end;
end;
(**************************************)
procedure Use_Key(pointr:cpointr);
begin
  if keypressed then
    begin
      pointr^.keycode1:=readkey;
      if pointr^.keycode1=#0 then
          pointr^.keycode2:=readkey
      else
          pointr^.keycode2:=#0;
    end
  else
    begin
      pointr^.keycode1:=#255;
      pointr^.keycode2:=#255;
    end;
end;
(**************************************)
procedure init_defaults(pointr:cpointr);
begin
  pointr^.exit:=false;
  pointr^.enter:=false;
  pointr^.shift:=false;
  pointr^.keycode1:=#255;
  pointr^.keycode2:=#255;
  pointr^.proc_sel:=0;
  pointr^.act_sel:=0;
  pointr^.ltaste:=false;
  pointr^.mtaste:=false;
  pointr^.rtaste:=false;
  pointr^.ltasteoff:=false;
  pointr^.mtasteoff:=false;
  pointr^.rtasteoff:=false;
  pointr^.taste:=0;
  pointr^.clickx:=0;
  pointr^.clicky:=0;
  pointr^.xmin:=5;
  pointr^.ymin:=5;
  pointr^.xmax:=getmaxx-5;
  pointr^.ymax:=getmaxy-5;
  pointr^.message:='                ';
  pointr^.messpos:=1;
  pointr^.messstat:=standby;
end;
(**************************************)
procedure autosize(pointr:wpointr);
var
  x,y   : word;
  i,m   : byte;
  buf   : hpointr;
begin
  pointr^.activ:=0;
  pointr^.select:=0;
  pointr^.headercolor:=15;         (* Header color *)
  pointr^.spointr:=nil;
  pointr^.ssize:=0;

  for i:=1 to pointr^.items do
    begin
      pointr^.zeile[i].color:=0;   (* Menu color *)
      pointr^.zeile[i].dy:=10;
      pointr^.zeile[i].dx:=8*length(pointr^.zeile[i].lines);
      pointr^.zeile[i].invert:=false;
      if (pointr^.zeile[i].kind<>4) and
         (pointr^.zeile[i].kind<>5) then pointr^.zeile[i].proc:=0;
      if pointr^.zeile[i].kind<>1 then pointr^.zeile[i].newpointr:=nil;
    end;

  if pointr^.main then
    begin
      pointr^.backpointr:=pointr;
      x:=getmaxx;
      y:=getmaxy;
      pointr^.x:=8;
      pointr^.y:=8;
      pointr^.dx:=x-16;
      pointr^.dy:=y-16;
    end
  else
    begin
      pointr^.backpointr:=nil;
      pointr^.dy:=60+(pointr^.items*10);
      m:=0;
      for i:=1 to pointr^.items do
        begin
          pointr^.zeile[i].x0:=10;   (* Menu color*)
          pointr^.zeile[i].y0:=20+(i*10);
          if pointr^.zeile[i].dx>m then m:=pointr^.zeile[i].dx;
        end;
      pointr^.dx:=30+m;
    end;

  buf:=pointr^.help;
  for i:=1 to 16 do
    begin
      buf^[i]:=' ';
    end;
end;
(**************************************)
procedure init_graphic;
var graphdriver,graphmode : integer;
begin
  clrscr;
  graphdriver:=detect;
  InitGraph(graphdriver,graphmode,'');
  (* Hintergrund grau *)
  Setbkcolor(7);
end;
(**************************************)
procedure write_zeile(pointr:wpointr;zeilen_nr:byte);
  begin
    if (zeilen_nr>0) and (zeilen_nr<=pointr^.items) then
      begin
        SetTextStyle(1,0,1);
        if pointr^.zeile[zeilen_nr].invert then
          begin
            setcolor(4);
            rectangle(pointr^.x+pointr^.zeile[zeilen_nr].x0,
                pointr^.y+pointr^.zeile[zeilen_nr].y0-1,
                pointr^.x+pointr^.zeile[zeilen_nr].x0+(8*length(pointr^.zeile[zeilen_nr].lines)),
                pointr^.y+pointr^.zeile[zeilen_nr].y0+9);
            setcolor(pointr^.zeile[zeilen_nr].color);
            moveto(pointr^.x+pointr^.zeile[zeilen_nr].x0,
                   pointr^.y+pointr^.zeile[zeilen_nr].y0);
            outtext(pointr^.zeile[zeilen_nr].lines);
            moveto(pointr^.x+pointr^.zeile[zeilen_nr].x0,
                   pointr^.y+pointr^.zeile[zeilen_nr].y0);
            setcolor(4);
            outtext(pointr^.zeile[zeilen_nr].lines[1]);
          end
        else
          begin
            setcolor(15);
            rectangle(pointr^.x+pointr^.zeile[zeilen_nr].x0,
                pointr^.y+pointr^.zeile[zeilen_nr].y0-1,
                pointr^.x+pointr^.zeile[zeilen_nr].x0+(8*length(pointr^.zeile[zeilen_nr].lines)),
                pointr^.y+pointr^.zeile[zeilen_nr].y0+9);
            setcolor(pointr^.zeile[zeilen_nr].color);
            moveto(pointr^.x+pointr^.zeile[zeilen_nr].x0,
                   pointr^.y+pointr^.zeile[zeilen_nr].y0);
            outtext(pointr^.zeile[zeilen_nr].lines);
            moveto(pointr^.x+pointr^.zeile[zeilen_nr].x0,
                   pointr^.y+pointr^.zeile[zeilen_nr].y0);
            setcolor(4);
            outtext(pointr^.zeile[zeilen_nr].lines[1]);
          end;
      end;
  end;
(**************************************)
procedure write_header(pointr:wpointr);
  begin
        (* Header-Text *)
    moveto(pointr^.x+28,pointr^.y+8);
    SetTextStyle(1,0,1);
    setcolor(pointr^.headercolor);
    Outtext(pointr^.header);
  end;
(**************************************)
procedure open_window(pointr:wpointr);
  var
    x0,y0,x1,y1,dx,dy : word;
    i                 : byte;
    xmax              : integer;

  begin
    xmax:=getmaxx;

    if pointr^.x<5 then pointr^.x:=5;
    if pointr^.y<5 then pointr^.y:=5;
    if pointr^.x+pointr^.dx>xmax-5 then pointr^.x:=xmax-5-pointr^.dx;
    if pointr^.y>200 then pointr^.y:=200;

    x0:=pointr^.x;
    y0:=pointr^.y;
    dx:=pointr^.dx;
    dy:=pointr^.dy;
    x1:=x0+dx;
    y1:=y0+dy;

    (* Hide background *)
    if not(pointr^.main) then
      begin
        pointr^.ssize:=ImageSize(x0,y0,x1+2,y1+2);
        getmem(pointr^.spointr,pointr^.ssize);
        getimage(x0,y0,x1+2,y1+2,pointr^.spointr^);
      end;

    (* Create window for background *)
    SetFillpattern(schw,15);
    bar(x0,y0,x1,y1);
    (* Frame *)
    setcolor(1);
    rectangle(x0+1,y0+1,x1-1,y1-1);
    rectangle(x0+3,y0+3,x1-3,y1-3);
    (* Shadow *)
    setcolor(5);
    line(x0+2,y1+1,x1+2,y1+1);
    line(x0+2,y1+2,x1+2,y1+2);
    line(x1+1,y1,x1+1,y0+2);
    line(x1+2,y1,x1+2,y0+2);
    (* Close headline *)
    setcolor(1);
    rectangle(x0+5,y0+5,x0+22,y0+18);
    line(x0+8,y0+12,x0+19,y0+12);
    line(x0+8,y0+11,x0+19,y0+11);
    line(x0+8,y0+10,x0+19,y0+10);
    (* OK button *)
    rectangle(x1-23,y1-5,x1-5,y1-18);

    (* Headline bar *)
    SetFillpattern(grau,1);
    bar(x0+23,y0+5,x1-5,y0+18);
    (* Base bar *)
    bar(x0+5,y1-5,x1-5,y1-18);
    (* Header text *)
    write_header(pointr);

    (* OK text
    setcolor(15);
    SetTextStyle(1,0,1);
    moveto(x1-19,y1-14);
    setcolor(4);
    Outtext(#219); *)

    (* Menu lines *)
    for i:=1 to pointr^.items do
      begin
        write_zeile(pointr,i);
      end;
  end;
(**************************************)
(* V1.02 *)
procedure hide_window(pointr:wpointr);      (* Hide window *)
  var
    x0,y0,x1,y1,dx,dy : word;
    xmax              : integer;

  begin
    xmax:=getmaxx;

    if pointr^.x<5 then pointr^.x:=5;
    if pointr^.y<5 then pointr^.y:=5;
    dx:=pointr^.dx;
    dy:=pointr^.dy;
    if pointr^.x+pointr^.dx>xmax-5 then pointr^.x:=xmax-5-pointr^.dx;
    if pointr^.y>200 then pointr^.y:=200;

    x0:=pointr^.x;
    y0:=pointr^.y;
    x1:=x0+dx;
    y1:=y0+dy;

    (* Create window for background *)
    SetFillpattern(schw,15);
    bar(x0+2,y0+2,x1+1,y1+1);

    setcolor(2);
    rectangle(x0+1,y0+1,x1+2,y1+2);

  end;
(**************************************)
procedure refresh_window(pointr:wpointr);
  var
    x0,y0,x1,y1,dx,dy : word;
    i                 : byte;
    xmax              : integer;

  begin
    xmax:=getmaxx;

    if pointr^.x<5 then pointr^.x:=5;
    if pointr^.y<5 then pointr^.y:=5;
    if pointr^.x+pointr^.dx>xmax-5 then pointr^.x:=xmax-5-pointr^.dx;
    if pointr^.y>200 then pointr^.y:=200;

    x0:=pointr^.x;
    y0:=pointr^.y;
    dx:=pointr^.dx;
    dy:=pointr^.dy;
    x1:=x0+dx;
    y1:=y0+dy;

    (* Create window for background *)
    SetFillpattern(schw,15);
    bar(x0+6,y0+20,x1-4,y1-20);

    (* Menu lines *)
    for i:=1 to pointr^.items do
      begin
        write_zeile(pointr,i);
      end;
  end;
(**************************************)
procedure close_window(pointr:wpointr);
  var
    x0,y0,x1,y1,dx,dy : word;
    i                 : byte;
  begin
    (* Rewrite background window *)

    if not(pointr^.main) then
      begin
        x0:=pointr^.x;
        y0:=pointr^.y;
        putimage(x0,y0,pointr^.spointr^,0);
        freemem(pointr^.spointr,pointr^.ssize);
      end;
  end;
(**************************************)
function exit_realy(pointr:cpointr):boolean;  (* Acknowledge end of program *)
var
  eing : char;
  size : word;
  zeig : pointer;
  ende : boolean;
begin
  draw_cursor(pointr);
  size:=ImageSize(200,100,500,150);
  getmem(zeig,size);
  getimage(200,100,500,150,zeig^);
  SetFillpattern(schw,7);
  bar(200,100,500,150);
  SetFillpattern(grau,1);
  bar(204,104,496,125);
  bar(470,130,490,145);
  setcolor(4);
  rectangle(200,100,500,150);
  rectangle(204,104,496,125);
  rectangle(470,130,490,145);
  setcolor(15);
  moveto(210,108);
  SetTextStyle(1,0,1);
  outtext('Do you really want to quit? (y/n)');
  moveto(473,135);
  outtext('OK');
  draw_cursor(pointr);
  delay(100);
  ende:=false;
  eing:=#32;
  while not ende do
    begin
      use_mouse(pointr);
      if (keypressed) then
        begin
          eing:=readkey;
          if (eing='y') or (eing='Y') then
            begin
              exit_realy:=true;
            end
          else
            begin
              exit_realy:=false;
            end;
          ende:=true;
        end;
      if (pointr^.ltaste) then
        begin
          ende:=true;
          if (pointr^.x>470) and (pointr^.x<490) and
                 (pointr^.y>130) and (pointr^.y<145) then
            begin
              exit_realy:=true;
            end
          else
            begin
              exit_realy:=false;
            end;
          end;
        end;
  draw_cursor(pointr);
  putimage(200,100,zeig^,0);
  freemem(zeig,size);
  draw_cursor(pointr);
end;
(**************************************)
procedure writewort(var i:byte;stab:char;var wort:string12);
begin
  setcolor(1);
  moveto(310,108);
  outtext(wort);
  wort[i]:=stab;
  if i<12 then i:=i+1;
  wort[i]:='_';
  setcolor(15);
  moveto(310,108);
  outtext(wort);
end;
(**************************************)
procedure writetaste(x0,y0,x1,y1:word;t:string);
begin
  SetFillpattern(grau,1);
  bar(x0,y0,x1,y1);
  setcolor(4);
  rectangle(x0,y0,x1,y1);
  setcolor(8);
  line(x1-1,y0+1,x1-1,y1-1);
  line(x1-2,y0+2,x1-2,y1-2);
  line(x0+1,y1-1,x1-1,y1-1);
  line(x0+2,y1-2,x1-2,y1-2);
  setcolor(15);
  line(x0+1,y0+1,x1-1,y0+1);
  line(x0+2,y0+2,x1-2,y0+2);
  line(x0+1,y0+1,x0+1,y1-1);
  line(x0+2,y0+2,x0+2,y1-2);
  SetTextStyle(1,0,1);
  setcolor(15);
  moveto(x0+5,y0+5);
  outtext(t);
end;
(**************************************)
procedure pushbuttom(x0,y0,x1,y1:word;t:string);
begin
  setcolor(15);
  line(x1-1,y0+1,x1-1,y1-1);
  line(x1-2,y0+2,x1-2,y1-2);
  line(x0+1,y1-1,x1-1,y1-1);
  line(x0+2,y1-2,x1-2,y1-2);
  setcolor(8);
  line(x0+1,y0+1,x1-1,y0+1);
  line(x0+2,y0+2,x1-2,y0+2);
  line(x0+1,y0+1,x0+1,y1-1);
  line(x0+2,y0+2,x0+2,y1-2);
  delay(100);
  setcolor(8);
  line(x1-1,y0+1,x1-1,y1-1);
  line(x1-2,y0+2,x1-2,y1-2);
  line(x0+1,y1-1,x1-1,y1-1);
  line(x0+2,y1-2,x1-2,y1-2);
  setcolor(15);
  line(x0+1,y0+1,x1-1,y0+1);
  line(x0+2,y0+2,x1-2,y0+2);
  line(x0+1,y0+1,x0+1,y1-1);
  line(x0+2,y0+2,x0+2,y1-2);
end;
(**************************************)
function input_window(pointr:cpointr):boolean;
var
  eing : char;
  size : word;
  zeig : pointer;
  sign,ende : boolean;
  wort : string12;
  i    : byte;
  wert : real;
  code : integer;
begin
  draw_cursor(pointr);
  sign:=true;
  i:=1;
  size:=ImageSize(200,100,420,310);
  getmem(zeig,size);
  getimage(200,100,420,310,zeig^);

  SetFillpattern(schw,7);          (* Outside frame *)
  bar(200,100,420,310);
  setcolor(4);
  rectangle(200,100,420,310);

  SetFillpattern(schw,1);          (* Input field *)
  bar(204,104,416,125);
  setcolor(4);
  rectangle(204,104,416,125);

  SetFillpattern(schw,1);          (* Field for comments *)
  bar(204,284,416,306);
  setcolor(4);
  rectangle(204,284,416,306);

  writetaste(220,140,245,160,'7');    (* 7 *)
  writetaste(250,140,275,160,'8');    (* 8 *)
  writetaste(280,140,305,160,'9');    (* 9 *)
  writetaste(220,170,245,190,'4');    (* 4 *)
  writetaste(250,170,275,190,'5');    (* 5 *)
  writetaste(280,170,305,190,'6');    (* 6 *)
  writetaste(220,200,245,220,'1');    (* 1 *)
  writetaste(250,200,275,220,'2');    (* 2 *)
  writetaste(280,200,305,220,'3');    (* 3 *)
  writetaste(220,230,245,250,'0');    (* 0 *)
  writetaste(250,230,275,250,'.');    (* . *)
  writetaste(280,230,305,250,'+-');   (* +- *)
  writetaste(220,260,245,280,'CL');   (* CL *)
  writetaste(250,260,305,280,'Enter');(* Enter *)
  writetaste(320,260,400,280,'Quit'); (* Quit *)

  moveto(300,108);
  outtext('+');
  moveto(210,108);
  outtext('Input ? :');
  moveto(210,294);
  outtext('ESC=CL  q=Quit');

  delay(100);
  ende:=false;
  eing:=#32;
  draw_cursor(pointr);
  wort:='_               ';
  moveto(310,108);
  outtext(wort);
  while not ende do
    begin
      use_mouse(pointr);
      if (keypressed) then
        begin
          eing:=readkey;
          case eing of
          #13 : begin
                  ende:=true;
                  input_window:=true;
                end;
          'q' : begin
                  ende:=true;
                  input_window:=false;
                end;
          'Q' : begin
                  ende:=true;
                  input_window:=false;
                end;
          #27 : begin
                  setcolor(1);
                  moveto(310,108);
                  outtext(wort);
                  wort:='_               ';
                  i:=1;
                  setcolor(15);
                  moveto(310,108);
                  outtext(wort);
                end;
          #8  : begin
                  if i>1 then
                    begin
                      setcolor(1);
                      moveto(310,108);
                      outtext(wort);
                      wort[i]:=' ';
                      if i>1 then i:=i-1;
                      wort[i]:='_';
                      setcolor(15);
                      moveto(310,108);
                      outtext(wort);
                    end;
                end;
          #0  : begin
                  eing:=readkey;
                end;
          '1' : begin
                  writewort(i,'1',wort);
                end;
          '2' : begin
                  writewort(i,'2',wort);
                end;
          '3' : begin
                  writewort(i,'3',wort);
                end;
          '4' : begin
                  writewort(i,'4',wort);
                end;
          '5' : begin
                  writewort(i,'5',wort);
                end;
          '6' : begin
                  writewort(i,'6',wort);
                end;
          '7' : begin
                  writewort(i,'7',wort);
                end;
          '8' : begin
                  writewort(i,'8',wort);
                end;
          '9' : begin
                  writewort(i,'9',wort);
                end;
          '0' : begin
                  writewort(i,'0',wort);
                end;
          '.' : begin
                  writewort(i,'.',wort);
                end;
          '+' : begin
                  sign:=true;
                  setcolor(1);
                  moveto(300,108);
                  outtext('-');
                  setcolor(15);
                  moveto(300,108);
                  outtext('+');
                end;
          '-' : begin
                  sign:=false;
                  setcolor(1);
                  moveto(300,108);
                  outtext('+');
                  setcolor(15);
                  moveto(300,108);
                  outtext('-');
                end;
          end;
        end;
     if (pointr^.ltaste) then
        begin

          if (pointr^.x>220) and (pointr^.x<245) and
             (pointr^.y>140) and (pointr^.y<160) then
            begin
              draw_cursor(pointr);
              pushbuttom(220,140,245,160,'7');
              draw_cursor(pointr);
              writewort(i,'7',wort);
              pointr^.ltaste:=false;
            end;
         if (pointr^.x>250) and (pointr^.x<275) and
             (pointr^.y>140) and (pointr^.y<160) then
            begin
              draw_cursor(pointr);
              pushbuttom(250,140,275,160,'8');
              draw_cursor(pointr);
              writewort(i,'8',wort);
              pointr^.ltaste:=false;
            end;
         if (pointr^.x>280) and (pointr^.x<305) and
             (pointr^.y>140) and (pointr^.y<160) then
            begin
              draw_cursor(pointr);
              pushbuttom(280,140,305,160,'9');
              draw_cursor(pointr);
              writewort(i,'9',wort);
              pointr^.ltaste:=false;
            end;

         if (pointr^.x>220) and (pointr^.x<245) and
             (pointr^.y>170) and (pointr^.y<190) then
            begin
              draw_cursor(pointr);
              pushbuttom(220,170,245,190,'4');
              draw_cursor(pointr);
              writewort(i,'4',wort);
              pointr^.ltaste:=false;
            end;
         if (pointr^.x>250) and (pointr^.x<275) and
             (pointr^.y>170) and (pointr^.y<190) then
            begin
              draw_cursor(pointr);
              pushbuttom(250,170,275,190,'5');
              draw_cursor(pointr);
              writewort(i,'5',wort);
              pointr^.ltaste:=false;
            end;
         if (pointr^.x>280) and (pointr^.x<305) and
             (pointr^.y>170) and (pointr^.y<190) then
            begin
              draw_cursor(pointr);
              pushbuttom(280,170,305,190,'6');
              draw_cursor(pointr);
              writewort(i,'6',wort);
              pointr^.ltaste:=false;
            end;

         if (pointr^.x>220) and (pointr^.x<245) and
             (pointr^.y>200) and (pointr^.y<220) then
            begin
              draw_cursor(pointr);
              pushbuttom(220,200,245,220,'1');
              draw_cursor(pointr);
              writewort(i,'1',wort);
              pointr^.ltaste:=false;
            end;
         if (pointr^.x>250) and (pointr^.x<275) and
             (pointr^.y>200) and (pointr^.y<220) then
            begin
              draw_cursor(pointr);
              pushbuttom(250,200,275,220,'2');
              draw_cursor(pointr);
              writewort(i,'2',wort);
              pointr^.ltaste:=false;
            end;
         if (pointr^.x>280) and (pointr^.x<305) and
             (pointr^.y>200) and (pointr^.y<220) then
            begin
              draw_cursor(pointr);
              pushbuttom(280,200,305,220,'3');
              draw_cursor(pointr);
              writewort(i,'3',wort);
              pointr^.ltaste:=false;
            end;
         if (pointr^.x>220) and (pointr^.x<245) and
             (pointr^.y>230) and (pointr^.y<250) then
            begin
              draw_cursor(pointr);
              pushbuttom(220,230,245,250,'0');
              draw_cursor(pointr);
              writewort(i,'0',wort);
              pointr^.ltaste:=false;
            end;
         if (pointr^.x>250) and (pointr^.x<275) and
             (pointr^.y>230) and (pointr^.y<250) then
            begin
              draw_cursor(pointr);
              pushbuttom(250,230,275,250,'.');
              draw_cursor(pointr);
              writewort(i,'.',wort);
              pointr^.ltaste:=false;
            end;
         if (pointr^.x>280) and (pointr^.x<305) and
             (pointr^.y>230) and (pointr^.y<250) then
            begin
              draw_cursor(pointr);
              pushbuttom(280,230,305,250,'+-');
              draw_cursor(pointr);
              if sign then
                begin
                  sign:=false;
                  setcolor(1);
                  moveto(300,108);
                  outtext('+');
                  setcolor(15);
                  moveto(300,108);
                  outtext('-');
                end
              else
                begin
                  sign:=true;
                  setcolor(1);
                  moveto(300,108);
                  outtext('-');
                  setcolor(15);
                  moveto(300,108);
                  outtext('+');
                end;
              pointr^.ltaste:=false;
            end;
         if (pointr^.x>220) and (pointr^.x<245) and
             (pointr^.y>260) and (pointr^.y<280) then
            begin
              draw_cursor(pointr);
              pushbuttom(220,260,245,280,'CL');
              draw_cursor(pointr);
              setcolor(1);
              moveto(310,108);
              outtext(wort);
              wort:='_               ';
              i:=1;
              setcolor(15);
              moveto(310,108);
              outtext(wort);
              pointr^.ltaste:=false;
            end;
         if (pointr^.x>250) and (pointr^.x<305) and
             (pointr^.y>260) and (pointr^.y<280) then
            begin
              draw_cursor(pointr);
              pushbuttom(250,260,305,280,'Enter');
              draw_cursor(pointr);
              ende:=true;
              input_window:=true;
              pointr^.ltaste:=false;
            end;
         if (pointr^.x>320) and (pointr^.x<400) and
             (pointr^.y>260) and (pointr^.y<280) then
            begin
              draw_cursor(pointr);
              pushbuttom(320,260,400,280,'Quit');
              draw_cursor(pointr);
              ende:=true;
              input_window:=false;
              pointr^.ltaste:=false;
            end;
        end;
    end;

    (* Push to the right and fill up with zero *)

    while (wort[12]=' ') or (wort[12]='_') do
      begin
        for i:=12 downto 2 do
          begin
            wort[i]:=wort[i-1];
          end;
        wort[1]:='0';
      end;
      val(wort,wert,code);
      if code=0 then
        begin
          if sign then pointr^.wert:=wert else pointr^.wert:=-wert;
        end
      else
        begin
          pointr^.wert:=0;
        end;

  draw_cursor(pointr);
  putimage(200,100,zeig^,0);
  freemem(zeig,size);
  pointr^.ltaste:=false;
  draw_cursor(pointr);
end;
(**************************************)
procedure help_window(vector:cpointr);
var
  size : word;
  zeig : pointer;
  i    : byte;
  zei1 : hpointr;
  q    : char;
begin
  draw_cursor(vector);
  size:=ImageSize(200,60,500,250);
  getmem(zeig,size);
  getimage(200,60,500,250,zeig^);
  SetFillpattern(schw,7);
  bar(200,60,500,250);
  setcolor(4);
  rectangle(200,60,500,250);
  moveto(230,65);
  SetTextStyle(1,0,1);
  outtext('Online Help');
  moveto(230,240);
  outtext('Press any key');
  setcolor(15);
  for i:=1 to 16 do
    begin
      moveto(230,i*10+80);
      outtext(vector^.window^.help^[i]);
    end;
  delay(100);
  repeat until keypressed;
  q:=readkey;
  if q=#0 then q:=readkey;
  putimage(200,60,zeig^,0);
  freemem(zeig,size);
  draw_cursor(vector);
end;
(**************************************)
procedure cursor_selector(vector:cpointr);
  var
    i,merker_select,merker_activ       : byte;
    x,y,x0,y0,x1,y1,dx,dy,
    a0,a1,b0,b1                        : word;
  begin
    x:=vector^.x;
    y:=vector^.y;
    x0:=vector^.window^.x;
    y0:=vector^.window^.y;
    dx:=vector^.window^.dx;
    dy:=vector^.window^.dy;
    x1:=x0+dx;
    y1:=y0+dy;
    merker_select:=0;
    merker_activ:=0;

    (* Cursor in window? *)

    if (x>x0+5) and (x<x1-5) and (y>y0+5) and (y<y1-5) then
      begin
        merker_activ:=255;
      end;

    (* Cursor on frame bar? *)

    if (y>y0+5) and (y<y0+18) and
       (x>x0+24) and (x<x1-5) and
       not(vector^.window^.main) then
      begin
        merker_activ:=103;
        merker_select:=103;
      end;

    (* Cursor on Quit window button? *)

    if (y>y0+5) and (y<y0+18) and
       (x>x0+5) and (x<x0+22) then
      begin
        merker_activ:=101;
        merker_select:=101;
      end;

    (* Cursor on OK button? *)

    if (y<y1-5) and (y>y1-18) and
       (x>x1-23) and (x<x1-5) then
      begin
        merker_activ:=102;
        merker_select:=102;
      end;

    (* Cursor on menu line? *)

    for i:=1 to vector^.window^.items do    (* Select menu no. 1 to 16 *)
      begin
        a0:=x0+vector^.window^.zeile[i].x0;
        a1:=x0+vector^.window^.zeile[i].x0+vector^.window^.zeile[i].dx;
        b0:=y0+vector^.window^.zeile[i].y0;
        b1:=y0+vector^.window^.zeile[i].y0+vector^.window^.zeile[i].dy;
        if (x>a0) and (x<a1) and (y>b0) and (y<b1) then
          begin
            merker_activ:=100;
            merker_select:=i;
          end;
      end;

  (* Has anything changed? *)

  if vector^.window^.activ<>merker_activ then
    begin
      if merker_activ=0 then
        begin
          vector^.window^.headercolor:=15;  (* Hide header *)
          draw_cursor(vector);
          write_header(vector^.window);
          draw_cursor(vector);
        end
      else
        begin
          vector^.window^.headercolor:=14;  (* Select header *)
          draw_cursor(vector);
          write_header(vector^.window);
          draw_cursor(vector);
        end;
      vector^.window^.activ:=merker_activ;
    end;

  if vector^.window^.select<>merker_select then
    begin
      if (vector^.window^.select>0) and (vector^.window^.select<=vector^.window^.items) then
        begin
          vector^.window^.zeile[vector^.window^.select].color:=0;  (* Hide menue *)
          vector^.window^.zeile[vector^.window^.select].invert:=false;
          draw_cursor(vector);
          write_zeile(vector^.window,vector^.window^.select);
          draw_cursor(vector);
        end;
      if (merker_select>0) and (merker_select<=vector^.window^.items) then
        begin
          vector^.window^.zeile[merker_select].color:=4;  (* Select menu *)
          vector^.window^.zeile[merker_select].invert:=true;
          draw_cursor(vector);
          write_zeile(vector^.window,merker_select);
          draw_cursor(vector);
        end;
      vector^.window^.select:=merker_select;
    end;
  end;

(**************************************)
procedure key_selector(vector:cpointr);
  var
    merker_select              : byte;
  begin
    merker_select:=vector^.window^.select;
    case vector^.keycode1 of
        #13: begin
               (* Return button *)
               if vector^.message<>'                ' then
                 begin
                   vector^.messstat:=action;
                 end
               else
                 begin
                   vector^.enter:=true;
                 end;
             end;
        #27: begin
               vector^.window^.activ:=101;    (* ESC key -> close window *)
               vector^.enter:=true;
             end;
        #8 : begin
               vector^.messstat:=backspc;
             end;
        #0 : begin
                case vector^.keycode2 of
                  #68 : begin
                          vector^.window^.activ:=105;    (* F10 -> exit *)
                          vector^.enter:=true;
                        end;
                  #59 : begin
                          vector^.window^.activ:=104;    (* F1 -> help window *)
                          vector^.enter:=true;
                        end;
                  #77 : begin
                          if merker_select<=vector^.window^.items then
                            begin
                              if merker_select=vector^.window^.items then
                                begin
                                  merker_select:=1;
                                end
                              else
                                begin
                                  merker_select:=merker_select+1;
                                end;
                              vector^.window^.activ:=100;
                            end
                          else
                            begin
                              merker_select:=1;
                            end;
                        end;
                  #75 : begin
                         if merker_select>=1 then
                            begin
                              if merker_select=1 then
                                begin
                                  merker_select:=vector^.window^.items;
                                end
                              else
                                begin
                                  merker_select:=merker_select-1;
                                end;
                              vector^.window^.activ:=100;
                            end
                          else
                            begin
                              merker_select:=1;
                            end;
                        end;
                  #80 : begin
                          if merker_select<=vector^.window^.items then
                            begin
                              if merker_select=vector^.window^.items then
                                begin
                                  merker_select:=1;
                                end
                              else
                                begin
                                  merker_select:=merker_select+1;
                                end;
                              vector^.window^.activ:=100;
                            end
                          else
                            begin
                              merker_select:=1;
                            end;
                        end;
                  #72 : begin
                          if merker_select>=1 then
                            begin
                              if merker_select=1 then
                                begin
                                  merker_select:=vector^.window^.items;
                                end
                              else
                                begin
                                  merker_select:=merker_select-1;
                                end;
                              vector^.window^.activ:=100;
                            end
                          else
                            begin
                              merker_select:=1;
                            end;
                        end;
                end;
              end;
    else
      begin
        if vector^.keycode1<>#255 then
          begin
            vector^.message[vector^.messpos]:=vector^.keycode1;
            vector^.messstat:=edit;
            if vector^.messpos<16 then vector^.messpos:=vector^.messpos+1;
          end;
      end;
    end;

    vector^.keycode1:=#255;
    vector^.keycode2:=#255;

    (* Has anything changed? *)

    if merker_select<>vector^.window^.select then
      begin
        if (vector^.window^.select>0) and (vector^.window^.select<=vector^.window^.items) then
          begin
            vector^.window^.zeile[vector^.window^.select].color:=0;  (* Hide menue *)
            vector^.window^.zeile[vector^.window^.select].invert:=false;
            draw_cursor(vector);
            write_zeile(vector^.window,vector^.window^.select);
            draw_cursor(vector);
          end;
        if (merker_select>0) and (merker_select<=vector^.window^.items) then
          begin
            vector^.window^.zeile[merker_select].color:=4;  (* select menu *)
            vector^.window^.zeile[merker_select].invert:=true;
            draw_cursor(vector);
            write_zeile(vector^.window,merker_select);
            vector^.x:=vector^.window^.x+vector^.window^.zeile[merker_select].x0+15;
            vector^.y:=vector^.window^.y+vector^.window^.zeile[merker_select].y0+5;
            setmousepos(vector);
            draw_cursor(vector);
          end;
        vector^.window^.select:=merker_select;
     end;
  end;
(**************************************)
procedure close_win(vector:cpointr);       (* Close window *)
  begin
    if not(vector^.window^.main) then
      begin
        draw_cursor(vector);
        if (vector^.window^.select>0) and (vector^.window^.select<=vector^.window^.items) then
          begin
            vector^.window^.zeile[vector^.window^.select].color:=0;  (* Hide menu *)
            vector^.window^.zeile[vector^.window^.select].invert:=false;
            write_zeile(vector^.window,vector^.window^.select);
          end;
        vector^.window^.activ:=0;         (* No activity *)
        vector^.window^.select:=0;
        close_window(vector^.window);
        vector^.window:=vector^.window^.backpointr;
        vector^.window^.headercolor:=15;  (* Select new header *)
        write_header(vector^.window);
        vector^.window^.activ:=0;         (* No activity *)
        vector^.window^.select:=0;
        vector^.window:=vector^.window;
        draw_cursor(vector);
      end
    else
      begin
        vector^.exit:=exit_realy(vector);
      end;
  end;
(**************************************)
procedure exit_win(vector:cpointr);        (* Close all windows *)
  begin
    draw_cursor(vector);
    while not(vector^.window^.main) do
      begin
        if (vector^.window^.select>0) and (vector^.window^.select<=vector^.window^.items) then
          begin
            vector^.window^.zeile[vector^.window^.select].color:=0;  (* Hide menu *)
            vector^.window^.zeile[vector^.window^.select].invert:=false;
            write_zeile(vector^.window,vector^.window^.select);
          end;
        vector^.window^.activ:=0;         (* No activity *)
        vector^.window^.select:=0;
        close_window(vector^.window);     (* Close window *)
        vector^.window:=vector^.window^.backpointr;
        vector^.window^.headercolor:=12;  (* Select new header *)
        write_header(vector^.window);
        vector^.window^.activ:=0;         (* No activity *)
        vector^.window^.select:=0;
        vector^.window:=vector^.window;
      end;
    draw_cursor(vector);
  end;
(**************************************)
procedure open_win(vector:cpointr);        (* Open window *)

  var
    merker : wpointr;
  begin
    draw_cursor(vector);
    merker:=vector^.window;
    vector^.window^.headercolor:=11;  (* Hide old header *)
    write_header(vector^.window);
    if (vector^.window^.select>0) and (vector^.window^.select<=vector^.window^.items) then
          begin
            vector^.window^.zeile[vector^.window^.select].color:=0;  (* Hide menu *)
            vector^.window^.zeile[vector^.window^.select].invert:=false;
            write_zeile(vector^.window,vector^.window^.select);
          end;
    vector^.window:=vector^.window^.zeile[merker^.select].newpointr;
    merker^.activ:=0;         (* No activity *)
    merker^.select:=0;

    open_window(vector^.window);

    vector^.window^.backpointr:=merker;
    vector^.window^.activ:=0;         (* No activity *)
    vector^.window^.select:=0;
    vector^.x:=vector^.window^.x+vector^.window^.zeile[1].x0+15;
    vector^.y:=vector^.window^.y+vector^.window^.zeile[1].y0+5;
    setmousepos(vector);
    draw_cursor(vector);
  end;
(**************************************)
procedure win_handler(vector:cpointr);
var
    buffer,i,r: byte;
    dx,dy     : integer;
    character : char;
    vgl0,vgl1 : string;
    vgl       : boolean;
    a,b       : byte;
begin

   (* Scan keys *)
   use_key(vector);

   (* Scan mouse *)
   use_mouse(vector);


   if not(vector^.shift) then
     begin
       (* Where is cursor? *)
       cursor_selector(vector);
       (* Interpret keyboard status *)
       key_selector(vector);
     end;

   (* Command line *)
   case (vector^.messstat) of
     edit : begin
              moveto(400+((vector^.messpos-1)*8),280);
              setcolor(4);
              character:=vector^.message[(vector^.messpos-1)];
              outtext(character);
              vector^.messstat:=standby;
            end;
  backspc : begin
              if vector^.messpos>1 then
                begin
                  vector^.messpos:=vector^.messpos-1;
                end;
              moveto(400+((vector^.messpos)*8),280);
              setcolor(15);
              character:=vector^.message[vector^.messpos];
              outtext(character);
              vector^.message[vector^.messpos]:=#32;
              vector^.messstat:=standby;
            end;
   action : begin
              for i:=1 to vector^.window^.items do
                begin
                  vgl0:=vector^.window^.zeile[i].lines;
                  vgl1:=vector^.message;
                  vgl:=true;
                  for r:=1 to (vector^.messpos-1) do
                    begin
                      a:=ord(vgl0[r]);
                      if a<91 then a:=a+32;
                      vgl0[r]:=chr(a);
                      b:=ord(vgl1[r]);
                      if b<91 then b:=b+32;
                      vgl1[r]:=chr(b);
                      if vgl0[r]<>vgl1[r] then vgl:=false;
                    end;
                  if vgl then
                    begin
                      sound(1000);
                      delay(50);
                      nosound;
                      vector^.window^.select:=i;
                      vector^.window^.activ:=100;
                      vector^.enter:=true;
                    end;
                end;
              if (not vgl) then
                begin
                  if vector^.message='quit            ' then
                    begin
                      sound(1000);
                      delay(50);
                      nosound;
                      vector^.window^.activ:=105;
                      vector^.enter:=true;
                    end;
                 if vector^.message='close           ' then
                    begin
                      sound(1000);
                      delay(50);
                      nosound;
                      vector^.window^.activ:=101;
                      vector^.enter:=true;
                    end;
                end;
              setcolor(15);
              for i:=1 to 16 do
                begin
                  moveto(400+(i*8),280);
                  character:=vector^.message[i];
                  outtext(character);
                end;
              vector^.message:='                ';
              vector^.messpos:=1;
              vector^.messstat:=standby;
            end;
   end;

   (* Left mouse click or ENTER *)
   if (vector^.ltaste or vector^.enter) then
     begin
       vector^.ltaste:=false;
       vector^.enter:=false;
       case vector^.window^.activ of
           0   : begin                  (* Cursor outside window *)
                   close_win(vector);
                 end;
           100 : begin
                   if (vector^.window^.select>0) and (vector^.window^.select<=vector^.window^.items) then
                     begin
                       case vector^.window^.zeile[vector^.window^.select].kind of
                       1: begin
                            open_win(vector);
                          end;
                       2: begin
                            close_win(vector);
                          end;
                       3: begin
                            exit_win(vector);
                            vector^.exit:=exit_realy(vector);
                          end;
                       4: begin
                            (* Procedure selector *)
                            vector^.proc_sel:=vector^.window^.zeile[vector^.window^.select].proc;
                          end;
                       5: begin
                            (* Entry window *)
                            vector^.proc_sel:=vector^.window^.zeile[vector^.window^.select].proc;
                            if not(input_window(vector)) then vector^.proc_sel:=0;
                          end;
                       end;
                     end;
                 end;
           101 : begin
                   close_win(vector);
                 end;
           103 : begin
                   (* Shift window *)
                   draw_cursor(vector);
                   vector^.x:=vector^.window^.x;
                   vector^.y:=vector^.window^.y;
                   setmousepos(vector);
                   vector^.shift:=true;
                   hide_window(vector^.window);
                   draw_cursor(vector);
                 end;
           104 : begin
                   (* Help *)
                   help_window(vector);
                 end;
           105 : begin
                   (* Exit *)
                   exit_win(vector);
                   vector^.exit:=exit_realy(vector);
                 end;
           end;
     end;

   (* Interpret message from user *)
   case (vector^.act_sel) of
     3  : begin
            exit_win(vector);                  (* Exit with confirmation *)
            vector^.exit:=exit_realy(vector);
          end;
    13  : begin
            exit_win(vector);                  (* Exit without confirmation *)
            vector^.exit:=true;
          end;
   end;

   (* Shift window *)
   if (vector^.shift) and (vector^.ltasteoff) then
         begin
           draw_cursor(vector);
           vector^.shift:=false;
           close_window(vector^.window);
           vector^.window^.x:=vector^.x;
           vector^.window^.y:=vector^.y;
           open_window(vector^.window);
           vector^.x:=vector^.x+30;
           vector^.y:=vector^.y+10;
           setmousepos(vector);
           draw_cursor(vector);
         end;
end;
(**************************************)
(**************************************)
(**************************************)
END.