/*---------------------------IK410_1.H---------------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Header File for the Basic Functions of IK410_1.cpp, iic.cpp, poti_1.cpp

  V 1.00
  October 1997
  --------------------------------------------------------------------------*/



// Constants for structurs
const unsigned char	on = 1;
const unsigned char	off = 0;

// Write register G26	
const unsigned short INITIALREG 	= 0x0c;					 
const unsigned short CONTROLREG1	= 0x0e;					 
const unsigned short REFMARKREG 	= 0x10;					 
const unsigned short ENDATUMREG 	= 0x12;					 
const unsigned short ENINTREG	 	= 0x14;					 
const unsigned short OFFSET00	 	= 0x16;					 
const unsigned short OFFSET90	 	= 0x18;
const unsigned short TIMERREG	 	= 0x1a;
const unsigned short CONTROLREG2	= 0x1c;
const unsigned short CONTROLREG3	= 0x1e;

// Switch the multiplexer for the encoder signals
const unsigned short ANALOGMULTIPLEX    = 0x24;

// Read register G26
const unsigned short DATUMREG0LSB = 0x00;					 
const unsigned short DATUMREG0	 = 0x02;					 
const unsigned short DATUMREG0MSB = 0x04;					 
const unsigned short DATUMREG1LSB = 0x06;					 
const unsigned short DATUMREG1	 = 0x08;					 
const unsigned short DATUMREG1MSB = 0x0a;					 
const unsigned short STATUSREG12	 = 0x0e;					 
const unsigned short AMPLITUDEREG = 0x10;					 
const unsigned short INTSTATUSREG = 0x14;					 
const unsigned short AMPLITUDE00	 = 0x16;					 
const unsigned short AMPLITUDE90	 = 0x18;
const unsigned short STATUSREG3	 = 0x1c;
const unsigned short STATUSREG4	 = 0x1e;

// Structurs
struct softcommand{
						unsigned char start;
						unsigned char stop;
						unsigned char clear;
						unsigned char latch0;
						unsigned char latch1;
						unsigned char latch2;
						unsigned char clrfreq;
						unsigned char clrstat;
						};

struct refcommand	{
						unsigned char ristart;
						unsigned char ristop;
						unsigned char riclear;
						unsigned char riclear2;
						unsigned char rilatch;
						unsigned char rilatch2;
						};

struct initlatch	{
						unsigned char en_l0_reg0;
						unsigned char en_latch2_reg0;
						unsigned char en_timer_reg0;
						unsigned char en_l1_reg1;
						unsigned char en_latch2_reg1;
						unsigned char en_timer_reg1;
						};

struct initsync	{
						unsigned char en_l0_axis2;
						unsigned char en_latch2_axis2;
						unsigned char en_timer_axis2;
						};

struct initmain	{
						unsigned char mode1024;
						unsigned char en_timer;
						unsigned char en_48bit;
						unsigned char onefold;
						unsigned char twofold;
						unsigned char fourfold;
						unsigned char arcmode;
						unsigned char arc180000;
						unsigned char sel_ri_1st;
						unsigned char sel_ri_2nd;
						};

struct initintrpt	{
						unsigned char reg0;
						unsigned char reg1;
						unsigned char timer;
						unsigned char port;
						};

struct intstate	{
						unsigned char l0;
						unsigned char l1;
						unsigned char timer;
						unsigned char pendl0;
						unsigned char pendl1;
						unsigned char pendtimer;
						};

struct countstate	{
						unsigned char latch0;
						unsigned char latch1;
						unsigned char stop;
						unsigned char sda;
						unsigned char error_freq;
						unsigned char ref_activ;
						};

struct signalstate{
						unsigned long ad00;
						unsigned long ad90;
						unsigned char amp_act;
						unsigned char amp_min;
						};

struct g26			{
						unsigned short				baseadr;
						unsigned char				ucaxis;
						double						register0;
						double						register1;
						struct softcommand		softcomm;
						struct refcommand			refcomm;
						struct initmain			inimain;
						struct initlatch			inilatch;
						struct initsync			inisync;
						struct initintrpt			iniint;
						struct countstate			cstatus;
						struct signalstate		sstatus;
						struct intstate			istatus;
						unsigned short				timer;
						short							offset00;
						short							offset90;
						};
						
struct ik121		{
						struct g26*	  		axis[2];		
						};		

struct cardc{
						struct ik121*		card[16];		
						};		

typedef struct g26* 				pG26;			// pointer to G26
typedef struct ik121* 			pIK410;		// pointer to IK410
typedef struct cardc* 			pCard;		// pointer to first card


/***************************************************************************/
/*			Definitions of functions from file IK410_1                        */
/***************************************************************************/
void InitIK410(pIK410);
void InitAxis(pG26);
void InitHandler(pG26);
void CommHandler(pG26);
unsigned short G26Main(pG26);  
unsigned short G26Latch(pG26);
unsigned short G26Sync(pG26); 
unsigned short G26Int(pG26);
unsigned short G26Soft(pG26);
unsigned short G26Ref(pG26);
void ReadCountStatus(pG26);
void ReadSignalStatus(pG26);
void ReadIntStatus(pG26);
unsigned char LookforIK410(pIK410);
void ReadReg0(pG26 axis);
void ReadReg1(pG26 axis);
void WriteOff00(unsigned short, unsigned char, short);         
void WriteOff90(unsigned short, unsigned char, short);
void WriteG26(unsigned short, unsigned char, unsigned short, unsigned short);
unsigned int ReadG26(unsigned short, unsigned char, unsigned short);
unsigned char Latched(unsigned int, unsigned char, unsigned char);
void PollLatch(unsigned int, unsigned char, unsigned char);
double ReadCountValue_48(unsigned short baseadr,unsigned char axis, unsigned char reg);
long ReadCountValue_32(unsigned short baseadr,unsigned char axis, unsigned char reg);
																											  

/***************************************************************************/
/*			Definitions of funktion from file IIC                             */
/***************************************************************************/
unsigned char PotiRead(pIK410,unsigned char,unsigned char,unsigned char);
void PotiInc(pIK410,unsigned char,unsigned char);
void PotiDec(pIK410,unsigned char,unsigned char);
unsigned char ReadPhasepoti(pIK410,unsigned char);
unsigned char ReadSympoti(pIK410,unsigned char);
void WritePhasepoti(pIK410,unsigned char,unsigned char);
void WriteSympoti(pIK410,unsigned char,unsigned char);
void WriteOffset00(pIK410,short,short);
void WriteOffset90(pIK410,short,short);
void TurnPhasepoti(pIK410,unsigned char,unsigned char,unsigned char);
void TurnSympoti(pIK410,unsigned char,unsigned char,unsigned char);
void TurnOffsetdg00(pIK410,unsigned char,unsigned char,unsigned char);
void TurnOffsetdg90(pIK410,unsigned char,unsigned char,unsigned char);
void StorePotis(pIK410);
void PotiDefault(pIK410);
void Read4Byte(pIK410,unsigned char*,unsigned char*,unsigned char*,unsigned char*);
void Write4Byte(pIK410,unsigned char,unsigned char,unsigned char,unsigned char);
void LoadOffset(pIK410);
void StoreOffset(pIK410);
void PollRom(pIK410);
void RomWrite(pIK410,unsigned short,unsigned char);
unsigned char RomRead(pIK410,unsigned short);
 

/***************************************************************************/
/*			Definitions of functions from file Poti.cpp                       */
/***************************************************************************/
void CrtInit();
void ShowPotis(pIK410);
void ShowPoti(pIK410,unsigned char,unsigned char);
void TurnPotis(pIK410);

