/*--------------------------VMEINIT.C----------------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Driver Unit for ROTEC VMEbus-Interface

  V 1.00
  November 1998
 --------------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <dos.h>
#include "vmerotec.h"


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	Text Definitions
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


#define VME_INIT_PROG_HEADER   "##############  VMEINIT - VMEbus Interface \
Initialisierung   ###############\n\r"

#define	TXT_CARD_ENABLE " --> VMEbus Interface Register enabled"

#define	TXT_SLAVE_INIT  "\n\r --> VMEbus Slave Interface Modus and Timing\
 initialisiert"

#define	TXT_ARBIT_INIT "\n\r --> Arbiter/Requester initialized"

#define	TXT_RELEASE_INIT "\n\r --> VMEbus Release Modus initialized"

#define	TXT_BUS_TO_INIT "\n\r --> Transfer Timeout initialized"

#define	TXT_INT_INIT "\n\r --> VMEbus Interrupt Handler and Level\
 initialized"

#define	TXT_VIC_INIT_END "\n\r --> VIC068: End of Init"

#define	TXT_SWAP_ENABLE "\n\r --> Byte Swapping enabled"

#define	TXT_ADR_STAT_INIT "\n\r --> Adress Status Register initialized"

#define	TXT_SYS_RESET "\n\r --> VMEbus System Reset"


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	I/O Port Addresses of VMEbus Interfaces
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	Display VME_INIT_PROG_HEADER
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void vme_init_init_screen(void)
{
	clrscr();
	cputs(VME_INIT_PROG_HEADER);
	cputs("\n\r");
	cputs("------------------------------------------------------------\
-------------------\n\r");
}					/* End of vme_init_init_screen           */

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	VMEbus System Reset
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void vme_system_reset(void)
{
  	outportb(SRR, VAL_SRR);		/* Interface Configuration Reg.  */
	cputs(TXT_SYS_RESET);	/* Display text		*/
	delay (500);
}					/* End of vme_system_reset   */

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	card_enable
	===========
	Enables VMEbus Interface via reading Dummy from Ports.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void card_enable(void)
{
	inportb(CARD_ENABLE);		/* Read dummy 			*/
	cputs(TXT_CARD_ENABLE);		/* Display text		*/
}					/* End of card_enable		*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	slave_init
	============
	Initializes VMEbus slave interfaces.
	Sets timing und modus of the VMEbus slave interface.
	!!!! Don't change this parameters !!!!
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void slave_init(void)
{
	outportb(SS0CR0, VAL_SS0CR0);	/* Slave Select 0 Control Reg. 0 */
	outportb(SS0CR1, VAL_SS0CR1);	/* Slave Select 0 Control Reg. 1 */
	outportb(ICR, VAL_ICR);		/* Interface Configuration Reg.  */

	cputs(TXT_SLAVE_INIT);		/* Display text		*/
}					/* End of slave_init		*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	arbit_init
	============
	Initializes the Arbiter Requester.
	User settings according to the specifications are possible.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void arbit_init(void)
{
	outportb(ARCR, VAL_ARCR);	/* Arbiter-Requester Conf. Reg.  */

	cputs(TXT_ARBIT_INIT);		/* Display text		*/
}					/* End of arbit_init		*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	release_init
	============
	Initializes the VMEbus release modus.
	User settings according to the specifications are possible.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void release_init(void)
{
	outportb(RCR, VAL_RCR);		/* Release Control Register     */

	cputs(TXT_RELEASE_INIT);	/* Display text			*/
}					/* End of release_init	*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	bus_to_init
	============
	Initializes the VMEbus und local bus transfer timeouts.
	User settings according to the specifications are possible.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void bus_to_init(void)
{
	outportb(TTR, VAL_TTR);		/* Transfer Timeout Register     */

	cputs(TXT_BUS_TO_INIT);		/* Display Text			*/

//	outportb(AMSR, VAL_AMR);		/* Set Address Modifier     */

}					/* End of bus_to_init		*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	int_init
	============
	Initializes the VMEbus interrupt handler and level.
	User settings according to the specifications are possible.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void int_init(void)
{
	inportb (CARD_ENABLE);
	outportb(VICR1, SPER_VICR1);	/* VMEbus Interrupt Control Reg. 1 */
	outportb(VICR2, SPER_VICR2);	/* VMEbus Interrupt Control Reg. 2 */
	outportb(VICR3, FREI_VICR3);	/* VMEbus Interrupt Control Reg. 3 */
	outportb(VICR4, SPER_VICR4);	/* VMEbus Interrupt Control Reg. 4 */
	outportb(VICR5, SPER_VICR5);	/* VMEbus Interrupt Control Reg. 5 */
	outportb(VICR6, SPER_VICR6);	/* VMEbus Interrupt Control Reg. 6 */
	outportb(VICR7, SPER_VICR7);	/* VMEbus Interrupt Control Reg. 7 */

	cputs(TXT_INT_INIT);		/* Display text			*/
}					/* End of int_init		*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	int_eoi
	============
	Reset VMEbus interrupt level.
	User settings according to the specifications are possible.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void int_eoi(IACK)
{
	inportb(IACK);	
}					         /* End of int_eoi		*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	vic_init_end
	============
	End of initializing the VIC068; Reset SYSFAIL
	!!!! Don't change these parameters !!!!
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void vic_init_end(void)
{
	outportb(ICR7, VAL_ICR7);	/* Interprocessor Commun. Reg. 7 */

	cputs(TXT_VIC_INIT_END);	/* Display text			*/
}					/* End of vic_init_end	*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	swap_enable
	===========
	Enable byte swapping via reading a dummy from the Port.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void swap_enable(void)
{
	inportb(SWAP_ENABLE);		/* Read	dummy  */
//	outportb(SWAP_ENABLE,0x0000);
//	cputs(TXT_SWAP_ENABLE);		/* Display text			*/
}					/* End of swap_enable		*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	adr_stat_init
	=============
	Initializes and reads the adress status registers
	and puts out the VMEbus slave base address.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void adr_stat_init(void)
{
	int adr_stat;
	int status;
	long int adresse;

	outport(ADR_STAT, 0x8000);	/* 				*/
	adr_stat = inport(ADR_STAT);
	cputs(TXT_ADR_STAT_INIT);		/* Displays text		*/

	status = (adr_stat & 0x07);	/* Mask status bits S1..3  */
	delay(100);
	delay(100);

	switch(status)
	{
		case 0x00:
			adresse = 0x580000L;
			break;

		case 0x04:
			adresse = 0x500000L;
			break;

		case 0x02:
			adresse = 0x480000L;
			break;

		case 0x06:
			adresse = 0x400000L;
			break;

		case 0x01:
			adresse = 0x380000L;
			break;

		case 0x05:
			adresse = 0x300000L;
			break;

		case 0x03:
			adresse = 0x280000L;
		break;

	}	/* end of switch */

	if (status == 0x07)
		cprintf("\n\r           VMEbus slave access enabled!!");
	else
		cprintf("\n\r           VMEbus slave base address  \
			  %#9lx hex \n\r", adresse);
	cprintf("\n");
}
					/* End of adr_stat_init	*/



/*##########################################################################
  The sequence of the initializing functions of the VMEbus interfaces
  should be unchanged
  #########################################################################*/


void VmeInit(void)
{
	vme_init_init_screen();
	card_enable();
	vme_system_reset();
	slave_init();
	arbit_init();
	release_init();
	bus_to_init();
	int_init();
	vic_init_end();
	swap_enable();
	adr_stat_init();
}
